/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.apps.qflog.Model;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFilter;
import de.qfs.lib.log.LogSource;
import de.qfs.lib.log.Logger;
import de.qfs.lib.logrmi.LogListener;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LogListenerImpl
extends UnicastRemoteObject
implements LogListener,
LogSource,
Unreferenced {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.LogListenerImpl");
    private int id;
    private List filters = Collections.synchronizedList(new ArrayList());

    public LogListenerImpl(int n) throws RemoteException {
        if (LogListenerImpl.logger.level >= 7) {
            logger.log(7, "LogListenerImpl()", "");
        }
        this.id = n;
    }

    public void remove() {
        if (LogListenerImpl.logger.level >= 7) {
            logger.log(7, "remove()", "");
        }
        try {
            LogListenerImpl.unexportObject(this, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.filters.clear();
    }

    public final int getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return "LogListenerImpl-" + this.id;
    }

    @Override
    public void log(LogEntry logEntry) throws RemoteException {
        for (int i = 0; i < this.filters.size() && ((LogFilter)this.filters.get(i)).filter(logEntry); ++i) {
        }
    }

    @Override
    public void log(LogEntry[] logEntryArray) throws RemoteException {
        if (LogListenerImpl.logger.level >= 7) {
            logger.log(7, "log(LogEntry[])", (String)(LogListenerImpl.logger.level < 8 ? "" : "entries.length: " + logEntryArray.length));
        }
        for (int i = 0; i < logEntryArray.length; ++i) {
            this.log(logEntryArray[i]);
        }
    }

    @Override
    public void disconnect() throws RemoteException {
        if (LogListenerImpl.logger.level >= 7) {
            logger.log(7, "disconnect()", "");
        }
        this.filters.clear();
        Model.instance().listenerDisconnected(this);
    }

    @Override
    public void addFilter(LogFilter logFilter) {
        if (LogListenerImpl.logger.level >= 7) {
            logger.log(7, "addFilter(LogFilter)", (String)(LogListenerImpl.logger.level < 8 ? "" : "filter: " + String.valueOf(logFilter)));
        }
        this.filters.add(0, logFilter);
    }

    @Override
    public void removeFilter(LogFilter logFilter) {
        if (LogListenerImpl.logger.level >= 7) {
            logger.log(7, "removeFilter(LogFilter)", (String)(LogListenerImpl.logger.level < 8 ? "" : "filter: " + String.valueOf(logFilter)));
        }
        this.filters.remove(logFilter);
    }

    @Override
    public void unreferenced() {
        if (LogListenerImpl.logger.level >= 7) {
            logger.log(7, "unreferenced()", "");
        }
        try {
            LogListenerImpl.unexportObject(this, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

