/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.apps.qflog.App;
import de.qfs.apps.qflog.LogListenerImpl;
import de.qfs.apps.qflog.RemoteLogLevelCallbackAdapter;
import de.qfs.apps.qflog.logview.LogFrame;
import de.qfs.apps.qflog.logview.LogLevelTreeModel;
import de.qfs.apps.qflog.logview.LogView;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LogLevelListener;
import de.qfs.lib.log.Logger;
import de.qfs.lib.logrmi.RemoteLogLevelListener;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.util.Observable;
import de.qfs.lib.util.Observer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class Model
extends AbstractTableModel
implements Observer {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.Model");
    public static final int NUM_COLUMNS = 4;
    public static final int COL_STATE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_TIME = 2;
    public static final int COL_ENTRIES = 3;
    private static final String[] headers = new String[]{"state", "name", "time", "entries"};
    private String[] columnNames;
    private List views = new ArrayList();
    private Map<Integer, ViewData> datas = Collections.synchronizedMap(new HashMap());
    private int id = 0;
    private Map nameMap = Collections.synchronizedMap(new HashMap());
    private static SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
    private static Model theModel = new Model();
    private static final Logger eclLogger = new Logger("de.qfs.apps.qflog.EntryCountListener");

    private Model() {
        if (Model.logger.level >= 7) {
            logger.log(7, "Model()", "");
        }
        App.getOptions().addObserver(this);
        this.columnNames = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            this.columnNames[i] = App.getResources().getString("logserver.column." + headers[i] + ".label", "MISSING: " + headers[i]);
        }
    }

    public static Model instance() {
        if (Model.logger.level >= 7) {
            logger.dumpStack(7, "instance()", "");
        }
        return theModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewId(String string) {
        ViewData viewData = new ViewData(null);
        Model model = this;
        synchronized (model) {
            viewData.id = this.id++;
        }
        viewData.name = string;
        this.datas.put(viewData.id, viewData);
        return viewData.id;
    }

    public LogListenerImpl getListener(int n) {
        ViewData viewData = this.datas.get(n);
        return viewData == null ? null : viewData.listener;
    }

    public final void setListener(int n, LogListenerImpl logListenerImpl) {
        boolean bl;
        if (Model.logger.level >= 7) {
            logger.log(7, "setListener(int, LogListenerImpl)", (String)(Model.logger.level < 8 ? "" : "id: " + n));
        }
        final ViewData viewData = this.datas.get(n);
        if (viewData.listener != null) {
            viewData.view.stopLogging(viewData.listener);
        }
        boolean bl2 = bl = viewData.view == null;
        if (bl) {
            viewData.view = new LogView();
            viewData.view.init();
            viewData.view.setLoggingEnabled(true);
            viewData.view.setClientName(viewData.name);
        }
        viewData.view.startLogging(logListenerImpl);
        viewData.view.setState(3);
        viewData.listener = logListenerImpl;
        if (viewData.countListener == null) {
            viewData.countListener = new EntryCountListener(viewData);
            viewData.view.getTableModel().addTableModelListener(viewData.countListener);
            viewData.view.getTableModel().addChangeListener(viewData.countListener);
        }
        if (bl) {
            SwingUtil.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Model.this.addView(viewData);
                }
            });
        }
    }

    public void listenerDisconnected(LogListenerImpl logListenerImpl) {
        if (Model.logger.level >= 7) {
            logger.log(7, "listenerDisonnected(LogListenerImpl)", (String)(Model.logger.level < 8 ? "" : "listener: " + String.valueOf(logListenerImpl)));
        }
        ViewData viewData = this.datas.get(logListenerImpl.getId());
        viewData.view.setState(4);
        viewData.view.getTableModel().removeTableModelListener(viewData.countListener);
        viewData.countListener = null;
        viewData.listener = null;
        final int n = this.views.indexOf(viewData);
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Model.this.fireTableRowsUpdated(n, n);
            }
        });
        this.checkViewNumbers();
    }

    public RemoteLogLevelListener getLogLevelListener(int n) {
        ViewData viewData = this.datas.get(n);
        return viewData == null ? null : viewData.levelListener;
    }

    public void setLogLevelListener(int n, RemoteLogLevelListener remoteLogLevelListener) {
        LogLevelListener logLevelListener;
        boolean bl;
        ViewData viewData;
        if (Model.logger.level >= 7) {
            logger.log(7, "setLogLevelListener(int,LogLevelListener)", (String)(Model.logger.level < 8 ? "" : "id: " + n));
        }
        if ((viewData = this.datas.get(n)) == null) {
            return;
        }
        boolean bl2 = bl = viewData.view == null;
        if (bl) {
            viewData.view = new LogView();
            viewData.view.init();
            viewData.view.setLoggingEnabled(true);
            viewData.view.setClientName(viewData.name);
        }
        if (remoteLogLevelListener instanceof RemoteLogLevelCallbackAdapter && (logLevelListener = ((RemoteLogLevelCallbackAdapter)remoteLogLevelListener).getListener()) instanceof LogLevelTreeModel) {
            viewData.view.setLogLevels((LogLevelTreeModel)logLevelListener);
        }
        viewData.levelListener = remoteLogLevelListener;
        if (bl) {
            SwingUtil.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Model.this.addView(viewData);
                }
            });
        }
    }

    public void addView(LogView logView) {
        final ViewData viewData = new ViewData(logView);
        viewData.name = logView.getClientName();
        if (viewData.name == null) {
            viewData.name = App.getResources().getString("logView.name.unknown", "unknown");
        }
        viewData.id = this.getNewId(viewData.name);
        this.datas.put(viewData.id, viewData);
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Model.this.addView(viewData);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getLiveIDs() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object object = this.datas;
        synchronized (object) {
            for (Map.Entry<Integer, ViewData> entry : this.datas.entrySet()) {
                if (entry.getValue().view.getState() != 3) continue;
                arrayList.add(entry.getKey());
            }
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    public LogView getViewForRow(int n) {
        return ((ViewData)this.views.get((int)n)).view;
    }

    public JFrame getFrameForRow(int n) {
        if (Model.logger.level >= 7) {
            logger.log(7, "getFrameForRow(int)", (String)(Model.logger.level < 8 ? "" : "index: " + n));
        }
        ViewData viewData = (ViewData)this.views.get(n);
        if (viewData.frame == null) {
            viewData.frame = viewData.view.getFrame();
        }
        return viewData.frame;
    }

    public void removeView(int n) {
        final ViewData viewData = (ViewData)this.views.get(n);
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Model.this.removeView(viewData);
            }
        });
    }

    private void removeView(ViewData viewData) {
        List list;
        if (Model.logger.level >= 7) {
            logger.log(7, "removeView(ViewData)", (String)(Model.logger.level < 8 ? "" : "data: " + String.valueOf(viewData)));
        }
        int n = this.views.indexOf(viewData);
        if (Model.logger.level >= 9) {
            logger.log(9, "removeView(ViewData)", "index: " + n);
        }
        if (n >= 0) {
            this.views.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
        if ((list = (List)this.nameMap.get(viewData.view.getClientName())) != null) {
            list.remove(viewData);
            if (list.size() == 0) {
                this.nameMap.remove(viewData.view.getClientName());
            }
        }
        if (viewData.countListener != null) {
            viewData.view.getTableModel().removeTableModelListener(viewData.countListener);
        }
        if (viewData.listener != null) {
            viewData.view.stopLogging(viewData.listener);
            viewData.listener.remove();
        }
        if (viewData.frame != null) {
            viewData.frame.setVisible(false);
            viewData.frame.dispose();
        }
        viewData.view.cleanup();
        this.datas.remove(viewData.id);
        viewData.view = null;
        viewData.listener = null;
        viewData.levelListener = null;
        System.gc();
        System.runFinalization();
        System.gc();
    }

    public void addView(ViewData viewData) {
        if (Model.logger.level >= 7) {
            logger.log(7, "addView(ViewData)", (String)(Model.logger.level < 8 ? "" : "data: " + String.valueOf(viewData)));
        }
        this.views.add(viewData);
        ArrayList<ViewData> arrayList = (ArrayList<ViewData>)this.nameMap.get(viewData.name);
        if (arrayList == null) {
            arrayList = new ArrayList<ViewData>();
            this.nameMap.put(viewData.name, arrayList);
        }
        arrayList.add(0, viewData);
        this.fireTableRowsInserted(this.views.size() - 1, this.views.size() - 1);
        this.checkViewNumbers();
    }

    private void checkViewNumbers() {
        if (Model.logger.level >= 7) {
            logger.log(7, "checkViewNumbers()", "");
        }
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Model.this.checkDeadNamed();
                Model.this.checkDead();
                Model.this.checkNamed();
                Model.this.checkTotal();
            }
        });
    }

    private void checkDeadNamed() {
        if (Model.logger.level >= 7) {
            logger.log(7, "checkDeadNamed()", "");
        }
        int n = App.getOptions().getInt("maxDeadNamedClients", 3);
        Collection collection = this.nameMap.values();
        for (List list : collection) {
            if (Model.logger.level >= 9) {
                logger.log(9, "checkDeadNamed()", "datas.size: " + list.size());
            }
            int n2 = 0;
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ViewData viewData = (ViewData)listIterator.next();
                if (Model.logger.level >= 9) {
                    logger.log(9, "checkDeadNamed()", "checking " + String.valueOf(viewData));
                }
                if (viewData.view.getState() != 4 || ++n2 <= n) continue;
                if (Model.logger.level >= 5) {
                    logger.log(5, "checkDeadNamed()", "Dropping view");
                }
                listIterator.remove();
                this.removeView(viewData);
            }
        }
    }

    private void checkDead() {
        if (Model.logger.level >= 7) {
            logger.log(7, "checkDead()", "");
        }
        int n = App.getOptions().getInt("maxDeadClients", 4);
        int n2 = 0;
        int n3 = 0;
        ListIterator listIterator = this.views.listIterator();
        while (listIterator.hasNext()) {
            ViewData viewData = (ViewData)listIterator.next();
            if (viewData.view.getState() == 4 && ++n3 > n) {
                if (Model.logger.level >= 5) {
                    logger.log(5, "checkDead()", "Dropping view");
                }
                listIterator.remove();
                this.fireTableRowsDeleted(n2, n2);
                this.removeView(viewData);
            }
            ++n2;
        }
    }

    private void checkNamed() {
        if (Model.logger.level >= 7) {
            logger.log(7, "checkNamed()", "");
        }
        int n = App.getOptions().getInt("maxNamedClients", 4);
        Collection collection = this.nameMap.values();
        for (List list : collection) {
            Object object = list.listIterator(list.size());
            while (list.size() > n && object.hasPrevious()) {
                ViewData viewData = (ViewData)object.previous();
                if (viewData.view.getState() != 4) continue;
                if (Model.logger.level >= 5) {
                    logger.log(5, "checkNamed()", "Dropping view");
                }
                object.remove();
                this.removeView(viewData);
            }
            while (list.size() > n) {
                if (Model.logger.level >= 5) {
                    logger.log(5, "checkNamed()", "Dropping view");
                }
                object = (ViewData)list.remove(list.size() - 1);
                this.removeView((ViewData)object);
            }
        }
    }

    private void checkTotal() {
        if (Model.logger.level >= 7) {
            logger.log(7, "checkTotal()", "");
        }
        int n = App.getOptions().getInt("maxClients", 4);
        int n2 = 0;
        Object object = this.views.listIterator(this.views.size());
        while (this.views.size() > n && object.hasPrevious()) {
            ViewData viewData = (ViewData)object.previous();
            if (Model.logger.level >= 9) {
                logger.log(9, "checkTotal()", "checking " + String.valueOf(viewData));
            }
            if (viewData.view.getState() != 4) continue;
            if (Model.logger.level >= 5) {
                logger.log(5, "checkDead()", "Dropping view ");
            }
            object.remove();
            this.fireTableRowsDeleted(n2, n2);
            this.removeView(viewData);
        }
        while (this.views.size() > n) {
            if (Model.logger.level >= 5) {
                logger.log(5, "check()", "Dropping view ");
            }
            object = (ViewData)this.views.remove(0);
            this.fireTableRowsDeleted(0, 0);
            this.removeView((ViewData)object);
        }
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 3: {
                return Integer.class;
            }
            case 1: 
            case 2: {
                return String.class;
            }
        }
        if (Model.logger.level >= 1) {
            logger.log(1, "getColumnClass(int)", "Unknown column: " + n);
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.views.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ViewData viewData = (ViewData)this.views.get(n);
        switch (n2) {
            case 0: {
                return viewData.view.getState();
            }
            case 1: {
                return viewData.name + "-" + viewData.id;
            }
            case 2: {
                return df.format(new Date(viewData.time));
            }
            case 3: {
                return viewData.view.getLogCount();
            }
        }
        return null;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (Model.logger.level >= 7) {
            logger.log(7, "update(Observable,Object)", (String)(Model.logger.level < 8 ? "" : "obs: " + String.valueOf(observable) + ", arg: " + String.valueOf(object)));
        }
        if (observable instanceof OptionSet) {
            final String string = ((OptionSet)observable).getString("lookAndFeel", null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Model.this.checkViewNumbers();
                    String string2 = System.getProperty("os.name");
                    try {
                        System.getProperties().put("os.name", "Windows");
                        UIManager.setLookAndFeel(string);
                    }
                    catch (Exception exception) {
                        if (Model.logger.level >= 1) {
                            logger.log("main(String[])", exception);
                        }
                    }
                    finally {
                        System.getProperties().put("os.name", string2);
                    }
                    for (ViewData viewData : Model.this.views) {
                        if (viewData.frame == null) continue;
                        SwingUtilities.updateComponentTreeUI(viewData.frame);
                    }
                }
            });
        }
    }

    private static class ViewData {
        private static final Logger logger = new Logger("de.qfs.apps.qflog.ViewData");
        public int id;
        public LogView view;
        public LogFrame frame;
        public LogListenerImpl listener;
        public RemoteLogLevelListener levelListener;
        public String name;
        public long time;
        public EntryCountListener countListener;

        public ViewData(LogView logView) {
            this.view = logView;
            this.time = System.currentTimeMillis();
        }

        public String toString() {
            return "ViewData[id=" + this.id + ",name=" + this.name + ",time=" + df.format(new Date(this.time)) + "]";
        }
    }

    private class EntryCountListener
    implements TableModelListener,
    ChangeListener {
        private ViewData data;

        public EntryCountListener(ViewData viewData) {
            if (Model.eclLogger.level >= 7) {
                eclLogger.log(7, "EntryCountListener(ViewData)", (String)(Model.eclLogger.level < 8 ? "" : "data: " + String.valueOf(viewData)));
            }
            this.data = viewData;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n;
            if (Model.eclLogger.level >= 7) {
                eclLogger.log(7, "tableChanged(TableModelEvent)", (String)(Model.eclLogger.level < 8 ? "" : "e: " + String.valueOf(tableModelEvent)));
            }
            if ((n = Model.this.views.indexOf(this.data)) < 0) {
                ((TableModel)tableModelEvent.getSource()).removeTableModelListener(this);
            } else {
                Model.this.fireTableRowsUpdated(n, n);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            if (Model.logger.level >= 7) {
                logger.log(7, "stateChanged(ChangeEvent)", (String)(Model.logger.level < 8 ? "" : "e: " + String.valueOf(changeEvent)));
            }
            if ((n = Model.this.views.indexOf(this.data)) < 0) {
                ((TableModel)changeEvent.getSource()).removeTableModelListener(this);
            } else {
                Model.this.fireTableRowsUpdated(n, n);
            }
        }
    }
}

