/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.lib.log.LogLevelCallback;
import de.qfs.lib.log.LogLevelEvent;
import de.qfs.lib.log.LogLevelListener;
import de.qfs.lib.logrmi.RemoteLogLevelCallback;
import de.qfs.lib.logrmi.RemoteLogLevelListener;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class RemoteLogLevelCallbackAdapter
extends UnicastRemoteObject
implements RemoteLogLevelListener,
LogLevelCallback {
    private static final int MAX_FAILURES = 3;
    LogLevelListener listener;
    RemoteLogLevelCallback callback;
    private int failures;

    public RemoteLogLevelCallbackAdapter() throws RemoteException {
    }

    public RemoteLogLevelCallbackAdapter(LogLevelListener logLevelListener) throws RemoteException {
        this.listener = logLevelListener;
    }

    public LogLevelListener getListener() {
        return this.listener;
    }

    public final RemoteLogLevelCallback getCallback() {
        return this.callback;
    }

    @Override
    public Object[] getLogLevels() {
        try {
            if (this.callback != null) {
                return this.callback.getLogLevels();
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
        return null;
    }

    @Override
    public void setLogLevel(String string, int n) {
        try {
            if (this.callback != null) {
                this.callback.setLogLevel(string, n);
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public void removeLogLevel(String string) {
        try {
            if (this.callback != null) {
                this.callback.removeLogLevel(string);
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public int getOutputLevel() {
        try {
            if (this.callback != null) {
                return this.callback.getOutputLevel();
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
        return 10;
    }

    @Override
    public void setOutputLevel(int n) {
        try {
            if (this.callback != null) {
                this.callback.setOutputLevel(n);
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public int getPreQueueLevel() {
        try {
            if (this.callback != null) {
                return this.callback.getPreQueueLevel();
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
        return 10;
    }

    @Override
    public void setPreQueueLevel(int n) {
        try {
            if (this.callback != null) {
                this.callback.setPreQueueLevel(n);
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public boolean isQueueing() {
        try {
            if (this.callback != null) {
                return this.callback.isQueueing();
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
        return true;
    }

    @Override
    public void setQueueing(boolean bl) {
        try {
            if (this.callback != null) {
                this.callback.setQueueing(bl);
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public int getQueueSize() {
        try {
            if (this.callback != null) {
                return this.callback.getQueueSize();
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
        return 3000;
    }

    @Override
    public void setQueueSize(int n) {
        try {
            if (this.callback != null) {
                this.callback.setQueueSize(n);
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public boolean isDropOnOverflow() {
        try {
            if (this.callback != null) {
                return this.callback.isDropOnOverflow();
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
        return false;
    }

    @Override
    public void setDropOnOverflow(boolean bl) {
        try {
            if (this.callback != null) {
                this.callback.setDropOnOverflow(bl);
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public int getFlushBufferSize() {
        try {
            if (this.callback != null) {
                return this.callback.getFlushBufferSize();
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
        return 0;
    }

    @Override
    public void setFlushBufferSize(int n) {
        try {
            if (this.callback != null) {
                this.callback.setFlushBufferSize(n);
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public int getFlushTriggerLevel() {
        try {
            if (this.callback != null) {
                return this.callback.getFlushTriggerLevel();
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
        return 1;
    }

    @Override
    public void setFlushTriggerLevel(int n) {
        try {
            if (this.callback != null) {
                this.callback.setFlushTriggerLevel(n);
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public int getPostFlushSize() {
        try {
            if (this.callback != null) {
                return this.callback.getPostFlushSize();
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
        return 10;
    }

    @Override
    public void setPostFlushSize(int n) {
        try {
            if (this.callback != null) {
                this.callback.setPostFlushSize(n);
            }
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public void disconnect() throws RemoteException {
    }

    @Override
    public void classAdded(LogLevelEvent logLevelEvent) {
        if (this.listener != null) {
            this.listener.classAdded(logLevelEvent);
        }
    }

    @Override
    public void levelChanged(LogLevelEvent logLevelEvent) {
        if (this.listener != null) {
            this.listener.levelChanged(logLevelEvent);
        }
    }

    @Override
    public void levelRemoved(LogLevelEvent logLevelEvent) {
        if (this.listener != null) {
            this.listener.levelRemoved(logLevelEvent);
        }
    }

    @Override
    public void setLogLevelCallback(RemoteLogLevelCallback remoteLogLevelCallback) {
        this.callback = remoteLogLevelCallback;
        if (this.listener != null && remoteLogLevelCallback != null) {
            this.listener.setLogLevelCallback(this);
        }
    }

    private void failed() {
        if (++this.failures >= 3) {
            this.callback = null;
        }
    }
}

