/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.apps.qflog.App;
import de.qfs.apps.qflog.LogServerImpl;
import de.qfs.apps.qflog.MainFrame;
import de.qfs.apps.qflog.Model;
import de.qfs.apps.qflog.SocketListener;
import de.qfs.apps.qflog.Version;
import de.qfs.apps.qflog.command.CommandFileOpen;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.config.Configurator;
import de.qfs.lib.gui.EventQueue;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.SplashWindow;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.logrmi.LogClient;
import de.qfs.lib.logrmi.RemoteLogWriter;
import de.qfs.lib.option.Option;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.MissingParameterException;
import de.qfs.lib.util.UnexpectedParameterException;
import de.qfs.lib.util.UnknownOptionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import lombok.Generated;

public class Start {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qflog.Start");
    private static final String CFG_NAME = System.getProperty("user.home") + File.separator + ".qflog" + File.separator + "config";
    public static String[] args;
    private static final String SERVER_NAME = "qflog";
    private static ArgsParser ap;
    private static Hashtable options;
    private static Configurator cfg;
    private static int argstart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(final String[] stringArray) {
        LogServerImpl logServerImpl;
        String string;
        Object object;
        block46: {
            boolean bl;
            Object object2;
            String string2;
            block43: {
                block42: {
                    if (Start.logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "main(String[])", 135).addDetail("args", stringArray)).log();
                    }
                    args = stringArray;
                    Log.setQueueing(false);
                    Log.setOutputLevel(2);
                    UIManager.put("List.timeFactor", 300L);
                    EventQueue.install();
                    App.instance();
                    new Splash(App.getResources());
                    Message.setResources(App.getResources());
                    Option.setResources(App.getResources());
                    Start.getOpts(stringArray);
                    if (options.containsKey("noquery")) {
                        options.remove("query");
                    } else if (!options.containsKey("query")) {
                        options.put("query", "");
                    }
                    if (options.containsKey("version")) {
                        Version.main(new String[0]);
                        System.exit(0);
                    }
                    App.instance().setArgs(options);
                    SwingUtil.prepareKeymaps();
                    if (options.containsKey("logserver")) {
                        try {
                            string2 = (String)options.get("logserver");
                            RemoteLogWriter.logRemote(string2, SERVER_NAME);
                            Log.setPreQueueLevel(10);
                        }
                        catch (Exception exception) {
                            if (Start.logger.level < 3) break block42;
                            ((LevelAwareLogBuilder)logger.lvlBuild(3, "main(String[])", 184).add("ex", exception)).log();
                        }
                    }
                }
                Logger.setLogLevels(options);
                string2 = CFG_NAME;
                if (options.containsKey("configfile")) {
                    string2 = (String)options.get("configfile");
                } else {
                    object2 = new File(System.getProperties().getProperty("user.home") + File.separator + ".qflog");
                    if (((File)object2).exists()) {
                        if (!((File)object2).isDirectory()) {
                            File file = new File(System.getProperties().getProperty("user.home") + File.separator + ".xqflogx");
                            ((File)object2).renameTo(file);
                            ((File)object2).mkdir();
                            file.renameTo(new File((File)object2, "config"));
                        }
                    } else {
                        ((File)object2).mkdir();
                    }
                }
                try {
                    object2 = new FileInputStream(string2);
                    try {
                        Configuration.instance().restore((InputStream)object2);
                    }
                    finally {
                        block44: {
                            try {
                                ((FileInputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                if (Start.logger.level < 9) break block44;
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "main(String[])", 220).add("t", throwable)).log();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (Start.logger.level < 1) break block43;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "main(String[])", 224).add("ex", exception)).log();
                }
            }
            App.instance().setConfigFile(new File(string2));
            object2 = System.getProperty("os.name");
            try {
                System.getProperties().put("os.name", "Windows");
                UIManager.setLookAndFeel(App.getOptions().getString("lookAndFeel", UIManager.getSystemLookAndFeelClassName()));
            }
            catch (Throwable throwable) {
                if (Start.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "main(String[])", 238).add("ex", throwable)).log();
                }
            }
            finally {
                System.getProperties().put("os.name", object2);
            }
            App.getResources().getIcon("logServer.icon", null);
            new JScrollPane();
            boolean bl2 = bl = argstart == stringArray.length - 1 && !options.containsKey("server");
            if (bl) {
                options.remove("query");
                options.put("noserver", "");
                App.getCommandDistributor().assignCommand(new CommandFileOpen(Start.class, new File(stringArray[argstart]), true));
                SwingUtil.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (Start.logger.level >= 7) {
                            logger.lvlBuild(7, "main(String[]).Runnable.run()", 258).log();
                        }
                        if (SplashWindow.getLastSplashWindow() != null) {
                            SplashWindow.getLastSplashWindow().remove();
                        }
                    }
                });
                return;
            }
            if (options.containsKey("serverhost")) {
                object = (String)options.get("serverhost");
            } else {
                try {
                    object = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    if (Start.logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "main(String[])", 275).add("ex", unknownHostException)).log();
                    }
                    object = "";
                }
            }
            if (options.containsKey("port")) {
                object = (String)object + ":" + String.valueOf(options.get("port"));
            }
            string = SERVER_NAME;
            if (options.containsKey("servername")) {
                string = (String)options.get("servername");
            }
            logServerImpl = null;
            if (!options.containsKey("noserver") || options.containsKey("query")) {
                try {
                    logServerImpl = new LogServerImpl(ap.getBoolean("remote", false));
                }
                catch (RemoteException remoteException) {
                    if (Start.logger.level < 1) break block46;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "main(String[])", 297).add("ex", remoteException)).log();
                }
            }
        }
        Object var7_17 = null;
        if (!options.containsKey("noserver")) {
            Start.registerServer(logServerImpl, string, options);
        }
        App.instance().setServerHost((String)object);
        App.instance().setServerName(string);
        Model model = Model.instance();
        cfg = new Configurator("top");
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                if (Start.logger.level >= 7) {
                    logger.lvlBuild(7, "main(String[]).Runnable.run()", 316).log();
                }
                MainFrame mainFrame = new MainFrame();
                mainFrame.init();
                cfg.add(mainFrame.getConfigurator());
                mainFrame.pack();
                cfg.register();
                mainFrame.setVisible(true);
                boolean bl2 = bl = argstart < stringArray.length;
                while (argstart < stringArray.length) {
                    App.getCommandDistributor().assignCommand(new CommandFileOpen((Object)mainFrame, mainFrame, new File(stringArray[argstart])));
                    ++argstart;
                }
                if (bl) {
                    mainFrame.getTable().setRowSelectionInterval(0, 0);
                    mainFrame.getTable().requestFocus();
                }
                if (SplashWindow.getLastSplashWindow() != null) {
                    SplashWindow.getLastSplashWindow().remove();
                }
            }
        });
        if (logServerImpl != null && options.containsKey("query")) {
            Start.queryClients(logServerImpl, options);
        }
        if (options.containsKey("streamport")) {
            new SocketListener(ap.getInt("streamport", 0));
        }
    }

    private static void getOpts(String[] stringArray) {
        if (Start.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getOpts(String[])", 362).addDetail("args", stringArray)).log();
        }
        ap = new ArgsParser(new String[]{"+configfile", "+log-*", "+logserver", "-nocreateregistry", "-noquery", "-noserver", "+optionfile", "+port", "m?query", "-remote", "-server", "+serverhost", "+servername", "+streamport", "-version", "+logstream"});
        ap.setDefaultOption("optionfile");
        try {
            argstart = ap.parse(stringArray);
            options = ap.getOptions();
        }
        catch (MissingParameterException missingParameterException) {
            System.err.println(Message.format("error.args.missingParameter", new Object[]{missingParameterException.getOption()}));
            System.err.println(App.getResources().getString("error.args.usage", ""));
            System.exit(1);
        }
        catch (UnexpectedParameterException unexpectedParameterException) {
            System.err.println(Message.format("error.args.unexpectedParamter", new Object[]{unexpectedParameterException.getOption()}));
            System.err.println(App.getResources().getString("error.args.usage", ""));
            System.exit(1);
        }
        catch (UnknownOptionException unknownOptionException) {
            System.err.println(Message.format("error.args.unknownOption", new Object[]{unknownOptionException.getOption()}));
            System.err.println(App.getResources().getString("error.args.usage", ""));
            System.exit(1);
        }
    }

    private static void registerServer(LogServerImpl logServerImpl, String string, Hashtable hashtable) {
        block14: {
            if (Start.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "registerServer(LogServerImpl,String,Hashtable)", 418).addDetail("server", logServerImpl)).addDetail("servername", string)).addDetail("options", hashtable)).log();
            }
            Registry registry = null;
            try {
                int n = 1099;
                if (hashtable.containsKey("port")) {
                    n = Integer.parseInt((String)hashtable.get("port"));
                }
                try {
                    registry = LocateRegistry.getRegistry(n);
                    registry.rebind(string, logServerImpl);
                    if (Start.logger.level >= 5) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "registerServer(LogServerImpl,String,Hashtable)", 432).add("LogServer bound")).log();
                    }
                }
                catch (RemoteException remoteException) {
                    if (!hashtable.containsKey("nocreateregistry")) {
                        try {
                            registry = LocateRegistry.createRegistry(n);
                            if (Start.logger.level >= 5) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "registerServer(LogServerImpl,String,Hashtable)", 437).add("registry created at port ")).add(n)).log();
                            }
                            if (registry == null) break block14;
                            registry.rebind(string, logServerImpl);
                            if (Start.logger.level >= 5) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(5, "registerServer(LogServerImpl,String,Hashtable)", 440).add("LogServer bound")).log();
                            }
                            break block14;
                        }
                        catch (RemoteException remoteException2) {
                            if (Start.logger.level >= 1) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(1, "registerServer(LogServerImpl,String,Hashtable)", 443).add("ex2", remoteException2)).log();
                            }
                            break block14;
                        }
                    }
                    if (Start.logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "registerServer(LogServerImpl,String,Hashtable)", 447).add("ex", remoteException)).log();
                    }
                }
            }
            catch (Exception exception) {
                if (Start.logger.level < 1) break block14;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "registerServer(LogServerImpl,String,Hashtable)", 451).add("ex", exception)).log();
            }
        }
    }

    private static void queryClients(LogServerImpl logServerImpl, Hashtable hashtable) {
        String[] stringArray;
        Object v;
        if (Start.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "queryClients(LogServerImpl,Hashtable)", 464).addDetail("server", logServerImpl)).addDetail("options", hashtable)).log();
        }
        if ((v = hashtable.get("query")) instanceof String[]) {
            stringArray = (String[])v;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = (String)v;
        }
        String[] stringArray3 = stringArray;
        for (int i = 0; i < stringArray3.length; ++i) {
            try {
                int n = stringArray3[i].indexOf(58);
                String string = stringArray3[i].length() > 0 ? stringArray3[i] : null;
                int n2 = -1;
                if (n >= 0) {
                    string = n == 0 ? null : stringArray3[i].substring(0, n);
                    try {
                        n2 = Integer.parseInt(stringArray3[i].substring(n + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Registry registry = LocateRegistry.getRegistry(string, n2);
                String[] stringArray4 = registry.list();
                for (int j = 0; j < stringArray4.length; ++j) {
                    if (!stringArray4[j].startsWith("LogClient-")) continue;
                    try {
                        LogClient logClient = (LogClient)registry.lookup(stringArray4[j]);
                        logClient.connect(logServerImpl);
                        continue;
                    }
                    catch (ServerException serverException) {
                        if (Start.logger.level < 3) continue;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "queryClients(LogServerImpl,Hashtable)", 497).add("ex", serverException)).log();
                        continue;
                    }
                    catch (ConnectException connectException) {
                        if (Start.logger.level >= 5) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(5, "queryClients(LogServerImpl,Hashtable)", 499).add("ex", connectException)).log();
                        }
                        try {
                            registry.unbind(stringArray4[j]);
                        }
                        catch (RemoteException remoteException) {
                        }
                        catch (NotBoundException notBoundException) {}
                        continue;
                    }
                    catch (Exception exception) {
                        if (Start.logger.level < 1) continue;
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "queryClients(LogServerImpl,Hashtable)", 510).add("ex", exception)).log();
                    }
                }
                continue;
            }
            catch (Exception exception) {
                if (Start.logger.level < 1) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "queryClients(LogServerImpl,Hashtable)", 515).add("ex", exception)).log();
            }
        }
    }

    private static class Splash
    extends SplashWindow {
        public Splash(MapResourceBundle mapResourceBundle) {
            super(100, 100);
            Icon icon;
            if (Start.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Splash.Splash(MapResourceBundle)", 537).addDetail("rb", mapResourceBundle)).log();
            }
            if ((icon = mapResourceBundle.getIcon("qflog.splash.icon", null)) != null) {
                this.panel.setBorder(BorderFactory.createRaisedBevelBorder());
                this.panel.add(new JLabel(icon));
                this.panel.remove(this.bar);
                this.setSize(this.panel.getPreferredSize());
                SwingUtil.centerWindow(this);
                this.setVisible(true);
            } else {
                this.remove();
            }
        }
    }
}

