/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.apps.qflog.App;
import de.qfs.apps.qflog.Model;
import de.qfs.lib.gui.WholeRowFocusRenderer;
import de.qfs.lib.log.Logger;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;

public class ViewTable
extends JTable {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.ViewTable");
    private static final String[] iconNames = new String[]{"logView.icon.file", "logView.icon.connected", "logView.icon.disconnected"};
    private static final Icon[] icons = new Icon[iconNames.length];

    public ViewTable(Model model) {
        super(model);
        if (ViewTable.logger.level >= 7) {
            logger.log(7, "ViewTable(Model)", (String)(ViewTable.logger.level < 8 ? "" : "model: " + String.valueOf(model)));
        }
        this.initIcons();
        this.getSelectionModel().setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        Renderer renderer = new Renderer();
        this.addFocusListener(renderer);
        this.setDefaultRenderer(Object.class, renderer);
        this.setDefaultRenderer(Integer.class, renderer);
        this.setDefaultRenderer(String.class, renderer);
        this.getColumnModel().setColumnMargin(0);
    }

    private void initIcons() {
        if (icons[0] == null) {
            for (int i = 0; i < icons.length; ++i) {
                ViewTable.icons[i] = App.getResources().getIcon(iconNames[i], null);
            }
        }
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    private class Renderer
    extends WholeRowFocusRenderer {
        public Renderer() {
            this.setStippleBorder();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            if (jTable.convertColumnIndexToModel(n2) == 0) {
                switch ((Integer)object) {
                    case 2: {
                        jLabel.setIcon(icons[0]);
                        jLabel.setText(null);
                        break;
                    }
                    case 3: {
                        jLabel.setIcon(icons[1]);
                        jLabel.setText(null);
                        break;
                    }
                    case 4: {
                        jLabel.setIcon(icons[2]);
                        jLabel.setText(null);
                    }
                }
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }
    }
}

