/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.apps.qflog.logview.FilterNode;
import de.qfs.apps.qflog.logview.FilterRootNode;
import de.qfs.apps.qflog.logview.LogFilterTreeModel;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.WindowsTreeCellRenderer;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;

public class LogFilterView
extends JPanel {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.logview.LogFilterView");
    private transient LogFilterTreeModel model;
    private transient JTree tree;
    private static MapResourceBundle defaultResources;
    private transient MapResourceBundle resources;
    private transient JPopupMenu popup;
    private transient PopupListener popupListener;
    private boolean logging;
    private ButtonModel toggleButtonModel;
    private Action removeAction;
    private Action removeRecursiveAction;
    private Action setERRAction;
    private Action setERRDETAILAction;
    private Action setWRNAction;
    private Action setWRNDETAILAction;
    private Action setMSGAction;
    private Action setMSGDETAILAction;
    private Action setMTDAction;
    private Action setMTDDETAILAction;
    private Action setDBGAction;
    private Action setDBGDETAILAction;
    private Action toggleFilterAction;
    private Action addFilterAction;
    private Action removeFilterAction;
    private Action clearFilterAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action showSetLevelsAction;
    private static final Logger claLogger;
    private static final Logger rlaLogger;
    private static final Logger sslaLogger;
    private static final int METHOD = 10;
    private static final int CLASS = 11;
    private static final int CLASS_OPEN = 12;
    private static final int PACKAGE = 13;
    private static final int PACKAGE_OPEN = 14;
    private static final String[] iconNames;
    private static final Icon[] icons;

    public LogFilterView(LogFilterTreeModel logFilterTreeModel) {
        this.model = logFilterTreeModel;
        this.setupResources();
        logFilterTreeModel.setRootName(this.resources.getString("logFilterView.root.name", "default"));
    }

    public final void setLoggingEnabled(boolean bl) {
        this.logging = bl;
        this.model.setLoggingEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        boolean bl;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(null);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(null);
            String string = this.resources.getString("logFilterView.title", "Filter");
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(UIManager.getColor("textText"));
            jLabel.setBorder(BorderFactory.createEtchedBorder());
            jPanel.add((Component)jLabel, "North");
            this.tree = new JTree(this.model){
                boolean initialized;
                {
                    this.initialized = true;
                }

                @Override
                public void updateUI() {
                    super.updateUI();
                    if (this.initialized) {
                        this.setCellRenderer(new Renderer());
                    }
                }
            };
            this.tree.setName("FilterTree");
            this.tree.setBorder(null);
            this.tree.setCellRenderer(new Renderer());
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            jScrollPane.setName("FilterScrollPane");
            jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
            jPanel.add((Component)jScrollPane, "Center");
            this.add((Component)jPanel, "Center");
            this.tree.setSelectionRow(0);
            this.setupActions();
            this.tree.registerKeyboardAction(this.removeAction, "remove", KeyStroke.getKeyStroke(127, 0), 0);
            this.tree.registerKeyboardAction(this.removeRecursiveAction, "removeRecursive", KeyStroke.getKeyStroke(127, 2), 0);
            this.tree.registerKeyboardAction(this.setERRAction, "setERR", KeyStroke.getKeyStroke(49, 0), 0);
            this.tree.registerKeyboardAction(this.setERRDETAILAction, "setERRDETAIL", KeyStroke.getKeyStroke(50, 0), 0);
            this.tree.registerKeyboardAction(this.setWRNAction, "setWRN", KeyStroke.getKeyStroke(51, 0), 0);
            this.tree.registerKeyboardAction(this.setWRNDETAILAction, "setWRNDETAIL", KeyStroke.getKeyStroke(52, 0), 0);
            this.tree.registerKeyboardAction(this.setMSGAction, "MSGERR", KeyStroke.getKeyStroke(53, 0), 0);
            this.tree.registerKeyboardAction(this.setMSGDETAILAction, "setMSGDETAIL", KeyStroke.getKeyStroke(54, 0), 0);
            this.tree.registerKeyboardAction(this.setMTDAction, "setMTD", KeyStroke.getKeyStroke(55, 0), 0);
            this.tree.registerKeyboardAction(this.setMTDDETAILAction, "setMTDDETAIL", KeyStroke.getKeyStroke(56, 0), 0);
            this.tree.registerKeyboardAction(this.setDBGAction, "setDBG", KeyStroke.getKeyStroke(57, 0), 0);
            this.tree.registerKeyboardAction(this.setDBGDETAILAction, "setDBGDETAIL", KeyStroke.getKeyStroke(48, 0), 0);
            this.tree.registerKeyboardAction(this.toggleFilterAction, "filter", KeyStroke.getKeyStroke(70, 2), 0);
            this.tree.registerKeyboardAction(this.addFilterAction, "addFilter", KeyStroke.getKeyStroke(65, 2), 0);
            this.tree.registerKeyboardAction(this.removeFilterAction, "removeFilter", KeyStroke.getKeyStroke(82, 2), 0);
            this.tree.registerKeyboardAction(this.clearFilterAction, "clearFilter", KeyStroke.getKeyStroke(75, 2), 0);
            this.tree.registerKeyboardAction(this.expandAllAction, "expandAll", KeyStroke.getKeyStroke(39, 8), 0);
            this.tree.registerKeyboardAction(this.collapseAllAction, "collapseAll", KeyStroke.getKeyStroke(37, 8), 0);
            this.popup = new JPopupMenu();
            this.fillMenu(this.popup);
            this.popupListener = new PopupListener();
            this.tree.addMouseListener(this.popupListener);
            this.showSetLevels();
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    public void cleanup() {
        if (this.logging && LogFilterView.logger.level >= 7) {
            logger.log(7, "cleanup()", "");
        }
        SwingUtil.cleanup(this);
        this.tree.removeMouseListener(this.popupListener);
        this.popupListener = null;
        SwingUtil.cleanup(this.popup);
        this.popup = null;
        this.tree.resetKeyboardActions();
        this.tree = null;
        this.resources = null;
        this.model.cleanup();
        this.model = null;
    }

    public final LogFilterTreeModel getModel() {
        return this.model;
    }

    public final JTree getTree() {
        return this.tree;
    }

    public void fillMenu(JMenu jMenu) {
        JMenuItem jMenuItem = jMenu.add(this.removeAction);
        jMenuItem = jMenu.add(this.removeRecursiveAction);
        jMenu.addSeparator();
        jMenuItem = jMenu.add(this.setERRAction);
        jMenuItem = jMenu.add(this.setERRDETAILAction);
        jMenuItem = jMenu.add(this.setWRNAction);
        jMenuItem = jMenu.add(this.setWRNDETAILAction);
        jMenuItem = jMenu.add(this.setMSGAction);
        jMenuItem = jMenu.add(this.setMSGDETAILAction);
        jMenuItem = jMenu.add(this.setMTDAction);
        jMenuItem = jMenu.add(this.setMTDDETAILAction);
        jMenuItem = jMenu.add(this.setDBGAction);
        jMenuItem = jMenu.add(this.setDBGDETAILAction);
        jMenu.addSeparator();
        jMenuItem = new JCheckBoxMenuItem((String)this.toggleFilterAction.getValue("Name"), (Icon)this.toggleFilterAction.getValue("SmallIcon"));
        if (this.toggleButtonModel == null) {
            this.toggleButtonModel = jMenuItem.getModel();
            this.toggleButtonModel.setSelected(this.model.isPackageFilteringEnabled());
            jMenuItem.addActionListener(this.toggleFilterAction);
        } else {
            jMenuItem.setModel(this.toggleButtonModel);
        }
        jMenu.add(jMenuItem);
        this.setMnemonic(jMenuItem, "toggleFilter");
        jMenuItem = jMenu.add(this.addFilterAction);
        this.setMnemonic(jMenuItem, "addFilter");
        jMenuItem = jMenu.add(this.removeFilterAction);
        this.setMnemonic(jMenuItem, "removeFilter");
        jMenuItem = jMenu.add(this.clearFilterAction);
        this.setMnemonic(jMenuItem, "clearFilter");
        jMenu.addSeparator();
        jMenuItem = jMenu.add(this.showSetLevelsAction);
        this.setMnemonic(jMenuItem, "showSetLevels");
    }

    public void fillMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.add(this.removeAction);
        jPopupMenu.add(this.removeRecursiveAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.setERRAction);
        jPopupMenu.add(this.setERRDETAILAction);
        jPopupMenu.add(this.setWRNAction);
        jPopupMenu.add(this.setWRNDETAILAction);
        jPopupMenu.add(this.setMSGAction);
        jPopupMenu.add(this.setMSGDETAILAction);
        jPopupMenu.add(this.setMTDAction);
        jPopupMenu.add(this.setMTDDETAILAction);
        jPopupMenu.add(this.setDBGAction);
        jPopupMenu.add(this.setDBGDETAILAction);
        jPopupMenu.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem((String)this.toggleFilterAction.getValue("Name"), (Icon)this.toggleFilterAction.getValue("SmallIcon"));
        if (this.toggleButtonModel == null) {
            this.toggleButtonModel = jCheckBoxMenuItem.getModel();
            this.toggleButtonModel.setSelected(this.model.isPackageFilteringEnabled());
            jCheckBoxMenuItem.addActionListener(this.toggleFilterAction);
        } else {
            jCheckBoxMenuItem.setModel(this.toggleButtonModel);
        }
        jPopupMenu.add(jCheckBoxMenuItem);
        jPopupMenu.add(this.addFilterAction);
        jPopupMenu.add(this.removeFilterAction);
        jPopupMenu.add(this.clearFilterAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.showSetLevelsAction);
    }

    public void setResources(ResourceBundle resourceBundle) {
        this.resources.addResources(resourceBundle);
        this.model.setRootName(this.resources.getString("logFilterView.root.name", "default"));
    }

    public void showSetLevels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogFilterView.this.showSetLevelsAction.actionPerformed(null);
            }
        });
    }

    private void setupActions() {
        if (this.removeAction == null) {
            this.removeAction = new RemoveLevelAction(false);
            this.setActionProperties(this.removeAction, "removeLevel");
            this.removeRecursiveAction = new RemoveLevelAction(true);
            this.setActionProperties(this.removeRecursiveAction, "removeLevelRecursive");
            this.setERRAction = new ChangeLevelAction(1);
            this.setActionProperties(this.setERRAction, "setLevelERR");
            this.setERRDETAILAction = new ChangeLevelAction(2);
            this.setActionProperties(this.setERRDETAILAction, "setLevelERRDETAIL");
            this.setWRNAction = new ChangeLevelAction(3);
            this.setActionProperties(this.setWRNAction, "setLevelWRN");
            this.setWRNDETAILAction = new ChangeLevelAction(4);
            this.setActionProperties(this.setWRNDETAILAction, "setLevelWRNDETAIL");
            this.setMSGAction = new ChangeLevelAction(5);
            this.setActionProperties(this.setMSGAction, "setLevelMSG");
            this.setMSGDETAILAction = new ChangeLevelAction(6);
            this.setActionProperties(this.setMSGDETAILAction, "setLevelMSGDETAIL");
            this.setMTDAction = new ChangeLevelAction(7);
            this.setActionProperties(this.setMTDAction, "setLevelMTD");
            this.setMTDDETAILAction = new ChangeLevelAction(8);
            this.setActionProperties(this.setMTDDETAILAction, "setLevelMTDDETAIL");
            this.setDBGAction = new ChangeLevelAction(9);
            this.setActionProperties(this.setDBGAction, "setLevelDBG");
            this.setDBGDETAILAction = new ChangeLevelAction(10);
            this.setActionProperties(this.setDBGDETAILAction, "setLevelDBGDETAIL");
            this.toggleFilterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogFilterView.this.model.togglePackageFiltering();
                    if (LogFilterView.this.toggleButtonModel != null) {
                        LogFilterView.this.toggleButtonModel.setSelected(LogFilterView.this.model.isPackageFilteringEnabled());
                    }
                }
            };
            this.setActionProperties(this.toggleFilterAction, "toggleFilter");
            this.addFilterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath[] treePathArray = LogFilterView.this.tree.getSelectionPaths();
                    if (treePathArray != null) {
                        for (int i = 0; i < treePathArray.length; ++i) {
                            FilterNode filterNode = (FilterNode)treePathArray[i].getLastPathComponent();
                            LogFilterView.this.model.addFilterPackage(filterNode);
                        }
                    }
                }
            };
            this.setActionProperties(this.addFilterAction, "addFilter");
            this.removeFilterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath[] treePathArray = LogFilterView.this.tree.getSelectionPaths();
                    if (treePathArray != null) {
                        for (int i = 0; i < treePathArray.length; ++i) {
                            FilterNode filterNode = (FilterNode)treePathArray[i].getLastPathComponent();
                            LogFilterView.this.model.removeFilterPackage(filterNode);
                        }
                    }
                }
            };
            this.setActionProperties(this.removeFilterAction, "removeFilter");
            this.clearFilterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogFilterView.this.model.clearFilterPackages();
                }
            };
            this.setActionProperties(this.clearFilterAction, "clearFilter");
            this.expandAllAction = new AbstractAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath treePath = LogFilterView.this.tree.getSelectionPath();
                    if (treePath != null) {
                        boolean bl;
                        boolean bl2 = bl = !LogFilterView.this.logging;
                        if (bl) {
                            Log.excludeThread();
                        }
                        try {
                            SwingUtil.expandAll(LogFilterView.this.tree, treePath, 1000);
                        }
                        finally {
                            if (bl) {
                                Log.includeThread();
                            }
                        }
                    }
                }
            };
            this.collapseAllAction = new AbstractAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath treePath = LogFilterView.this.tree.getSelectionPath();
                    if (treePath != null) {
                        boolean bl;
                        boolean bl2 = bl = !LogFilterView.this.logging;
                        if (bl) {
                            Log.excludeThread();
                        }
                        try {
                            SwingUtil.collapseAll(LogFilterView.this.tree, treePath, 1000);
                        }
                        finally {
                            if (bl) {
                                Log.includeThread();
                            }
                        }
                    }
                }
            };
            this.showSetLevelsAction = new ShowSetLevelsAction();
            this.setActionProperties(this.showSetLevelsAction, "showSetLevels");
        }
    }

    private void setActionProperties(Action action, String string) {
        Icon icon;
        String string2;
        String string3 = this.resources.getString("logFilterView.action." + string + ".name", null);
        if (string3 != null) {
            action.putValue("Name", string3);
        }
        if ((string2 = this.resources.getString("logFilterView.action." + string + ".icon", null)) != null && (icon = this.resources.getIcon(string2, null)) != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    private void setupResources() {
        if (defaultResources == null) {
            defaultResources = new MapResourceBundle();
            defaultResources.setResolvingClass(this.getClass());
            defaultResources.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/logfilterview", this.getClass());
        }
        this.resources = defaultResources;
    }

    private void setMnemonic(JMenuItem jMenuItem, String string) {
        if (LogFilterView.logger.level >= 7) {
            logger.log(7, "setMnemonic(JMenuItem,String)", (String)(LogFilterView.logger.level < 8 ? "" : "mi: " + String.valueOf(jMenuItem) + ", resource: " + string));
        }
        String string2 = this.resources.getString("logFilterView.action." + string + ".mnemonic", null);
        if (LogFilterView.logger.level >= 9) {
            logger.log(9, "setMnemonic(JMenuItem,String)", "mnemo:" + string2);
        }
        if (string2 != null) {
            jMenuItem.setMnemonic(string2.charAt(0));
        }
    }

    static {
        claLogger = new Logger("de.qfs.apps.qflog.logview.ChangeLevelAction");
        rlaLogger = new Logger("de.qfs.apps.qflog.logview.RemoveLevelAction");
        sslaLogger = new Logger("de.qfs.apps.qflog.logview.ShowSetLevelsAction");
        iconNames = new String[]{"logFilterView.icon.err", "logFilterView.icon.errDetail", "logFilterView.icon.wrn", "logFilterView.icon.wrnDetail", "logFilterView.icon.msg", "logFilterView.icon.msgDetail", "logFilterView.icon.mtd", "logFilterView.icon.mtdDetail", "logFilterView.icon.dbg", "logFilterView.icon.dbgDetail", "logFilterView.icon.method", "logFilterView.icon.class", "logFilterView.icon.classOpen", "logFilterView.icon.package", "logFilterView.icon.packageOpen"};
        icons = new Icon[iconNames.length];
    }

    private class Renderer
    extends WindowsTreeCellRenderer {
        public Renderer() {
            this.initIcons();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            jLabel.setForeground(((FilterNode)object).isExtra() ? Color.red : (bl ? this.getTextSelectionColor() : this.getTextNonSelectionColor()));
            Integer n2 = LogFilterView.this.model.getLevel(object);
            Icon icon = bl3 ? icons[10] : (object instanceof FilterRootNode || !((FilterNode)object).getData().getClazz().endsWith(".") ? icons[bl2 ? 12 : 11] : icons[bl2 ? 14 : 13]);
            if (n2 == null) {
                jLabel.setIcon(icon);
                return jLabel;
            }
            int n3 = n2;
            if (n3 < 1 || n3 > 10) {
                jLabel.setIcon(icon);
            } else {
                jLabel.setIcon(icons[n2 - 1]);
            }
            return jLabel;
        }

        private void initIcons() {
            if (icons[0] == null) {
                for (int i = 0; i < icons.length; ++i) {
                    LogFilterView.icons[i] = LogFilterView.this.resources.getIcon(iconNames[i], null);
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybePopup(MouseEvent mouseEvent) {
            boolean bl;
            boolean bl2 = bl = !LogFilterView.this.logging;
            if (bl) {
                Log.excludeThread();
            }
            try {
                if (mouseEvent.isPopupTrigger()) {
                    int n = LogFilterView.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n >= 0 && !LogFilterView.this.tree.isRowSelected(n)) {
                        LogFilterView.this.tree.setSelectionRow(n);
                    }
                    SwingUtil.showPopup(LogFilterView.this.popup, LogFilterView.this.tree, mouseEvent.getX(), mouseEvent.getY(), false);
                    LogFilterView.this.popup.requestFocus();
                }
            }
            finally {
                if (bl) {
                    Log.includeThread();
                }
            }
        }
    }

    private class RemoveLevelAction
    extends AbstractAction {
        private boolean recurse;

        public RemoveLevelAction(boolean bl) {
            this.recurse = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray;
            if (LogFilterView.this.logging && LogFilterView.rlaLogger.level >= 7) {
                rlaLogger.log(7, "actionPerformed(ActionEvent)", (String)(LogFilterView.rlaLogger.level < 8 ? "" : "recurse: " + this.recurse));
            }
            if ((treePathArray = LogFilterView.this.tree.getSelectionPaths()) != null) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    LogFilterView.this.model.removeLevel(treePathArray[i], this.recurse);
                }
            }
        }
    }

    private class ChangeLevelAction
    extends AbstractAction {
        private int level;

        public ChangeLevelAction(int n) {
            this.level = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray;
            if (LogFilterView.this.logging && LogFilterView.claLogger.level >= 7) {
                claLogger.log(7, "actionPerformed(ActionEvent)", (String)(LogFilterView.claLogger.level < 8 ? "" : "level: " + this.level));
            }
            if ((treePathArray = LogFilterView.this.tree.getSelectionPaths()) != null) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    LogFilterView.this.model.setLevel(treePathArray[i], this.level);
                }
            }
        }
    }

    private class ShowSetLevelsAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            boolean bl2 = bl = !LogFilterView.this.logging;
            if (bl) {
                Log.excludeThread();
            }
            try {
                this.maybeExpandPath(new TreePath(new Object[]{LogFilterView.this.model.getRoot()}));
            }
            finally {
                if (bl) {
                    Log.includeThread();
                }
            }
        }

        private boolean maybeExpandPath(TreePath treePath) {
            Object object;
            if (LogFilterView.this.logging && LogFilterView.sslaLogger.level >= 7) {
                sslaLogger.log(7, "maybeExpandPath(TreePath)", (String)(LogFilterView.sslaLogger.level < 8 ? "" : "path: " + String.valueOf(treePath)));
            }
            boolean bl = LogFilterView.this.model.getLevel(object = treePath.getLastPathComponent()) != null;
            boolean bl2 = false;
            if (LogFilterView.this.model.isLeaf(object)) {
                return bl;
            }
            int n = LogFilterView.this.model.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = LogFilterView.this.model.getChild(object, i);
                if (!this.maybeExpandPath(treePath.pathByAddingChild(object2))) continue;
                bl2 = true;
            }
            if (object == LogFilterView.this.model.getRoot()) {
                bl2 = true;
            }
            if (LogFilterView.sslaLogger.level >= 9) {
                sslaLogger.log(9, "maybeExpandPath(TreePath)", "expand: " + bl2);
            }
            if (bl2) {
                LogFilterView.this.tree.expandPath(treePath);
            } else {
                LogFilterView.this.tree.collapsePath(treePath);
            }
            return bl2 || bl;
        }
    }
}

