/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.apps.qflog.logview.InternalLogLevelCallback;
import de.qfs.apps.qflog.logview.LogLevelTreeModel;
import de.qfs.apps.qflog.logview.LogView;
import de.qfs.apps.qflog.logview.command.CommandFileClose;
import de.qfs.apps.qflog.logview.command.CommandLoadProguardMap;
import de.qfs.apps.qflog.logview.command.CommandSaveConfiguration;
import de.qfs.apps.qflog.logview.command.CommandSaveLog;
import de.qfs.lib.command.CommandDistributor;
import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.config.Configurator;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.NotifyingJFrame;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.ProguardMap;
import de.qfs.lib.option.KeyOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Observable;
import de.qfs.lib.util.Observer;
import de.qfs.lib.util.Reflector;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import lombok.Generated;

public class LogFrame
extends NotifyingJFrame
implements Observer {
    private static Logger logger = new Logger("de.qfs.apps.qflog.logview.LogFrame");
    private transient JMenuBar menuBar;
    private transient JMenu filterMenu;
    private transient JMenu levelMenu;
    protected transient LogView view;
    protected transient Configurator cfg;
    private transient boolean initialized;
    private transient boolean logging = false;
    private transient Action actionHelpKeys;
    private transient Action actionSaveAll;
    private transient Action actionSaveVisible;
    private transient Action actionLoadProguardMap;
    private transient Action actionUnloadProguardMap;
    private transient JMenuItem unloadProguardMapMenuItem;
    private transient Action actionSaveCfg;
    private transient Action actionLoadCfg;
    private transient Action actionCloseWindow;

    LogFrame() {
        this(new LogView());
        this.view.setLoggingEnabled(this.logging);
    }

    LogFrame(LogView logView) {
        boolean bl;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.view = logView;
            this.cfg = new Configurator("LogFrame");
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        boolean bl;
        if (this.logging && LogFrame.logger.level >= 7) {
            logger.log(7, "init()", "");
        }
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.view.init();
            String string = this.view.getClientName();
            this.setName("LogFrame-" + (string == null ? "" : string));
            this.setupActions();
            this.initMenu();
            OptionSet optionSet = this.view.getOptions();
            optionSet.getOption("ShowFilterView").addObserver(this);
            optionSet.getOption("ShowLevelView").addObserver(this);
            this.filterMenu.setEnabled(optionSet.getBoolean("ShowFilterView", false));
            this.levelMenu.setEnabled(optionSet.getBoolean("ShowLevelView", false));
            this.getContentPane().add(this.view);
            this.pack();
            this.setLocation(new Point(0, 10));
            this.setSize(new Dimension(1020, 750));
            this.cfg.add(ConfigWrapper.makeWrapper(this, "frame"));
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 123 && keyEvent.getModifiers() == 0) {
                        System.err.println(String.valueOf(SwingUtilities.findFocusOwner(LogFrame.this)));
                    }
                }
            });
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.logging && LogFrame.logger.level >= 7) {
            logger.log(7, "setVisible(boolean)", (String)(LogFrame.logger.level < 8 ? "" : "visible: " + bl));
        }
        if (bl) {
            this.init();
        }
        super.setVisible(bl);
    }

    @Override
    public void show() {
        block8: {
            Robot robot;
            block7: {
                if (this.logging && LogFrame.logger.level >= 7) {
                    logger.log(7, "show()", "");
                }
                this.init();
                robot = null;
                if (Misc.OS_IS_WINDOWS) {
                    try {
                        robot = new Robot();
                        robot.keyPress(17);
                        Thread.sleep(50L);
                    }
                    catch (Throwable throwable) {
                        if (LogFrame.logger.level < 3) break block7;
                        logger.log(3, "show()", throwable);
                    }
                }
            }
            super.show();
            this.toFront();
            if (Misc.OS_IS_WINDOWS) {
                try {
                    Thread.sleep(50L);
                    robot.keyRelease(17);
                }
                catch (Throwable throwable) {
                    if (LogFrame.logger.level < 3) break block8;
                    logger.log(3, "show()", throwable);
                }
            }
        }
    }

    @Override
    public void dispose() {
        boolean bl;
        if (this.logging && LogFrame.logger.level >= 7) {
            logger.log(7, "dispose()", "");
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            if (this.cfg.isRegistered()) {
                this.cfg.unregister(true);
                this.cfg = null;
            }
            OptionSet optionSet = this.view.getOptions();
            optionSet.getOption("ShowFilterView").deleteObserver(this);
            optionSet.getOption("ShowLevelView").deleteObserver(this);
            SwingUtil.cleanup(this);
            this.view.cleanup();
            this.view = null;
            super.dispose();
            this.removeNotify();
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    public final void setLoggingEnabled(boolean bl) {
        this.logging = bl;
    }

    public final LogView getView() {
        return this.view;
    }

    public final Configurator getConfigurator() {
        return this.cfg;
    }

    @Override
    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        if (aWTEvent.getID() == 507) {
            if (((MouseWheelEvent)aWTEvent).getScrollType() == 0 && ((MouseWheelEvent)aWTEvent2).getScrollType() == 0) {
                int n = ((MouseWheelEvent)aWTEvent).getScrollAmount();
                Reflector.safeSet(aWTEvent, "scrollAmount", (Object)(n += ((MouseWheelEvent)aWTEvent2).getScrollAmount()), true);
            }
            return aWTEvent;
        }
        return super.coalesceEvents(aWTEvent, aWTEvent2);
    }

    private void setupActions() {
        this.actionHelpKeys = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogFrame.this.showKeyBindings();
            }
        };
        this.actionSaveAll = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDistributor.getDefaultDistributor().assignCommand(new CommandSaveLog((Object)LogFrame.this, LogFrame.this, null, true, true));
            }
        };
        this.actionSaveVisible = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDistributor.getDefaultDistributor().assignCommand(new CommandSaveLog((Object)LogFrame.this, LogFrame.this, null, true, false));
            }
        };
        this.actionLoadProguardMap = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDistributor.getDefaultDistributor().assignCommand(new CommandLoadProguardMap(LogFrame.this, LogFrame.this, LogFrame.this.view));
            }
        };
        this.actionUnloadProguardMap = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogFrame.this.view.setProguardMap(null);
            }
        };
        this.actionSaveCfg = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDistributor.getDefaultDistributor().assignCommand(new CommandSaveConfiguration(LogFrame.this, LogFrame.this, true));
            }
        };
        this.actionLoadCfg = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDistributor.getDefaultDistributor().assignCommand(new CommandSaveConfiguration(LogFrame.this, LogFrame.this, false));
            }
        };
        this.actionCloseWindow = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDistributor.getDefaultDistributor().assignCommand(new CommandFileClose(LogFrame.this, LogFrame.this));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMenu() {
        boolean bl;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.menuBar = new JMenuBar();
            this.setJMenuBar(this.menuBar);
            JMenu jMenu = this.makeMenu("file");
            this.menuBar.add(jMenu);
            JMenuItem jMenuItem = this.makeMenuItem("fileSaveAll", this.actionSaveAll);
            if (KeyOption.DEFVAL_KEYSTROKE_SAVE_FILE_AS_SYSTEM != null) {
                jMenuItem.setAccelerator(KeyOptionEdit.getKeyStrokeForData(KeyOption.DEFVAL_KEYSTROKE_SAVE_FILE_AS_SYSTEM));
            }
            jMenu.add(jMenuItem);
            jMenuItem = this.makeMenuItem("fileSaveVis", this.actionSaveVisible);
            jMenu.add(jMenuItem);
            if (ProguardMap.detectLibDir() != null) {
                jMenu.addSeparator();
                jMenuItem = this.makeMenuItem("loadPGMap", this.actionLoadProguardMap);
                jMenu.add(jMenuItem);
                this.unloadProguardMapMenuItem = this.makeMenuItem("unloadPGMap", this.actionUnloadProguardMap);
                jMenu.add(this.unloadProguardMapMenuItem);
                this.unloadProguardMapMenuItem.setEnabled(this.view.getProguardMap() != null);
            }
            jMenu.addSeparator();
            jMenuItem = this.makeMenuItem("fileLoadCfg", this.actionLoadCfg);
            jMenu.add(jMenuItem);
            jMenuItem = this.makeMenuItem("fileSaveCfg", this.actionSaveCfg);
            jMenu.add(jMenuItem);
            jMenuItem = this.makeMenuItem("fileClose", this.actionCloseWindow);
            if (KeyOption.DEFVAL_KEYSTROKE_CLOSESUITE_SYSTEM != null) {
                jMenuItem.setAccelerator(KeyOptionEdit.getKeyStrokeForData(KeyOption.DEFVAL_KEYSTROKE_CLOSESUITE_SYSTEM));
            }
            jMenu.add(jMenuItem);
            JMenu jMenu2 = this.makeMenu("messages");
            this.menuBar.add(jMenu2);
            this.view.getTableView().fillMenu(jMenu2);
            this.filterMenu = this.makeMenu("filter");
            this.menuBar.add(this.filterMenu);
            this.view.getFilterView().fillMenu(this.filterMenu);
            this.levelMenu = this.makeMenu("level");
            this.menuBar.add(this.levelMenu);
            if (this.view.getLevelView() != null) {
                this.view.getLevelView().fillMenu(this.levelMenu);
            } else {
                this.levelMenu.setEnabled(false);
            }
            this.menuBar.add(this.view.makeViewMenu());
            JMenu jMenu3 = this.makeMenu("help");
            this.menuBar.add(jMenu3);
            jMenuItem = this.makeMenuItem("helpKeys", this.actionHelpKeys);
            jMenu3.add(jMenuItem);
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    protected JMenu makeMenu(String string) {
        JMenu jMenu = new JMenu(this.view.getResources().getString("logView.menu." + string + ".name", "MISSING: " + string));
        String string2 = this.view.getResources().getString("logView.menu." + string + ".mnemonic", null);
        if (string2 != null) {
            jMenu.setMnemonic(string2.charAt(0));
        }
        return jMenu;
    }

    protected JMenuItem makeMenuItem(String string, ActionListener actionListener) {
        MapResourceBundle mapResourceBundle = this.view.getResources();
        JMenuItem jMenuItem = new JMenuItem(mapResourceBundle.getString("logView.action." + string + ".name", "MISSING NAME: " + string));
        String string2 = mapResourceBundle.getString("logView.action." + string + ".mnemonic", null);
        if (string2 != null) {
            jMenuItem.setMnemonic(string2.charAt(0));
        }
        jMenuItem.setActionCommand(mapResourceBundle.getString("logView.action." + string + ".command", "MISSING COMMAND: " + string));
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private void showKeyBindings() {
        boolean bl;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            Message.showMessage(this, "keyBindings");
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object object) {
        if (this.logging && LogFrame.logger.level >= 7) {
            logger.log(7, "update(Observable,Object)", (String)(LogFrame.logger.level < 8 ? "" : "obj: " + String.valueOf(observable) + ", arg: " + String.valueOf(object)));
        }
        if (observable instanceof Option) {
            boolean bl;
            boolean bl2 = bl = !this.logging;
            if (bl) {
                Log.excludeThread();
            }
            try {
                Option option = (Option)observable;
                OptionSet optionSet = this.view.getOptions();
                if (option.getName().equals("ShowFilterView")) {
                    this.filterMenu.setEnabled(optionSet.getBoolean("ShowFilterView", false));
                } else if (option.getName().equals("ShowLevelView")) {
                    if (optionSet.getBoolean("ShowLevelView", false) && this.view.getLevelView() != null && this.levelMenu.getItemCount() == 0) {
                        this.view.getLevelView().fillMenu(this.levelMenu);
                    }
                    this.levelMenu.setEnabled(optionSet.getBoolean("ShowLevelView", false));
                }
            }
            finally {
                if (bl) {
                    Log.includeThread();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        Log.setQueueing(false);
        Log.setOutputLevel(10);
        Log.setPreQueueLevel(10);
        Logger.setDefaultLogLevel(10);
        final LogFrame logFrame = new LogFrame();
        SwingUtil.invokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logFrame.init();
                Log.excludeThread();
                try {
                    logFrame.getConfigurator().register();
                    logFrame.getView().getConfigurator().register();
                }
                finally {
                    Log.includeThread();
                }
                LogLevelTreeModel logLevelTreeModel = new LogLevelTreeModel();
                Logger.addLogLevelListener(logLevelTreeModel);
                logLevelTreeModel.setLogLevelCallback(new InternalLogLevelCallback(logLevelTreeModel));
                logFrame.getView().setLogLevels(logLevelTreeModel);
                logFrame.setTitle("Logging selftest");
                logFrame.addWindowListener(new WindowAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream("/tmp/logtest.cfg");
                            try {
                                Configuration.instance().save(fileOutputStream);
                            }
                            finally {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        System.exit(0);
                    }
                });
                Log.excludeThread();
                try {
                    Option.setResources(logFrame.view.getResources());
                    Message.setResources(logFrame.view.getResources());
                    FileInputStream fileInputStream = new FileInputStream("/tmp/logtest.cfg");
                    try {
                        Configuration.instance().restore(fileInputStream);
                    }
                    finally {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    Log.includeThread();
                }
                logFrame.show();
            }
        });
        for (int i = 0; i < 100; ++i) {
            LogEntry logEntry = new LogEntry(i % 10 + 1, i, "Thread" + i % 3, "Class" + i % 7, "Method" + i % 11, "message");
            logFrame.view.getTableView().getModel().filter(logEntry);
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Generated
    public JMenuItem getUnloadProguardMapMenuItem() {
        return this.unloadProguardMapMenuItem;
    }
}

