/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogLevelCallback;
import de.qfs.lib.log.LogLevelEvent;
import de.qfs.lib.log.LogLevelListener;
import de.qfs.lib.log.Logger;
import de.qfs.lib.option.BooleanOption;
import de.qfs.lib.option.ConfigurableOption;
import de.qfs.lib.option.IntegerOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.util.Observable;
import de.qfs.lib.util.Observer;
import de.qfs.lib.util.TaskQueue;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class LogLevelTreeModel
implements TreeModel,
Configurable,
Observer,
LogLevelListener {
    static final Logger logger = new Logger("de.qfs.apps.qflog.logview.LogLevelTreeModel");
    private List listeners = new ArrayList();
    Node root = new Node("", 4);
    private boolean rootSet;
    private LogLevelCallback callback;
    private int failures = 0;
    private static final int MAX_FAILURES = 3;
    private TaskQueue taskQueue;
    private String configurableName = "LogLevelTreeModel";
    private String rootName = "default";
    private OptionSet options;
    private boolean outputLevelSet;
    private boolean preQueueLevelSet;
    private boolean queueSizeSet;
    private boolean flushBufferSizeSet;
    private boolean flushTriggerLevelSet;
    private boolean postFlushSizeSet;
    private boolean logging;

    public LogLevelTreeModel() {
        boolean bl;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.options = new OptionSet("LogLevelOptions");
            Option option = new IntegerOption("OutputLevel", 10, true, false);
            option.addObserver(this);
            this.options.add(option);
            option = new IntegerOption("PreQueueLevel", 10, true, false);
            option.addObserver(this);
            this.options.add(option);
            option = new BooleanOption("Queueing", true);
            option.addObserver(this);
            this.options.add(option);
            option = new IntegerOption("QueueSize", 3000, true, false);
            option.addObserver(this);
            this.options.add(option);
            option = new BooleanOption("DropOnOverflow", false);
            option.addObserver(this);
            this.options.add(option);
            option = new IntegerOption("FlushBufferSize", 0, true, false);
            option.addObserver(this);
            this.options.add(option);
            option = new IntegerOption("FlushTriggerLevel", 1, true, false);
            option.addObserver(this);
            this.options.add(option);
            option = new IntegerOption("PostFlushSize", 10, true, false);
            option.addObserver(this);
            this.options.add(option);
            option = new BooleanOption("ForceValuesOnConnect", true);
            this.options.add(option);
            this.taskQueue = new TaskQueue("LogLevelTreeModelTaskQueue");
            this.taskQueue.setPriority(6);
            this.taskQueue.start();
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    public void cleanup() {
        if (this.logging && LogLevelTreeModel.logger.level >= 7) {
            logger.log(7, "cleanup()", "");
        }
        this.root = null;
        this.listeners = null;
        this.callback = null;
        this.taskQueue.finish(true);
        this.taskQueue = null;
        Option[] optionArray = this.options.getOptions();
        for (int i = 0; i < optionArray.length; ++i) {
            optionArray[i].deleteObservers();
        }
        this.options = null;
    }

    public final String getRootName() {
        return this.rootName;
    }

    public final void setRootName(String string) {
        this.rootName = string;
    }

    public final void setLoggingEnabled(boolean bl) {
        this.logging = bl;
    }

    public Object[] getPath(String string) {
        List list = this.root.findNodePath(string);
        Node node = (Node)list.get(list.size() - 1);
        if (node.name.equals(string)) {
            return list.toArray();
        }
        return null;
    }

    public final OptionSet getOptions() {
        return this.options;
    }

    public void setLogLevel(TreePath treePath, final int n) {
        final Node node = (Node)treePath.getLastPathComponent();
        if (node.level == null || node.level != n) {
            node.level = n;
            this.fireNodesChanged(treePath.getPath());
            if (this.callback != null && this.failures < 3) {
                this.taskQueue.addTask(new Runnable(){

                    @Override
                    public void run() {
                        LogLevelTreeModel.this.callback.setLogLevel(node.name, n);
                    }
                });
            }
        }
        if (node == this.root) {
            this.rootSet = true;
        }
    }

    public void removeLogLevel(TreePath treePath, boolean bl) {
        final Node node = (Node)treePath.getLastPathComponent();
        if (node == this.root && node.level != 4 || node.level != null) {
            node.level = node == this.root ? Integer.valueOf(4) : null;
            this.fireNodesChanged(treePath.getPath());
            if (this.callback != null && this.failures < 3) {
                this.taskQueue.addTask(new Runnable(){

                    @Override
                    public void run() {
                        LogLevelTreeModel.this.callback.removeLogLevel(node.name);
                    }
                });
            }
        }
        if (node == this.root) {
            this.rootSet = false;
        }
        if (bl) {
            int n;
            if (node.packages != null) {
                for (n = 0; n < node.packages.size(); ++n) {
                    this.removeLogLevel(treePath.pathByAddingChild(node.packages.get(n)), bl);
                }
            }
            if (node.classes != null) {
                for (n = 0; n < node.classes.size(); ++n) {
                    this.removeLogLevel(treePath.pathByAddingChild(node.classes.get(n)), bl);
                }
            }
        }
    }

    @Override
    public void classAdded(LogLevelEvent logLevelEvent) {
        boolean bl = !this.logging;
        final String[] stringArray = logLevelEvent.getNames();
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < stringArray.length; ++i) {
                    LogLevelTreeModel.this.classAddedImpl(stringArray[i]);
                }
            }
        });
    }

    private void classAddedImpl(String string) {
        int n;
        int n2;
        if (this.root == null) {
            return;
        }
        List list = this.root.findNodePath(string);
        Node node = (Node)list.get(list.size() - 1);
        if (node.name.equals(string)) {
            if (this.logging && LogLevelTreeModel.logger.level >= 3) {
                logger.log(3, "classAdded(String)", "Class already known: " + string);
            }
            return;
        }
        int n3 = n2 = node == this.root ? -1 : node.name.length();
        while ((n = string.indexOf(".", n2 + 1)) >= 0 && n != string.length() - 1) {
            Node node2 = new Node(string.substring(0, n + 1), null);
            int n4 = node.addChild(node2);
            this.fireNodesInserted(list.toArray(), n4);
            list.add(node2);
            node = node2;
            n2 = n;
        }
        Node node3 = new Node(string, null);
        int n5 = node.addChild(node3);
        this.fireNodesInserted(list.toArray(), n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void levelChanged(LogLevelEvent logLevelEvent) {
        boolean bl;
        final String[] stringArray = logLevelEvent.getNames();
        final int[] nArray = logLevelEvent.getLevels();
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            SwingUtil.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < stringArray.length; ++i) {
                        LogLevelTreeModel.this.levelChangedImpl(stringArray[i], nArray[i]);
                    }
                }
            });
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void levelChangedImpl(String string, int n) {
        boolean bl;
        if (this.root == null) {
            return;
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            List list = this.root.findNodePath(string);
            if (!((Node)list.get((int)(list.size() - 1))).name.equals(string)) {
                this.classAddedImpl(string);
                list = this.root.findNodePath(string);
            }
            Node node = (Node)list.get(list.size() - 1);
            node.level = n;
            if (node == this.root) {
                this.rootSet = true;
            }
            this.fireNodesChanged(list.toArray());
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    @Override
    public void levelRemoved(LogLevelEvent logLevelEvent) {
        final String[] stringArray = logLevelEvent.getNames();
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < stringArray.length; ++i) {
                    LogLevelTreeModel.this.levelRemovedImpl(stringArray[i]);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void levelRemovedImpl(String string) {
        boolean bl;
        if (this.root == null) {
            return;
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            Node node;
            List list = this.root.findNodePath(string);
            if (!((Node)list.get((int)(list.size() - 1))).name.equals(string)) {
                this.classAddedImpl(string);
                list = this.root.findNodePath(string);
            }
            if ((node = (Node)list.get(list.size() - 1)) == this.root) {
                node.level = 4;
                this.rootSet = false;
            } else {
                node.level = null;
            }
            this.fireNodesChanged(list.toArray());
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLogLevelCallback(LogLevelCallback logLevelCallback) {
        boolean bl;
        if (this.logging && LogLevelTreeModel.logger.level >= 7) {
            logger.log(7, "setLogLevelCallback(LogLevelCallback)", "");
        }
        this.callback = logLevelCallback;
        this.failures = 0;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            Option option;
            boolean bl3 = this.options.getBoolean("ForceValuesOnConnect", false);
            Properties properties = null;
            if (bl3) {
                properties = this.getConfigurableState();
            } else {
                this.removeLogLevel(new TreePath(new Object[]{this.root}), true);
            }
            final Object[] objectArray = logLevelCallback.getLogLevels();
            SwingUtil.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < objectArray.length; i += 2) {
                        String string = (String)objectArray[i];
                        Integer n = (Integer)objectArray[i + 1];
                        if (n == null) {
                            LogLevelTreeModel.this.classAddedImpl(string);
                            continue;
                        }
                        LogLevelTreeModel.this.levelChangedImpl(string, n);
                    }
                }
            });
            if (!bl3 || !this.outputLevelSet) {
                option = this.options.getOption("OutputLevel");
                option.setValue(logLevelCallback.getOutputLevel());
                option.notifyObservers(logLevelCallback);
            }
            if (!bl3 || !this.preQueueLevelSet) {
                option = this.options.getOption("PreQueueLevel");
                option.setValue(logLevelCallback.getPreQueueLevel());
                option.notifyObservers(logLevelCallback);
            }
            if (!bl3 || !this.queueSizeSet) {
                option = this.options.getOption("QueueSize");
                option.setValue(logLevelCallback.getQueueSize());
                option.notifyObservers(logLevelCallback);
            }
            if (!bl3 || !this.flushBufferSizeSet) {
                option = this.options.getOption("FlushBufferSize");
                option.setValue(logLevelCallback.getFlushBufferSize());
                option.notifyObservers(logLevelCallback);
            }
            if (!bl3 || !this.flushTriggerLevelSet) {
                option = this.options.getOption("FlushTriggerLevel");
                option.setValue(logLevelCallback.getFlushTriggerLevel());
                option.notifyObservers(logLevelCallback);
            }
            if (!bl3 || !this.postFlushSizeSet) {
                option = this.options.getOption("PostFlushSize");
                option.setValue(logLevelCallback.getPostFlushSize());
                option.notifyObservers(logLevelCallback);
            }
            if (properties != null) {
                this.setConfigurableState(properties);
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    @Override
    public String getConfigurableName() {
        return this.configurableName;
    }

    @Override
    public void setConfigurableName(String string) {
        this.configurableName = string;
    }

    @Override
    public Properties getConfigurableState() {
        if (this.logging && LogLevelTreeModel.logger.level >= 7) {
            logger.log(7, "getConfigurableState()", "");
        }
        Properties properties = new Properties();
        this.root.fillProperties(properties);
        if (!this.rootSet) {
            properties.remove("*default*");
        }
        if (this.outputLevelSet) {
            properties.put("-OutputLevel", "" + this.options.getInt("OutputLevel", 0));
        }
        if (this.preQueueLevelSet) {
            properties.put("-PreQueueLevel", "" + this.options.getInt("PreQueueLevel", 0));
        }
        properties.put("-Queueing", "" + this.options.getBoolean("Queueing", true));
        if (this.queueSizeSet) {
            properties.put("-QueueSize", "" + this.options.getInt("QueueSize", 0));
        }
        properties.put("-DropOnOverflow", "" + this.options.getBoolean("DropOnOverflow", true));
        if (this.flushBufferSizeSet) {
            properties.put("-FlushBufferSize", "" + this.options.getInt("FlushBufferSize", 0));
        }
        if (this.flushTriggerLevelSet) {
            properties.put("-FlushTriggerLevel", "" + this.options.getInt("FlushTriggerLevel", 0));
        }
        if (this.postFlushSizeSet) {
            properties.put("-PostFlushSize", "" + this.options.getInt("PostFlushSize", 0));
        }
        properties.put("-ForceValuesOnConnect", "" + this.options.getBoolean("ForceValuesOnConnect", false));
        return properties;
    }

    @Override
    public void setConfigurableState(final Properties properties) {
        if (this.logging && LogLevelTreeModel.logger.level >= 7) {
            logger.log(7, "setConfigurableState(Properties)", "");
        }
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                LogLevelTreeModel.this.outputLevelSet = false;
                LogLevelTreeModel.this.preQueueLevelSet = false;
                LogLevelTreeModel.this.queueSizeSet = false;
                LogLevelTreeModel.this.flushBufferSizeSet = false;
                LogLevelTreeModel.this.flushTriggerLevelSet = false;
                LogLevelTreeModel.this.postFlushSizeSet = false;
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    try {
                        String string;
                        String string2 = (String)enumeration.nextElement();
                        if (string2.charAt(0) == '-') {
                            string = string2.substring(1);
                            Option option = LogLevelTreeModel.this.options.getOption(string);
                            ((ConfigurableOption)((Object)option)).setConfigurableValue((String)properties.get(string2));
                            option.notifyObservers();
                            continue;
                        }
                        string = string2.equals("*default*") ? "" : string2;
                        final int n = Integer.parseInt(properties.getProperty(string2));
                        if (LogLevelTreeModel.this.callback != null && LogLevelTreeModel.this.failures < 3) {
                            LogLevelTreeModel.this.taskQueue.addTask(new Runnable(){

                                @Override
                                public void run() {
                                    LogLevelTreeModel.this.callback.setLogLevel(string, n);
                                }
                            });
                        }
                        LogLevelTreeModel.this.levelChangedImpl(string, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!LogLevelTreeModel.this.logging || LogLevelTreeModel.logger.level < 3) continue;
                        logger.log("setConfigurableState(Properties)", numberFormatException);
                    }
                    catch (NullPointerException nullPointerException) {
                        if (!LogLevelTreeModel.this.logging || LogLevelTreeModel.logger.level < 3) continue;
                        logger.log("setConfigurableState(Properties)", nullPointerException);
                    }
                }
            }
        });
    }

    @Override
    public void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2) {
        if (LogLevelTreeModel.logger.level >= 7) {
            logger.log(7, "registrationChanged(Configuration,String,boolean,boolean)", (String)(LogLevelTreeModel.logger.level < 8 ? "" : "name: " + string + ", registered: " + bl));
        }
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        int n2;
        if (n < 0) {
            throw new IndexOutOfBoundsException("Illegal index: " + n);
        }
        Node node = (Node)object;
        int n3 = n2 = node.packages == null ? 0 : node.packages.size();
        if (n < n2) {
            return node.packages.get(n);
        }
        if (node.classes == null || n - n2 >= node.classes.size()) {
            throw new IndexOutOfBoundsException("Illegal index: " + n);
        }
        return node.classes.get(n - n2);
    }

    @Override
    public int getChildCount(Object object) {
        Node node = (Node)object;
        return (node.packages == null ? 0 : node.packages.size()) + (node.classes == null ? 0 : node.classes.size());
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        int n;
        Node node = (Node)object;
        int n2 = n = node.packages == null ? 0 : node.packages.size();
        if (((Node)object2).name.endsWith(".")) {
            if (node.packages == null) {
                return -1;
            }
            return Collections.binarySearch(node.packages, object2, NodeComparator.instance);
        }
        if (node.classes == null) {
            return -1;
        }
        int n3 = Collections.binarySearch(node.classes, object2, NodeComparator.instance);
        return n3 < 0 ? -1 : n3 + n;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return !((Node)object).isPackage();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodesInserted(Object[] objectArray, int n) {
        TreeModelListener[] treeModelListenerArray;
        Object object = this.getChild(objectArray[objectArray.length - 1], n);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray, new int[]{n}, new Object[]{object});
        LogLevelTreeModel logLevelTreeModel = this;
        synchronized (logLevelTreeModel) {
            treeModelListenerArray = this.listeners.toArray(new TreeModelListener[0]);
        }
        for (int i = 0; i < treeModelListenerArray.length; ++i) {
            treeModelListenerArray[i].treeNodesInserted(treeModelEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodesChanged(Object[] objectArray) {
        TreeModelListener[] treeModelListenerArray;
        Object object = this;
        synchronized (object) {
            treeModelListenerArray = this.listeners.toArray(new TreeModelListener[0]);
        }
        object = new TreeModelEvent((Object)this, objectArray);
        for (int i = 0; i < treeModelListenerArray.length; ++i) {
            treeModelListenerArray[i].treeNodesChanged((TreeModelEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeStructureChanged(Object[] objectArray) {
        TreeModelListener[] treeModelListenerArray;
        Object object = this;
        synchronized (object) {
            treeModelListenerArray = this.listeners.toArray(new TreeModelListener[0]);
        }
        object = new TreeModelEvent((Object)this, objectArray);
        for (int i = 0; i < treeModelListenerArray.length; ++i) {
            treeModelListenerArray[i].treeStructureChanged((TreeModelEvent)object);
        }
    }

    public String getClazz(Object object) {
        return ((Node)object).name;
    }

    public Integer getLevel(Object object) {
        return ((Node)object).level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object object) {
        if (this.logging && LogLevelTreeModel.logger.level >= 7) {
            logger.log(7, "update(Observable,Object)", (String)(LogLevelTreeModel.logger.level < 8 ? "" : "obj: " + String.valueOf(observable) + ", arg: " + String.valueOf(object)));
        }
        if (observable instanceof Option) {
            boolean bl;
            if (this.callback != null && object == this.callback) {
                return;
            }
            boolean bl2 = bl = !this.logging;
            if (bl) {
                Log.excludeThread();
            }
            try {
                Option option = (Option)observable;
                if (option.getName().equals("OutputLevel")) {
                    if (option.getValue() == null) {
                        this.outputLevelSet = false;
                    } else {
                        if (this.callback != null) {
                            this.callback.setOutputLevel(this.options.getInt("OutputLevel", 0));
                        }
                        this.outputLevelSet = true;
                    }
                } else if (option.getName().equals("PreQueueLevel")) {
                    if (option.getValue() == null) {
                        this.preQueueLevelSet = false;
                    } else {
                        if (this.callback != null) {
                            this.callback.setPreQueueLevel(this.options.getInt("PreQueueLevel", 0));
                        }
                        this.preQueueLevelSet = true;
                    }
                } else if (option.getName().equals("Queueing")) {
                    if (this.callback != null) {
                        this.callback.setQueueing(this.options.getBoolean("Queueing", true));
                    }
                } else if (option.getName().equals("QueueSize")) {
                    if (option.getValue() == null) {
                        this.queueSizeSet = false;
                    } else {
                        if (this.callback != null) {
                            this.callback.setQueueSize(this.options.getInt("QueueSize", 0));
                        }
                        this.queueSizeSet = true;
                    }
                } else if (option.getName().equals("DropOnOverflow")) {
                    if (this.callback != null) {
                        this.callback.setDropOnOverflow(this.options.getBoolean("DropOnOverflow", true));
                    }
                } else if (option.getName().equals("FlushBufferSize")) {
                    if (option.getValue() == null) {
                        this.flushBufferSizeSet = false;
                    } else {
                        if (this.callback != null) {
                            this.callback.setFlushBufferSize(this.options.getInt("FlushBufferSize", 0));
                        }
                        this.flushBufferSizeSet = true;
                    }
                } else if (option.getName().equals("FlushTriggerLevel")) {
                    if (option.getValue() == null) {
                        this.flushTriggerLevelSet = false;
                    } else {
                        if (this.callback != null) {
                            this.callback.setFlushTriggerLevel(this.options.getInt("FlushTriggerLevel", 0));
                        }
                        this.flushTriggerLevelSet = true;
                    }
                } else if (option.getName().equals("PostFlushSize")) {
                    if (option.getValue() == null) {
                        this.postFlushSizeSet = false;
                    } else {
                        if (this.callback != null) {
                            this.callback.setPostFlushSize(this.options.getInt("PostFlushSize", 0));
                        }
                        this.postFlushSizeSet = true;
                    }
                }
            }
            finally {
                if (bl) {
                    Log.includeThread();
                }
            }
        }
    }

    class Node {
        public String name;
        public Integer level;
        public List classes;
        public List packages;

        public Node(String string, Integer n) {
            this.name = string;
            this.level = n;
        }

        public List findNodePath(String string) {
            ArrayList arrayList = new ArrayList();
            LogLevelTreeModel.this.root.findNodePath(string, arrayList);
            return arrayList;
        }

        public int addChild(Node node) {
            if (this.isPackage(node.name)) {
                return this.addPackageNode(node);
            }
            return this.addClassNode(node) + (this.packages == null ? 0 : this.packages.size());
        }

        public boolean isPackage() {
            return this.isPackage(this.name);
        }

        public String toString() {
            if (this.isPackage(this.name)) {
                return this.name.length() == 0 ? LogLevelTreeModel.this.getRootName() : this.name.substring(0, this.name.length() - 1);
            }
            return this.name.substring(this.name.lastIndexOf(".") + 1);
        }

        private boolean isPackage(String string) {
            return string.length() == 0 || string.endsWith(".");
        }

        private int addClassNode(Node node) {
            int n;
            if (this.classes == null) {
                this.classes = new ArrayList();
            }
            if ((n = Collections.binarySearch(this.classes, node.name, NodeComparator.instance)) < 0) {
                this.classes.add(-n - 1, node);
                return -n - 1;
            }
            return -1;
        }

        private int addPackageNode(Node node) {
            int n;
            if (this.packages == null) {
                this.packages = new ArrayList();
            }
            if ((n = Collections.binarySearch(this.packages, node.name, NodeComparator.instance)) < 0) {
                this.packages.add(-n - 1, node);
                return -n - 1;
            }
            return -1;
        }

        public void findNodePath(String string, List list) {
            int n;
            list.add(this);
            if (!this.isPackage(string) && this.classes != null && (n = Collections.binarySearch(this.classes, string, NodeComparator.instance)) >= 0) {
                list.add(this.classes.get(n));
                return;
            }
            if (this.packages != null) {
                for (Node node : this.packages) {
                    if (string.equals(node.name)) {
                        list.add(node);
                        return;
                    }
                    if (!string.startsWith(node.name)) continue;
                    node.findNodePath(string, list);
                }
            }
        }

        public synchronized void fillProperties(Properties properties) {
            int n;
            if (this.level != null) {
                properties.put(this.name.length() == 0 ? "*default*" : this.name, this.level.toString());
            }
            if (this.packages != null) {
                for (n = 0; n < this.packages.size(); ++n) {
                    ((Node)this.packages.get(n)).fillProperties(properties);
                }
            }
            if (this.classes != null) {
                for (n = 0; n < this.classes.size(); ++n) {
                    ((Node)this.classes.get(n)).fillProperties(properties);
                }
            }
        }
    }

    private static class NodeComparator
    implements Comparator {
        public static NodeComparator instance = new NodeComparator();

        private NodeComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = object instanceof Node ? ((Node)object).name : (String)object;
            String string2 = object2 instanceof Node ? ((Node)object2).name : (String)object2;
            return Collator.getInstance().compare(string, string2);
        }
    }
}

