/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.apps.qflog.logview.LogTableModel;
import de.qfs.lib.gui.TableModelFilter;
import de.qfs.lib.gui.TableModelFilterEvent;
import de.qfs.lib.gui.TableModelFilterListener;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import java.util.Vector;
import javax.swing.table.TableModel;

class LogTableFilter
implements TableModelFilter,
TableModelFilterListener {
    private TableModelFilter filter;
    private int filterLevel = -1;
    private String filterThread = null;
    private String filterClass = null;
    private String filterMethod = null;
    private String filterString = null;
    private Vector listeners = new Vector();
    private boolean logging;

    public LogTableFilter() {
    }

    public LogTableFilter(TableModelFilter tableModelFilter) {
        this.filter = tableModelFilter;
        if (tableModelFilter != null) {
            tableModelFilter.addTableModelFilterListener(this);
        }
    }

    public final void setLoggingEnabled(boolean bl) {
        this.logging = bl;
    }

    public void setFilter(TableModelFilter tableModelFilter) {
        if (this.filter != null) {
            this.filter.removeTableModelFilterListener(this);
        }
        this.filter = tableModelFilter;
        if (tableModelFilter != null) {
            tableModelFilter.addTableModelFilterListener(this);
        }
        this.fireFilterChanged();
    }

    public void setFilterLevel(int n) {
        this.filterLevel = this.filterLevel == -1 ? n : -1;
        this.fireFilterChanged();
    }

    public void setFilterThread(String string) {
        this.filterThread = this.filterThread == null ? string : null;
        this.fireFilterChanged();
    }

    public void setFilterClass(String string) {
        this.filterClass = this.filterClass == null ? string : null;
        this.fireFilterChanged();
    }

    public final String getFilterMethod() {
        return this.filterMethod;
    }

    public void setFilterMethod(String string) {
        this.filterMethod = string;
        this.fireFilterChanged();
    }

    public void setFilterString(String string) {
        this.filterString = this.filterString == null ? string : null;
        this.fireFilterChanged();
    }

    public void clearFilters() {
        this.filterLevel = -1;
        this.filterThread = null;
        this.filterClass = null;
        this.filterMethod = null;
        this.filterString = null;
        this.fireFilterChanged();
    }

    @Override
    public boolean filter(TableModel tableModel, int n) {
        if (this.filter != null && !this.filter.filter(tableModel, n)) {
            return false;
        }
        LogEntry logEntry = ((LogTableModel)tableModel).getEntry(n);
        if (this.filterLevel >= 0 && logEntry.getLevel() != this.filterLevel) {
            return false;
        }
        if (this.filterThread != null && !this.filterThread.equals(logEntry.getThread())) {
            return false;
        }
        if (this.filterClass != null && !this.filterClass.equals(logEntry.getClazz())) {
            return false;
        }
        if (!(this.filterMethod == null || this.filterMethod.equals(logEntry.getMethod()) || this.filterMethod.endsWith(")") && logEntry.getMethod().startsWith(this.filterMethod))) {
            return false;
        }
        return this.filterString == null || logEntry.getMessage() != null && logEntry.getMessage().toLowerCase().indexOf(this.filterString) >= 0;
    }

    @Override
    public void addTableModelFilterListener(TableModelFilterListener tableModelFilterListener) {
        this.listeners.addElement(tableModelFilterListener);
    }

    @Override
    public void removeTableModelFilterListener(TableModelFilterListener tableModelFilterListener) {
        this.listeners.removeElement(tableModelFilterListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFilterChanged() {
        boolean bl;
        Vector vector = (Vector)this.listeners.clone();
        TableModelFilterEvent tableModelFilterEvent = new TableModelFilterEvent(this);
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            for (int i = 0; i < vector.size(); ++i) {
                ((TableModelFilterListener)vector.elementAt(i)).filterChanged(tableModelFilterEvent);
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    @Override
    public void filterChanged(TableModelFilterEvent tableModelFilterEvent) {
        this.fireFilterChanged();
    }
}

