/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.TableModelFilter;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogUser;
import de.qfs.lib.log.Logger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class LogTableModel
extends AbstractTableModel
implements LogUser {
    private static Logger logger = new Logger("de.qfs.apps.qflog.logview.LogTableModel");
    public static final int COL_LEVEL = 0;
    public static final int COL_TIME = 1;
    public static final int COL_THREAD = 2;
    public static final int COL_CLASS = 3;
    public static final int COL_METHOD = 4;
    public static final int COL_DETAIL = 5;
    public static final int NUM_COLUMNS = 6;
    public static final int COL_ENTRY = -1;
    private String[] columnNames = new String[]{"Level", "Time", "Thread", "Class", "Method", "Message"};
    private List data = new ArrayList();
    private List newData = new ArrayList();
    private SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    protected Updater updater;
    private int doUpdate;
    private boolean inUpdate;
    private Vector listeners = new Vector();
    private int maxData = 100000;
    private int deleted = 0;
    private boolean logging = true;
    private int logUserMode = 3;
    private static final Logger uLogger = new Logger("de.qfs.apps.qflog.logview.Updater");

    public LogTableModel() {
        this.updater = new Updater();
        this.updater.setPriority(1);
        this.updater.setName("LogTableUpdater");
        this.updater.setDaemon(true);
        if (!this.logging) {
            Log.excludeThread(this.updater);
        }
        this.updater.start();
    }

    public void setColumnNames(String[] stringArray) {
        if (stringArray.length != 6) {
            throw new IllegalArgumentException("names array must contain exactly 6 elements");
        }
        this.columnNames = stringArray;
    }

    public final void setLoggingEnabled(boolean bl) {
        if (this.logging != bl) {
            this.logging = bl;
            if (this.logging) {
                Log.includeThread(this.updater);
            } else {
                Log.excludeThread(this.updater);
            }
        }
    }

    public LogEntry getEntry(int n) {
        if (n >= 0 && n < this.data.size()) {
            return (LogEntry)this.data.get(n);
        }
        return null;
    }

    public LogEntry[] getData() {
        return this.data.toArray(new LogEntry[0]);
    }

    public void setData(LogEntry[] logEntryArray) {
        if (this.logging && LogTableModel.logger.level >= 7) {
            logger.log(7, "setData(LogEntry[])", (String)(LogTableModel.logger.level < 8 ? "" : "data.length: " + logEntryArray.length));
        }
        if (this.data != null) {
            this.deleted += this.data.size();
        }
        for (int i = 0; i < logEntryArray.length; ++i) {
            logEntryArray[i] = this.processEntry(logEntryArray[i]);
        }
        this.data = new ArrayList<LogEntry>(Arrays.asList(logEntryArray));
        if (this.maxData > 0 && this.data.size() > this.maxData) {
            this.deleted += this.data.size() - this.maxData;
            this.data.subList(0, this.data.size() - this.maxData).clear();
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public int getDeleted() {
        return this.deleted;
    }

    public synchronized int getPending() {
        return this.doUpdate == 0 ? 0 : this.newData.size();
    }

    public final int getMaxRows() {
        return this.maxData;
    }

    public final synchronized void setMaxRows(int n) {
        if (this.logging && LogTableModel.logger.level >= 7) {
            logger.log(7, "setMaxRows(int)", (String)(LogTableModel.logger.level < 8 ? "" : "maxRows: " + n));
        }
        this.maxData = n;
        this.notifyAll();
    }

    public final int getDoUpdate() {
        return this.doUpdate;
    }

    public final synchronized void setDoUpdate(int n) {
        if (LogTableModel.logger.level >= 7) {
            logger.log(7, "setDoUpdate(int)", (String)(LogTableModel.logger.level < 8 ? "" : "doUpdate: " + n));
        }
        this.doUpdate = n;
        this.notifyAll();
    }

    public synchronized void reduceToVisible(TableModelFilter tableModelFilter) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (tableModelFilter.filter(this, i)) continue;
            this.data.remove(i--);
            ++this.deleted;
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public synchronized void removeVisible(TableModelFilter tableModelFilter) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!tableModelFilter.filter(this, i)) continue;
            this.data.remove(i--);
            ++this.deleted;
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public synchronized void removeRows(int[] nArray) {
        if (LogTableModel.logger.level >= 7) {
            logger.log(7, "removeRows(int[])", (String)(LogTableModel.logger.level < 8 ? "" : "rows.length: " + nArray.length));
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.data.remove(nArray[i]);
        }
        this.deleted += nArray.length;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public synchronized void cleanup() {
        if (this.logging && LogTableModel.logger.level >= 7) {
            logger.log(7, "cleanup()", "");
        }
        this.newData = null;
        this.notifyAll();
        Log.includeThread(this.updater);
        this.data = null;
        this.listenerList = null;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Integer.class;
        }
        return super.getColumnClass(n);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        LogEntry logEntry = (LogEntry)this.data.get(n);
        switch (n2) {
            case -1: {
                return logEntry;
            }
            case 0: {
                return logEntry.getLevel();
            }
            case 1: {
                return this.df.format(new Date(logEntry.getTimestamp()));
            }
            case 2: {
                return logEntry.getThread();
            }
            case 3: {
                int n3 = logEntry.getClazz().lastIndexOf(".");
                if (n3 == -1) {
                    return logEntry.getClazz();
                }
                return logEntry.getClazz().substring(n3 + 1);
            }
            case 4: {
                return logEntry.getMethod();
            }
            case 5: {
                return logEntry.getMessage();
            }
        }
        return "";
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.removeElement(changeListener);
        this.listeners.insertElementAt(changeListener, 0);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.removeElement(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePendingChanged() {
        Vector vector;
        final ChangeEvent changeEvent = new ChangeEvent(this);
        LogTableModel logTableModel = this;
        synchronized (logTableModel) {
            vector = (Vector)this.listeners.clone();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < vector.size(); ++i) {
                    ((ChangeListener)vector.elementAt(i)).stateChanged(changeEvent);
                }
            }
        });
    }

    @Override
    public synchronized boolean filter(LogEntry logEntry) {
        this.newData.add(this.processEntry(logEntry));
        if (this.doUpdate == 1) {
            this.firePendingChanged();
            while (this.newData.size() > this.maxData / 2) {
                this.newData.remove(0);
                ++this.deleted;
            }
        }
        this.updater.interrupt();
        return this.logUserMode == 3 || this.logUserMode == 1;
    }

    @Override
    public synchronized LogEntry[] filter(LogEntry[] logEntryArray) {
        for (int i = 0; i < logEntryArray.length; ++i) {
            this.newData.add(this.processEntry(logEntryArray[i]));
        }
        if (this.doUpdate == 1) {
            this.firePendingChanged();
        }
        this.updater.interrupt();
        if (this.logUserMode == 3 || this.logUserMode == 1) {
            return logEntryArray;
        }
        return new LogEntry[0];
    }

    @Override
    public final void setFilterMode(int n) {
        this.logUserMode = n;
    }

    protected LogEntry processEntry(LogEntry logEntry) {
        return logEntry;
    }

    public boolean isInUpdate() {
        return this.inUpdate;
    }

    private class Updater
    extends Thread {
        private Updater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LogTableModel.this.logging && LogTableModel.uLogger.level >= 7) {
                uLogger.log(7, "run()", "");
            }
            while (LogTableModel.this.newData != null) {
                List list;
                LogTableModel logTableModel = LogTableModel.this;
                synchronized (logTableModel) {
                    while (LogTableModel.this.doUpdate == 1 || LogTableModel.this.newData.size() == 0 && (LogTableModel.this.maxData <= 0 || LogTableModel.this.data.size() <= LogTableModel.this.maxData)) {
                        try {
                            LogTableModel.this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (LogTableModel.this.newData != null) continue;
                        return;
                    }
                }
                if (LogTableModel.this.logging && LogTableModel.uLogger.level >= 9) {
                    uLogger.log(9, "run()", "Got new data");
                }
                boolean bl = true;
                long l = System.currentTimeMillis() + 1000L;
                while (bl && LogTableModel.this.newData != null && System.currentTimeMillis() < l) {
                    try {
                        Updater.sleep(100L);
                        bl = false;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (LogTableModel.this.logging && LogTableModel.uLogger.level >= 9) {
                    uLogger.log(9, "run()", "wakeup - " + (String)(LogTableModel.this.newData == null ? "Updater finished" : LogTableModel.this.newData.size() + " new rows"));
                }
                LogTableModel logTableModel2 = LogTableModel.this;
                synchronized (logTableModel2) {
                    if (LogTableModel.this.newData == null) {
                        return;
                    }
                    list = LogTableModel.this.newData;
                    LogTableModel.this.newData = new ArrayList();
                }
                SwingUtil.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Updater.this.update(list);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(List list) {
            boolean bl;
            boolean bl2 = bl = !LogTableModel.this.logging;
            if (bl) {
                Log.excludeThread();
            }
            try {
                LogTableModel.this.inUpdate = true;
                if (LogTableModel.this.logging && LogTableModel.uLogger.level >= 7) {
                    uLogger.log(7, "update(List)", (String)(LogTableModel.uLogger.level < 8 ? "" : "newStuff: " + list.size() + " rows"));
                }
                int n = LogTableModel.this.data.size();
                int n2 = list.size();
                if (LogTableModel.this.maxData > 0 && n2 > LogTableModel.this.maxData) {
                    if (LogTableModel.this.logging && LogTableModel.uLogger.level >= 9) {
                        uLogger.log(9, "update(List)", "Replacing data with newStuff");
                    }
                    LogTableModel.this.deleted += n;
                    LogTableModel.this.deleted += n2 - LogTableModel.this.maxData;
                    list.subList(0, n2 - LogTableModel.this.maxData).clear();
                    LogTableModel.this.data = list;
                    if (LogTableModel.this.data.size() != LogTableModel.this.maxData && LogTableModel.this.logging && LogTableModel.uLogger.level >= 1) {
                        uLogger.log(1, "update(List)", "Internal error, wrong data size -data.size(): " + LogTableModel.this.data.size() + ", maxData: " + LogTableModel.this.maxData);
                    }
                    LogTableModel.this.fireTableDataChanged();
                    return;
                }
                int n3 = n + n2 - LogTableModel.this.maxData;
                if (LogTableModel.this.maxData > 0 && n3 > 0) {
                    LogTableModel.this.data.subList(0, n3).clear();
                    LogTableModel.this.deleted += n3;
                    if (LogTableModel.this.logging && LogTableModel.uLogger.level >= 9) {
                        uLogger.log(9, "update(List)", "Removing " + n3 + " rows");
                    }
                    LogTableModel.this.fireTableRowsDeleted(0, n3 - 1);
                    n -= n3;
                }
                if (n2 > 0) {
                    LogTableModel.this.data.addAll(list);
                    if (n2 > 500) {
                        LogTableModel.this.fireTableDataChanged();
                    } else {
                        if (LogTableModel.this.logging && LogTableModel.uLogger.level >= 9) {
                            uLogger.log(9, "update(List)", "Adding " + list.size() + " rows");
                        }
                        LogTableModel.this.fireTableRowsInserted(n, n + n2 - 1);
                    }
                }
            }
            finally {
                LogTableModel.this.inUpdate = false;
                if (bl) {
                    Log.includeThread();
                }
            }
        }
    }
}

