/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.apps.qflog.logview.LogDetailView;
import de.qfs.apps.qflog.logview.LogSorter;
import de.qfs.apps.qflog.logview.LogTableFilter;
import de.qfs.apps.qflog.logview.LogTableModel;
import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configurator;
import de.qfs.lib.gui.DelayedListSelectionListener;
import de.qfs.lib.gui.FilteredAndSortedTableModel;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.MultiPane;
import de.qfs.lib.gui.SortedTableHeaderCellRenderer;
import de.qfs.lib.gui.SortedTableHelper;
import de.qfs.lib.gui.StatusLine;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.TableModelFilter;
import de.qfs.lib.gui.WindowsTableCellRenderer;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.ProguardMap;
import de.qfs.lib.log.ProguardMapPossessor;
import de.qfs.lib.option.BooleanOption;
import de.qfs.lib.option.IntegerOption;
import de.qfs.lib.option.KeyOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionDialog;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.util.DelayedAction;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Observable;
import de.qfs.lib.util.Observer;
import de.qfs.lib.util.Reflector;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import lombok.Generated;

public class LogTableView
extends JPanel
implements Observer,
AWTEventListener,
ProguardMapPossessor {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.logview.LogTableView");
    private static final String[] iconNames = new String[]{"logTableView.icon.err", "logTableView.icon.errDetail", "logTableView.icon.wrn", "logTableView.icon.wrnDetail", "logTableView.icon.msg", "logTableView.icon.msgDetail", "logTableView.icon.mtd", "logTableView.icon.mtdDetail", "logTableView.icon.dbg", "logTableView.icon.dbgDetail"};
    private static final Color[] bgColors = new Color[]{new Color(253, 209, 209), new Color(255, 214, 214), new Color(255, 255, 219), new Color(255, 255, 224), new Color(214, 220, 253), new Color(219, 225, 255), new Color(226, 237, 226), new Color(231, 242, 231), new Color(240, 238, 209), new Color(245, 243, 214)};
    private static final Color[] selectedColors = new Color[]{new Color(243, 159, 159), new Color(248, 164, 164), new Color(245, 235, 99), new Color(250, 240, 104), new Color(164, 170, 255), new Color(169, 175, 255), new Color(176, 237, 176), new Color(181, 242, 181), new Color(205, 198, 169), new Color(210, 203, 174)};
    private static final Icon[] icons = new Icon[iconNames.length];
    private static final String LINESEP = System.getProperty("line.separator");
    private transient LogTableModel model;
    private transient boolean initialized;
    private JLabel titleLabel;
    private String titleBase;
    private transient JTable table;
    private transient int rowHeight = 16;
    private transient JScrollPane tablePane;
    private transient LogSorter sorter;
    private transient LogTableFilter filter;
    private transient boolean[] filterEnabled = new boolean[6];
    private transient SortedTableHelper tableHelper;
    private transient CellSelectionListener selListener;
    private transient InitialFocusListener focusListener;
    private transient TableKeyListener tableKeyListener;
    private transient PopupListener popupListener;
    private Markers markers;
    private transient LogDetailView detailView;
    private transient MultiPane multiPane;
    private transient StatusLine statusLine;
    private transient Search search;
    private transient Configurator configurator = new Configurator("LogTable");
    private transient MapResourceBundle resources;
    private OptionSet options = new OptionSet("Options");
    private transient JPopupMenu popup;
    private transient JMenu setMenu;
    private transient JMenu goMenu;
    private OptionDialog optionDialog;
    private transient boolean logging;
    private boolean showColors = true;
    private Action copySelectedAction;
    private Action copyVisibleAction;
    private Action copyAllAction;
    private Action clearAction;
    private Action clearSelectedAction;
    private Action reduceToVisibleAction;
    private Action removeVisibleAction;
    private Action toggleColumnFilterAction;
    private Action clearColumnFiltersAction;
    private Action setSortColumnAction;
    private Action[] setMarkerActions;
    private Action[] gotoMarkerActions;
    private Action toggleUpdateAction;
    private Action editOptionsAction;
    private ProguardMap proguardMap;
    private static final Logger mLogger = new Logger("de.qfs.apps.qflog.logview.Markers");
    private static final int KEY_MASK = 11;
    private static final int DELAY = 200;
    private static final Logger cslLogger = new Logger("de.qfs.apps.qflog.logview.CellSelectionListener");

    public LogTableView(LogTableModel logTableModel) {
        this.model = logTableModel;
        this.resources = new MapResourceBundle();
        this.resources.setResolvingClass(this.getClass());
        this.resources.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/logtableview", this.getClass());
    }

    public void init() {
        Serializable serializable;
        JPanel jPanel;
        block7: {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            Option option = new IntegerOption("MaxRows", 100000, true, false){

                @Override
                public void setValueFromString(String string) {
                    Object object = this.getValueFromString(string);
                    if (object != null && !(object instanceof Integer)) {
                        throw new IllegalArgumentException("Value is not an Integer: " + string);
                    }
                    if (object != null && LogTableView.this.model != null) {
                        LogTableView.this.model.setMaxRows((Integer)object);
                    }
                    super.setValueFromString(string);
                }
            };
            option.addObserver(this);
            this.options.add(option);
            option = new BooleanOption("ShowLines", true);
            option.addObserver(this);
            this.options.add(option);
            option = new BooleanOption("ShowColors", true);
            option.addObserver(this);
            this.options.add(option);
            this.initIcons();
            this.setLayout(new BorderLayout());
            this.setBorder(null);
            jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(null);
            this.titleBase = this.resources.getString("logTableView.title", "Messages");
            this.titleLabel = new JLabel(this.titleBase);
            this.titleLabel.setForeground(UIManager.getColor("textText"));
            this.titleLabel.setBorder(BorderFactory.createEtchedBorder());
            this.titleLabel.setHorizontalTextPosition(10);
            jPanel.add((Component)this.titleLabel, "North");
            String[] stringArray = new String[]{this.resources.getString("logTableView.table.level.title", "Level"), this.resources.getString("logTableView.table.time.title", "Time"), this.resources.getString("logTableView.table.thread.title", "Thread"), this.resources.getString("logTableView.table.class.title", "Class"), this.resources.getString("logTableView.table.method.title", "Method"), this.resources.getString("logTableView.table.message.title", "Message")};
            this.model.setColumnNames(stringArray);
            this.table = new JTable(this.model);
            String string = System.getProperty("de.qfs.apps.qflog.table.font.size");
            if (string != null) {
                try {
                    float f = Float.parseFloat(string);
                    if (LogTableView.logger.level >= 9) {
                        logger.build("init()").add("fontSize: ").add(f).log(9);
                    }
                    serializable = this.table.getFont().deriveFont(f);
                    if (Misc.OS_IS_WINDOWS) {
                        serializable = ((Font)serializable).deriveFont(AffineTransform.getTranslateInstance(0.0, -2.0));
                    }
                    this.table.setFont((Font)serializable);
                    this.rowHeight = ((Font)serializable).getSize() + 3;
                }
                catch (NumberFormatException numberFormatException) {
                    if (LogTableView.logger.level < 1) break block7;
                    logger.log(1, "init()", numberFormatException);
                }
            }
        }
        Object object = Reflector.safeCall((Object)new JTextField(), "getFocusTraversalKeys", new Class[]{Integer.TYPE}, new Object[]{0});
        Reflector.safeCall((Object)this.table, "setFocusTraversalKeys", new Class[]{Integer.TYPE, Set.class}, new Object[]{0, object});
        object = Reflector.safeCall((Object)new JTextField(), "getFocusTraversalKeys", new Class[]{Integer.TYPE}, new Object[]{1});
        Reflector.safeCall((Object)this.table, "setFocusTraversalKeys", new Class[]{Integer.TYPE, Set.class}, new Object[]{1, object});
        this.table.setName("MessageTable");
        serializable = new JTableHeader(this.table.getColumnModel()){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        ((JComponent)serializable).setRequestFocusEnabled(false);
        this.table.setTableHeader((JTableHeader)serializable);
        this.table.setBorder(null);
        this.setBackground(this.table.getBackground());
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowMargin(1);
        this.table.setRowHeight(this.rowHeight);
        this.sorter = new LogSorter("Sorter");
        this.configurator.add(this.sorter);
        this.table.setDefaultRenderer(Integer.class, new LevelRenderer(true));
        this.table.setDefaultRenderer(Object.class, new LevelRenderer(false));
        if (this.filter == null) {
            this.filter = new LogTableFilter();
            this.filter.setLoggingEnabled(this.logging);
        }
        this.tableHelper = new SortedTableHelper(this.table, this.filter, this.sorter);
        this.tableHelper.prepareTable();
        this.table.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setIdentifier("Level");
        tableColumnModel.getColumn(0).setPreferredWidth(24);
        tableColumnModel.getColumn(1).setIdentifier("Time");
        tableColumnModel.getColumn(1).setPreferredWidth(94);
        tableColumnModel.getColumn(2).setIdentifier("Thread");
        tableColumnModel.getColumn(2).setPreferredWidth(84);
        tableColumnModel.getColumn(3).setIdentifier("Class");
        tableColumnModel.getColumn(3).setPreferredWidth(100);
        tableColumnModel.getColumn(4).setIdentifier("Method");
        tableColumnModel.getColumn(4).setPreferredWidth(100);
        tableColumnModel.getColumn(5).setIdentifier("Message");
        tableColumnModel.getColumn(5).setPreferredWidth(380);
        this.configurator.add(ConfigWrapper.makeWrapper(this.table, "Table"));
        this.table.getSelectionModel().setAnchorSelectionIndex(-1);
        this.focusListener = new InitialFocusListener();
        this.table.addFocusListener(this.focusListener);
        this.tableHelper.saveSelection(true);
        this.tableHelper.setHeaderCellRenderer(new HeaderRenderer());
        this.tablePane = new JScrollPane(this.table);
        this.tablePane.setName("MessageScrollPane");
        this.tablePane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tablePane.getViewport().putClientProperty("EnableWindowBlit", "true");
        jPanel.add((Component)this.tablePane, "Center");
        this.detailView = new LogDetailView();
        this.detailView.setLoggingEnabled(this.logging);
        this.detailView.setResources(this.resources);
        this.detailView.setProguardMap(this.proguardMap);
        this.detailView.init();
        this.selListener = new CellSelectionListener();
        this.table.getSelectionModel().addListSelectionListener(this.selListener);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this.selListener);
        this.table.getModel().addTableModelListener(this.selListener);
        this.model.addTableModelListener(this.selListener);
        this.markers = new Markers();
        this.model.addTableModelListener(this.markers);
        this.multiPane = new MultiPane("MultiPane", 0, jPanel, this.detailView, 0.8, 0, false);
        this.configurator.add(this.multiPane);
        this.add((Component)this.multiPane, "Center");
        this.tableKeyListener = new TableKeyListener();
        this.table.addKeyListener(this.tableKeyListener);
        this.search = new Search();
        this.table.addKeyListener(this.search);
        this.table.registerKeyboardAction(this.search, "backsearch", KeyStroke.getKeyStroke(8, 0), 0);
        this.table.registerKeyboardAction(this.search, "copysearch", KeyStroke.getKeyStroke(113, 0), 0);
        this.table.registerKeyboardAction(this.search, "pastesearch", KeyStroke.getKeyStroke(86, 2), 0);
        this.table.registerKeyboardAction(this.search, "searchagain", KeyStroke.getKeyStroke(114, 0), 0);
        this.table.registerKeyboardAction(this.search, "clearsearch", KeyStroke.getKeyStroke(27, 0), 0);
        this.table.registerKeyboardAction(this.search, "previoussearch", KeyStroke.getKeyStroke(27, 1), 0);
        this.table.registerKeyboardAction(this.search, "revertsearch", KeyStroke.getKeyStroke(82, 2), 0);
        this.setupActions();
        this.table.registerKeyboardAction(this.toggleColumnFilterAction, "toggleFilter", KeyStroke.getKeyStroke(70, 2), 0);
        this.table.registerKeyboardAction(this.clearColumnFiltersAction, "clearFilters", KeyStroke.getKeyStroke(75, 2), 0);
        this.table.registerKeyboardAction(this.setSortColumnAction, "setSortColumn", KeyStroke.getKeyStroke(83, 2), 0);
        this.popup = new JPopupMenu();
        this.fillMenu(this.popup);
        this.popupListener = new PopupListener();
        this.table.addMouseListener(this.popupListener);
        this.configurator.add(this.options);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
    }

    public void cleanup() {
        if (this.logging && LogTableView.logger.level >= 7) {
            logger.log(7, "cleanup()", "");
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        SwingUtil.cleanup(this);
        this.statusLine = null;
        this.table.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.table.getSelectionModel().removeListSelectionListener(this.selListener);
        this.table.getColumnModel().getSelectionModel().removeListSelectionListener(this.selListener);
        this.table.getModel().removeTableModelListener(this.selListener);
        this.model.removeTableModelListener(this.selListener);
        this.selListener = null;
        this.model.removeTableModelListener(this.markers);
        this.markers = null;
        this.table.removeKeyListener(this.tableKeyListener);
        this.tableKeyListener = null;
        this.table.removeKeyListener(this.search);
        this.search = null;
        SwingUtil.cleanup(this.popup);
        this.popup = null;
        this.setMenu = null;
        this.goMenu = null;
        this.table.removeMouseListener(this.popupListener);
        this.popupListener = null;
        this.detailView.cleanup();
        this.detailView = null;
        this.model.cleanup();
        this.model = null;
        this.tableHelper = null;
        this.table.resetKeyboardActions();
        this.table = null;
        Option[] optionArray = this.options.getOptions();
        for (int i = 0; i < optionArray.length; ++i) {
            optionArray[i].deleteObservers();
        }
        this.options = null;
        this.resources = null;
    }

    public final LogTableModel getModel() {
        return this.model;
    }

    public final JTable getTable() {
        return this.table;
    }

    public final MultiPane getMultiPane() {
        return this.multiPane;
    }

    public void fillMenu(JMenu jMenu) {
        JMenuItem jMenuItem = jMenu.add(this.copySelectedAction);
        this.setMnemonic(jMenuItem, "copySelected");
        jMenuItem.setAccelerator(KeyOptionEdit.getKeyStrokeForData(KeyOption.DEFVAL_KEYSTROKE_COPY_SYSTEM));
        jMenuItem = jMenu.add(this.copyVisibleAction);
        this.setMnemonic(jMenuItem, "copyVisible");
        jMenuItem = jMenu.add(this.copyAllAction);
        this.setMnemonic(jMenuItem, "copyAll");
        jMenu.addSeparator();
        jMenuItem = jMenu.add(this.clearSelectedAction);
        this.setMnemonic(jMenuItem, "clearSelected");
        jMenuItem.setAccelerator(KeyOptionEdit.getKeyStrokeForData(KeyOption.DEFVAL_KEYSTROKE_DELETE_SYSTEM));
        jMenuItem = jMenu.add(this.removeVisibleAction);
        this.setMnemonic(jMenuItem, "removeVisible");
        jMenuItem = jMenu.add(this.clearAction);
        this.setMnemonic(jMenuItem, "clear");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        jMenuItem = jMenu.add(this.reduceToVisibleAction);
        this.setMnemonic(jMenuItem, "reduceToVisible");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jMenu.addSeparator();
        jMenuItem = jMenu.add(this.setSortColumnAction);
        this.setMnemonic(jMenuItem, "setSortColumn");
        jMenuItem = jMenu.add(this.toggleColumnFilterAction);
        this.setMnemonic(jMenuItem, "toggleColumnFilter");
        jMenuItem = jMenu.add(this.clearColumnFiltersAction);
        this.setMnemonic(jMenuItem, "clearColumnFilters");
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu(this.resources.getString("logTableView.action.setMarker.name", "Set Mark"));
        String string = this.resources.getString("logTableView.action.setMarker.mnemonic", null);
        if (string != null) {
            jMenu2.setMnemonic(string.charAt(0));
        }
        for (int i = 0; i <= 9; ++i) {
            jMenuItem = jMenu2.add(this.setMarkerActions[i]);
            this.setMnemonic(jMenuItem, "setMarker" + i);
        }
        jMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu(this.resources.getString("logTableView.action.gotoMarker.name", "Goto Mark"));
        string = this.resources.getString("logTableView.action.gotoMarker.name", null);
        if (string != null) {
            jMenu3.setMnemonic(string.charAt(0));
        }
        for (int i = 0; i <= 9; ++i) {
            jMenuItem = jMenu3.add(this.gotoMarkerActions[i]);
            this.setMnemonic(jMenuItem, "gotoMarker" + i);
        }
        jMenu.add(jMenu3);
        jMenu.addSeparator();
        jMenuItem = new JCheckBoxMenuItem((String)this.toggleUpdateAction.getValue("Name"));
        jMenuItem.addActionListener(this.toggleUpdateAction);
        jMenuItem.setSelected(this.model.getDoUpdate() == 0);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = jMenu.add(this.editOptionsAction);
        this.setMnemonic(jMenuItem, "editOptions");
    }

    public void fillMenu(JPopupMenu jPopupMenu) {
        int n;
        jPopupMenu.add(this.copySelectedAction);
        jPopupMenu.add(this.copyVisibleAction);
        jPopupMenu.add(this.copyAllAction);
        jPopupMenu.add(this.clearAction);
        jPopupMenu.add(this.reduceToVisibleAction);
        jPopupMenu.add(this.removeVisibleAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.setSortColumnAction);
        jPopupMenu.add(this.toggleColumnFilterAction);
        jPopupMenu.add(this.clearColumnFiltersAction);
        jPopupMenu.addSeparator();
        this.setMenu = new JMenu(this.resources.getString("logTableView.action.setMarker.name", "Set Mark"));
        for (n = 0; n <= 9; ++n) {
            this.setMenu.add(this.setMarkerActions[n]);
        }
        jPopupMenu.add(this.setMenu);
        this.goMenu = new JMenu(this.resources.getString("logTableView.action.gotoMarker.name", "Goto Mark"));
        for (n = 0; n <= 9; ++n) {
            this.goMenu.add(this.gotoMarkerActions[n]);
        }
        jPopupMenu.add(this.goMenu);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.editOptionsAction);
    }

    public Configurator getConfigurator() {
        return this.configurator;
    }

    public final OptionSet getOptions() {
        return this.options;
    }

    public final void setLoggingEnabled(boolean bl) {
        this.logging = bl;
        this.model.setLoggingEnabled(bl);
        if (this.detailView != null) {
            this.detailView.setLoggingEnabled(this.logging);
        }
        if (this.filter != null) {
            this.filter.setLoggingEnabled(this.logging);
        }
    }

    public void setStatusLine(StatusLine statusLine) {
        this.statusLine = statusLine;
        if (this.search != null) {
            this.search.setTitle();
        }
    }

    public void setResources(ResourceBundle resourceBundle) {
        this.resources.addResources(resourceBundle);
    }

    public final void setFilter(TableModelFilter tableModelFilter) {
        if (this.filter == null) {
            this.filter = new LogTableFilter(tableModelFilter);
            this.filter.setLoggingEnabled(this.logging);
        } else {
            this.filter.setFilter(tableModelFilter);
        }
    }

    @Override
    public final void setProguardMap(ProguardMap proguardMap) {
        this.proguardMap = proguardMap;
        if (this.detailView != null) {
            this.detailView.setProguardMap(proguardMap);
        }
    }

    public void copySelectedToClipboard() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length > 0) {
            TableModel tableModel = this.table.getModel();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(((LogEntry)tableModel.getValueAt(nArray[i], -1)).toString());
                stringBuffer.append(LINESEP);
            }
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            SwingUtil.safeSetClipboard(null, stringSelection, stringSelection);
        }
    }

    public void copyVisibleToClipboard() {
        if (this.table.getRowCount() > 0) {
            TableModel tableModel = this.table.getModel();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                stringBuffer.append(((LogEntry)tableModel.getValueAt(i, -1)).toString());
                stringBuffer.append(LINESEP);
            }
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            SwingUtil.safeSetClipboard(null, stringSelection, stringSelection);
        }
    }

    public void copyAllToClipboard() {
        LogEntry[] logEntryArray = this.model.getData();
        if (logEntryArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < logEntryArray.length; ++i) {
                stringBuffer.append(logEntryArray[i].toString());
                stringBuffer.append(LINESEP);
            }
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            SwingUtil.safeSetClipboard(null, stringSelection, stringSelection);
        }
    }

    public void clearAll() {
        this.selListener.forgetSavedRow();
        this.model.setData(new LogEntry[0]);
    }

    public void clearSelected() {
        int n;
        int[] nArray;
        if (LogTableView.logger.level >= 7) {
            logger.log(7, "clearSelected()", "");
        }
        if ((nArray = this.table.getSelectedRows()) == null || nArray.length == 0) {
            return;
        }
        int n2 = this.table.getSelectionModel().getLeadSelectionIndex();
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n2) continue;
            ++n3;
        }
        n2 -= n3;
        this.table.clearSelection();
        FilteredAndSortedTableModel filteredAndSortedTableModel = (FilteredAndSortedTableModel)this.table.getModel();
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = filteredAndSortedTableModel.getMappedRow(nArray[n]);
        }
        Arrays.sort(nArray2);
        this.model.removeRows(nArray2);
        n = Math.min(n2, this.table.getRowCount() - 1);
        if (n >= 0) {
            this.table.setRowSelectionInterval(n, n);
        }
    }

    public void reduceToVisible() {
        this.selListener.forgetSavedRow();
        this.model.reduceToVisible(this.filter);
    }

    public void removeVisible() {
        this.selListener.forgetSavedRow();
        this.model.removeVisible(this.filter);
    }

    public void showDetail(boolean bl) {
        if (this.logging && LogTableView.logger.level >= 7) {
            logger.log(7, "showDetail(boolean)", (String)(LogTableView.logger.level < 8 ? "" : "show: " + bl));
        }
        this.multiPane.setShowing(bl ? 0 : 1);
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 501 && ((MouseEvent)aWTEvent).getButton() >= 4 && ((MouseEvent)aWTEvent).getButton() <= 9) {
            Window window;
            Component component;
            if (LogTableView.logger.level >= 9) {
                logger.build("eventDispatched(AWTEvent)").add("e: ").add(aWTEvent).log(9);
            }
            if (!((component = (Component)aWTEvent.getSource()) instanceof Window)) {
                component = SwingUtilities.getWindowAncestor(component);
            }
            if ((window = SwingUtilities.getWindowAncestor(this)) == component) {
                this.markers.jumpToRecent(((MouseEvent)aWTEvent).getButton() % 2 == 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object object) {
        if (this.logging && LogTableView.logger.level >= 7) {
            logger.log(7, "update(Observable,Object)", (String)(LogTableView.logger.level < 8 ? "" : "obj: " + String.valueOf(observable) + ", arg: " + String.valueOf(object)));
        }
        if (observable instanceof Option) {
            boolean bl;
            boolean bl2 = bl = !this.logging;
            if (bl) {
                Log.excludeThread();
            }
            try {
                Option option = (Option)observable;
                if (option.getName().equals("MaxRows")) {
                    this.model.setMaxRows(this.options.getInt("MaxRows", 0));
                } else if (option.getName().equals("ShowLines")) {
                    if (this.options.getBoolean("ShowLines", true)) {
                        this.table.getColumnModel().setColumnMargin(1);
                        this.table.setRowMargin(1);
                        this.table.setRowHeight(this.rowHeight);
                        this.table.setShowVerticalLines(true);
                        this.table.setShowHorizontalLines(true);
                    } else {
                        this.table.getColumnModel().setColumnMargin(0);
                        this.table.setRowMargin(0);
                        this.table.setRowHeight(this.rowHeight + 1);
                        this.table.setShowVerticalLines(false);
                        this.table.setShowHorizontalLines(false);
                    }
                } else if (option.getName().equals("ShowColors")) {
                    this.showColors = this.options.getBoolean("ShowColors", true);
                    this.table.repaint();
                    this.table.revalidate();
                }
            }
            finally {
                if (bl) {
                    Log.includeThread();
                }
            }
        }
    }

    private void initIcons() {
        if (icons[0] == null) {
            for (int i = 0; i < icons.length; ++i) {
                LogTableView.icons[i] = this.resources.getIcon(iconNames[i], null);
            }
        }
    }

    private void setupActions() {
        if (this.copySelectedAction == null) {
            this.copySelectedAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogTableView.this.copySelectedToClipboard();
                }
            };
            this.setActionProperties(this.copySelectedAction, "copySelected");
            this.copyVisibleAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogTableView.this.copyVisibleToClipboard();
                }
            };
            this.setActionProperties(this.copyVisibleAction, "copyVisible");
            this.copyAllAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogTableView.this.copyAllToClipboard();
                }
            };
            this.setActionProperties(this.copyAllAction, "copyAll");
            this.clearAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogTableView.this.clearAll();
                }
            };
            this.setActionProperties(this.clearAction, "clear");
            this.clearSelectedAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogTableView.this.clearSelected();
                }
            };
            this.setActionProperties(this.clearSelectedAction, "clearSelected");
            this.reduceToVisibleAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogTableView.this.reduceToVisible();
                }
            };
            this.setActionProperties(this.reduceToVisibleAction, "reduceToVisible");
            this.removeVisibleAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogTableView.this.removeVisible();
                }
            };
            this.setActionProperties(this.removeVisibleAction, "removeVisible");
            this.toggleColumnFilterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex();
                    int n2 = LogTableView.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                    if (n == -1 || n2 == -1) {
                        return;
                    }
                    int n3 = LogTableView.this.table.convertColumnIndexToModel(n2);
                    LogTableView.this.filterCell(n, n3);
                }
            };
            this.setActionProperties(this.toggleColumnFilterAction, "toggleColumnFilter");
            this.clearColumnFiltersAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogTableView.this.filter.clearFilters();
                    for (int i = 0; i < LogTableView.this.filterEnabled.length; ++i) {
                        LogTableView.this.filterEnabled[i] = false;
                        LogTableView.this.table.getTableHeader().repaint();
                    }
                }
            };
            this.setActionProperties(this.clearColumnFiltersAction, "clearColumnFilters");
            this.setSortColumnAction = new AbstractAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl;
                    boolean bl2 = bl = !LogTableView.this.logging;
                    if (bl) {
                        Log.excludeThread();
                    }
                    try {
                        int n = LogTableView.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                        if (n == -1) {
                            return;
                        }
                        int n2 = LogTableView.this.table.convertColumnIndexToModel(n);
                        LogTableView.this.sorter.setSortColumn(n2);
                    }
                    finally {
                        if (bl) {
                            Log.includeThread();
                        }
                    }
                }
            };
            this.setActionProperties(this.setSortColumnAction, "setSortColumn");
            this.setMarkerActions = new Action[10];
            this.gotoMarkerActions = new Action[10];
            for (int i = 0; i <= 9; ++i) {
                this.setMarkerActions[i] = new SetMarkerAction("" + i);
                this.setActionProperties(this.setMarkerActions[i], "setMarker" + i);
                this.gotoMarkerActions[i] = new GotoMarkerAction("" + i);
                this.setActionProperties(this.gotoMarkerActions[i], "gotoMarker" + i);
            }
            this.toggleUpdateAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogTableView.this.model.setDoUpdate(1 - LogTableView.this.model.getDoUpdate());
                }
            };
            this.setActionProperties(this.toggleUpdateAction, "toggleUpdate");
            this.editOptionsAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogTableView.this.editOptions();
                }
            };
            this.setActionProperties(this.editOptionsAction, "editOptions");
        }
    }

    private void setActionProperties(Action action, String string) {
        Icon icon;
        String string2;
        String string3 = this.resources.getString("logTableView.action." + string + ".name", null);
        if (string3 != null) {
            action.putValue("Name", string3);
        }
        if ((string2 = this.resources.getString("logTableView.action." + string + ".icon", null)) != null && (icon = this.resources.getIcon(string2, null)) != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    private void setMnemonic(JMenuItem jMenuItem, String string) {
        String string2 = this.resources.getString("logTableView.action." + string + ".mnemonic", null);
        if (string2 != null) {
            jMenuItem.setMnemonic(string2.charAt(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editOptions() {
        boolean bl;
        if (this.logging && LogTableView.logger.level >= 7) {
            logger.log(7, "editOptions()", "");
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            Window window = SwingUtilities.windowForComponent(this);
            Frame frame = window instanceof Frame ? (Frame)window : new Frame();
            if (this.optionDialog == null) {
                this.optionDialog = new OptionDialog("logTableView", frame, this.options, "tableview");
                this.optionDialog.setReusable(true);
                SwingUtil.closeOnEscape(this.optionDialog);
            } else {
                this.optionDialog.update(this.options);
            }
            this.optionDialog.doModal(this, true);
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    private void restoreRow(int n, int n2) {
        if (this.logging && LogTableView.logger.level >= 7) {
            logger.log(7, "restoreRow(int,int)", (String)(LogTableView.logger.level < 8 ? "" : "row: " + n + ", column: " + n2));
        }
        if (n >= 0) {
            FilteredAndSortedTableModel filteredAndSortedTableModel = (FilteredAndSortedTableModel)this.table.getModel();
            int n3 = filteredAndSortedTableModel.getNearestReverseRow(n);
            if (n3 != 0 && n3 < filteredAndSortedTableModel.getRowCount()) {
                this.jumpToRow(n3, false);
            }
            if (n2 >= 0) {
                this.table.addColumnSelectionInterval(n2, n2);
            }
        }
    }

    private void jumpToRow(int n, boolean bl) {
        Rectangle rectangle = this.table.getCellRect(n, 0, false);
        JViewport jViewport = (JViewport)this.table.getParent();
        Dimension dimension = jViewport.getSize();
        Point point = jViewport.getViewPosition();
        if (!bl && point.y <= rectangle.y && point.y + dimension.height >= rectangle.y + rectangle.height) {
            this.table.addRowSelectionInterval(n, n);
            return;
        }
        Dimension dimension2 = this.table.getSize();
        point.y = rectangle.y - (dimension.height - rectangle.height) / 2;
        if (point.y + dimension.height > dimension2.height) {
            point.y = dimension2.height - dimension.height;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        ((JViewport)this.table.getParent()).setViewPosition(point);
        this.table.getParent().repaint();
        this.table.addRowSelectionInterval(n, n);
        this.table.getSelectionModel().setAnchorSelectionIndex(n);
    }

    private void filterCell(int n, int n2) {
        LogEntry logEntry = (LogEntry)this.table.getValueAt(n, -1);
        switch (n2) {
            case 0: {
                this.filter.setFilterLevel(logEntry.getLevel());
                this.filterEnabled[0] = !this.filterEnabled[0];
                this.table.getTableHeader().repaint();
                break;
            }
            case 2: {
                this.filter.setFilterThread(logEntry.getThread());
                this.filterEnabled[2] = !this.filterEnabled[2];
                this.table.getTableHeader().repaint();
                break;
            }
            case 3: {
                this.filter.setFilterClass(logEntry.getClazz());
                this.filterEnabled[3] = !this.filterEnabled[3];
                this.table.getTableHeader().repaint();
                break;
            }
            case 4: {
                String string = logEntry.getMethod();
                int n3 = string.indexOf(").");
                if (string.equals(this.filter.getFilterMethod()) || n3 < 0 || n3 == string.length() - 1) {
                    this.filterEnabled[4] = !this.filterEnabled[4];
                    this.filter.setFilterMethod(this.filterEnabled[4] ? string : null);
                } else {
                    String string2 = string.substring(0, n3 + 1);
                    if (string2.equals(this.filter.getFilterMethod())) {
                        this.filter.setFilterMethod(string);
                    } else {
                        this.filter.setFilterMethod(string2);
                    }
                    this.filterEnabled[4] = true;
                }
                this.table.getTableHeader().repaint();
                break;
            }
            case 5: {
                String string;
                String string3 = string = this.search == null ? null : this.search.search.toString();
                if ("".equals(string)) {
                    string = null;
                }
                this.filter.setFilterString(string);
                this.filterEnabled[5] = !this.filterEnabled[5] && string != null;
                this.table.getTableHeader().repaint();
            }
        }
    }

    @Override
    @Generated
    public ProguardMap getProguardMap() {
        return this.proguardMap;
    }

    public class LevelRenderer
    extends WindowsTableCellRenderer {
        private boolean isLevel;

        public LevelRenderer(boolean bl) {
            this.isLevel = bl;
            LogTableView.this.initIcons();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = (Integer)jTable.getModel().getValueAt(n, 0);
            if (this.isLevel) {
                Icon icon = null;
                if (n3 >= 1 && n3 <= 10) {
                    icon = icons[n3 - 1];
                }
                if (icon != null) {
                    jLabel.setIcon(icon);
                    jLabel.setText(null);
                }
            }
            if (LogTableView.this.showColors && n3 >= 1 && n3 <= 10) {
                jLabel.setBackground((bl ? selectedColors : bgColors)[n3 - 1]);
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }
    }

    private class InitialFocusListener
    extends FocusAdapter {
        private InitialFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex() < 0 && LogTableView.this.table.getRowCount() > 0) {
                LogTableView.this.table.setRowSelectionInterval(0, 0);
            }
        }
    }

    private class HeaderRenderer
    extends SortedTableHeaderCellRenderer {
        public HeaderRenderer() {
            super(LogTableView.this.table);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (LogTableView.this.filterEnabled[n3]) {
                jLabel.setForeground(Color.red);
            } else {
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }
    }

    protected class CellSelectionListener
    extends DelayedListSelectionListener
    implements TableModelListener,
    Runnable {
        private DelayedAction delay;
        private int lastRow;
        private int lastColumn;

        public CellSelectionListener() {
            super(200);
            this.lastRow = -1;
            this.delay = new DelayedAction(200);
        }

        public void forgetSavedRow() {
            this.lastRow = -1;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            super.valueChanged(listSelectionEvent);
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n;
                if (LogTableView.this.table.getSelectionModel().isSelectionEmpty()) {
                    n = -1;
                } else {
                    n = LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex();
                    if (n >= LogTableView.this.table.getRowCount()) {
                        n = -1;
                    }
                }
                LogTableView.this.markers.rowChanged(n);
            }
        }

        @Override
        public void delayedValueChanged(ListSelectionEvent listSelectionEvent) {
            if (LogTableView.this.logging && LogTableView.cslLogger.level >= 7) {
                cslLogger.log(7, "delayedValueChanged(ListSelectionEvent)", (String)(LogTableView.cslLogger.level < 8 ? "" : "e: " + String.valueOf(listSelectionEvent)));
            }
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (LogTableView.this.table.getSelectionModel().isSelectionEmpty()) {
                LogTableView.this.detailView.setEntry(null);
                this.lastRow = -1;
            } else {
                int n = LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex();
                this.lastColumn = LogTableView.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                if (n >= 0 && n < LogTableView.this.table.getRowCount()) {
                    LogTableView.this.detailView.setEntry((LogEntry)LogTableView.this.table.getModel().getValueAt(n, -1));
                    this.lastRow = ((FilteredAndSortedTableModel)LogTableView.this.table.getModel()).getMappedRow(n);
                } else {
                    LogTableView.this.detailView.setEntry(null);
                    this.lastRow = -1;
                }
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getLastRow();
            if (LogTableView.this.logging && LogTableView.cslLogger.level >= 7) {
                cslLogger.log(7, "tableChanged(TableModelEvent)", (String)(LogTableView.cslLogger.level < 8 ? "" : "source: " + (tableModelEvent.getSource() == LogTableView.this.model ? "model" : "filteredModel") + ", start: " + n + ", end: " + n2 + ", lastRow: " + this.lastRow));
            }
            if (tableModelEvent.getSource() == LogTableView.this.model) {
                if (LogTableView.this.table.getSelectionModel().isSelectionEmpty()) {
                    LogTableView.this.detailView.setEntry(null);
                    this.lastRow = -1;
                }
                if (this.lastRow >= 0) {
                    int n3 = tableModelEvent.getType();
                    if (n == -1 || n == 0 && n2 >= LogTableView.this.model.getRowCount() && n3 == 0) {
                        if (LogTableView.this.logging && LogTableView.cslLogger.level >= 9) {
                            cslLogger.log(9, "tableChanged(TableModelEvent)", "lastRow invalidated");
                        }
                        this.lastRow = -1;
                    } else if (n3 == 1) {
                        if (n <= this.lastRow) {
                            this.lastRow += n2 - n + 1;
                            if (LogTableView.this.logging && LogTableView.cslLogger.level >= 9) {
                                cslLogger.log(9, "tableChanged(TableModelEvent)", "lastRow moved up");
                            }
                        }
                    } else if (n3 == -1 && n <= this.lastRow) {
                        if (n2 >= this.lastRow) {
                            this.lastRow = -1;
                            if (LogTableView.this.logging && LogTableView.cslLogger.level >= 9) {
                                cslLogger.log(9, "tableChanged(TableModelEvent)", "lastRow invalidated");
                            }
                        } else {
                            this.lastRow -= n2 - n + 1;
                            if (LogTableView.this.logging && LogTableView.cslLogger.level >= 9) {
                                cslLogger.log(9, "tableChanged(TableModelEvent)", "lastRow moved down");
                            }
                        }
                    }
                    if (this.lastRow == -1) {
                        LogTableView.this.detailView.setEntry(null);
                    }
                }
            } else {
                this.delay.perform(this);
            }
        }

        @Override
        public void run() {
            int n;
            if (LogTableView.this.logging && LogTableView.cslLogger.level >= 9) {
                cslLogger.log(9, "run()", "lastRow: " + this.lastRow + ", lastColumn: " + this.lastColumn);
            }
            if (LogTableView.this.table == null) {
                return;
            }
            if (this.lastRow >= 0) {
                LogTableView.this.restoreRow(this.lastRow, this.lastColumn);
            }
            if ((n = LogTableView.this.table.getSelectedRow()) >= 0 && n < LogTableView.this.table.getRowCount()) {
                LogTableView.this.detailView.setEntry((LogEntry)LogTableView.this.table.getModel().getValueAt(n, -1));
            } else {
                LogTableView.this.detailView.setEntry(null);
            }
        }
    }

    private class Markers
    implements TableModelListener {
        final int RECENT_ROW_NUM = 20;
        final long RECENT_ROW_DELAY = 1000L;
        private Hashtable<String, Integer> markers = new Hashtable();
        private long lastRowWhen;
        private int recentRowNum;
        private int recentRowPos;
        private boolean inRestore;

        public void addMarker(String string, int n) {
            if (LogTableView.this.logging && LogTableView.mLogger.level >= 7) {
                mLogger.log(7, "addMarker(String,int)", (String)(LogTableView.mLogger.level < 8 ? "" : "id: " + string + ", row: " + n));
            }
            this.markers.put(string, n);
            if (LogTableView.this.statusLine != null) {
                LogTableView.this.statusLine.setTemporaryMessage(Message.format("logTableView.setMark", new String[]{string}));
            }
        }

        public void removeMarker(String string) {
            if (LogTableView.this.logging && LogTableView.mLogger.level >= 7) {
                mLogger.log(7, "removeMarker(String)", (String)(LogTableView.mLogger.level < 8 ? "" : "id: " + string));
            }
            this.markers.remove(string);
        }

        public void clearMarkers() {
            if (LogTableView.this.logging && LogTableView.mLogger.level >= 7) {
                mLogger.log(7, "clearMarkers()", "");
            }
            this.markers.clear();
        }

        public void jumpToMarker(String string) {
            Integer n;
            if (LogTableView.this.logging && LogTableView.mLogger.level >= 7) {
                mLogger.log(7, "jumpToMarker(String)", (String)(LogTableView.mLogger.level < 8 ? "" : "id: " + string));
            }
            if ((n = this.markers.get(string)) != null) {
                if (LogTableView.this.statusLine != null) {
                    LogTableView.this.statusLine.setTemporaryMessage(Message.format("logTableView.jumpToMark", new String[]{string}));
                }
                LogTableView.this.table.clearSelection();
                LogTableView.this.restoreRow(n, -1);
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            block5: {
                int n;
                int n2;
                int n3;
                int n4;
                block7: {
                    block6: {
                        n4 = tableModelEvent.getFirstRow();
                        n3 = tableModelEvent.getLastRow();
                        if (LogTableView.this.logging && LogTableView.mLogger.level >= 7) {
                            mLogger.log(7, "tableChanged(TableModelEvent)", (String)(LogTableView.mLogger.level < 8 ? "" : ", start: " + n4 + ", end: " + n3));
                        }
                        if (this.markers.size() < 0) break block5;
                        n2 = tableModelEvent.getType();
                        n = n3 - n4 + 1;
                        if (n4 != -1 && (n4 != 0 || n3 < LogTableView.this.model.getRowCount() || n2 != 0)) break block6;
                        if (LogTableView.this.logging && LogTableView.mLogger.level >= 9) {
                            mLogger.log(9, "tableChanged(TableModelEvent)", "markers cleared");
                        }
                        this.clearMarkers();
                        break block5;
                    }
                    if (n2 != 1) break block7;
                    Enumeration<String> enumeration = this.markers.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement();
                        Integer n5 = this.markers.get(string);
                        if (n4 > n5) continue;
                        this.markers.put(string, n5 + n);
                        if (!LogTableView.this.logging || LogTableView.mLogger.level < 9) continue;
                        mLogger.log(9, "tableChanged(TableModelEvent)", "marker " + string + " moved up");
                    }
                    break block5;
                }
                if (n2 != -1) break block5;
                Enumeration<String> enumeration = this.markers.keys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    Integer n6 = this.markers.get(string);
                    if (n4 > n6) continue;
                    if (n3 >= n6) {
                        this.markers.remove(string);
                        if (!LogTableView.this.logging || LogTableView.mLogger.level < 9) continue;
                        mLogger.log(9, "tableChanged(TableModelEvent)", "marker " + string + " removed");
                        continue;
                    }
                    this.markers.put(string, n6 - n);
                    if (!LogTableView.this.logging || LogTableView.mLogger.level < 9) continue;
                    mLogger.log(9, "tableChanged(TableModelEvent)", "marker " + string + " moved down");
                }
            }
        }

        public void rowChanged(int n) {
            boolean bl;
            if (LogTableView.logger.level >= 7) {
                Logger.Builder builder = logger.build("rowChanged(int)");
                (LogTableView.logger.level < 8 ? builder : builder.add("row: ").add(n)).log(7);
            }
            if (bl = LogTableView.this.model.isInUpdate()) {
                return;
            }
            if (n >= 0) {
                n = ((FilteredAndSortedTableModel)LogTableView.this.table.getModel()).getMappedRow(n);
            }
            long l = System.currentTimeMillis();
            if (this.markers.containsKey("lastRow")) {
                int n2 = this.markers.get("lastRow");
                if (n == n2) {
                    return;
                }
                if (n2 >= 0 && (this.inRestore || n < 0 || l - this.lastRowWhen > 1000L)) {
                    this.pushRow(n2);
                }
            } else if (!this.inRestore && this.recentRowPos < this.recentRowNum) {
                this.recentRowPos = this.recentRowNum;
            }
            if (n >= 0 && !this.inRestore) {
                this.markers.put("lastRow", n);
                this.lastRowWhen = l;
            } else {
                this.markers.remove("lastRow");
            }
        }

        private void pushRow(int n) {
            int n2 = this.recentRowNum++;
            this.markers.put("recent" + n2, n);
            if (this.recentRowNum > 20) {
                this.markers.remove("recent" + (this.recentRowNum - 20));
            }
            if (!this.inRestore) {
                this.recentRowPos = this.recentRowNum;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jumpToRecent(boolean bl) {
            int n;
            int n2 = -1;
            if (bl) {
                for (n = this.recentRowPos + 1; n < this.recentRowNum; ++n) {
                    if (!this.markers.containsKey("recent" + n)) continue;
                    n2 = this.markers.get("recent" + n);
                    if (((FilteredAndSortedTableModel)LogTableView.this.table.getModel()).getNearestReverseRow(n2) < 0) {
                        n2 = -1;
                        continue;
                    }
                    break;
                }
            } else {
                for (n = this.recentRowPos - 1; n >= Math.max(0, this.recentRowNum - 20); --n) {
                    if (!this.markers.containsKey("recent" + n)) continue;
                    n2 = this.markers.get("recent" + n);
                    if (((FilteredAndSortedTableModel)LogTableView.this.table.getModel()).getNearestReverseRow(n2) < 0) {
                        n2 = -1;
                        continue;
                    }
                    break;
                }
            }
            if (n2 >= 0) {
                this.inRestore = true;
                this.recentRowPos = n;
                try {
                    LogTableView.this.table.clearSelection();
                    LogTableView.this.restoreRow(n2, -1);
                }
                finally {
                    this.inRestore = false;
                }
            }
        }
    }

    protected class TableKeyListener
    extends KeyAdapter {
        private int row = -1;
        DelayedAction delayed = new DelayedAction(300);
        private Runnable restoreSel = new Runnable(){

            @Override
            public void run() {
                if (TableKeyListener.this.row >= 0) {
                    LogTableView.this.table.getSelectionModel().setSelectionInterval(TableKeyListener.this.row, TableKeyListener.this.row);
                    TableKeyListener.this.row = -1;
                }
            }
        };

        protected TableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38 && (keyEvent.getModifiers() & 0xB) == 8) {
                keyEvent.consume();
                this.fastUp();
            } else if (keyEvent.getKeyCode() == 40 && (keyEvent.getModifiers() & 0xB) == 8) {
                keyEvent.consume();
                this.fastDown();
            } else if (keyEvent.getKeyCode() >= 48 && keyEvent.getKeyCode() <= 57 && (keyEvent.getModifiers() & 0xB) == 8) {
                keyEvent.consume();
                int n = LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex();
                if (n >= 0) {
                    n = ((FilteredAndSortedTableModel)LogTableView.this.table.getModel()).getMappedRow(n);
                    char c = (char)(48 + keyEvent.getKeyCode() - 48);
                    LogTableView.this.markers.addMarker("" + c, n);
                }
            } else if (keyEvent.getKeyCode() >= 48 && keyEvent.getKeyCode() <= 57 && (keyEvent.getModifiers() & 0xB) == 2) {
                keyEvent.consume();
                char c = (char)(48 + keyEvent.getKeyCode() - 48);
                LogTableView.this.markers.jumpToMarker("" + c);
            } else if (keyEvent.getKeyCode() == 8 && (keyEvent.getModifiers() & 2) != 0) {
                keyEvent.consume();
                LogTableView.this.markers.jumpToRecent((keyEvent.getModifiers() & 1) != 0);
            }
        }

        private void fastUp() {
            if (this.row < 0) {
                this.row = LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex();
            }
            if (this.row == 0) {
                return;
            }
            --this.row;
            JViewport jViewport = LogTableView.this.tablePane.getViewport();
            Point point = jViewport.getViewPosition();
            if (point.y > 0) {
                point.y -= LogTableView.this.table.getRowHeight() + LogTableView.this.table.getRowMargin();
                if (point.y < 0) {
                    point.y = 0;
                }
                jViewport.setViewPosition(point);
                this.delayed.perform(this.restoreSel);
            } else {
                LogTableView.this.table.getSelectionModel().setSelectionInterval(this.row, this.row);
                this.row = -1;
            }
        }

        private void fastDown() {
            if (this.row < 0) {
                this.row = LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex();
            }
            if (this.row == LogTableView.this.table.getRowCount() - 1) {
                return;
            }
            ++this.row;
            JViewport jViewport = LogTableView.this.tablePane.getViewport();
            Point point = jViewport.getViewPosition();
            Dimension dimension = jViewport.getViewSize();
            if (point.y + jViewport.getSize().height < dimension.height) {
                point.y += LogTableView.this.table.getRowHeight() + LogTableView.this.table.getRowMargin();
                if (point.y + jViewport.getSize().height > dimension.height) {
                    point.y = dimension.height - jViewport.getSize().height;
                }
                jViewport.setViewPosition(point);
                this.delayed.perform(this.restoreSel);
            } else {
                LogTableView.this.table.getSelectionModel().setSelectionInterval(this.row, this.row);
                this.row = -1;
            }
        }
    }

    private class Search
    extends KeyAdapter
    implements ActionListener {
        final int SEARCH_STACK_SIZE = 10;
        private StringBuffer search = new StringBuffer();
        private int lastLevel = -1;
        private boolean reverse = false;
        private boolean wrapped = false;
        private boolean found = false;
        private String searchTitle;
        private String rsearchTitle;
        private String wrappedTitle;
        private String notFoundTitle;
        private List<String> searchStack;
        private int searchStackPos;

        private Search() {
            this.searchTitle = LogTableView.this.resources.getString("logTableView.search.title", "search");
            this.rsearchTitle = LogTableView.this.resources.getString("logTableView.rsearch.title", "rsearch");
            this.wrappedTitle = LogTableView.this.resources.getString("logTableView.wrapped.title", "wrapped");
            this.notFoundTitle = LogTableView.this.resources.getString("logTableView.notFound.title", "not found");
            this.searchStack = new ArrayList<String>();
            this.searchStackPos = -1;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if ((keyEvent.getModifiers() & 0xE) == 0 && c != '\uffff' && !Character.isISOControl(c)) {
                keyEvent.consume();
                c = Character.toLowerCase(c);
                int n = LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex();
                int n2 = LogTableView.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                if (n == -1 || n2 == -1) {
                    return;
                }
                int n3 = LogTableView.this.table.convertColumnIndexToModel(n2);
                this.wrapped = false;
                if (n3 == 0) {
                    if (Character.isDigit(c)) {
                        this.lastLevel = c == '0' ? 10 : c - 48;
                        this.searchRow(n, this.lastLevel, this.reverse);
                    }
                    this.search.setLength(0);
                } else {
                    this.lastLevel = -1;
                    this.search.append(c);
                    this.searchRow(n, n2, this.search.toString(), true, this.reverse);
                }
                this.setTitle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block26: {
                boolean bl;
                int n = LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex();
                int n2 = LogTableView.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                if (n == -1 || n2 == -1) {
                    return;
                }
                int n3 = LogTableView.this.table.convertColumnIndexToModel(n2);
                boolean bl2 = bl = !LogTableView.this.logging;
                if (bl) {
                    Log.excludeThread();
                }
                try {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("backsearch")) {
                        this.wrapped = false;
                        this.found = true;
                        if (n3 != 0 && this.search.length() > 0) {
                            this.search.setLength(this.search.length() - 1);
                        }
                        this.setTitle();
                        break block26;
                    }
                    if (string.equals("copysearch")) {
                        if (n3 != 0) {
                            this.wrapped = false;
                            this.found = true;
                            this.saveSearch();
                            this.search = new StringBuffer(((String)LogTableView.this.table.getValueAt(n, n2)).toLowerCase());
                            this.setTitle();
                        }
                        break block26;
                    }
                    if (string.equals("searchagain")) {
                        if (n3 == 0) {
                            if (this.lastLevel >= 0) {
                                this.wrapped = false;
                                this.searchRow(n, this.lastLevel, this.reverse);
                                this.setTitle();
                            }
                        } else if (this.search.length() > 0) {
                            this.wrapped = false;
                            this.searchRow(n, n2, this.search.toString(), false, this.reverse);
                            this.setTitle();
                        }
                        break block26;
                    }
                    if (string.equals("clearsearch")) {
                        this.saveSearch();
                        this.wrapped = false;
                        this.search.setLength(0);
                        this.lastLevel = -1;
                        this.setTitle();
                        break block26;
                    }
                    if (string.equals("previoussearch")) {
                        if (!this.searchStack.isEmpty() && this.searchStackPos >= 0 && this.searchStackPos < this.searchStack.size()) {
                            int n4 = this.searchStackPos;
                            String string2 = this.searchStack.remove(n4--);
                            this.saveSearch();
                            this.searchStackPos = n4 < 0 ? 0 : n4;
                            this.wrapped = false;
                            this.search.setLength(0);
                            this.search.append(string2);
                            this.lastLevel = -1;
                            this.setTitle();
                        }
                        break block26;
                    }
                    if (string.equals("pastesearch")) {
                        boolean bl3;
                        if (n3 == 0) break block26;
                        String string3 = null;
                        Transferable transferable = SwingUtil.safeGetClipboard(null);
                        boolean bl4 = bl3 = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
                        if (bl3) {
                            try {
                                string3 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (string3 != null) {
                            this.saveSearch();
                            this.wrapped = false;
                            this.found = true;
                            this.lastLevel = -1;
                            if (this.search == null) {
                                this.search = new StringBuffer(string3.toLowerCase());
                            } else {
                                this.search.append(string3.toLowerCase());
                            }
                            this.setTitle();
                        }
                        break block26;
                    }
                    if (string.equals("revertsearch")) {
                        this.wrapped = false;
                        this.found = true;
                        this.reverse = !this.reverse;
                        this.setTitle();
                    }
                }
                finally {
                    if (bl) {
                        Log.includeThread();
                    }
                }
            }
        }

        private void searchRow(int n, int n2, String string, boolean bl, boolean bl2) {
            this.found = false;
            int n3 = string.length();
            if (bl2) {
                String string2;
                int n4;
                for (n4 = n - (bl ? 0 : 1); n4 >= 0; --n4) {
                    string2 = (String)LogTableView.this.table.getValueAt(n4, n2);
                    if (string2.length() < n3 || string2.toLowerCase().indexOf(string) < 0) continue;
                    LogTableView.this.jumpToRow(n4, false);
                    LogTableView.this.table.getSelectionModel().setSelectionInterval(n4, n4);
                    this.found = true;
                    break;
                }
                for (n4 = LogTableView.this.table.getRowCount() - 1; !this.found && n4 > n; --n4) {
                    string2 = (String)LogTableView.this.table.getValueAt(n4, n2);
                    if (string2.length() < n3 || string2.toLowerCase().indexOf(string) < 0) continue;
                    LogTableView.this.jumpToRow(n4, false);
                    LogTableView.this.table.getSelectionModel().setSelectionInterval(n4, n4);
                    this.found = true;
                    this.wrapped = true;
                    break;
                }
            } else {
                String string3;
                int n5;
                for (n5 = n + (bl ? 0 : 1); n5 < LogTableView.this.table.getRowCount(); ++n5) {
                    string3 = (String)LogTableView.this.table.getValueAt(n5, n2);
                    if (string3.length() < n3 || string3.toLowerCase().indexOf(string) < 0) continue;
                    LogTableView.this.jumpToRow(n5, false);
                    LogTableView.this.table.getSelectionModel().setSelectionInterval(n5, n5);
                    this.found = true;
                    break;
                }
                for (n5 = 0; !this.found && n5 < n; ++n5) {
                    string3 = (String)LogTableView.this.table.getValueAt(n5, n2);
                    if (string3.length() < n3 || string3.toLowerCase().indexOf(string) < 0) continue;
                    LogTableView.this.jumpToRow(n5, false);
                    LogTableView.this.table.getSelectionModel().setSelectionInterval(n5, n5);
                    this.found = true;
                    this.wrapped = true;
                    break;
                }
            }
        }

        private void searchRow(int n, int n2, boolean bl) {
            this.found = false;
            if (bl) {
                int n3;
                for (n3 = n - 1; n3 >= 0; --n3) {
                    if (((LogEntry)LogTableView.this.table.getValueAt(n3, -1)).getLevel() != n2) continue;
                    LogTableView.this.jumpToRow(n3, false);
                    LogTableView.this.table.getSelectionModel().setSelectionInterval(n3, n3);
                    this.found = true;
                    break;
                }
                for (n3 = LogTableView.this.table.getRowCount() - 1; !this.found && n3 > n; --n3) {
                    if (((LogEntry)LogTableView.this.table.getValueAt(n3, -1)).getLevel() != n2) continue;
                    LogTableView.this.jumpToRow(n3, false);
                    LogTableView.this.table.getSelectionModel().setSelectionInterval(n3, n3);
                    this.found = true;
                    this.wrapped = true;
                    break;
                }
            } else {
                int n4;
                for (n4 = n + 1; n4 < LogTableView.this.table.getRowCount(); ++n4) {
                    if (((LogEntry)LogTableView.this.table.getValueAt(n4, -1)).getLevel() != n2) continue;
                    LogTableView.this.jumpToRow(n4, false);
                    LogTableView.this.table.getSelectionModel().setSelectionInterval(n4, n4);
                    this.found = true;
                    break;
                }
                for (n4 = 0; !this.found && n4 < n; ++n4) {
                    if (((LogEntry)LogTableView.this.table.getValueAt(n4, -1)).getLevel() != n2) continue;
                    LogTableView.this.jumpToRow(n4, false);
                    LogTableView.this.table.getSelectionModel().setSelectionInterval(n4, n4);
                    this.found = true;
                    this.wrapped = true;
                    break;
                }
            }
        }

        private void setTitle() {
            StringBuffer stringBuffer = new StringBuffer();
            if (LogTableView.this.statusLine == null) {
                stringBuffer.append(LogTableView.this.titleBase);
            }
            if (this.lastLevel >= 0 || this.search.length() > 0) {
                stringBuffer.append("   ");
                stringBuffer.append(this.reverse ? this.rsearchTitle : this.searchTitle);
                if (this.wrapped) {
                    stringBuffer.append(" (");
                    stringBuffer.append(this.wrappedTitle);
                    stringBuffer.append(")");
                } else if (!this.found) {
                    stringBuffer.append(" (");
                    stringBuffer.append(this.notFoundTitle);
                    stringBuffer.append(")");
                }
                stringBuffer.append(": ");
                if (this.lastLevel > 0) {
                    if (LogTableView.this.statusLine == null) {
                        LogTableView.this.titleLabel.setIcon(icons[this.lastLevel - 1]);
                    } else {
                        LogTableView.this.statusLine.getMessageLabel().setIcon(icons[this.lastLevel - 1]);
                        LogTableView.this.statusLine.getMessageLabel().setHorizontalTextPosition(10);
                    }
                } else {
                    if (LogTableView.this.statusLine == null) {
                        LogTableView.this.titleLabel.setIcon(null);
                    } else {
                        LogTableView.this.statusLine.getMessageLabel().setIcon(null);
                    }
                    stringBuffer.append(this.search);
                }
            } else if (LogTableView.this.statusLine == null) {
                LogTableView.this.titleLabel.setIcon(null);
            }
            if (LogTableView.this.statusLine == null) {
                LogTableView.this.titleLabel.setText(stringBuffer.toString());
            } else {
                LogTableView.this.titleLabel.setText(LogTableView.this.titleBase);
                LogTableView.this.titleLabel.setIcon(null);
                if (stringBuffer.length() == 0) {
                    LogTableView.this.statusLine.clearMessages();
                } else {
                    LogTableView.this.statusLine.pushMessage(stringBuffer.toString());
                }
            }
        }

        private void saveSearch() {
            if (this.search.length() > 0) {
                this.searchStack.add(this.search.toString());
            }
            if (this.searchStack.size() > 10) {
                this.searchStack.remove(0);
            }
            this.searchStackPos = this.searchStack.size() - 1;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        private void maybePopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = LogTableView.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                int n2 = LogTableView.this.table.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (n >= 0 && !LogTableView.this.table.isRowSelected(n)) {
                    LogTableView.this.table.setRowSelectionInterval(n, n);
                }
                if (n2 >= 0) {
                    LogTableView.this.table.setColumnSelectionInterval(n2, n2);
                }
                SwingUtil.showPopup(LogTableView.this.popup, LogTableView.this.table, mouseEvent.getX(), mouseEvent.getY(), false);
            }
        }
    }

    private class SetMarkerAction
    extends AbstractAction {
        private String marker;

        public SetMarkerAction(String string) {
            this.marker = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex();
            if (n >= 0) {
                n = ((FilteredAndSortedTableModel)LogTableView.this.table.getModel()).getMappedRow(n);
                LogTableView.this.markers.addMarker(this.marker, n);
            }
        }
    }

    private class GotoMarkerAction
    extends AbstractAction {
        private String marker;

        public GotoMarkerAction(String string) {
            this.marker = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LogTableView.this.table.getSelectionModel().getAnchorSelectionIndex();
            LogTableView.this.markers.jumpToMarker(this.marker);
        }
    }
}

