/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview.command;

import de.qfs.apps.qflog.FileChooser;
import de.qfs.apps.qflog.logview.LogFileFilter;
import de.qfs.apps.qflog.logview.LogFilterTreeModel;
import de.qfs.apps.qflog.logview.LogFrame;
import de.qfs.apps.qflog.logview.LogLevelTreeModel;
import de.qfs.apps.qflog.logview.LogView;
import de.qfs.lib.command.CancelCommandException;
import de.qfs.lib.command.Command;
import de.qfs.lib.command.CommandException;
import de.qfs.lib.command.Invokable;
import de.qfs.lib.command.MessageCommandException;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.gui.Message;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.tree.TreePath;

public class CommandSaveConfiguration
extends Command
implements Invokable {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.logview.command.CommandSaveConfiguration");
    private boolean save;
    private LogFrame frame;
    private LogView view;
    private Frame parent;

    public CommandSaveConfiguration(Object object, LogFrame logFrame, boolean bl) {
        super(object);
        this.parent = logFrame;
        this.frame = logFrame;
        this.view = logFrame.getView();
        this.save = bl;
    }

    public CommandSaveConfiguration(Object object, Frame frame, LogView logView, boolean bl) {
        super(object);
        this.parent = frame;
        this.view = logView;
        this.save = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke() throws CommandException {
        boolean bl;
        boolean bl2 = bl = !this.view.isLoggingEnabled();
        if (bl) {
            Log.excludeThread();
        }
        try {
            MyConfiguration myConfiguration = new MyConfiguration();
            if (this.frame != null) {
                this.frame.getConfigurator().copy().register(myConfiguration);
            }
            this.view.getConfigurator().copy().register(myConfiguration);
            if (this.save) {
                this.save(myConfiguration);
            } else {
                this.restore(myConfiguration);
            }
            Object var3_3 = null;
            return var3_3;
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Configuration configuration) throws CommandException {
        FileChooser fileChooser = new FileChooser(this.view.getConfigurationDirectory());
        LogFileFilter logFileFilter = new LogFileFilter(this.view.getResources().getString("logView.fileFilter.qlc", "qflog configuration file"), ".qlc");
        fileChooser.setFileFilter(logFileFilter);
        if (fileChooser.showSaveDialog(this.parent) != 0) {
            throw new CancelCommandException();
        }
        File file = logFileFilter.forceExtension(fileChooser.getSelectedFile());
        if (file.exists() && Message.showMessage(this.parent, "logView.askOverwrite", new String[]{file.getName()}) != 0) {
            throw new CancelCommandException();
        }
        boolean bl = true;
        String string = this.view.getResources().getString("logView.status.savingConfig", "Saving configuration...");
        if (this.view.getStatusLine() != null) {
            this.view.getStatusLine().pushMessage(string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                configuration.save(fileOutputStream);
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
            bl = false;
            String string2 = file.getParent();
            if (string2 != null) {
                this.view.setConfigurationDirectory(new File(string2));
            }
            if (this.view.getStatusLine() != null) {
                this.view.getStatusLine().popMessage(string);
                this.view.getStatusLine().setTemporaryMessage(this.view.getResources().getString(bl ? "logView.status.savingConfig.failed" : "logView.status.savingConfig.done", "Saving configuration..." + (bl ? "failed" : "done")));
            }
        }
        catch (IOException iOException) {
            try {
                if (CommandSaveConfiguration.logger.level >= 3) {
                    logger.log(3, "save(Configuration)", iOException);
                }
                throw new MessageCommandException(iOException.getMessage(), this.parent, "logView.saveError", new String[]{file.getPath()});
            }
            catch (Throwable throwable) {
                if (this.view.getStatusLine() != null) {
                    this.view.getStatusLine().popMessage(string);
                    this.view.getStatusLine().setTemporaryMessage(this.view.getResources().getString(bl ? "logView.status.savingConfig.failed" : "logView.status.savingConfig.done", "Saving configuration..." + (bl ? "failed" : "done")));
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore(Configuration configuration) throws CommandException {
        FileChooser fileChooser = new FileChooser(this.view.getConfigurationDirectory());
        LogFileFilter logFileFilter = new LogFileFilter(this.view.getResources().getString("logView.fileFilter.qlc", "qflog configuration file"), ".qlc");
        fileChooser.setFileFilter(logFileFilter);
        if (fileChooser.showOpenDialog(this.parent) != 0) {
            throw new CancelCommandException();
        }
        File file = fileChooser.getSelectedFile();
        boolean bl = true;
        String string = this.view.getResources().getString("logView.status.loadingConfig", "Restoring configuration...");
        this.view.getStatusLine().pushMessage(string);
        LogFilterTreeModel logFilterTreeModel = this.view.getFilterView().getModel();
        Properties properties = logFilterTreeModel.getConfigurableState();
        logFilterTreeModel.removeLevel(new TreePath(new Object[]{logFilterTreeModel.getRoot()}), true);
        Properties properties2 = null;
        LogLevelTreeModel logLevelTreeModel = null;
        if (this.view.getLevelView() != null) {
            logLevelTreeModel = this.view.getLevelView().getModel();
            properties2 = logLevelTreeModel.getConfigurableState();
            logLevelTreeModel.removeLogLevel(new TreePath(new Object[]{logLevelTreeModel.getRoot()}), true);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                configuration.restore(fileInputStream);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {}
            }
            bl = false;
            String string2 = file.getParent();
            if (string2 != null) {
                this.view.setConfigurationDirectory(new File(string2));
            }
            this.view.getFilterView().showSetLevels();
            if (this.view.getLevelView() != null) {
                this.view.getLevelView().showSetLevels();
            }
            this.view.getStatusLine().popMessage(string);
            this.view.getStatusLine().setTemporaryMessage(this.view.getResources().getString(bl ? "logView.status.loadingConfig.failed" : "logView.status.loadingConfig.done", "Loading configuration..." + (bl ? "failed" : "done")));
        }
        catch (IOException iOException) {
            try {
                if (CommandSaveConfiguration.logger.level >= 3) {
                    logger.log(3, "restore(Configuration)", iOException);
                }
                logFilterTreeModel.setConfigurableState(properties);
                if (logLevelTreeModel != null) {
                    logLevelTreeModel.setConfigurableState(properties2);
                }
                throw new MessageCommandException(iOException.getMessage(), this.parent, "logView.loadError", new String[]{file.getPath()});
            }
            catch (Throwable throwable) {
                this.view.getStatusLine().popMessage(string);
                this.view.getStatusLine().setTemporaryMessage(this.view.getResources().getString(bl ? "logView.status.loadingConfig.failed" : "logView.status.loadingConfig.done", "Loading configuration..." + (bl ? "failed" : "done")));
                throw throwable;
            }
        }
    }

    private class MyConfiguration
    extends Configuration {
    }
}

