/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.jedit;

import de.qfs.apps.qftest.jedit.InputHandler;
import de.qfs.apps.qftest.jedit.JEditTextComponent;
import de.qfs.apps.qftest.jedit.SyntaxDocument;
import de.qfs.apps.qftest.jedit.SyntaxStyle;
import de.qfs.apps.qftest.jedit.TextAreaDefaults;
import de.qfs.apps.qftest.jedit.TextAreaPainter;
import de.qfs.apps.qftest.jedit.TextUtilities;
import de.qfs.apps.qftest.jedit.Token;
import de.qfs.apps.qftest.jedit.TokenMarker;
import de.qfs.lib.gui.PopupHandler;
import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class JEditTextArea
extends JTextArea
implements JEditTextComponent {
    private static final QFLogger K = new QFLogger("de.qfs.apps.qftest.jedit.JEditTextArea");
    public static String LEFT_OF_SCROLLBAR = "los";
    private int L;
    private int M;
    private TextAreaPainter.SearchHighlight searchHighlight;
    private TextAreaPainter.SearchHighlight N;
    private Color O;
    private final List P = new ArrayList();
    HighlightDelegate a;
    @Nullable
    protected final Clipboard b = this.getToolkit().getSystemSelection();
    protected static String c = "center";
    protected static String d = "right";
    protected static String e = "bottom";
    protected static String f = "left";
    protected static JEditTextArea g;
    protected static Timer h;
    protected TextAreaPainter i;
    protected JPopupMenu j;
    protected MutableCaretEvent k;
    protected boolean l;
    protected boolean m;
    protected boolean n;
    protected boolean o;
    protected int p;
    protected int q;
    protected int r;
    protected int s;
    @Nullable
    protected JScrollBar t;
    @Nullable
    protected JScrollBar u;
    protected boolean v;
    protected InputHandler w;
    protected SyntaxDocument x;
    protected DocumentHandler y;
    protected Segment z;
    protected int A;
    protected int B;
    protected int C;
    protected int D;
    protected boolean E;
    protected int F;
    protected int G;
    protected int H;
    protected boolean I;
    protected boolean J;
    private int Q;
    private int R;
    private Set[] S;

    public JEditTextArea() {
        this(TextAreaDefaults.a());
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "JEditTextArea()", 204).log();
        }
    }

    public JEditTextArea(TextAreaDefaults textAreaDefaults) {
        super(textAreaDefaults.k, textAreaDefaults.j);
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "JEditTextArea(TextAreaDefaults)", 217).addDetail("defaults", (Object)textAreaDefaults)).log();
        }
        super.setHighlighter(null);
        this.enableEvents(8L);
        this.i = new TextAreaPainter(this, textAreaDefaults);
        this.y = new DocumentHandler();
        this.listenerList = new EventListenerList();
        this.k = new MutableCaretEvent();
        this.z = new Segment();
        this.F = -1;
        this.G = -1;
        this.n = true;
        this.setLayout(new ScrollLayout());
        this.add(c, this.i);
        this.setBackground(this.i.getBackground());
        if (textAreaDefaults.h) {
            this.t = new JScrollBar(1);
            this.add(d, this.t);
            this.t.addAdjustmentListener(new AdjustHandler());
        }
        if (textAreaDefaults.i) {
            this.u = new JScrollBar(0);
            this.add(e, this.u);
            this.u.addAdjustmentListener(new AdjustHandler());
        }
        this.i.addComponentListener(new ComponentHandler());
        this.i.addMouseListener(new MouseHandler());
        this.i.addMouseMotionListener(new DragHandler());
        if (Misc.OS_IS_MAC_OS_X) {
            this.i.setAutoscrolls(false);
        }
        this.i.addMouseWheelListener(new MouseWheelHandler());
        this.searchHighlight = this.i.new TextAreaPainter.SearchHighlight();
        this.i.a(this.searchHighlight);
        this.N = this.i.new TextAreaPainter.SearchHighlight();
        this.i.a(this.N);
        this.addFocusListener(new FocusHandler());
        this.setSelectionColor(this.i.c());
        this.S = new Set[]{this.getFocusTraversalKeys(0), this.getFocusTraversalKeys(1), this.getFocusTraversalKeys(2), this.getFocusTraversalKeys(3)};
        this.setInputHandler(textAreaDefaults.a);
        this.setDocument(textAreaDefaults.b);
        this.o = textAreaDefaults.c;
        this.m = textAreaDefaults.d;
        this.l = textAreaDefaults.e;
        this.r = textAreaDefaults.g;
        this.j = textAreaDefaults.v;
        this.setCaretVisible(false);
        SyntaxDocument syntaxDocument = this.getDocument();
        this.updateScrollBars();
    }

    public Point getCursorLocation(boolean bl2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "getCursorLocation(boolean)", 290).addDetail("absolute", bl2)).log();
        }
        int n2 = this.getCaretPosition();
        int n3 = this.getCaretLine();
        int n4 = this.offsetToX(n3, n2 - this.getLineStartOffset(n3));
        int n5 = this.lineToY(n3);
        Point point = new Point(n4, n5);
        if (bl2) {
            SwingUtilities.convertPointToScreen(point, this.getPainter());
        }
        return point;
    }

    @Nullable
    public JScrollBar getVerticalScrollBar() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getVerticalScrollBar()", 307).log();
        }
        return this.t;
    }

    public void regionHighlight(int n2, int n3) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "regionHighlight(int,int)", 315).addDetail("start", n2)).addDetail("end", n3)).log();
        }
        this.N.addHighlight(n2, n3);
    }

    public void removeRegionHighlight() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "removeRegionHighlight()", 323).log();
        }
        this.N.removeHighlights();
    }

    @Override
    public void highlight(int n2, int n3, int n4) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "highlight(int,int,int)", 332).addDetail("start", n2)).addDetail("end", n3)).addDetail("highlightType", n4)).log();
        }
        if (n2 == 0 && n3 == 0) {
            Color color = null;
            if (n4 == 0) {
                color = UIManager.getColor("highlightError");
            } else if (n4 == 2) {
                color = UIManager.getColor("highlightWarning");
            } else if (n4 == -2) {
                color = UIManager.getColor("searchHighlight");
            }
            color = color != null ? new Color(color.getRGB()) : (this.a == null ? this.searchHighlight.getHighlightingColor() : this.a.a());
            this.setBackground(color);
            this.repaint();
        } else {
            this.searchHighlight.addHighlight(n2, n3);
        }
    }

    @Override
    public void unhighlight() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "unhighlight()", 361).log();
        }
        this.searchHighlight.removeHighlights();
        this.N.removeHighlights();
        if (this.O != null) {
            this.setBackground(this.O);
            this.repaint();
        }
    }

    @Override
    public void setHighlightingColor(Color color) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setHighlightingColor(Color)", 375).addDetail("color", (Object)color)).log();
        }
        if (this.searchHighlight != null) {
            this.searchHighlight.setHighlightingColor(color);
        }
    }

    public void setRegionHighlightingColor(Color color) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setRegionHighlightingColor(Color)", 385).addDetail("color", (Object)color)).log();
        }
        if (this.N != null) {
            this.N.setHighlightingColor(color);
        }
    }

    @Override
    public void setFont(Font font) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setFont(Font)", 396).addDetail("font", (Object)font)).log();
        }
        this.getPainter().setFont(font);
    }

    @Override
    public Font getFont() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getFont()", 405).log();
        }
        if (this.i == null) {
            return TextAreaPainter.a;
        }
        return this.i.getFont();
    }

    @Override
    public final boolean isManagingFocus() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "isManagingFocus()", 421).log();
        }
        return true;
    }

    public final TextAreaPainter getPainter() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getPainter()", 432).log();
        }
        return this.i;
    }

    public final InputHandler getInputHandler() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getInputHandler()", 443).log();
        }
        return this.w;
    }

    public void setInputHandler(InputHandler inputHandler) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setInputHandler(InputHandler)", 455).addDetail("inputHandler", (Object)inputHandler)).log();
        }
        this.w = inputHandler;
    }

    public final boolean isCaretBlinkEnabled() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "isCaretBlinkEnabled()", 466).log();
        }
        return this.l;
    }

    public void setCaretBlinkEnabled(boolean bl2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setCaretBlinkEnabled(boolean)", 478).addDetail("caretBlinks", bl2)).log();
        }
        this.l = bl2;
        if (!bl2) {
            this.n = false;
        }
        if (this.i != null) {
            this.i.m();
        }
    }

    public final boolean isCaretVisible() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "isCaretVisible()", 495).log();
        }
        return (!this.l || this.n) && this.m;
    }

    public void setCaretVisible(boolean bl2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setCaretVisible(boolean)", 508).addDetail("caretVisible", bl2)).log();
        }
        this.m = bl2;
        this.n = true;
        if (this.i != null) {
            this.i.m();
        }
    }

    public final void blinkCaret() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "blinkCaret()", 523).log();
        }
        if (this.l) {
            boolean bl2 = this.n = !this.n;
            if (this.i != null) {
                this.i.m();
            }
        } else {
            this.n = true;
        }
    }

    public final int getElectricScroll() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getElectricScroll()", 543).log();
        }
        return this.r;
    }

    public final void setElectricScroll(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setElectricScroll(int)", 557).addDetail("electricScroll", n2)).log();
        }
        this.r = n2;
    }

    public void updateScrollBars() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "updateScrollBars()", 570).log();
        }
        if (this.i == null) {
            return;
        }
        if (this.t != null && this.q != 0) {
            this.t.setValues(this.p, this.q, 0, this.getLineCount());
            this.t.setUnitIncrement(2);
            this.t.setBlockIncrement(this.q);
        }
        int n2 = this.i.getWidth();
        if (this.u != null && n2 != 0) {
            int n3 = this.h() * this.i.l().charWidth('w');
            this.u.setValues(-this.s, n2, 0, n3);
            this.u.setUnitIncrement(this.i.l().charWidth('w'));
            this.u.setBlockIncrement(n2 / 2);
        }
        if (this.t == null && this.u == null) {
            this.i.r = this.getLineCount();
        }
    }

    private int h() {
        int n2;
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getMaxLineLength()", 606).log();
        }
        int n3 = 0;
        int n4 = -1;
        for (int i2 = 0; i2 < this.getLineCount(); ++i2) {
            n2 = this.getLineLength(i2);
            if (n2 <= n3) continue;
            n3 = n2;
            n4 = i2;
        }
        if (n4 >= 0) {
            String string = this.getLineText(n4);
            for (n2 = 0; n2 < string.length(); ++n2) {
                if (string.charAt(n2) != '\t') continue;
                n3 += 7;
            }
        }
        return n3;
    }

    public final int getFirstLine() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getFirstLine()", 635).log();
        }
        return this.p;
    }

    public void setFirstLine(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setFirstLine(int)", 647).addDetail("firstLine", n2)).log();
        }
        if (n2 == this.p) {
            return;
        }
        int n3 = this.p;
        this.p = n2;
        this.p = Math.max(0, this.p);
        if (this.t != null && n2 != this.t.getValue()) {
            this.updateScrollBars();
        }
        if (this.i != null) {
            this.i.repaint();
        }
    }

    public final int getVisibleLines() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getVisibleLines()", 670).log();
        }
        return this.q;
    }

    public final void recalculateVisibleLines() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "recalculateVisibleLines()", 682).log();
        }
        if (this.i == null) {
            return;
        }
        int n2 = this.i.getHeight();
        int n3 = this.i.l().getHeight();
        int n4 = this.q;
        this.q = n2 / n3;
        this.updateScrollBars();
        this.v = true;
    }

    public final int getHorizontalOffset() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getHorizontalOffset()", 701).log();
        }
        return this.s;
    }

    public void setHorizontalOffset(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setHorizontalOffset(int)", 714).addDetail("horizontalOffset", n2)).log();
        }
        if (this.u == null) {
            return;
        }
        if (n2 == this.s) {
            return;
        }
        this.s = n2;
        if (n2 != this.u.getValue()) {
            this.updateScrollBars();
        }
        if (this.i != null) {
            this.i.repaint();
        }
    }

    public boolean setOrigin(int n2, int n3) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "setOrigin(int,int)", 738).addDetail("firstLine", n2)).addDetail("horizontalOffset", n3)).log();
        }
        boolean bl2 = false;
        int n4 = this.p;
        if (n3 != this.s) {
            this.s = n3;
            bl2 = true;
        }
        if (n2 != this.p) {
            this.p = n2;
            bl2 = true;
        }
        if (bl2) {
            this.updateScrollBars();
            if (this.i != null) {
                this.i.repaint();
            }
        }
        return bl2;
    }

    public boolean scrollToCaret() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "scrollToCaret()", 775).log();
        }
        int n2 = this.getCaretLine();
        int n3 = this.getLineStartOffset(n2);
        int n4 = Math.max(0, Math.min(this.getLineLength(n2) - 1, this.getCaretPosition() - n3));
        return this.scrollTo(n2, n4);
    }

    public boolean scrollTo(int n2, int n3) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "scrollTo(int,int)", 796).addDetail("line", n2)).addDetail("offset", n3)).log();
        }
        if (this.i == null) {
            return false;
        }
        if (this.q == 0) {
            this.setFirstLine(Math.max(0, n2 - this.r));
            return true;
        }
        int n4 = this.p;
        int n5 = this.s;
        if (n2 < this.p + this.r) {
            n4 = Math.max(0, n2 - this.r);
        } else if (n2 + this.r >= this.p + this.q) {
            n4 = n2 - this.q + this.r + 1;
            if (n4 + this.q >= this.getLineCount()) {
                n4 = this.getLineCount() - this.q;
            }
            if (n4 < 0) {
                n4 = 0;
            }
        }
        int n6 = this._offsetToX(n2, n3);
        int n7 = this.i.l().charWidth('w');
        if (n6 < 0) {
            n5 = Math.min(0, this.s - n6 + n7 + 5);
        } else if (n6 + n7 >= this.i.getWidth()) {
            n5 = this.s + (this.i.getWidth() - n6) - n7 - 5;
        }
        return this.setOrigin(n4, n5);
    }

    public int lineToY(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "lineToY(int)", 849).addDetail("line", n2)).log();
        }
        FontMetrics fontMetrics = this.i();
        return (n2 - this.p) * fontMetrics.getHeight() - (fontMetrics.getLeading() + fontMetrics.getMaxDescent());
    }

    private FontMetrics i() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getFontMetrics()", 860).log();
        }
        if (this.i == null) {
            return Toolkit.getDefaultToolkit().getFontMetrics(TextAreaPainter.a);
        }
        return this.i.l();
    }

    public int yToLine(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "yToLine(int)", 875).addDetail("y", n2)).log();
        }
        FontMetrics fontMetrics = this.i();
        int n3 = fontMetrics.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, n2 / n3 + this.p));
    }

    public final int offsetToX(int n2, int n3) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "offsetToX(int,int)", 892).addDetail("line", n2)).addDetail("offset", n3)).log();
        }
        if (this.i != null) {
            this.i.c = null;
        }
        return this._offsetToX(n2, n3);
    }

    public int _offsetToX(int n2, int n3) {
        Token token;
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "_offsetToX(int,int)", 911).addDetail("line", n2)).addDetail("offset", n3)).log();
        }
        if (this.i == null) {
            return 0;
        }
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this.i();
        this.getLineText(n2, this.z);
        int n4 = this.z.offset;
        int n5 = this.s;
        if (tokenMarker == null) {
            this.z.count = n3;
            return n5 + Utilities.getTabbedTextWidth(this.z, fontMetrics, n5, (TabExpander)this.i, 0);
        }
        if (this.i.b == n2 && this.i.c != null) {
            token = this.i.c;
        } else {
            this.i.b = n2;
            token = this.i.c = tokenMarker.b(this.z, n2);
        }
        Toolkit toolkit = this.i.getToolkit();
        Font font = this.i.getFont();
        SyntaxStyle[] syntaxStyleArray = this.i.a();
        byte by2;
        while ((by2 = token.s) != 127) {
            fontMetrics = by2 == 0 ? this.i.l() : syntaxStyleArray[by2].a(this.i, font);
            int n6 = token.r;
            if (n3 + n4 < this.z.offset + n6) {
                this.z.count = n3 - (this.z.offset - n4);
                return n5 + Utilities.getTabbedTextWidth(this.z, fontMetrics, n5, (TabExpander)this.i, 0);
            }
            this.z.count = n6;
            n5 += Utilities.getTabbedTextWidth(this.z, fontMetrics, n5, (TabExpander)this.i, 0);
            this.z.offset += n6;
            token = token.t;
        }
        return n5;
    }

    public int xToOffset(int n2, int n3) {
        Token token;
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "xToOffset(int,int)", 992).addDetail("line", n2)).addDetail("x", n3)).log();
        }
        if (this.i == null) {
            return 0;
        }
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this.i.l();
        this.getLineText(n2, this.z);
        char[] cArray = this.z.array;
        int n4 = this.z.offset;
        int n5 = this.z.count;
        int n6 = this.s;
        if (tokenMarker == null) {
            for (int i2 = 0; i2 < n5; ++i2) {
                char c2 = cArray[i2 + n4];
                int n7 = c2 == '\t' ? (int)this.i.nextTabStop(n6, i2) - n6 : fontMetrics.charWidth(c2);
                if (this.i.h() ? n3 - n7 <= n6 : n3 - n7 / 2 <= n6) {
                    return i2;
                }
                n6 += n7;
            }
            return n5;
        }
        if (this.i.b == n2 && this.i.c != null) {
            token = this.i.c;
        } else {
            this.i.b = n2;
            token = this.i.c = tokenMarker.b(this.z, n2);
        }
        int n8 = 0;
        Toolkit toolkit = this.i.getToolkit();
        Font font = this.i.getFont();
        SyntaxStyle[] syntaxStyleArray = this.i.a();
        int n9 = n6;
        byte by2;
        while ((by2 = token.s) != 127) {
            fontMetrics = by2 == 0 ? this.i.l() : syntaxStyleArray[by2].a(this.i, font);
            int n10 = token.r;
            StringBuilder stringBuilder = new StringBuilder();
            int n11 = (Integer)this.getDocument().getProperty("tabSize");
            for (int i3 = 0; i3 < n10; ++i3) {
                int n12;
                char c3 = cArray[n4 + n8 + i3];
                if (c3 == '\t') {
                    int n13 = n11 - stringBuilder.length() % n11;
                    char[] cArray2 = new char[n13];
                    for (int i4 = 0; i4 < n13; ++i4) {
                        stringBuilder.append(' ');
                        cArray2[i4] = 32;
                    }
                    n12 = fontMetrics.stringWidth(new String(cArray2));
                } else {
                    stringBuilder.append(c3);
                    n12 = fontMetrics.charWidth(c3);
                }
                if (this.i.h() ? n3 - n12 <= n9 : n3 - n12 / 2 <= n9) {
                    return n8 + i3;
                }
                n9 = n6 + fontMetrics.stringWidth(stringBuilder.toString());
            }
            n6 = n9;
            n8 += n10;
            token = token.t;
        }
        return n8;
    }

    public int xyToOffset(int n2, int n3) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "xyToOffset(int,int)", 1107).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        int n4 = this.yToLine(n3);
        int n5 = this.getLineStartOffset(n4);
        return n5 + this.xToOffset(n4, n2);
    }

    @Override
    public int viewToModel(Point point) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "viewToModel(Point)", 1118).addDetail("pt", (Object)point)).log();
        }
        return this.xyToOffset(point.x, point.y);
    }

    @Override
    public final SyntaxDocument getDocument() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getDocument()", 1130).log();
        }
        return this.x;
    }

    public void setDocument(SyntaxDocument syntaxDocument) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setDocument(SyntaxDocument)", 1142).addDetail("document", (Object)syntaxDocument)).log();
        }
        if (this.x == syntaxDocument) {
            return;
        }
        if (this.x != null) {
            this.x.removeDocumentListener(this.y);
        }
        this.x = syntaxDocument;
        syntaxDocument.addDocumentListener(this.y);
        this.select(0, 0);
        if (this.i != null) {
            this.updateScrollBars();
            this.i.repaint();
        }
    }

    @Override
    public void setDocument(Document document) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setDocument(Document)", 1163).addDetail("doc", (Object)document)).log();
        }
        if (document instanceof SyntaxDocument) {
            this.setDocument((SyntaxDocument)document);
            return;
        }
    }

    public final TokenMarker getTokenMarker() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getTokenMarker()", 1178).log();
        }
        return this.x.a();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setTokenMarker(TokenMarker)", 1191).addDetail("tokenMarker", (Object)tokenMarker)).log();
        }
        this.x.a(tokenMarker);
        this.repaint();
    }

    public final int getDocumentLength() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getDocumentLength()", 1204).log();
        }
        return this.x.getLength();
    }

    @Override
    public final int getLineCount() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getLineCount()", 1216).log();
        }
        return this.x.getDefaultRootElement().getElementCount();
    }

    @Override
    public final int getLineOfOffset(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "getLineOfOffset(int)", 1229).addDetail("offset", n2)).log();
        }
        return this.x.getDefaultRootElement().getElementIndex(n2);
    }

    @Override
    public int getLineStartOffset(int n2) {
        Element element;
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "getLineStartOffset(int)", 1244).addDetail("line", n2)).log();
        }
        Element element2 = element = n2 < 0 ? null : this.x.getDefaultRootElement().getElement(n2);
        if (element == null) {
            return -1;
        }
        return element.getStartOffset();
    }

    @Override
    public int getLineEndOffset(int n2) {
        Element element;
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "getLineEndOffset(int)", 1263).addDetail("line", n2)).log();
        }
        Element element2 = element = n2 < 0 ? null : this.x.getDefaultRootElement().getElement(n2);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset();
    }

    public int getLineLength(int n2) {
        Element element;
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "getLineLength(int)", 1279).addDetail("line", n2)).log();
        }
        Element element2 = element = n2 < 0 ? null : this.x.getDefaultRootElement().getElement(n2);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset() - element.getStartOffset() - 1;
    }

    @Override
    public void setText(String string) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setText(String)", 1295).addDetail("text", string)).log();
        }
        try {
            this.x.replace(0, this.x.getLength(), string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public String getText() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getText()", 1310).log();
        }
        try {
            return this.x.getText(0, this.x.getLength());
        }
        catch (BadLocationException badLocationException) {
            if (JEditTextArea.K.level >= 5) {
                ((LevelAwareLogBuilder)K.lvlBuild(5, "getText()", 1318).add("bl", (Object)badLocationException)).log();
            }
            return null;
        }
    }

    @Override
    public final String getText(int n2, int n3) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "getText(int,int)", 1332).addDetail("start", n2)).addDetail("len", n3)).log();
        }
        try {
            return this.x.getText(n2, n3);
        }
        catch (BadLocationException badLocationException) {
            if (JEditTextArea.K.level >= 5) {
                ((LevelAwareLogBuilder)K.lvlBuild(5, "getText(int,int)", 1340).add("bl", (Object)badLocationException)).log();
            }
            return null;
        }
    }

    public final void getText(int n2, int n3, Segment segment) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "getText(int,int,Segment)", 1355).addDetail("start", n2)).addDetail("len", n3)).addDetail("segment", (Object)segment)).log();
        }
        try {
            this.x.getText(n2, n3, segment);
        }
        catch (BadLocationException badLocationException) {
            if (JEditTextArea.K.level >= 5) {
                ((LevelAwareLogBuilder)K.lvlBuild(5, "getText(int,int,Segment)", 1363).add("bl", (Object)badLocationException)).log();
            }
            segment.count = 0;
            segment.offset = 0;
        }
    }

    public final String getLineText(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "getLineText(int)", 1376).addDetail("lineIndex", n2)).log();
        }
        int n3 = this.getLineStartOffset(n2);
        return this.getText(n3, this.getLineEndOffset(n2) - n3 - 1);
    }

    public final void getLineText(int n2, Segment segment) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "getLineText(int,Segment)", 1390).addDetail("lineIndex", n2)).addDetail("segment", (Object)segment)).log();
        }
        int n3 = this.getLineStartOffset(n2);
        this.getText(n3, this.getLineEndOffset(n2) - n3 - 1, segment);
    }

    @Override
    public final int getSelectionStart() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getSelectionStart()", 1403).log();
        }
        return this.A;
    }

    public int getSelectionStart(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "getSelectionStart(int)", 1415).addDetail("line", n2)).log();
        }
        if (n2 == this.B) {
            return this.A;
        }
        if (this.J) {
            Element element = this.x.getDefaultRootElement();
            int n3 = this.A - element.getElement(this.B).getStartOffset();
            Element element2 = element.getElement(n2);
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset() - 1;
            return Math.min(n5, n4 + n3);
        }
        return this.getLineStartOffset(n2);
    }

    public final int getSelectionStartLine() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getSelectionStartLine()", 1440).log();
        }
        return this.B;
    }

    @Override
    public final void setSelectionStart(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setSelectionStart(int)", 1455).addDetail("selectionStart", n2)).log();
        }
        this.select(n2, this.C);
    }

    @Override
    public final int getSelectionEnd() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getSelectionEnd()", 1466).log();
        }
        return this.C;
    }

    public int getSelectionEnd(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "getSelectionEnd(int)", 1478).addDetail("line", n2)).log();
        }
        if (n2 == this.D) {
            return this.C;
        }
        if (this.J) {
            Element element = this.x.getDefaultRootElement();
            int n3 = this.C - element.getElement(this.D).getStartOffset();
            Element element2 = element.getElement(n2);
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset() - 1;
            return Math.min(n5, n4 + n3);
        }
        return this.getLineEndOffset(n2) - 1;
    }

    public final int getSelectionEndLine() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getSelectionEndLine()", 1503).log();
        }
        return this.D;
    }

    @Override
    public final void setSelectionEnd(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setSelectionEnd(int)", 1518).addDetail("selectionEnd", n2)).log();
        }
        this.select(this.A, n2);
    }

    @Override
    public final int getCaretPosition() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getCaretPosition()", 1532).log();
        }
        return this.E ? this.A : this.C;
    }

    public final int getCaretLine() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getCaretLine()", 1543).log();
        }
        return this.E ? this.B : this.D;
    }

    public final int getMarkPosition() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getMarkPosition()", 1556).log();
        }
        return this.E ? this.C : this.A;
    }

    public final int getMarkLine() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getMarkLine()", 1567).log();
        }
        return this.E ? this.D : this.B;
    }

    @Override
    public final void setCaretPosition(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setCaretPosition(int)", 1582).addDetail("caret", n2)).log();
        }
        this.select(n2, n2);
    }

    @Override
    public final void selectAll() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "selectAll()", 1594).log();
        }
        this.select(0, this.getDocumentLength());
    }

    public final void selectNone() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "selectNone()", 1605).log();
        }
        this.select(this.getCaretPosition(), this.getCaretPosition());
    }

    @Override
    public void select(int n2, int n3) {
        boolean bl2;
        int n4;
        int n5;
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "select(int,int)", 1622).addDetail("start", n2)).addDetail("end", n3)).log();
        }
        if (n2 <= n3) {
            n5 = n2;
            n4 = n3;
            bl2 = false;
        } else {
            n5 = n3;
            n4 = n2;
            bl2 = true;
        }
        if (n5 < 0) {
            if (JEditTextArea.K.level >= 9) {
                ((LevelAwareLogBuilder)K.lvlBuild(9, "select(int,int)", 1640).add("Ignoring negative input")).log();
            }
            return;
        }
        int n6 = this.getDocumentLength();
        if (n4 > n6) {
            n4 = n6;
        }
        if (this.i != null && (n5 != this.A || n4 != this.C || bl2 != this.E)) {
            int n7 = this.getLineOfOffset(n5);
            int n8 = this.getLineOfOffset(n4);
            if (this.i.g()) {
                if (this.G != -1) {
                    this.i.a(this.G);
                }
                this.a(n3);
                if (this.G != -1) {
                    this.i.a(this.G);
                }
            }
            this.i.a(this.B, this.D);
            this.i.a(n7, n8);
            this.x.a(new CaretUndo(this.A, this.C));
            this.A = n5;
            this.C = n4;
            this.B = n7;
            this.D = n8;
            this.E = bl2;
            this.c();
        }
        this.n = true;
        h.restart();
        if (this.A == this.C) {
            this.J = false;
        }
        this.H = -1;
        this.scrollToCaret();
    }

    @Override
    public final String getSelectedText() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getSelectedText()", 1704).log();
        }
        if (this.A == this.C) {
            return null;
        }
        if (this.J) {
            Element element = this.x.getDefaultRootElement();
            int n2 = this.A - element.getElement(this.B).getStartOffset();
            int n3 = this.C - element.getElement(this.D).getStartOffset();
            if (n3 < n2) {
                int n4 = n3;
                n3 = n2;
                n2 = n4;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Segment segment = new Segment();
            for (int i2 = this.B; i2 <= this.D; ++i2) {
                Element element2 = element.getElement(i2);
                int n5 = element2.getStartOffset();
                int n6 = element2.getEndOffset() - 1;
                int n7 = n6 - n5;
                n5 = Math.min(n5 + n2, n6);
                n7 = Math.min(n3 - n2, n6 - n5);
                this.getText(n5, n7, segment);
                stringBuffer.append(segment.array, segment.offset, segment.count);
                if (i2 == this.D) continue;
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        return this.getText(this.A, this.C - this.A);
    }

    public void setSelectedText(String string) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setSelectedText(String)", 1764).addDetail("selectedText", string)).log();
        }
        if (!this.o) {
            throw new InternalError("Text component read only");
        }
        this.x.c();
        try {
            if (this.J) {
                int n2;
                int n3;
                Element element = this.x.getDefaultRootElement();
                int n4 = this.A - element.getElement(this.B).getStartOffset();
                int n5 = this.C - element.getElement(this.D).getStartOffset();
                if (n5 < n4) {
                    n3 = n5;
                    n5 = n4;
                    n4 = n3;
                }
                n3 = 0;
                int n6 = 0;
                for (n2 = this.B; n2 <= this.D; ++n2) {
                    Element element2 = element.getElement(n2);
                    int n7 = element2.getStartOffset();
                    int n8 = element2.getEndOffset() - 1;
                    int n9 = Math.min(n8, n7 + n4);
                    this.x.remove(n9, Math.min(n8 - n9, n5 - n4));
                    if (string == null) continue;
                    n6 = string.indexOf(10, n3);
                    if (n6 == -1) {
                        n6 = string.length();
                    }
                    this.x.insertString(n9, string.substring(n3, n6), null);
                    n3 = Math.min(string.length(), n6 + 1);
                }
                if (string != null && n6 != string.length()) {
                    n2 = element.getElement(this.D).getEndOffset() - 1;
                    this.x.insertString(n2, "\n", null);
                    this.x.insertString(n2 + 1, string.substring(n6 + 1), null);
                }
            } else {
                this.x.remove(this.A, this.C - this.A);
                if (string != null) {
                    this.x.insertString(this.A, string, null);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            if (JEditTextArea.K.level >= 5) {
                ((LevelAwareLogBuilder)K.lvlBuild(5, "setSelectedText(String)", 1843).add("bl", (Object)badLocationException)).log();
            }
            throw new InternalError("Cannot replace selection");
        }
        finally {
            this.x.d();
        }
        this.setCaretPosition(this.C);
    }

    @Override
    public final boolean isEditable() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "isEditable()", 1864).log();
        }
        return this.o;
    }

    @Override
    public final void setEditable(boolean bl2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setEditable(boolean)", 1878).addDetail("editable", bl2)).log();
        }
        this.o = bl2;
    }

    public final JPopupMenu getRightClickPopup() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getRightClickPopup()", 1889).log();
        }
        return this.j;
    }

    public final void setRightClickPopup(JPopupMenu jPopupMenu) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setRightClickPopup(JPopupMenu)", 1901).addDetail("popup", (Object)jPopupMenu)).log();
        }
        this.j = jPopupMenu;
    }

    public final int getMagicCaretPosition() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getMagicCaretPosition()", 1913).log();
        }
        return this.H;
    }

    public final void setMagicCaretPosition(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setMagicCaretPosition(int)", 1926).addDetail("magicCaret", n2)).log();
        }
        this.H = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteSetSelectedText(String string) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "overwriteSetSelectedText(String)", 1941).addDetail("str", string)).log();
        }
        if (!this.I || this.A != this.C) {
            this.setSelectedText(string);
            return;
        }
        int n2 = this.getCaretPosition();
        int n3 = this.getLineEndOffset(this.getCaretLine());
        if (n3 - n2 <= string.length()) {
            this.setSelectedText(string);
            return;
        }
        this.x.c();
        try {
            this.x.remove(n2, string.length());
            this.x.insertString(n2, string, null);
        }
        catch (BadLocationException badLocationException) {
            if (JEditTextArea.K.level >= 5) {
                ((LevelAwareLogBuilder)K.lvlBuild(5, "overwriteSetSelectedText(String)", 1969).add("bl", (Object)badLocationException)).log();
            }
        }
        finally {
            this.x.d();
        }
    }

    public final boolean isOverwriteEnabled() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "isOverwriteEnabled()", 1983).log();
        }
        return this.I;
    }

    public final void setOverwriteEnabled(boolean bl2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setOverwriteEnabled(boolean)", 1996).addDetail("overwrite", bl2)).log();
        }
        this.I = bl2;
        if (this.i != null) {
            this.i.m();
        }
    }

    public final boolean isSelectionRectangular() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "isSelectionRectangular()", 2009).log();
        }
        return this.J;
    }

    public final void setSelectionRectangular(boolean bl2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setSelectionRectangular(boolean)", 2022).addDetail("rectSelect", bl2)).log();
        }
        this.J = bl2;
        if (this.i != null) {
            this.i.m();
        }
    }

    public final int getBracketPosition() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getBracketPosition()", 2037).log();
        }
        return this.F;
    }

    public final int getBracketLine() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getBracketLine()", 2048).log();
        }
        return this.G;
    }

    public void delete() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "delete()", 2056).log();
        }
        if (this.o) {
            this.setSelectedText("");
        }
    }

    @Override
    public void cut() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "cut()", 2071).log();
        }
        if (this.o) {
            this.copy();
            this.setSelectedText("");
        }
    }

    @Override
    public void copy() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "copy()", 2087).log();
        }
        this.a();
    }

    protected void a() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "copyToClipboard()", 2095).log();
        }
        if (this.A != this.C) {
            String string = this.getSelectedText();
            int n2 = this.w.f();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(string);
            }
            SwingUtil.safeSetClipboard(null, (Transferable)new StringSelection(stringBuffer.toString()), null);
        }
    }

    protected void a(Clipboard clipboard) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "copyToClipboard(Clipboard)", 2113).addDetail("clipboard", (Object)clipboard)).log();
        }
        if (this.A != this.C) {
            String string = this.getSelectedText();
            int n2 = this.w.f();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(string);
            }
            SwingUtil.safeSetClipboard((Clipboard)clipboard, (Transferable)new StringSelection(stringBuffer.toString()), null);
        }
    }

    @Override
    public void paste() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "paste()", 2135).log();
        }
        this.b();
    }

    protected void b() {
        block8: {
            if (JEditTextArea.K.level >= 7) {
                K.lvlBuild(7, "pasteFromClipboard()", 2143).log();
            }
            if (this.o) {
                try {
                    int n2;
                    Object object = ((String)SwingUtil.safeGetClipboard(null).getTransferData(DataFlavor.stringFlavor)).replace('\r', '\n');
                    if (this.M > 0) {
                        n2 = this.M - this.getLineCount();
                        int n3 = ((String)object).indexOf(10);
                        while (n3 > 0) {
                            if (n2 <= 0) {
                                object = ((String)object).substring(0, n3) + " " + ((String)object).substring(n3 + 1);
                            }
                            --n2;
                            n3 = ((String)object).indexOf(10, n3 + 1);
                        }
                    }
                    n2 = this.w.f();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        stringBuffer.append((String)object);
                    }
                    object = stringBuffer.toString();
                    this.setSelectedText((String)object);
                }
                catch (Exception exception) {
                    this.getToolkit().beep();
                    if (JEditTextArea.K.level < 1) break block8;
                    ((LevelAwareLogBuilder)K.lvlBuild(1, "pasteFromClipboard()", 2175).add("Clipboard does not contain a string")).log();
                }
            }
        }
    }

    protected void b(Clipboard clipboard) {
        block8: {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "pasteFromClipboard(Clipboard)", 2183).addDetail("clipboard", (Object)clipboard)).log();
            }
            if (this.o) {
                try {
                    int n2;
                    Object object = ((String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor)).replace('\r', '\n');
                    if (this.M > 0) {
                        n2 = this.M - this.getLineCount();
                        int n3 = ((String)object).indexOf(10);
                        while (n3 > 0) {
                            if (n2 <= 0) {
                                object = ((String)object).substring(0, n3) + " " + ((String)object).substring(n3 + 1);
                            }
                            --n2;
                            n3 = ((String)object).indexOf(10, n3 + 1);
                        }
                    }
                    n2 = this.w.f();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        stringBuffer.append((String)object);
                    }
                    object = stringBuffer.toString();
                    this.setSelectedText((String)object);
                }
                catch (Exception exception) {
                    this.getToolkit().beep();
                    if (JEditTextArea.K.level < 1) break block8;
                    ((LevelAwareLogBuilder)K.lvlBuild(1, "pasteFromClipboard(Clipboard)", 2217).add("Clipboard does not contain a string")).log();
                }
            }
        }
    }

    @Override
    public void removeNotify() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "removeNotify()", 2230).log();
        }
        super.removeNotify();
        if (g == this) {
            g = null;
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "processKeyEvent(KeyEvent)", 2246).addDetail("evt", (Object)keyEvent)).log();
        }
        if (this.w == null) {
            return;
        }
        switch (keyEvent.getID()) {
            case 400: {
                this.w.keyTyped(keyEvent);
                break;
            }
            case 401: {
                this.w.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.w.keyReleased(keyEvent);
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public void addCompletionPopupActionProvider(PopupHandler popupHandler) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "addCompletionPopupActionProvider(PopupHandler)", 2270).addDetail("handler", (Object)popupHandler)).log();
        }
        if (!this.P.contains(popupHandler)) {
            this.P.add(popupHandler);
            PopupManager.instance().registerPopupHandler(popupHandler, (JComponent)this);
        }
    }

    protected void c() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "fireCaretEvent()", 2338).log();
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; --i2) {
            if (objectArray[i2] != CaretListener.class) continue;
            ((CaretListener)objectArray[i2 + 1]).caretUpdate(this.k);
        }
    }

    protected void a(int n2) {
        block5: {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "updateBracketHighlight(int)", 2353).addDetail("newCaretPosition", n2)).log();
            }
            if (n2 == 0) {
                this.G = -1;
                this.F = -1;
                return;
            }
            try {
                int n3 = TextUtilities.a(this.x, n2 - 1);
                if (n3 != -1) {
                    this.G = this.getLineOfOffset(n3);
                    this.F = n3 - this.getLineStartOffset(this.G);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                if (JEditTextArea.K.level < 5) break block5;
                ((LevelAwareLogBuilder)K.lvlBuild(5, "updateBracketHighlight(int)", 2374).add("bl", (Object)badLocationException)).log();
            }
        }
        this.F = -1;
        this.G = -1;
    }

    protected void a(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "documentChanged(DocumentEvent)", 2383).addDetail("evt", (Object)documentEvent)).log();
        }
        int n2 = (elementChange = documentEvent.getChange(this.x.getDefaultRootElement())) == null ? 0 : elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length;
        int n3 = this.getLineOfOffset(documentEvent.getOffset());
        if (JEditTextArea.K.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(9, "documentChanged(DocumentEvent)", 2395).add("line: ")).add("line", n3)).add(", firstLine: ")).add("firstLine", this.p)).add(", count: ")).add("count", n2)).add(", visibleLines: ")).add("visibleLines", this.q)).log();
        }
        if (n2 == 0) {
            if (this.i != null) {
                this.i.a(n3);
            }
        } else if (n3 < this.p) {
            this.setFirstLine(Math.min(this.p + n2, this.getLineCount() - this.q));
        } else {
            if (this.i != null) {
                this.i.a(n3, this.p + this.q);
            }
            this.updateScrollBars();
        }
        this.unhighlight();
        if (JEditTextArea.K.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(9, "documentChanged(DocumentEvent)", 2421).add("firstLine: ")).add("firstLine", this.p)).add(", visibleLines: ")).add("visibleLines", this.q)).add(", lineCount: ")).add("getLineCount()", this.getLineCount())).log();
        }
        this.fixFirstLine(true);
    }

    public void fixFirstLine(boolean bl2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "fixFirstLine(boolean)", 2436).addDetail("alsoLater", bl2)).log();
        }
        if (this.p + this.q > this.getLineCount()) {
            this.setFirstLine(this.getLineCount() - this.q);
        }
        if (bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (JEditTextArea.K.level >= 7) {
                        K.lvlBuild(7, "fixFirstLine(boolean).Runnable.run()", 2445).log();
                    }
                    JEditTextArea.this.fixFirstLine(false);
                }
            });
        }
    }

    protected void d() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "showSelections()", 2876).log();
        }
        this.setCaretVisible(true);
        if (this.i != null) {
            this.i.b(true);
            this.i.b(this.getSelectionColor());
        }
        g = this;
    }

    protected void e() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "hideSelections()", 2888).log();
        }
        this.setCaretVisible(false);
        if (this.i != null) {
            this.i.b(false);
            this.i.b(this.i.getBackground());
        }
        g = null;
    }

    protected boolean f() {
        JComponent jComponent;
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "didOwnPopupMenuTriggerFocusLoss()", 2900).log();
        }
        if ((jComponent = PopupManager.instance().getMenuItem("")) == null) {
            return false;
        }
        if (jComponent != null && ((JPopupMenu)jComponent).getInvoker() == this.getPainter()) {
            ((JPopupMenu)jComponent).addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    if (JEditTextArea.K.level >= 7) {
                        ((LevelAwareLogBuilder)K.lvlBuild(7, "didOwnPopupMenuTriggerFocusLoss().PopupMenuListener.popupMenuWillBecomeVisible(PopupMenuEvent)", 2908).addDetail("e", (Object)popupMenuEvent)).log();
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    if (JEditTextArea.K.level >= 7) {
                        ((LevelAwareLogBuilder)K.lvlBuild(7, "didOwnPopupMenuTriggerFocusLoss().PopupMenuListener.popupMenuWillBecomeInvisible(PopupMenuEvent)", 2911).addDetail("e", (Object)popupMenuEvent)).log();
                    }
                    ((JPopupMenu)jComponent).removePopupMenuListener(this);
                    JEditTextArea.this.e();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    if (JEditTextArea.K.level >= 7) {
                        ((LevelAwareLogBuilder)K.lvlBuild(7, "didOwnPopupMenuTriggerFocusLoss().PopupMenuListener.popupMenuCanceled(PopupMenuEvent)", 2918).addDetail("e", (Object)popupMenuEvent)).log();
                    }
                }
            });
            return true;
        }
        return false;
    }

    protected SyntaxDocument g() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "createDefaultModel()", 3156).log();
        }
        return new SyntaxDocument();
    }

    @Override
    public void setLineWrap(boolean bl2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setLineWrap(boolean)", 3161).addDetail("wrap", bl2)).log();
        }
        throw new UnsupportedOperationException("No Line Wrap supported");
    }

    @Override
    public void setWrapStyleWord(boolean bl2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setWrapStyleWord(boolean)", 3166).addDetail("word", bl2)).log();
        }
        throw new UnsupportedOperationException("No Line Wrap supported");
    }

    @Override
    public int getRows() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getRows()", 3171).log();
        }
        return this.getVisibleLines();
    }

    @Override
    public void setRows(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setRows(int)", 3176).addDetail("rows", n2)).log();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected int getRowHeight() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getRowHeight()", 3181).log();
        }
        if (this.Q == 0) {
            FontMetrics fontMetrics = this.i();
            this.Q = fontMetrics.getHeight();
        }
        return this.Q;
    }

    @Override
    public int getColumns() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getColumns()", 3190).log();
        }
        return (int)this.getSize().getWidth() / this.getColumnWidth();
    }

    @Override
    public void setColumns(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setColumns(int)", 3195).addDetail("columns", n2)).log();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected int getColumnWidth() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getColumnWidth()", 3200).log();
        }
        if (this.R == 0) {
            FontMetrics fontMetrics = this.i();
            this.R = fontMetrics.charWidth('m');
        }
        return this.R;
    }

    @Override
    public Dimension getPreferredSize() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getPreferredSize()", 3209).log();
        }
        if (this.i != null) {
            return this.i.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    protected String paramString() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "paramString()", 3218).log();
        }
        return "maxLines=" + this.M + ", lineCountCache=" + this.L;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getScrollableTracksViewportWidth()", 3223).log();
        }
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getPreferredScrollableViewportSize()", 3228).log();
        }
        if (this.i != null) {
            return this.i.getSize();
        }
        return super.getPreferredScrollableViewportSize();
    }

    @Override
    public void updateUI() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "updateUI()", 3240).log();
        }
        super.updateUI();
        String string = this.M == 1 ? "TextField" : "TextArea";
        this.O = UIManager.getColor(string + ".background");
    }

    @Override
    public void setMargin(Insets insets) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setMargin(Insets)", 3247).addDetail("m", (Object)insets)).log();
        }
    }

    @Override
    public void setCaretColor(Color color) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setCaretColor(Color)", 3252).addDetail("c", (Object)color)).log();
        }
        super.setCaretColor(color);
        if (this.i != null) {
            this.i.a(color);
        }
    }

    @Override
    public void setSelectionColor(Color color) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setSelectionColor(Color)", 3260).addDetail("c", (Object)color)).log();
        }
        super.setSelectionColor(color);
        if (g == this && this.i != null) {
            this.i.b(color);
        }
    }

    @Override
    public void setSelectedTextColor(Color color) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setSelectedTextColor(Color)", 3268).addDetail("c", (Object)color)).log();
        }
    }

    @Override
    public void setDisabledTextColor(Color color) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setDisabledTextColor(Color)", 3273).addDetail("c", (Object)color)).log();
        }
    }

    @Override
    public void replaceSelection(String string) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "replaceSelection(String)", 3278).addDetail("content", string)).log();
        }
        this.setSelectedText(string);
    }

    @Override
    public void moveCaretPosition(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "moveCaretPosition(int)", 3283).addDetail("pos", n2)).log();
        }
        this.setSelectionStart(this.getCaretPosition());
        this.setSelectionEnd(n2);
    }

    @Override
    public void read(Reader reader, Object object) throws IOException {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "read(Reader,Object)", 3289).addDetail("in", (Object)reader)).addDetail("desc", object)).log();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "write(Writer)", 3294).addDetail("out", (Object)writer)).log();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBackground(Color color) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setBackground(Color)", 3299).addDetail("bg", (Object)color)).log();
        }
        super.setBackground(color);
        if (this.i != null) {
            this.i.setBackground(color);
        }
        if (this.a != null) {
            this.a.a(color);
        }
    }

    public void setMaxLines(int n2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setMaxLines(int)", 3317).addDetail("maxLines", n2)).log();
        }
        this.M = n2;
        boolean bl2 = this.M != 1;
        this.a(bl2);
        this.setCaretColor(bl2 ? TextAreaDefaults.a().m : UIManager.getColor("TextField.caretForeground"));
        this.setSelectionColor(bl2 ? TextAreaDefaults.a().n : UIManager.getColor("TextField.selectionBackground"));
    }

    private void a(boolean bl2) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "fixFocusTraversal(boolean)", 3333).addDetail("isMultiLine", bl2)).log();
        }
        if (this.S != null) {
            for (int i2 = 0; i2 < this.S.length; ++i2) {
                this.setFocusTraversalKeys(i2, bl2 ? this.S[i2] : null);
            }
        }
    }

    public int getMaxLines() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getMaxLines()", 181).log();
        }
        return this.M;
    }

    public List getCompletionPopupActionProviders() {
        if (JEditTextArea.K.level >= 7) {
            K.lvlBuild(7, "getCompletionPopupActionProviders()", 189).log();
        }
        return this.P;
    }

    public JEditTextArea setHighlightDelegate(HighlightDelegate highlightDelegate) {
        if (JEditTextArea.K.level >= 7) {
            ((LevelAwareLogBuilder)K.lvlBuild(7, "setHighlightDelegate(HighlightDelegate)", 191).addDetail("highlightDelegate", (Object)highlightDelegate)).log();
        }
        this.a = highlightDelegate;
        return this;
    }

    @Override
    protected /* synthetic */ Document createDefaultModel() {
        return this.g();
    }

    static {
        h = new Timer(500, new CaretBlinker());
        h.setInitialDelay(500);
        h.start();
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "DocumentHandler.insertUpdate(DocumentEvent)", 2757).addDetail("evt", (Object)documentEvent)).log();
            }
            JEditTextArea.this.a(documentEvent);
            int n2 = documentEvent.getOffset();
            int n3 = documentEvent.getLength();
            int n4 = JEditTextArea.this.A > n2 || JEditTextArea.this.A == JEditTextArea.this.C && JEditTextArea.this.A == n2 ? JEditTextArea.this.A + n3 : JEditTextArea.this.A;
            int n5 = JEditTextArea.this.C >= n2 ? JEditTextArea.this.C + n3 : JEditTextArea.this.C;
            JEditTextArea.this.select(n4, n5);
            int n6 = JEditTextArea.this.getLineCount();
            if (JEditTextArea.K.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(9, "DocumentHandler.insertUpdate(DocumentEvent)", 2780).add("tmp", n6)).add("tmp", n6)).log();
            }
            if (n6 != JEditTextArea.this.L) {
                JEditTextArea.this.revalidate();
            }
            JEditTextArea.this.L = n6;
            JEditTextArea.this.revalidate();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "DocumentHandler.removeUpdate(DocumentEvent)", 2789).addDetail("evt", (Object)documentEvent)).log();
            }
            JEditTextArea.this.a(documentEvent);
            int n2 = documentEvent.getOffset();
            int n3 = documentEvent.getLength();
            int n4 = JEditTextArea.this.A > n2 ? (JEditTextArea.this.A > n2 + n3 ? JEditTextArea.this.A - n3 : n2) : JEditTextArea.this.A;
            int n5 = JEditTextArea.this.C > n2 ? (JEditTextArea.this.C > n2 + n3 ? JEditTextArea.this.C - n3 : n2) : JEditTextArea.this.C;
            JEditTextArea.this.select(n4, n5);
            int n6 = JEditTextArea.this.getLineCount();
            if (JEditTextArea.K.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(9, "DocumentHandler.removeUpdate(DocumentEvent)", 2821).add("tmp", n6)).add("lineCountCache", JEditTextArea.this.L)).log();
            }
            if (n6 != JEditTextArea.this.L) {
                JEditTextArea.this.revalidate();
            }
            JEditTextArea.this.L = n6;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "DocumentHandler.changedUpdate(DocumentEvent)", 2829).addDetail("evt", (Object)documentEvent)).log();
            }
        }
    }

    class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(JEditTextArea.this);
            if (JEditTextArea.K.level >= 7) {
                K.lvlBuild(7, "MutableCaretEvent.MutableCaretEvent()", 2615).log();
            }
        }

        @Override
        public int getDot() {
            if (JEditTextArea.K.level >= 7) {
                K.lvlBuild(7, "MutableCaretEvent.getDot()", 2621).log();
            }
            return JEditTextArea.this.getCaretPosition();
        }

        @Override
        public int getMark() {
            if (JEditTextArea.K.level >= 7) {
                K.lvlBuild(7, "MutableCaretEvent.getMark()", 2627).log();
            }
            return JEditTextArea.this.getMarkPosition();
        }
    }

    class ScrollLayout
    implements LayoutManager {
        private Component b;
        private Component c;
        private Component d;
        private Vector e = new Vector();
        private Component f;

        ScrollLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "ScrollLayout.addLayoutComponent(String,Component)", 2458).addDetail("name", string)).addDetail("comp", (Object)component)).log();
            }
            if (string.equals(c)) {
                this.b = component;
            } else if (string.equals(d)) {
                this.c = component;
            } else if (string.equals(e)) {
                this.d = component;
            } else if (string.equals(LEFT_OF_SCROLLBAR)) {
                this.e.addElement(component);
            } else if (string.equals(f)) {
                this.f = component;
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "ScrollLayout.removeLayoutComponent(Component)", 2473).addDetail("comp", (Object)component)).log();
            }
            if (this.b == component) {
                this.b = null;
            }
            if (this.c == component) {
                this.c = null;
            }
            if (this.d == component) {
                this.d = null;
            } else {
                this.e.removeElement(component);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "ScrollLayout.preferredLayoutSize(Container)", 2486).addDetail("parent", (Object)container)).log();
            }
            Dimension dimension = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            Dimension dimension2 = this.b.getPreferredSize();
            dimension.width += dimension2.width;
            dimension.height += dimension2.height;
            Dimension dimension3 = new Dimension(0, 0);
            if (this.c != null) {
                dimension3 = this.c.getPreferredSize();
            }
            dimension.width += dimension3.width;
            Dimension dimension4 = new Dimension(0, 0);
            if (this.d != null) {
                dimension4 = this.d.getPreferredSize();
            }
            dimension.height += dimension4.height;
            if (this.f != null) {
                Dimension dimension5 = this.f.getPreferredSize();
                dimension.width += dimension5.width;
            }
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "ScrollLayout.minimumLayoutSize(Container)", 2515).addDetail("parent", (Object)container)).log();
            }
            Dimension dimension = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            Dimension dimension2 = this.b.getMinimumSize();
            dimension.width += dimension2.width;
            dimension.height += dimension2.height;
            Dimension dimension3 = new Dimension(0, 0);
            if (this.c != null) {
                dimension3 = this.c.getMinimumSize();
            }
            dimension.width += dimension3.width;
            Dimension dimension4 = new Dimension(0, 0);
            if (this.d != null) {
                dimension4 = this.d.getMinimumSize();
            }
            dimension.height += dimension4.height;
            if (this.c != null) {
                Dimension dimension5 = this.c.getMinimumSize();
                dimension.width += dimension5.width;
            }
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "ScrollLayout.layoutContainer(Container)", 2544).addDetail("parent", (Object)container)).log();
            }
            if (this.b == null) {
                return;
            }
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n2 = insets.top;
            int n3 = insets.left;
            int n4 = insets.bottom;
            int n5 = insets.right;
            int n6 = this.c != null ? this.c.getPreferredSize().width : 0;
            int n7 = this.f != null ? this.f.getPreferredSize().width : 0;
            int n8 = this.d != null ? this.d.getPreferredSize().height : 0;
            int n9 = dimension.width - n6 - n7 - n3 - n5;
            int n10 = dimension.height - n8 - n2 - n4;
            if (this.b != null) {
                this.b.setBounds(n3 + n7, n2, n9, n10);
            }
            if (this.c != null) {
                this.c.setBounds(n3 + n7 + n9, n2, n6, n10);
            }
            if (this.f != null) {
                this.f.setBounds(n3, n2, n7, n10);
            }
            Enumeration enumeration = this.e.elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                Dimension dimension2 = component.getPreferredSize();
                component.setBounds(n3, n2 + n10, dimension2.width, n8);
                n3 += dimension2.width;
            }
            if (this.d != null) {
                this.d.setBounds(n3, n2 + n10, dimension.width - n6 - n3 - n5, n8);
            }
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        @Override
        public void adjustmentValueChanged(final AdjustmentEvent adjustmentEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "AdjustHandler.adjustmentValueChanged(AdjustmentEvent)", 2713).addDetail("evt", (Object)adjustmentEvent)).log();
            }
            if (!JEditTextArea.this.v) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (JEditTextArea.K.level >= 7) {
                        K.lvlBuild(7, "AdjustHandler.adjustmentValueChanged(AdjustmentEvent).Runnable.run()", 2723).log();
                    }
                    if (adjustmentEvent.getAdjustable() == JEditTextArea.this.t) {
                        if (JEditTextArea.this.t != null) {
                            JEditTextArea.this.setFirstLine(JEditTextArea.this.t.getValue());
                        }
                    } else if (JEditTextArea.this.u != null) {
                        JEditTextArea.this.setHorizontalOffset(-JEditTextArea.this.u.getValue());
                    }
                }
            });
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "ComponentHandler.componentResized(ComponentEvent)", 2745).addDetail("evt", (Object)componentEvent)).log();
            }
            JEditTextArea.this.recalculateVisibleLines();
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "MouseHandler.mousePressed(MouseEvent)", 2932).addDetail("evt", (Object)mouseEvent)).log();
            }
            JEditTextArea.this.requestFocus();
            JEditTextArea.this.setCaretVisible(true);
            g = JEditTextArea.this;
            if ((mouseEvent.getModifiers() & 4) != 0) {
                if (JEditTextArea.this.j != null) {
                    JEditTextArea.this.j.show(JEditTextArea.this.i, mouseEvent.getX(), mouseEvent.getY());
                }
                return;
            }
            int n2 = JEditTextArea.this.yToLine(mouseEvent.getY());
            int n3 = JEditTextArea.this.xToOffset(n2, mouseEvent.getX());
            int n4 = JEditTextArea.this.getLineStartOffset(n2) + n3;
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    this.a(mouseEvent, n2, n3, n4);
                    break;
                }
                case 2: {
                    try {
                        this.b(mouseEvent, n2, n3, n4);
                    }
                    catch (BadLocationException badLocationException) {
                        if (JEditTextArea.K.level < 5) break;
                        ((LevelAwareLogBuilder)K.lvlBuild(5, "MouseHandler.mousePressed(MouseEvent)", 2966).add("bl", (Object)badLocationException)).log();
                    }
                    break;
                }
                case 3: {
                    this.c(mouseEvent, n2, n3, n4);
                }
            }
        }

        private void a(MouseEvent mouseEvent, int n2, int n3, int n4) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "MouseHandler.doSingleClick(MouseEvent,int,int,int)", 2975).addDetail("evt", (Object)mouseEvent)).addDetail("line", n2)).addDetail("offset", n3)).addDetail("dot", n4)).log();
            }
            if ((mouseEvent.getModifiers() & 1) != 0) {
                JEditTextArea.this.J = (mouseEvent.getModifiers() & 2) != 0;
                JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), n4);
            } else {
                JEditTextArea.this.setCaretPosition(n4);
            }
            if (JEditTextArea.this.b != null && (mouseEvent.getModifiersEx() & 0x800) != 0) {
                JEditTextArea.this.b(JEditTextArea.this.b);
            }
        }

        private void b(MouseEvent mouseEvent, int n2, int n3, int n4) throws BadLocationException {
            int n5;
            int n6;
            block9: {
                if (JEditTextArea.K.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "MouseHandler.doDoubleClick(MouseEvent,int,int,int)", 2993).addDetail("evt", (Object)mouseEvent)).addDetail("line", n2)).addDetail("offset", n3)).addDetail("dot", n4)).log();
                }
                if (JEditTextArea.this.getLineLength(n2) == 0) {
                    return;
                }
                try {
                    int n7 = TextUtilities.a(JEditTextArea.this.x, Math.max(0, n4 - 1));
                    if (n7 != -1) {
                        int n8 = JEditTextArea.this.getMarkPosition();
                        if (n7 > n8) {
                            ++n7;
                            --n8;
                        }
                        JEditTextArea.this.select(n8, n7);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (JEditTextArea.K.level < 5) break block9;
                    ((LevelAwareLogBuilder)K.lvlBuild(5, "MouseHandler.doDoubleClick(MouseEvent,int,int,int)", 3019).add("bl", (Object)badLocationException)).log();
                }
            }
            String string = JEditTextArea.this.getLineText(n2);
            char c2 = string.charAt(Math.max(0, n3 - 1));
            String string2 = (String)JEditTextArea.this.x.getProperty("noWordSep");
            if (string2 == null) {
                string2 = "";
            }
            boolean bl2 = !Character.isLetterOrDigit(c2) && string2.indexOf(c2) == -1;
            int n9 = 0;
            for (n6 = n3 - 1; n6 >= 0; --n6) {
                c2 = string.charAt(n6);
                if (!(bl2 ^ (!Character.isLetterOrDigit(c2) && string2.indexOf(c2) == -1))) continue;
                n9 = n6 + 1;
                break;
            }
            n6 = string.length();
            for (n5 = n3; n5 < string.length(); ++n5) {
                c2 = string.charAt(n5);
                if (!(bl2 ^ (!Character.isLetterOrDigit(c2) && string2.indexOf(c2) == -1))) continue;
                n6 = n5;
                break;
            }
            n5 = JEditTextArea.this.getLineStartOffset(n2);
            JEditTextArea.this.select(n5 + n9, n5 + n6);
        }

        private void c(MouseEvent mouseEvent, int n2, int n3, int n4) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "MouseHandler.doTripleClick(MouseEvent,int,int,int)", 3077).addDetail("evt", (Object)mouseEvent)).addDetail("line", n2)).addDetail("offset", n3)).addDetail("dot", n4)).log();
            }
            JEditTextArea.this.select(JEditTextArea.this.getLineStartOffset(n2), JEditTextArea.this.getLineEndOffset(n2) - 1);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "MouseHandler.mouseReleased(MouseEvent)", 3084).addDetail("evt", (Object)mouseEvent)).log();
            }
            if (JEditTextArea.this.b != null) {
                JEditTextArea.this.a(JEditTextArea.this.b);
            }
        }
    }

    class DragHandler
    implements MouseMotionListener {
        DragHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "DragHandler.mouseDragged(MouseEvent)", 2840).addDetail("evt", (Object)mouseEvent)).log();
            }
            if (JEditTextArea.this.j != null && JEditTextArea.this.j.isVisible()) {
                return;
            }
            JEditTextArea.this.setSelectionRectangular((mouseEvent.getModifiers() & 2) != 0);
            JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), JEditTextArea.this.xyToOffset(mouseEvent.getX(), mouseEvent.getY()));
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "DragHandler.mouseMoved(MouseEvent)", 2851).addDetail("evt", (Object)mouseEvent)).log();
            }
        }
    }

    class MouseWheelHandler
    implements MouseWheelListener {
        MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "MouseWheelHandler.mouseWheelMoved(MouseWheelEvent)", 2639).addDetail("e", (Object)mouseWheelEvent)).log();
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (JEditTextArea.this.t == null || JEditTextArea.this.q == 0) {
                bl2 = true;
            } else {
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, JEditTextArea.this);
                if (JEditTextArea.K.level >= 9) {
                    ((LevelAwareLogBuilder)K.lvlBuild(9, "MouseWheelHandler.mouseWheelMoved(MouseWheelEvent)", 2648).add("parentPane", (Object)jScrollPane)).log();
                }
                if (jScrollPane == null || jScrollPane.getVerticalScrollBar() == null || !jScrollPane.getVerticalScrollBar().isShowing()) {
                    bl3 = true;
                } else {
                    int n2 = JEditTextArea.this.getLineCount();
                    boolean bl4 = bl2 = !JEditTextArea.this.t.isShowing() || mouseWheelEvent.getWheelRotation() < 0 && JEditTextArea.this.p == 0 || mouseWheelEvent.getWheelRotation() > 0 && JEditTextArea.this.p + JEditTextArea.this.q >= n2;
                    if (!bl2) {
                        Container container = JEditTextArea.this;
                        for (Container container2 = JEditTextArea.this.getParent(); container2 != null && container2 != jScrollPane; container2 = container2.getParent()) {
                            if (!(container2 instanceof JComponent) || ((JComponent)container2).getClientProperty("BetterScrollPane.Parent") == null) continue;
                            container = container2;
                            break;
                        }
                        if (JEditTextArea.K.level >= 9) {
                            ((LevelAwareLogBuilder)K.lvlBuild(9, "MouseWheelHandler.mouseWheelMoved(MouseWheelEvent)", 2675).add("parent", (Object)container)).log();
                        }
                        Rectangle rectangle = SwingUtilities.convertRectangle(container, SwingUtilities.getLocalBounds(container), jScrollPane);
                        Dimension dimension = jScrollPane.getSize();
                        if (mouseWheelEvent.getWheelRotation() < 0 && rectangle.y < 0 || mouseWheelEvent.getWheelRotation() > 0 && rectangle.y + rectangle.height > dimension.height) {
                            bl2 = true;
                        }
                    }
                }
            }
            if (JEditTextArea.K.level >= 9) {
                ((LevelAwareLogBuilder)K.lvlBuild(9, "MouseWheelHandler.mouseWheelMoved(MouseWheelEvent)", 2688).add("passOn", bl2)).log();
            }
            if (!bl2) {
                bl3 = true;
            } else {
                try {
                    Reflector.call((Object)JEditTextArea.this, (String)"dispatchMouseWheelToAncestor", MouseWheelEvent.class, (Object)mouseWheelEvent, (boolean)true);
                }
                catch (Throwable throwable) {
                    if (JEditTextArea.K.level >= 3) {
                        ((LevelAwareLogBuilder)K.lvlBuild(3, "MouseWheelHandler.mouseWheelMoved(MouseWheelEvent)", 2696).add("ex", (Object)throwable)).log();
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                int n3 = mouseWheelEvent.getUnitsToScroll();
                JEditTextArea.this.t.setValue(JEditTextArea.this.t.getValue() + n3);
            }
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "FocusHandler.focusGained(FocusEvent)", 2860).addDetail("evt", (Object)focusEvent)).log();
            }
            JEditTextArea.this.d();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "FocusHandler.focusLost(FocusEvent)", 2866).addDetail("evt", (Object)focusEvent)).log();
            }
            if (JEditTextArea.this.f()) {
                return;
            }
            JEditTextArea.this.e();
        }
    }

    public static interface HighlightDelegate {
        public void a(Color var1);

        public Color a();
    }

    class CaretUndo
    extends AbstractUndoableEdit {
        private int b;
        private int c;

        CaretUndo(int n2, int n3) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)K.lvlBuild(7, "CaretUndo.CaretUndo(int,int)", 3101).addDetail("start", n2)).addDetail("end", n3)).log();
            }
            this.b = n2;
            this.c = n3;
        }

        @Override
        public boolean isSignificant() {
            if (JEditTextArea.K.level >= 7) {
                K.lvlBuild(7, "CaretUndo.isSignificant()", 3108).log();
            }
            return false;
        }

        @Override
        public String getPresentationName() {
            if (JEditTextArea.K.level >= 7) {
                K.lvlBuild(7, "CaretUndo.getPresentationName()", 3114).log();
            }
            return "caret move";
        }

        @Override
        public void undo() throws CannotUndoException {
            if (JEditTextArea.K.level >= 7) {
                K.lvlBuild(7, "CaretUndo.undo()", 3120).log();
            }
            super.undo();
            JEditTextArea.this.select(this.b, this.c);
        }

        @Override
        public void redo() throws CannotRedoException {
            if (JEditTextArea.K.level >= 7) {
                K.lvlBuild(7, "CaretUndo.redo()", 3128).log();
            }
            super.redo();
            JEditTextArea.this.select(this.b, this.c);
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "CaretUndo.addEdit(UndoableEdit)", 3136).addDetail("edit", (Object)undoableEdit)).log();
            }
            if (undoableEdit instanceof CaretUndo) {
                CaretUndo caretUndo = (CaretUndo)undoableEdit;
                this.b = caretUndo.b;
                this.c = caretUndo.c;
                caretUndo.die();
                return true;
            }
            return false;
        }
    }

    static class CaretBlinker
    implements ActionListener {
        CaretBlinker() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JEditTextArea.K.level >= 7) {
                ((LevelAwareLogBuilder)K.lvlBuild(7, "CaretBlinker.actionPerformed(ActionEvent)", 2602).addDetail("evt", (Object)actionEvent)).log();
            }
            if (g != null && g.hasFocus()) {
                g.blinkCaret();
            }
        }
    }
}

