/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.macos;

import de.qfs.apps.qftest.App;
import de.qfs.apps.qftest.base.BaseFrame;
import de.qfs.apps.qftest.macos.a;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.script.modules.Automac;
import de.qfs.apps.qftest.suite.SuiteFrame;
import de.qfs.apps.qftest.suite.WorkbenchFrame;
import de.qfs.apps.qftest.t;
import de.qfs.lib.command.Command;
import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.OptionValidator;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;

public abstract class MacOSIntegration
extends t {
    private static final QFLogger j = new QFLogger("de.qfs.apps.qftest.macos.MacOSIntegration");
    protected static final String b = "/de/qfs/qftest/JVMArguments";
    protected static final String c = "/de/qfs/qftest/JVMOptions";
    protected static final String d = "option.group.suite.root.general.children";
    protected static final Pattern e = Pattern.compile("\\D*((\\d+)([mMkKgG]?)).*?");
    protected static final int f = 1;
    protected static final int g = 2;
    public static final String PROP_USE_SCREEN_MENU_BAR_OLD = "com.apple.macos.useScreenMenuBar";
    public static final String PROP_USE_SCREEN_MENU_BAR = "apple.laf.useScreenMenuBar";
    protected static Queue h = new LinkedBlockingQueue();
    private final AtomicReference k = new AtomicReference();

    @Override
    public void initApplication() {
        if (MacOSIntegration.j.level >= 7) {
            j.lvlBuild(7, "initApplication()", 91).log();
        }
        if (MacOSIntegration.j.level >= 7) {
            ((LevelAwareLogBuilder)j.lvlBuild(7, "initApplication()", 92).add("OS_IS_MAC_OS_X", Misc.OS_IS_MAC_OS_X)).log();
        }
        this.a();
        if (!Automac.instance().isProcessTrusted(true)) {
            Message.showMessage(null, (String)"macos.assistive");
        }
        if (!Automac.instance().canCaptureScreen(true)) {
            Message.showMessage(null, (String)"macos.screenrecording");
        }
        this.setHandlers();
    }

    protected abstract void setHandlers();

    protected void a() {
        if (MacOSIntegration.j.level >= 7) {
            j.lvlBuild(7, "setMacOSProperties()", 115).log();
        }
        String string = "" + this.isUsingSystemMenu();
        System.setProperty(PROP_USE_SCREEN_MENU_BAR, string);
        System.setProperty(PROP_USE_SCREEN_MENU_BAR_OLD, string);
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "QF-Test");
        System.setProperty("com.apple.smallTabs", "true");
        System.setProperty("file.encoding", "UTF-8");
    }

    private boolean b() {
        String string;
        if (MacOSIntegration.j.level >= 7) {
            j.lvlBuild(7, "useScreenMenuBar()", 129).log();
        }
        if ((string = System.getProperty(PROP_USE_SCREEN_MENU_BAR)) == null) {
            string = System.getProperty(PROP_USE_SCREEN_MENU_BAR_OLD);
        }
        if (string == null) {
            return true;
        }
        return !Boolean.FALSE.equals(Boolean.parseBoolean(string));
    }

    protected void a(String string) {
        Object object;
        if (MacOSIntegration.j.level >= 7) {
            ((LevelAwareLogBuilder)j.lvlBuild(7, "executeMenuCommand(String)", 149).addDetail("menuCommand", string)).log();
        }
        JMenuItem jMenuItem = null;
        if (WorkbenchFrame.H()) {
            object = WorkbenchFrame.G();
            assert (object != null) : "Workbench was not ready";
            jMenuItem = object.getMenuItem(string);
        }
        if (MacOSIntegration.j.level >= 9) {
            ((LevelAwareLogBuilder)j.lvlBuild(9, "executeMenuCommand(String)", 159).add("menuItem", (Object)jMenuItem)).log();
        }
        object = null;
        AbstractButton abstractButton = null;
        for (Window window : Frame.getWindows()) {
            if (window instanceof BaseFrame) {
                BaseFrame baseFrame = (BaseFrame)((Object)window);
                if (window.isActive()) {
                    jMenuItem = baseFrame.getMenuItem(string);
                }
                if (jMenuItem == null && object == null && window instanceof SuiteFrame) {
                    object = baseFrame.getMenuItem(string);
                }
                if (jMenuItem == null && object == null && abstractButton == null) {
                    abstractButton = baseFrame.getMenuItem(string);
                }
            }
            if (!window.isShowing() || !(window instanceof Dialog)) continue;
            return;
        }
        if (jMenuItem != null) {
            jMenuItem.doClick();
        } else if (object != null) {
            ((AbstractButton)object).doClick();
        } else if (abstractButton != null) {
            abstractButton.doClick();
        } else if (MacOSIntegration.j.level >= 3) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)j.lvlBuild(3, "executeMenuCommand(String)", 190).add("No suitable menu item found for ")).add(string)).log();
        }
    }

    protected void a(File file) {
        if (MacOSIntegration.j.level >= 7) {
            ((LevelAwareLogBuilder)j.lvlBuild(7, "openFile(File)", 203).addDetail("file", (Object)file)).log();
        }
        App.instance().getCommandDistributor().assignCommand((Command)new de.qfs.apps.qftest.base.command.t(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] extendArgsWithStartupFiles(String[] stringArray) {
        if (MacOSIntegration.j.level >= 7) {
            ((LevelAwareLogBuilder)j.lvlBuild(7, "extendArgsWithStartupFiles(String[])", 219).addDetail("originalArgs", (Object)stringArray)).log();
        }
        try {
            if (stringArray == null || h == null || h.size() == 0) {
                String[] stringArray2 = stringArray;
                return stringArray2;
            }
            int n2 = stringArray.length;
            String[] stringArray3 = new String[n2 + h.size()];
            System.arraycopy(stringArray, 0, stringArray, 0, n2);
            int n3 = stringArray.length;
            String[] stringArray4 = h.iterator();
            while (stringArray4.hasNext()) {
                String string;
                stringArray3[n3] = string = (String)stringArray4.next();
                ++n3;
            }
            stringArray4 = stringArray3;
            return stringArray4;
        }
        finally {
            h = null;
        }
    }

    @Override
    public void fixupResources(MapResourceBundle mapResourceBundle) {
        if (MacOSIntegration.j.level >= 7) {
            ((LevelAwareLogBuilder)j.lvlBuild(7, "fixupResources(MapResourceBundle)", 248).addDetail("rb", (Object)mapResourceBundle)).log();
        }
        this.a(mapResourceBundle);
    }

    private void a(MapResourceBundle mapResourceBundle) {
        if (MacOSIntegration.j.level >= 7) {
            ((LevelAwareLogBuilder)j.lvlBuild(7, "addStartupMacOptionPane(MapResourceBundle)", 256).addDetail("rb", (Object)mapResourceBundle)).log();
        }
        String string = mapResourceBundle.getString(d);
        mapResourceBundle.addResource(d, (Object)(string + " startupmac"));
    }

    @Override
    public void loadPlatformPreferences() {
        block3: {
            if (MacOSIntegration.j.level >= 7) {
                j.lvlBuild(7, "loadPlatformPreferences()", 266).log();
            }
            try {
                Preferences preferences = Preferences.userRoot().node(b);
                String string = preferences.get("args", "");
                Options.setOption((String)Options.OPT_EXTRA_STARTUP_ARGS, (Object)string);
                Options.getOption((String)Options.OPT_EXTRA_STARTUP_ARGS).addValidator((OptionValidator)new a(this));
                preferences = Preferences.userRoot().node(c);
                String string2 = preferences.get("Xms", "");
                Options.setOption((String)Options.OPT_EXTRA_VM_XMS_ARGS, (Object)this.a(string2, 1));
                String string3 = preferences.get("Xmx", "");
                Options.setOption((String)Options.OPT_EXTRA_VM_XMX_ARGS, (Object)this.a(string3, 2));
            }
            catch (Exception exception) {
                if (MacOSIntegration.j.level < 1) break block3;
                ((LevelAwareLogBuilder)j.lvlBuild(1, "loadPlatformPreferences()", 317).add("ex", (Object)exception)).log();
            }
        }
    }

    private String a(String string, int n2) {
        Matcher matcher;
        if (MacOSIntegration.j.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)j.lvlBuild(7, "fixupXmOption(String,int)", 325).addDetail("fullOption", string)).addDetail("minMB", n2)).log();
        }
        if ((matcher = e.matcher(string)).matches()) {
            int n3;
            String string2;
            block11: {
                string2 = matcher.group(3).toUpperCase();
                n3 = Integer.MAX_VALUE;
                try {
                    n3 = Integer.valueOf(matcher.group(2));
                }
                catch (NumberFormatException numberFormatException) {
                    if (MacOSIntegration.j.level < 5) break block11;
                    ((LevelAwareLogBuilder)j.lvlBuild(5, "fixupXmOption(String,int)", 333).add("ex", (Object)numberFormatException)).log();
                }
            }
            if ("M".equals(string2)) {
                if (n3 < n2) {
                    n3 = n2;
                }
            } else if ("K".equals(string2)) {
                if (n3 < n2 * 1024) {
                    n3 = n2 * 1024;
                }
            } else if ("".equals(string2) && (n3 = (int)(Math.ceil((double)n3 / 1024.0) * 1024.0)) < n2 * 1024 * 1024) {
                n3 = n2 * 1024 * 1024;
            }
            return n3 + string2;
        }
        return "";
    }

    @Override
    public void savePlatformPreferences() {
        block11: {
            if (MacOSIntegration.j.level >= 7) {
                j.lvlBuild(7, "savePlatformPreferences()", 352).log();
            }
            try {
                Preferences preferences = Preferences.userRoot().node(b);
                String string = Options.cached_OPT_EXTRA_STARTUP_ARGS;
                if (Misc.emptyOrNull((String)string)) {
                    preferences.remove("args");
                } else {
                    preferences.put("args", string);
                }
                preferences.flush();
                preferences = Preferences.userRoot().node(c);
                String string2 = Options.getString((String)Options.OPT_EXTRA_VM_XMS_ARGS, (String)"");
                String string3 = this.a(string2, 1);
                if (Misc.emptyOrNull((String)string3)) {
                    preferences.remove("Xms");
                } else {
                    if (!string3.equals(string2)) {
                        Message.showMessage(null, (String)"startup.memfix", (Object[])new Object[]{"Xms", string2, string3});
                    }
                    preferences.put("Xms", "-Xms" + string3);
                }
                String string4 = Options.getString((String)Options.OPT_EXTRA_VM_XMX_ARGS, (String)"");
                String string5 = this.a(string4, 2);
                if (Misc.emptyOrNull((String)string5)) {
                    preferences.remove("Xmx");
                } else {
                    if (!string5.equals(string4)) {
                        Message.showMessage(null, (String)"startup.memfix", (Object[])new Object[]{"Xmx", string4, string5});
                    }
                    preferences.put("Xmx", "-Xmx" + string5);
                }
                preferences.flush();
            }
            catch (Exception exception) {
                if (MacOSIntegration.j.level < 1) break block11;
                ((LevelAwareLogBuilder)j.lvlBuild(1, "savePlatformPreferences()", 392).add("ex", (Object)exception)).log();
            }
        }
    }

    @Override
    public void toggleFullScreen(Window window) {
        block3: {
            if (MacOSIntegration.j.level >= 7) {
                ((LevelAwareLogBuilder)j.lvlBuild(7, "toggleFullScreen(Window)", 403).addDetail("window", (Object)window)).log();
            }
            try {
                Class<?> clazz = Class.forName("com.apple.eawt.Application");
                Object object = Reflector.call(clazz, (String)"getApplication");
                Reflector.call((Object)object, (String)"requestToggleFullScreen", (Class[])new Class[]{Window.class}, (Object[])new Object[]{window});
            }
            catch (Exception exception) {
                if (MacOSIntegration.j.level < 3) break block3;
                ((LevelAwareLogBuilder)j.lvlBuild(3, "toggleFullScreen(Window)", 410).add("Could not toggle fullscreen mode", (Object)exception)).log();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUsingSystemMenu() {
        Object object;
        if (MacOSIntegration.j.level >= 7) {
            j.lvlBuild(7, "isUsingSystemMenu()", 83).log();
        }
        if ((object = this.k.get()) == null) {
            AtomicReference atomicReference = this.k;
            synchronized (atomicReference) {
                object = this.k.get();
                if (object == null) {
                    boolean bl2 = this.b();
                    object = bl2;
                    this.k.set(object);
                }
            }
        }
        return (Boolean)object;
    }
}

