/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.macos;

import de.qfs.apps.qftest.base.BaseFrame;
import de.qfs.apps.qftest.macos.MacOSIntegration;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Reflector;
import java.awt.Desktop;
import java.awt.Window;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.io.File;

public class MacOSIntegration9
extends MacOSIntegration
implements AboutHandler,
OpenFilesHandler,
PreferencesHandler,
QuitHandler {
    private static final QFLogger j = new QFLogger("de.qfs.apps.qftest.macos.MacOSIntegration9");

    @Override
    public void setHandlers() {
        block3: {
            if (MacOSIntegration9.j.level >= 7) {
                j.lvlBuild(7, "setHandlers()", 68).log();
            }
            try {
                Desktop desktop = Desktop.getDesktop();
                desktop.setAboutHandler(this);
                desktop.setPreferencesHandler(this);
                desktop.setQuitHandler(this);
                desktop.setOpenFileHandler(this);
            }
            catch (Exception exception) {
                if (MacOSIntegration9.j.level < 1) break block3;
                ((LevelAwareLogBuilder)j.lvlBuild(1, "setHandlers()", 76).add("ex", (Object)exception)).log();
            }
        }
    }

    @Override
    public void handleAbout(AboutEvent aboutEvent) {
        if (MacOSIntegration9.j.level >= 7) {
            ((LevelAwareLogBuilder)j.lvlBuild(7, "handleAbout(AboutEvent)", 88).addDetail("aboutEvent", (Object)aboutEvent)).log();
        }
        this.a("help.info");
    }

    @Override
    public void handleQuitRequestWith(QuitEvent quitEvent, QuitResponse quitResponse) {
        if (MacOSIntegration9.j.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)j.lvlBuild(7, "handleQuitRequestWith(QuitEvent,QuitResponse)", 99).addDetail("quitEvent", (Object)quitEvent)).addDetail("quitResponse", (Object)quitResponse)).log();
        }
        quitResponse.cancelQuit();
        this.a("file.exit");
    }

    @Override
    public void handlePreferences(PreferencesEvent preferencesEvent) {
        if (MacOSIntegration9.j.level >= 7) {
            ((LevelAwareLogBuilder)j.lvlBuild(7, "handlePreferences(PreferencesEvent)", 113).addDetail("preferenceEvent", (Object)preferencesEvent)).log();
        }
        this.a("edit.options");
    }

    @Override
    public void openFiles(OpenFilesEvent openFilesEvent) {
        if (MacOSIntegration9.j.level >= 7) {
            ((LevelAwareLogBuilder)j.lvlBuild(7, "openFiles(OpenFilesEvent)", 127).addDetail("openFilesEvent", (Object)openFilesEvent)).log();
        }
        if (MacOSIntegration9.j.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)j.lvlBuild(7, "openFiles(OpenFilesEvent)", 128).add("files", openFilesEvent == null ? null : openFilesEvent.getFiles())).addDetail("startupFiles", (Object)h)).log();
        }
        boolean bl2 = h != null;
        for (File file : openFilesEvent.getFiles()) {
            if (bl2) {
                h.add(file.getAbsolutePath());
                continue;
            }
            this.a(file);
        }
    }

    @Override
    public void enableOSFullscreen(BaseFrame baseFrame) {
        block3: {
            if (MacOSIntegration9.j.level >= 7) {
                ((LevelAwareLogBuilder)j.lvlBuild(7, "enableOSFullscreen(BaseFrame)", 146).addDetail("w", (Object)baseFrame)).log();
            }
            try {
                Class<?> clazz = Class.forName("com.apple.eawt.FullScreenUtilities");
                Reflector.call(clazz, (String)"setWindowCanFullScreen", (Class[])new Class[]{Window.class, Boolean.TYPE}, (Object[])new Object[]{baseFrame, true});
            }
            catch (Exception exception) {
                if (MacOSIntegration9.j.level < 3) break block3;
                ((LevelAwareLogBuilder)j.lvlBuild(3, "enableOSFullscreen(BaseFrame)", 151).add("Could not enable fullscreen mode", (Object)exception)).log();
            }
        }
    }

    static {
        Reflector.openModule((String)"java.desktop", (String)"com.apple.laf", MacOSIntegration9.class);
        Reflector.openModule((String)"java.desktop", (String)"com.apple.eawt", MacOSIntegration9.class);
    }
}

