/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.record.procbuilder.RppConditionDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholder;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholdersForStep;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.step.AbstractStep;
import de.qfs.apps.qftest.suite.Suite;
import de.qfs.apps.qftest.suite.SuiteMap;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class KeywordDefinitions {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.KeywordDefinitions");
    static final String STEP_START = "<qfs:step>";
    static final String STEP_END = "</qfs:step>";
    static final String KEYWORD_SEPARATOR = ";";
    static final String CONDITION_SEPARATOR = "--if--";
    List keywordDefinitions = new ArrayList();
    String interpreter = null;

    public KeywordDefinitions(String[][] stringArray, String string) {
        if (Misc.emptyOrNull((Object[])stringArray)) {
            return;
        }
        this.interpreter = string;
        for (String[] stringArray2 : stringArray) {
            this.keywordDefinitions.add(new String[]{this.extractKeyword(stringArray2), this.extractCondition(stringArray2)});
        }
    }

    private String extractKeyword(String[] stringArray) {
        if (KeywordDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "extractKeyword(String[])", 97).addDetail("definition", (Object)stringArray)).log();
        }
        if (stringArray == null) {
            return "";
        }
        return stringArray[0] == null ? "" : stringArray[0].trim();
    }

    private String extractCondition(String[] stringArray) {
        if (KeywordDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "extractCondition(String[])", 112).addDetail("definition", (Object)stringArray)).log();
        }
        if (stringArray == null || stringArray.length < 2) {
            return "";
        }
        return stringArray[1] == null ? "" : stringArray[1].trim();
    }

    public static Map setAllKeywordDefinitions() {
        String[] stringArray;
        HashMap hashMap = new HashMap();
        String string = null;
        for (String string2 : stringArray = Options.cached_OPT_KEYWORD_DEFINITIONS.split(STEP_START)) {
            String[] stringArray2;
            String string3;
            if (string == null) {
                if (string2.trim().isEmpty()) {
                    string = "jython";
                    continue;
                }
                string = string2.trim();
                continue;
            }
            if (string2.trim().isEmpty()) continue;
            String[] stringArray3 = string2.trim().split(STEP_END);
            if (stringArray3.length != 2) {
                if (KeywordDefinitions.logger.level < 9) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setAllKeywordDefinitions()", 155).add("The step must be specified by '<qfs:step>step name</qfs:step>'")).log();
                continue;
            }
            String string4 = null;
            String[] stringArray4 = stringArray3[0].split("___");
            if (stringArray4.length == 1) {
                string3 = stringArray4[0].trim();
            } else if (stringArray4.length == 2) {
                string3 = stringArray4[0].trim();
                string4 = stringArray4[1].trim();
            } else {
                if (KeywordDefinitions.logger.level < 9) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setAllKeywordDefinitions()", 167).add("invalid keyword definition: invalid syntax for the step")).log();
                continue;
            }
            for (String string5 : stringArray2 = stringArray3[1].split(KEYWORD_SEPARATOR)) {
                if (string5.isEmpty()) continue;
                String[] stringArray5 = string5.split(CONDITION_SEPARATOR);
                if (stringArray5.length == 0 || stringArray5.length > 2) {
                    if (KeywordDefinitions.logger.level < 9) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "setAllKeywordDefinitions()", 177).add("The keyword and the condition must be separated by a tab. The definition must contain only one tab")).log();
                    continue;
                }
                String string6 = stringArray5[0].trim();
                String string7 = null;
                if (stringArray5.length > 1) {
                    string7 = stringArray5[1].trim();
                }
                KeywordDefinitions.addStepsKeywordDefinition(hashMap, string3, string4, string6, string7, string);
            }
        }
        return hashMap;
    }

    private static void addStepsKeywordDefinition(Map map, String string, String string2, String string3, String string4, String string5) {
        if (KeywordDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addStepsKeywordDefinition(Map<String, KeywordDefinitions>,String,String,String,String,String)", 205).addDetail("allStepsKeywordDefinitions", (Object)map)).addDetail("step", string)).addDetail("stepType", string2)).addDetail("keyword", string3)).addDetail("condition", string4)).addDetail("interpreter", string5)).log();
        }
        Object object = string;
        if (string2 != null) {
            object = string + "___" + string2;
        }
        if (map.containsKey(object)) {
            ((KeywordDefinitions)map.get((Object)object)).keywordDefinitions.add(new String[]{string3, string4});
        } else {
            String[][] stringArray = new String[][]{{string3, string4}};
            map.put(object, new KeywordDefinitions(stringArray, string5));
        }
    }

    @Nullable
    public String getKeyword(RppPlaceholdersForStep rppPlaceholdersForStep) {
        if (KeywordDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getKeyword(RppPlaceholdersForStep)", 228).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).log();
        }
        for (String[] stringArray : this.keywordDefinitions) {
            String string = stringArray[1];
            String string2 = stringArray[0];
            if (Misc.emptyOrNull((String)string)) {
                return rppPlaceholdersForStep.replacePlaceholders(string2, this.interpreter);
            }
            String string3 = rppPlaceholdersForStep.replacePlaceholders(string, this.interpreter);
            String string4 = rppPlaceholdersForStep.getStep().getName() == null ? rppPlaceholdersForStep.getStep().getClass().getName() : rppPlaceholdersForStep.getStep().getName();
            boolean bl2 = RppConditionDefinition.performConditionCheck(string4, string3, this.interpreter, null);
            if (!bl2) continue;
            return rppPlaceholdersForStep.replacePlaceholders(string2, this.interpreter);
        }
        return null;
    }

    @Nullable
    public static String getKeywordForAbstractStep(Map map, AbstractStep abstractStep) {
        Suite suite;
        if (KeywordDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getKeywordForAbstractStep(Map<String, KeywordDefinitions>,AbstractStep)", 259).addDetail("allStepsKeywordDefinitions", (Object)map)).addDetail("step", (Object)abstractStep)).log();
        }
        if ((suite = SuiteMap.instance().e()) == null) {
            return null;
        }
        RppPlaceholdersForStep rppPlaceholdersForStep = new RppPlaceholdersForStep(abstractStep, suite, null);
        Object object = RppPlaceholder.getKindOfNode(abstractStep);
        String string = RppPlaceholder.getNodeType(abstractStep);
        if (string != null) {
            object = (String)object + "___" + string;
        }
        if (!map.containsKey(object)) {
            if (KeywordDefinitions.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getKeywordForAbstractStep(Map<String, KeywordDefinitions>,AbstractStep)", 273).add("no keyword definition for ", (String)object)).log();
            }
            return null;
        }
        KeywordDefinitions keywordDefinitions = (KeywordDefinitions)map.get(object);
        return keywordDefinitions.getKeyword(rppPlaceholdersForStep);
    }

    public List getKeywordDefinitions() {
        if (KeywordDefinitions.logger.level >= 7) {
            logger.lvlBuild(7, "getKeywordDefinitions()", 58).log();
        }
        return this.keywordDefinitions;
    }
}

