/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.log.recording.a;
import de.qfs.apps.qftest.record.RecordingProcessor;
import de.qfs.apps.qftest.record.procbuilder.RppDebug;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholders;
import de.qfs.apps.qftest.record.procbuilder.RppProcCallDefinitions;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.ClientData;
import de.qfs.apps.qftest.shared.data.ElementInfo;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.step.AbstractStep;
import de.qfs.apps.qftest.step.ProcedureCall;
import de.qfs.apps.qftest.suite.Suite;
import de.qfs.apps.qftest.suite.SuiteView;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.List;

public class ProcedureCallRecordingProcessor
implements RecordingProcessor {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.ProcedureCallRecordingProcessor");
    private String previousScope = "";
    private String previousVscope = "";

    @Override
    public List preprocess(Suite suite, List list) {
        if (ProcedureCallRecordingProcessor.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "preprocess(Suite,List<ClientData>)", 50).addDetail("suite", (Object)suite)).addDetail("events", (Object)list)).log();
        }
        return null;
    }

    @Override
    public String mapComponent(Suite suite, String string, String string2, ElementInfo elementInfo, ClientData clientData) {
        if (ProcedureCallRecordingProcessor.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "mapComponent(Suite,String,String,ElementInfo,ClientData)", 55).addDetail("suite", (Object)suite)).addDetail("smartID", string)).addDetail("clientName", string2)).addDetail("info", (Object)elementInfo)).addDetail("data", (Object)clientData)).log();
        }
        return null;
    }

    @Override
    public List process(Suite suite, List list) {
        if (ProcedureCallRecordingProcessor.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "process(Suite,List<AbstractStep>)", 60).addDetail("suite", (Object)suite)).addDetail("steps", (Object)list)).log();
        }
        if (!Options.cached_OPT_RECORD_PROCEDURE_CALLS) {
            return null;
        }
        if (Options.cached_OPT_RECORDING_PROCESSOR_NEW != 1) {
            return null;
        }
        RppPlaceholders rppPlaceholders = ProcedureCallRecordingProcessor.initializePlaceholders(suite, list);
        this.previousScope = "";
        this.previousVscope = "";
        a a2 = SuiteView.a(0, true);
        RppProcCallDefinitions.dictionaries.clear();
        RppDebug rppDebug = new RppDebug(suite, a2);
        RppProcCallDefinitions rppProcCallDefinitions = new RppProcCallDefinitions(suite, rppDebug);
        if (ProcedureCallRecordingProcessor.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "process(Suite,List<AbstractStep>)", 77).add("procCallDefinitions: ", (Object)rppProcCallDefinitions)).log();
        }
        if (rppProcCallDefinitions.isEmpty()) {
            if (a2 != null) {
                a2.save(a2.getFile());
            }
            return list;
        }
        this.removeIgnoreSteps(rppPlaceholders, list, rppDebug);
        for (int i2 = 1; i2 <= Options.getInt((String)Options.OPT_RECORDING_PROCESSOR_LOOPS); ++i2) {
            rppPlaceholders.setOffset(0);
            this.transformSteps(rppPlaceholders, list, rppDebug, i2);
            rppPlaceholders = ProcedureCallRecordingProcessor.initializePlaceholders(suite, list);
        }
        if (a2 != null) {
            a2.save(a2.getFile());
        }
        for (AbstractStep abstractStep : list) {
            String string;
            String[] stringArray;
            if (!(abstractStep instanceof ProcedureCall) || (stringArray = ProcedureCall.splitName(string = abstractStep.getName()))[0] == null || !suite.canUseImplicitReference(stringArray[0], stringArray[1], ProcedureCall.PROCEDURE)) continue;
            ((ProcedureCall)abstractStep).setName(stringArray[1]);
        }
        return list;
    }

    private static RppPlaceholders initializePlaceholders(Suite suite, List list) {
        if (ProcedureCallRecordingProcessor.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "initializePlaceholders(Suite,List<AbstractStep>)", 113).addDetail("suite", (Object)suite)).addDetail("steps", (Object)list)).log();
        }
        RppPlaceholders rppPlaceholders = new RppPlaceholders(suite);
        for (AbstractStep abstractStep : list) {
            rppPlaceholders.addStep(abstractStep);
        }
        return rppPlaceholders;
    }

    private void transformSteps(RppPlaceholders rppPlaceholders, List list, RppDebug rppDebug, int n2) {
        if (ProcedureCallRecordingProcessor.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "transformSteps(RppPlaceholders,List<AbstractStep>,RppDebug,int)", 129).addDetail("placeholders", (Object)rppPlaceholders)).addDetail("steps", (Object)list)).addDetail("debug", (Object)rppDebug)).addDetail("iterationNumber", n2)).log();
        }
        if (ProcedureCallRecordingProcessor.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "transformSteps(RppPlaceholders,List<AbstractStep>,RppDebug,int)", 131).add("steps", (Object)list)).log();
        }
        if (n2 > 1) {
            rppDebug.logSteps("Steps before iterations ", list);
        }
        rppDebug.pushSequenceLog("Iteration " + n2 + " - procedure call definitions checked");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = ((AbstractStep)list.get(i2)).getClass().getSimpleName();
            rppDebug.pushSequenceLog("(" + (rppPlaceholders.getOffset() + i2) + ") ");
            int n3 = RppProcCallDefinitions.processNextSteps(rppPlaceholders, list, rppDebug, i2);
            if (n3 > 0) {
                if (n3 > 1) {
                    rppPlaceholders.setOffset(rppPlaceholders.getOffset() + n3 - 1);
                }
                ((AbstractStep)list.get(i2)).setComment(this.pruneComment(((AbstractStep)list.get(i2)).getComment()));
            } else {
                int n4 = 2;
                int n5 = 3;
                int n6 = Options.cached_OPT_RECORDING_PROCESSOR_UNPROCESSED_STEPS;
                if (n6 == n4) {
                    list.remove(i2);
                    rppPlaceholders.removeStep(i2);
                    --i2;
                } else if (n6 == n5) {
                    AbstractStep abstractStep = (AbstractStep)list.get(i2);
                    abstractStep.setComment("@red");
                }
                if (ProcedureCallRecordingProcessor.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "transformSteps(RppPlaceholders,List<AbstractStep>,RppDebug,int)", 164).add("step unchanged ")).add(rppPlaceholders.getOffset() + i2)).log();
                }
            }
            rppDebug.updateNameAndPopLog(ProcedureCallRecordingProcessor.setDebugMessage(rppPlaceholders, list, n3, i2, string));
            if (ProcedureCallRecordingProcessor.logger.level < 9) continue;
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "transformSteps(RppPlaceholders,List<AbstractStep>,RppDebug,int)", 168).add("steps", (Object)list)).log();
        }
        rppDebug.popLog();
    }

    private static String setDebugMessage(RppPlaceholders rppPlaceholders, List list, int n2, int n3, String string) {
        if (ProcedureCallRecordingProcessor.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setDebugMessage(RppPlaceholders,List<AbstractStep>,int,int,String)", 173).addDetail("placeholders", (Object)rppPlaceholders)).addDetail("steps", (Object)list)).addDetail("processedSteps", n2)).addDetail("currentStep", n3)).addDetail("stepClass", string)).log();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 0) {
            return stringBuilder.append("(").append(rppPlaceholders.getOffset() + n3).append(") ").append(string).append(" unchanged").toString();
        }
        if (n2 == 1) {
            stringBuilder.append("(").append(rppPlaceholders.getOffset() + n3).append(") ").append(string);
        } else {
            int n4 = rppPlaceholders.getOffset() + n3 - n2 + 1;
            stringBuilder.append("(").append(n4).append(") - (").append(n4 + n2 - 1).append(") ").append(string).append("...");
        }
        AbstractStep abstractStep = (AbstractStep)list.get(n3);
        Object object = "";
        if (abstractStep instanceof ProcedureCall) {
            ProcedureCall procedureCall = (ProcedureCall)abstractStep;
            object = " -> " + procedureCall.getName();
        }
        return stringBuilder.append((String)object).toString();
    }

    private void removeIgnoreSteps(RppPlaceholders rppPlaceholders, List list, RppDebug rppDebug) {
        if (ProcedureCallRecordingProcessor.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "removeIgnoreSteps(RppPlaceholders,List<AbstractStep>,RppDebug)", 202).addDetail("placeholders", (Object)rppPlaceholders)).addDetail("steps", (Object)list)).addDetail("debug", (Object)rppDebug)).log();
        }
        if (ProcedureCallRecordingProcessor.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "removeIgnoreSteps(RppPlaceholders,List<AbstractStep>,RppDebug)", 204).add("steps", (Object)list)).log();
        }
        rppDebug.pushSequenceLog("Remove 'Ignore' steps - definitions checked:");
        int n2 = rppPlaceholders.getOffset();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            StringBuilder stringBuilder = new StringBuilder();
            rppDebug.pushSequenceLog("(" + n2 + ")  Definitions checked for ignoring");
            int n3 = RppProcCallDefinitions.findMatchingIgnoreDefinition(rppPlaceholders, i2, list, rppDebug);
            String string = ((AbstractStep)list.get(i2)).getClass().getSimpleName();
            if (n3 > 0) {
                if (n3 == 1) {
                    stringBuilder.append("(").append(n2).append(") ").append(string).append(" removed");
                } else {
                    stringBuilder.append("(").append(n2).append(") - (").append(n2 + n3 - 1).append(") ").append(string).append("... removed");
                    n2 += n3 - 1;
                }
                if (ProcedureCallRecordingProcessor.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "removeIgnoreSteps(RppPlaceholders,List<AbstractStep>,RppDebug)", 222).add(n3)).add(" steps removed, starting from ")).add(i2)).log();
                }
                for (int i3 = 0; i3 < n3 && i2 < list.size(); ++i3) {
                    list.remove(i2);
                    rppPlaceholders.removeStep(i2);
                }
                --i2;
            } else {
                stringBuilder.append("(").append(n2).append(") ").append(string);
            }
            rppDebug.updateNameAndPopLog(stringBuilder.toString());
            ++n2;
        }
        rppDebug.popLog();
        rppDebug.logSteps("Steps after removing 'Ignore steps'", list);
    }

    private String pruneComment(String string) {
        if (ProcedureCallRecordingProcessor.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "pruneComment(String)", 255).addDetail("comment", string)).log();
        }
        if (!Misc.emptyOrNull((String)string)) {
            String string2;
            String string3 = Util.getDoctag((String)string, (String)"scope");
            if (string3 != null) {
                if (string3.contains("<no_") || string3.equals("noscope")) {
                    string = string.replaceAll("@scope .*\n?", "@noscope\n");
                } else if (string3.equals(this.previousScope)) {
                    string = Util.stripDoctags((String)string, (String)"scope");
                } else {
                    this.previousScope = string3;
                }
            }
            if (Options.cached_OPT_RECORDING_PROCESSOR_ADD_VSCOPE_ONCE && (string2 = Util.getDoctag((String)string, (String)"vscope")) != null) {
                if (string2.equals(this.previousVscope)) {
                    string = Util.stripDoctags((String)string, (String)"vscope");
                } else {
                    this.previousVscope = string2;
                }
            }
        }
        return string;
    }
}

