/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.log.AbstractStepLog;
import de.qfs.apps.qftest.log.BasicSequenceLog;
import de.qfs.apps.qftest.log.DefinitionStepLog;
import de.qfs.apps.qftest.log.MessageLog;
import de.qfs.apps.qftest.log.StepLog;
import de.qfs.apps.qftest.log.recording.a;
import de.qfs.apps.qftest.record.procbuilder.RppDebugEvent;
import de.qfs.apps.qftest.record.procbuilder.RppDebugGroup;
import de.qfs.apps.qftest.shared.data.ClientData;
import de.qfs.apps.qftest.shared.data.ElementInfo;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.step.AbstractStep;
import de.qfs.apps.qftest.step.BasicSequence;
import de.qfs.apps.qftest.step.CommentStep;
import de.qfs.apps.qftest.step.DefinitionStep;
import de.qfs.apps.qftest.suite.Suite;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RppDebug {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.RppDebug");
    private final Suite currentSuite;
    private final a recordingLog;
    private final List logStack = new ArrayList();

    public RppDebug(Suite suite, a a2) {
        this.currentSuite = suite;
        this.recordingLog = a2;
        this.pushSequenceLog("Procedure Call Recording debug information");
    }

    public void logInvalidDefinition(String string, DefinitionStep definitionStep, Suite suite) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "logInvalidDefinition(String,DefinitionStep,Suite)", 75).addDetail("message", string)).addDetail("defStep", (Object)definitionStep)).addDetail("suite", (Object)suite)).log();
        }
        this.logMessage("msg.plain", new String[]{"Invalid data in definition step: " + string}, 2);
        DefinitionStepLog definitionStepLog = (DefinitionStepLog)StepLog.makeLog(definitionStep, suite);
        definitionStepLog.b(string);
        this.addLog(definitionStepLog);
    }

    public void logMessage(String string, String[] stringArray, int n2) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "logMessage(String,String[],int)", 86).addDetail("resourceName", string)).addDetail("args", (Object)stringArray)).addDetail("state", n2)).log();
        }
        MessageLog messageLog = new MessageLog(string, stringArray);
        messageLog.setState(n2);
        this.addLog(messageLog);
    }

    public void logSteps(String string, List list) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "logSteps(String,List<AbstractStep>)", 96).addDetail("sequenceName", string)).addDetail("steps", (Object)list)).log();
        }
        this.pushSequenceLog(string);
        for (AbstractStep abstractStep : list) {
            this.addLog(StepLog.makeLog(abstractStep, this.currentSuite));
        }
        this.popLog();
    }

    public void logStep(AbstractStep abstractStep) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "logStep(AbstractStep)", 108).addDetail("step", (Object)abstractStep)).log();
        }
        this.addLog(StepLog.makeLog(abstractStep, this.currentSuite));
    }

    public void logStep(AbstractStep abstractStep, String string) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "logStep(AbstractStep,String)", 116).addDetail("step", (Object)abstractStep)).addDetail("message", string)).log();
        }
        StepLog stepLog = StepLog.makeLog(abstractStep, this.currentSuite);
        stepLog.setAnnotation(string);
        this.addLog(stepLog);
    }

    void logDebugStep(AbstractStep abstractStep, RppDebugEvent rppDebugEvent) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "logDebugStep(AbstractStep,RppDebugEvent)", 126).addDetail("step", (Object)abstractStep)).addDetail("debugEvent", (Object)rppDebugEvent)).log();
        }
        if (abstractStep == null || rppDebugEvent == null) {
            return;
        }
        AbstractStep abstractStep2 = (AbstractStep)abstractStep.cloneNode();
        RppDebugEvent rppDebugEvent2 = (RppDebugEvent)rppDebugEvent.getRecordedSteps().get(rppDebugEvent.getRecordedSteps().size() - 1);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = rppDebugEvent2.isMatch();
        int n2 = rppDebugEvent.getRepeatExpected().getCurrRepeat();
        if (bl2) {
            if (n2 > 1) {
                stringBuilder.append("Node matches the event definition (repetition ").append(n2).append(")");
            } else {
                stringBuilder.append("Node matches");
            }
        } else if (rppDebugEvent.getRepeatExpected().getMax() > 1) {
            stringBuilder.append("The event is not part of the repeat series of the current event definition");
        } else {
            stringBuilder.append("Node does not match");
        }
        stringBuilder.append(" - Recording post processor debug info:\n");
        rppDebugEvent.writeMatchInfo(rppDebugEvent2, stringBuilder);
        if (!bl2) {
            abstractStep2.setDisabled(true);
        }
        this.logStep(abstractStep2, stringBuilder.toString());
    }

    public void pushSequenceLog(String string) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "pushSequenceLog(String)", 163).addDetail("name", string)).log();
        }
        BasicSequenceLog basicSequenceLog = (BasicSequenceLog)StepLog.makeLog(new BasicSequence(string), this.currentSuite);
        this.pushLog(basicSequenceLog);
    }

    public void logStepsWithDebugInfo(List list, ElementInfo[] elementInfoArray, ClientData[] clientDataArray, HashMap[] hashMapArray) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "logStepsWithDebugInfo(List<AbstractStep>,ElementInfo[],ClientData[],HashMap<String, String>[])", 172).addDetail("steps", (Object)list)).addDetail("allStepsInfo", (Object)elementInfoArray)).addDetail("allStepsData", (Object)clientDataArray)).addDetail("allStepsPlaceholders", (Object)hashMapArray)).log();
        }
        this.pushSequenceLog("Recorded steps with debug info");
        int n2 = 0;
        for (AbstractStep abstractStep : list) {
            this.pushLog(StepLog.makeLog(abstractStep, this.currentSuite));
            this.logMessage("msg.plain", new String[]{"@elementinfo\n" + elementInfoArray[n2].toString()}, 0);
            this.logMessage("msg.plain", new String[]{"@stepdata\n" + clientDataArray[n2].toString()}, 0);
            this.logMessage("msg.plain", new String[]{"@placeholders\n" + hashMapArray[n2].toString()}, 0);
            this.popLog();
            ++n2;
        }
        this.popLog();
    }

    public void logDefinitionWithDebugInfo(RppDebugGroup rppDebugGroup, String string, DefinitionStep definitionStep) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "logDefinitionWithDebugInfo(RppDebugGroup,String,DefinitionStep)", 192).addDetail("debugGroup", (Object)rppDebugGroup)).addDetail("entryName", string)).addDetail("definitionStep", (Object)definitionStep)).log();
        }
        DebugInfoWriter debugInfoWriter = new DebugInfoWriter();
        String string2 = debugInfoWriter.writeDebugInfo(string, this.currentSuite.getFileName(), rppDebugGroup);
        DefinitionStepLog definitionStepLog = (DefinitionStepLog)StepLog.makeLog(definitionStep, this.currentSuite);
        definitionStepLog.b(string2);
        this.addLog(definitionStepLog);
    }

    public DefinitionStepLog pushLogDefinitionStep(DefinitionStep definitionStep) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "pushLogDefinitionStep(DefinitionStep)", 204).addDetail("definitionStep", (Object)definitionStep)).log();
        }
        DefinitionStepLog definitionStepLog = (DefinitionStepLog)StepLog.makeLog(definitionStep, this.currentSuite);
        this.addLog(definitionStepLog);
        return definitionStepLog;
    }

    public void updateDebugInfoInDefinitionLog(RppDebugGroup rppDebugGroup, String string, DefinitionStepLog definitionStepLog) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "updateDebugInfoInDefinitionLog(RppDebugGroup,String,DefinitionStepLog)", 214).addDetail("debugGroup", (Object)rppDebugGroup)).addDetail("entryName", string)).addDetail("debugStep", (Object)definitionStepLog)).log();
        }
        DebugInfoWriter debugInfoWriter = new DebugInfoWriter();
        String string2 = debugInfoWriter.writeDebugInfo(string, this.currentSuite.getFileName(), rppDebugGroup);
        definitionStepLog.b(string2);
    }

    public void pushLog(StepLog stepLog) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "pushLog(StepLog)", 224).addDetail("log", (Object)stepLog)).log();
        }
        this.addLog(stepLog);
        this.logStack.add(stepLog);
    }

    public void popLog() {
        if (RppDebug.logger.level >= 7) {
            logger.lvlBuild(7, "popLog()", 233).log();
        }
        if (this.logStack.isEmpty()) {
            this.logStack.add(this.recordingLog.j());
        } else {
            this.logStack.remove(this.logStack.size() - 1);
        }
    }

    public void updateNameAndPopLog(String string) {
        StepLog stepLog;
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "updateNameAndPopLog(String)", 245).addDetail("name", string)).log();
        }
        if (!this.logStack.isEmpty() && (stepLog = (StepLog)this.logStack.get(this.logStack.size() - 1)) instanceof AbstractStepLog) {
            AbstractStepLog abstractStepLog = (AbstractStepLog)stepLog;
            abstractStepLog.getStep().setAttribute(AbstractStepLog.NAME, string);
        }
        this.popLog();
    }

    public void addCommentStep(String string) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addCommentStep(String)", 261).addDetail("message", string)).log();
        }
        CommentStep commentStep = new CommentStep();
        commentStep.a(string);
        this.logStep(commentStep);
    }

    public void addLog(StepLog stepLog) {
        StepLog stepLog2;
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addLog(StepLog)", 273).addDetail("log", (Object)stepLog)).log();
        }
        if (this.logStack.isEmpty()) {
            this.logStack.add(this.recordingLog.j());
        }
        if ((stepLog2 = (StepLog)this.logStack.get(this.logStack.size() - 1)) != null) {
            this.addLog(stepLog, stepLog2);
        }
    }

    private void addLog(StepLog stepLog, StepLog stepLog2) {
        if (RppDebug.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addLog(StepLog,StepLog)", 290).addDetail("log", (Object)stepLog)).addDetail("parent", (Object)stepLog2)).log();
        }
        if (Options.cached_OPT_RECORDING_PROCESSOR_LOGLEVEL < 10) {
            return;
        }
        StepLog stepLog3 = stepLog;
        SwingUtil.invokeAndWait(() -> this.recordingLog.addNode((Object)stepLog2, stepLog3, false));
    }

    public Suite getCurrentSuite() {
        if (RppDebug.logger.level >= 7) {
            logger.lvlBuild(7, "getCurrentSuite()", 48).log();
        }
        return this.currentSuite;
    }

    private static final class DebugInfoWriter {
        private String debugInfo;

        private DebugInfoWriter() {
        }

        public String writeDebugInfo(String string, String string2, RppDebugGroup rppDebugGroup) {
            if (RppDebug.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DebugInfoWriter.writeDebugInfo(String,String,RppDebugGroup)", 307).addDetail("codeEntryName", string)).addDetail("suiteName", string2)).addDetail("debugGroup", (Object)rppDebugGroup)).log();
            }
            this.debugInfo = "";
            this.writeHeader(string, string2);
            this.writeGroup(1, rppDebugGroup);
            this.writeFooter();
            return this.debugInfo;
        }

        private void writeGroup(int n2, RppDebugGroup rppDebugGroup) {
            if (RppDebug.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DebugInfoWriter.writeGroup(int,RppDebugGroup)", 315).addDetail("indentLevel", n2)).addDetail("debugGroup", (Object)rppDebugGroup)).log();
            }
            if ("sequential group".equals(rppDebugGroup.getGroupType())) {
                this.writeSequentialGroup(n2, rppDebugGroup);
            } else {
                this.writeAnywhereGroup(n2, rppDebugGroup);
            }
        }

        private void writeSequentialGroup(int n2, RppDebugGroup rppDebugGroup) {
            if (RppDebug.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DebugInfoWriter.writeSequentialGroup(int,RppDebugGroup)", 324).addDetail("indentLevel", n2)).addDetail("debugGroup", (Object)rppDebugGroup)).log();
            }
            this.writeGroupHeader(rppDebugGroup, n2);
            for (RppDebugEvent rppDebugEvent : rppDebugGroup.getSteps()) {
                if (rppDebugEvent.subGroupIsEmpty()) {
                    for (RppDebugEvent rppDebugEvent2 : rppDebugEvent.getRecordedSteps()) {
                        this.writeEvent(rppDebugEvent, rppDebugEvent2, n2 + 1, false);
                        this.writeClass(rppDebugEvent, rppDebugEvent2, n2 + 2, false);
                        this.writeCondition(rppDebugEvent, rppDebugEvent2, n2 + 2, false);
                    }
                } else {
                    this.writeGroup(n2 + 1, rppDebugEvent.getSubGroup());
                }
                if (rppDebugEvent.subAnywhereGroupIsEmpty()) continue;
                this.writeAnywhereGroup(n2 + 2, rppDebugEvent.getAnywhereGroup());
            }
        }

        private void writeAnywhereGroup(int n2, RppDebugGroup rppDebugGroup) {
            if (RppDebug.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DebugInfoWriter.writeAnywhereGroup(int,RppDebugGroup)", 345).addDetail("indentLevel", n2)).addDetail("debugGroup", (Object)rppDebugGroup)).log();
            }
            this.writeGroupHeader(rppDebugGroup, n2);
            int n3 = -1;
            for (RppDebugEvent rppDebugEvent : rppDebugGroup.getSteps()) {
                int n4 = rppDebugEvent.getCurrInfoIndex();
                for (RppDebugEvent rppDebugEvent2 : rppDebugEvent.getRecordedSteps()) {
                    if (rppDebugEvent.subGroupIsEmpty()) {
                        boolean bl2 = n3 == n4;
                        int n5 = bl2 ? 1 : 0;
                        this.writeEvent(rppDebugEvent, rppDebugEvent2, n2 + 1 + n5, bl2);
                        this.writeClass(rppDebugEvent, rppDebugEvent2, n2 + 2 + n5, bl2);
                        this.writeCondition(rppDebugEvent, rppDebugEvent2, n2 + 2 + n5, bl2);
                    } else {
                        this.writeGroup(n2 + 1, rppDebugEvent.getSubGroup());
                    }
                    if (rppDebugEvent.subAnywhereGroupIsEmpty()) continue;
                    this.writeGroup(n2 + 2, rppDebugEvent.getAnywhereGroup());
                }
                n3 = n4;
            }
        }

        private void writeGroupHeader(RppDebugGroup rppDebugGroup, int n2) {
            if (RppDebug.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DebugInfoWriter.writeGroupHeader(RppDebugGroup,int)", 371).addDetail("debugGroup", (Object)rppDebugGroup)).addDetail("indentLevel", n2)).log();
            }
            String string = rppDebugGroup.getNumStepsProcessed() == 1 ? "1 step matches" : rppDebugGroup.getNumStepsProcessed() + " steps match";
            this.debugInfo = this.debugInfo + "<tr><td><b>" + this.getIndent(n2) + rppDebugGroup.getGroupType() + " group</b></td><td>" + string + "</td><td></td><td></td></tr>";
        }

        private void writeEvent(RppDebugEvent rppDebugEvent, RppDebugEvent rppDebugEvent2, int n2, boolean bl2) {
            Object object;
            if (RppDebug.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DebugInfoWriter.writeEvent(RppDebugEvent,RppDebugEvent,int,boolean)", 380).addDetail("debugEvent", (Object)rppDebugEvent)).addDetail("currEvent", (Object)rppDebugEvent2)).addDetail("indentLevel", n2)).addDetail("sameRecordedStep", bl2)).log();
            }
            String string = rppDebugEvent.getCheckTypeExpected() == null ? rppDebugEvent.getStepTypeExpected() : rppDebugEvent.getStepTypeExpected() + " - " + rppDebugEvent.getCheckTypeExpected();
            Object object2 = object = rppDebugEvent2.getCheckTypeExpected() == null ? rppDebugEvent2.getStepTypeExpected() : rppDebugEvent2.getStepTypeExpected() + " - " + rppDebugEvent2.getCheckTypeExpected();
            if (bl2) {
                object = "<i>" + (String)object + "</i>";
            }
            String string2 = rppDebugEvent2.isMatch() ? "match" : "no match";
            string2 = rppDebugEvent2.getRepeatInfo() == null ? string2 : rppDebugEvent2.getRepeatInfo();
            this.debugInfo = this.debugInfo + "<tr><td>" + this.getIndent(n2) + "Event</td><td>" + string2 + "</td><td>" + string + "</td><td>" + (String)object + "</td></tr>";
        }

        private void writeClass(RppDebugEvent rppDebugEvent, RppDebugEvent rppDebugEvent2, int n2, boolean bl2) {
            if (RppDebug.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DebugInfoWriter.writeClass(RppDebugEvent,RppDebugEvent,int,boolean)", 392).addDetail("debugEvent", (Object)rppDebugEvent)).addDetail("currEvent", (Object)rppDebugEvent2)).addDetail("indentLevel", n2)).addDetail("sameRecordedStep", bl2)).log();
            }
            if (rppDebugEvent2.getClassesExpected() != null) {
                Object object = rppDebugEvent2.getClassesExpected();
                if (bl2) {
                    object = "<i>" + (String)object + "</i>";
                }
                this.debugInfo = this.debugInfo + "<tr><td>" + this.getIndent(n2) + "Class</td><td></td><td>" + this.getIndent(1) + rppDebugEvent.getClassesExpected() + "</td><td>" + this.getIndent(1) + (String)object + "</td></tr>";
            }
        }

        private void writeCondition(RppDebugEvent rppDebugEvent, RppDebugEvent rppDebugEvent2, int n2, boolean bl2) {
            if (RppDebug.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DebugInfoWriter.writeCondition(RppDebugEvent,RppDebugEvent,int,boolean)", 406).addDetail("debugEvent", (Object)rppDebugEvent)).addDetail("currEvent", (Object)rppDebugEvent2)).addDetail("indentLevel", n2)).addDetail("sameRecordedStep", bl2)).log();
            }
            if (rppDebugEvent2.getConditionExpected() != null) {
                Object object = rppDebugEvent2.getConditionExpected().replace("<", "&lt;").replace(">", "&gt;");
                if (bl2) {
                    object = "<i>" + (String)object + "</i>";
                }
                this.debugInfo = this.debugInfo + "<tr><td>" + this.getIndent(n2) + "Condition</td><td></td><td>" + this.getIndent(1) + rppDebugEvent.getConditionExpected().replace("<", "&lt;").replace(">", "&gt;") + "</td><td>" + this.getIndent(1) + (String)object + "</td></tr>";
            }
        }

        private void writeFooter() {
            if (RppDebug.logger.level >= 7) {
                logger.lvlBuild(7, "DebugInfoWriter.writeFooter()", 420).log();
            }
            this.debugInfo = this.debugInfo + "</table>\n";
        }

        private void writeHeader(String string, String string2) {
            if (RppDebug.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DebugInfoWriter.writeHeader(String,String)", 425).addDetail("codeEntryName", string)).addDetail("suiteName", string2)).log();
            }
            this.debugInfo = "<h3>" + string + "</h3>\n<p>" + string2 + "</p>\n<table border=\"1\" cellspacing=\"0\" cellpadding=\"5\">\n";
            this.debugInfo = this.debugInfo + "<thead><th>Structure</th><th>Result</th><th>Expected step</th><th>Recorded step</th></thead>\n";
        }

        private String getIndent(int n2) {
            if (RppDebug.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "DebugInfoWriter.getIndent(int)", 433).addDetail("indentLevel", n2)).log();
            }
            int n3 = n2 * 3;
            return String.format("%" + n3 + "s", " ");
        }
    }
}

