/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.record.procbuilder.RppExtractStep;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholder;
import de.qfs.apps.qftest.shared.exceptions.ProcedureNotFoundException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.step.AbstractStep;
import de.qfs.apps.qftest.step.BasicSequence;
import de.qfs.apps.qftest.step.CatchSequence;
import de.qfs.apps.qftest.step.ComponentDependant;
import de.qfs.apps.qftest.step.DefinitionStep;
import de.qfs.apps.qftest.step.ElseSequence;
import de.qfs.apps.qftest.step.ElseifSequence;
import de.qfs.apps.qftest.step.FetchGeometryStep;
import de.qfs.apps.qftest.step.FetchIndexStep;
import de.qfs.apps.qftest.step.FetchTextStep;
import de.qfs.apps.qftest.step.FinallySequence;
import de.qfs.apps.qftest.step.IfSequence;
import de.qfs.apps.qftest.step.KeyEventStep;
import de.qfs.apps.qftest.step.LogMessageStep;
import de.qfs.apps.qftest.step.Package;
import de.qfs.apps.qftest.step.Procedure;
import de.qfs.apps.qftest.step.ProcedureCall;
import de.qfs.apps.qftest.step.RootStep;
import de.qfs.apps.qftest.step.ScriptStep;
import de.qfs.apps.qftest.step.SetGlobalStep;
import de.qfs.apps.qftest.step.ThrowStep;
import de.qfs.apps.qftest.step.TryStep;
import de.qfs.apps.qftest.suite.Suite;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RppExtractProcCallDef {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.RppExtractProcCallDef");
    private static final String RPP_OPTIONAL = "rpp_optional";
    private static final String RPP_OPTIONAL_START = "rpp_optional_start";
    private static final String RPP_OPTIONAL_END = "rpp_optional_end";
    static final String RPP_IGNORE = "rpp_ignore";
    private static final String RPP_IGNORE_START = "rpp_ignore_start";
    private static final String RPP_IGNORE_END = "rpp_ignore_end";
    static final String RPP_DUPLICATE = "rpp_duplicate";
    static final String RPP_PRIORITY = "rpp_priority";
    static final String RPP_SCOPE = "rpp_scope";
    private static final String DEFINITIONS_MODIFIED = "definitions modified";
    private static final String DEFINITIONS_DONE = "definitions done";
    private static final String ALL_EQUAL = "all equal";
    static final String KNOWN_PROCEDURES = "known procedures";
    private String indent = "\n";
    private final StringBuilder sbError = new StringBuilder();
    protected static Map knownProceduresList = new HashMap();
    private List optionalSteps = new ArrayList();
    private List extractedSteps;
    boolean ignore = false;
    boolean addExistingDefinitionsToResult = false;
    private int numberOfMandatorySteps = 0;
    private final Procedure procedure;
    private final Suite suite;
    String optionalStepsStartProcedure = null;

    protected RppExtractProcCallDef(Suite suite, Procedure procedure) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RppExtractProcCallDef(Suite,Procedure)", 195).addDetail("suite", (Object)suite)).addDetail("procedure", (Object)procedure)).log();
        }
        this.procedure = knownProceduresList.getOrDefault(procedure.getQualifiedName(false), procedure);
        this.suite = suite;
        this.addExistingDefinitionsToResult = !Options.cached_OPT_RECORDING_PROCESSOR_SKIP_EXISTING_DEFINITIONS;
    }

    public String toString() {
        return "Definition for: " + this.procedure.toString();
    }

    private String addProcedureNameToCode() {
        if (RppExtractProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "addProcedureNameToCode()", 214).log();
        }
        return this.procedure.getName() + ":";
    }

    private RppExtractStep handleIfOrTry(RppExtractStep rppExtractStep) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "handleIfOrTry(RppExtractStep)", 238).addDetail("inputStep", (Object)rppExtractStep)).log();
        }
        if (rppExtractStep.getGroup().isEmpty()) {
            return rppExtractStep;
        }
        RppExtractStep rppExtractStep2 = this.makeGroupWithBlocksOnly(rppExtractStep);
        RppExtractStep rppExtractStep3 = new RppExtractStep(null, rppExtractStep.getLevelOfIndentation(), rppExtractStep.isOptional());
        if (rppExtractStep2.getGroup().isEmpty()) {
            return rppExtractStep3;
        }
        if (ALL_EQUAL.equals(RppExtractProcCallDef.removeDuplicates(rppExtractStep2))) {
            rppExtractStep2.setGroupType(null);
            ((RppExtractStep)rppExtractStep2.getGroup().get(0)).setGroupType(null);
            return rppExtractStep2;
        }
        if (rppExtractStep2.getGroup().size() == 1) {
            if ("finally".equals(((RppExtractStep)rppExtractStep2.getGroup().get(0)).getGroupType())) {
                rppExtractStep3.addEntriesToGroup(rppExtractStep2);
            } else {
                rppExtractStep3.addEntriesAsOptional(rppExtractStep2);
                rppExtractStep3.setOptional(true);
            }
            return rppExtractStep3;
        }
        if (rppExtractStep2.optionalEntryExist()) {
            for (RppExtractStep rppExtractStep4 : rppExtractStep2.getGroup()) {
                if ("finally".equals(((RppExtractStep)rppExtractStep2.getGroup().get(0)).getGroupType())) {
                    rppExtractStep3.addEntriesToGroup(rppExtractStep4);
                    continue;
                }
                rppExtractStep3.addEntriesAsOptional(rppExtractStep4);
                rppExtractStep3.setOptional(true);
            }
            return rppExtractStep3;
        }
        return rppExtractStep2;
    }

    private static String removeDuplicates(RppExtractStep rppExtractStep) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeDuplicates(RppExtractStep)", 305).addDetail("choiceGroup", (Object)rppExtractStep)).log();
        }
        if (rppExtractStep.getGroup().size() <= 1) {
            return null;
        }
        List list = rppExtractStep.getGroup();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            for (int i3 = i2 + 1; i3 < list.size(); ++i3) {
                if (!((RppExtractStep)list.get(i2)).allGroupEntriesHaveEqualText((RppExtractStep)list.get(i3))) continue;
                ((RppExtractStep)list.get(i2)).setOptional(((RppExtractStep)list.get(i2)).isOptional() || ((RppExtractStep)list.get(i3)).isOptional());
                list.remove(i3);
                --i3;
            }
        }
        if (rppExtractStep.getGroup().size() == 1) {
            return ALL_EQUAL;
        }
        return null;
    }

    private RppExtractStep makeGroupWithBlocksOnly(RppExtractStep rppExtractStep) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "makeGroupWithBlocksOnly(RppExtractStep)", 366).addDetail("inputStep", (Object)rppExtractStep)).log();
        }
        RppExtractStep rppExtractStep2 = new RppExtractStep(null, rppExtractStep.getLevelOfIndentation() + 1, rppExtractStep.isOptional());
        RppExtractStep rppExtractStep3 = new RppExtractStep("choice group", rppExtractStep.getLevelOfIndentation(), rppExtractStep.isOptional());
        for (RppExtractStep rppExtractStep4 : rppExtractStep.getGroup()) {
            if ("else".equals(rppExtractStep4.getGroupType()) || "elseif".equals(rppExtractStep4.getGroupType()) || "catch".equals(rppExtractStep4.getGroupType()) || "finally".equals(rppExtractStep4.getGroupType())) {
                if (!rppExtractStep2.getGroup().isEmpty() && rppExtractStep2.getGroupType() == null) {
                    rppExtractStep2.setGroupType(rppExtractStep.getGroupType());
                    rppExtractStep3.addEntryToGroup(rppExtractStep2);
                }
                if (rppExtractStep4.getGroup().isEmpty()) continue;
                RppExtractStep rppExtractStep5 = new RppExtractStep(rppExtractStep4.getGroupType(), rppExtractStep.getLevelOfIndentation() + 1, rppExtractStep.isOptional());
                for (RppExtractStep rppExtractStep6 : rppExtractStep4.getGroup()) {
                    if ("if".equals(rppExtractStep6.getGroupType()) || "try".equals(rppExtractStep6.getGroupType())) {
                        rppExtractStep5.addEntryToGroupAsFlatAsPossible(this.handleIfOrTry(rppExtractStep6));
                        continue;
                    }
                    rppExtractStep5.addEntryToGroupAsFlatAsPossible(rppExtractStep6);
                }
                rppExtractStep3.addEntryToGroup(rppExtractStep5);
                continue;
            }
            if ("if".equals(rppExtractStep4.getGroupType()) || "try".equals(rppExtractStep4.getGroupType())) {
                rppExtractStep2.addEntryToGroupAsFlatAsPossible(this.handleIfOrTry(rppExtractStep4));
                continue;
            }
            rppExtractStep2.addEntryToGroupAsFlatAsPossible(rppExtractStep4);
        }
        if (!rppExtractStep2.getGroup().isEmpty() && rppExtractStep2.getGroupType() == null) {
            rppExtractStep2.setGroupType(rppExtractStep.getGroupType());
            rppExtractStep3.addEntryToGroup(rppExtractStep2);
        }
        if (rppExtractStep3.getGroup().size() > 1 && "try".equals(((RppExtractStep)rppExtractStep3.getGroup().get(0)).getGroupType())) {
            List list = rppExtractStep3.getGroup();
            for (int i2 = 1; i2 < list.size(); ++i2) {
                if (!"else".equals(((RppExtractStep)list.get(i2)).getGroupType())) continue;
                ((RppExtractStep)list.get(0)).addEntriesToGroup((RppExtractStep)list.get(i2));
                list.remove(i2);
                break;
            }
        }
        return rppExtractStep3;
    }

    private StringBuilder codeForPriority() {
        if (RppExtractProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "codeForPriority()", 436).log();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.numberOfMandatorySteps == 0) {
            stringBuilder.append("\n  Invalid definition because there are no mandatory steps!");
        }
        stringBuilder.append("\n  priority: ");
        String string = this.procedure.getDoctag(RPP_PRIORITY);
        if (string == null) {
            return stringBuilder.append(this.numberOfMandatorySteps * 10);
        }
        try {
            if (string.startsWith("+")) {
                return stringBuilder.append(this.numberOfMandatorySteps * 10 + Integer.parseInt(string.substring(1)));
            }
            if (string.startsWith("-")) {
                return stringBuilder.append(this.numberOfMandatorySteps * 10 - Integer.parseInt(string.substring(1)));
            }
            return stringBuilder.append(Integer.parseInt(string));
        }
        catch (Exception exception) {
            return stringBuilder.append(string).append("\n  Invalid priority in doctag. Allowed: [+|-]number");
        }
    }

    private StringBuilder writeCodeForSequence(RppExtractStep rppExtractStep) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "writeCodeForSequence(RppExtractStep)", 466).addDetail("extractedStuff", (Object)rppExtractStep)).log();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (rppExtractStep.getGroup().isEmpty()) {
            return stringBuilder;
        }
        String string = rppExtractStep.getIndentation();
        stringBuilder.append("\n").append(string).append("  ").append("sequential group").append(":").append("\n").append(string).append("    ").append("expected nodes").append(":");
        this.addCodeForGroup(rppExtractStep, stringBuilder);
        return stringBuilder;
    }

    private void addCodeForGroup(RppExtractStep rppExtractStep, StringBuilder stringBuilder) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addCodeForGroup(RppExtractStep,StringBuilder)", 486).addDetail("extractedStuff", (Object)rppExtractStep)).addDetail("sb", (Object)stringBuilder)).log();
        }
        for (RppExtractStep rppExtractStep2 : rppExtractStep.getGroup()) {
            if (rppExtractStep2.getGroup().isEmpty()) {
                stringBuilder.append((CharSequence)rppExtractStep2.getIndentedSbStep(rppExtractStep.getLevelOfIndentation()));
                if (rppExtractStep2.isOptional()) continue;
                ++this.numberOfMandatorySteps;
                continue;
            }
            if ("if".equals(rppExtractStep2.getGroupType()) || "try".equals(rppExtractStep2.getGroupType())) {
                RppExtractStep rppExtractStep3 = this.handleIfOrTry(rppExtractStep2);
                if (rppExtractStep.isOptional()) {
                    rppExtractStep3.setOptional(true);
                }
                this.appendCodeForChoiceGroup(rppExtractStep3, stringBuilder);
                continue;
            }
            if (rppExtractStep2.getGroupType() != null && RppExtractProcCallDef.logger.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "addCodeForGroup(RppExtractStep,StringBuilder)", 508).add("Group entries for ")).add(rppExtractStep2.getGroupType())).add(" will be handled like the entries of a sequential group.")).log();
            }
            rppExtractStep2.setLevelOfIndentation(rppExtractStep.getLevelOfIndentation());
            this.addCodeForGroup(rppExtractStep2, stringBuilder);
        }
    }

    private void appendCodeForChoiceGroup(RppExtractStep rppExtractStep, StringBuilder stringBuilder) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "appendCodeForChoiceGroup(RppExtractStep,StringBuilder)", 526).addDetail("choiceGroup", (Object)rppExtractStep)).addDetail("sb", (Object)stringBuilder)).log();
        }
        if (rppExtractStep.isOptional()) {
            for (RppExtractStep rppExtractStep2 : rppExtractStep.getGroup()) {
                rppExtractStep2.setLevelOfIndentation(rppExtractStep.getLevelOfIndentation());
                stringBuilder.append((CharSequence)rppExtractStep2.getCodeForOptionalStep());
            }
            return;
        }
        if (rppExtractStep.getGroupType() == null) {
            this.addCodeForGroup(rppExtractStep, stringBuilder);
            return;
        }
        if (rppExtractStep.getGroup().size() < 2 && RppExtractProcCallDef.logger.level >= 1) {
            ((LevelAwareLogBuilder)logger.lvlBuild(1, "appendCodeForChoiceGroup(RppExtractStep,StringBuilder)", 546).add("The given choiceGroup must always have at least two subgroups, otherwise something went wrong in handleIfOrTry().")).log();
        }
        String string = rppExtractStep.getIndentation();
        stringBuilder.append("\n").append(string).append("    ").append("- ").append("choice group").append(":").append("\n").append(string).append("        ").append("expected nodes").append(":");
        for (RppExtractStep rppExtractStep3 : rppExtractStep.getGroup()) {
            if (rppExtractStep3.getGroup().size() == 1) {
                RppExtractStep rppExtractStep4 = (RppExtractStep)rppExtractStep3.getGroup().get(0);
                if ("choice group".equals(rppExtractStep4.getGroupType())) {
                    rppExtractStep4.setLevelOfIndentation(rppExtractStep.getLevelOfIndentation() + 1);
                    this.appendCodeForChoiceGroup(rppExtractStep4, stringBuilder);
                    continue;
                }
                stringBuilder.append((CharSequence)rppExtractStep4.getIndentedSbStep(rppExtractStep.getLevelOfIndentation() + 1));
                if (rppExtractStep4.isOptional()) continue;
                ++this.numberOfMandatorySteps;
                continue;
            }
            rppExtractStep3.setLevelOfIndentation(rppExtractStep.getLevelOfIndentation() + 1);
            string = rppExtractStep3.getIndentation();
            stringBuilder.append("\n").append(string).append("    ").append("- ").append("sequential group").append(":").append("\n").append(string).append("        ").append("expected nodes").append(":");
            for (RppExtractStep rppExtractStep5 : rppExtractStep3.getGroup()) {
                rppExtractStep5.setLevelOfIndentation(rppExtractStep.getLevelOfIndentation() + 2);
                if ("choice group".equals(rppExtractStep5.getGroupType())) {
                    this.appendCodeForChoiceGroup(rppExtractStep5, stringBuilder);
                    continue;
                }
                stringBuilder.append((CharSequence)rppExtractStep5.getIndentedSbStep(rppExtractStep5.getLevelOfIndentation()));
                if (rppExtractStep5.isOptional()) continue;
                ++this.numberOfMandatorySteps;
            }
        }
    }

    @Nullable
    public DefinitionStep extract(boolean bl2, Map map) {
        StringBuilder stringBuilder;
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "extract(boolean,Map<String, String>)", 596).addDetail("setKnownProcedures", bl2)).addDetail("docTags", (Object)map)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("docTags is marked non-null but is null");
        }
        if (Misc.emptyOrNull((Collection)this.procedure.getSteps()) || this.ignoreStepByKindAndDoctag(this.procedure)) {
            if (RppExtractProcCallDef.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "extract(boolean,Map<String, String>)", 600).add("Empty procedure or to be ignored", (Object)this.procedure)).log();
            }
            return null;
        }
        DefinitionStep definitionStep = new DefinitionStep();
        if (this.addExistingDefinitionsToResult && (definitionStep = this.findExistingDefinition()).q() != null) {
            return definitionStep;
        }
        String string = this.procedure.getQualifiedName(false);
        if (string.startsWith(KNOWN_PROCEDURES)) {
            definitionStep.setComment("The definition is based on the procedure '" + string + "'");
            string = string.split(KNOWN_PROCEDURES)[1].substring(1);
        }
        definitionStep.e(string);
        definitionStep.b("jython");
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(this.addProcedureNameToCode());
        this.indent = "\n";
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        RppExtractStep rppExtractStep = this.extractSteps(this.suite, this.procedure, false, this.addProcedureParametersToHierarchy(this.procedure), arrayList, map, arrayList2);
        this.sbError.append((CharSequence)rppExtractStep.getSbError());
        if (!Misc.emptyOrNull(arrayList2)) {
            stringBuilder = new StringBuilder("Known procedures used for the definition:");
            for (String string2 : arrayList2) {
                stringBuilder.append("\n").append(KNOWN_PROCEDURES).append(".").append(string2);
            }
            if (definitionStep.getComment() == null) {
                definitionStep.setComment(stringBuilder.toString());
            } else {
                definitionStep.setComment(definitionStep.getComment() + "\n\n" + String.valueOf(stringBuilder));
            }
        }
        if (rppExtractStep.getGroup().isEmpty()) {
            stringBuilder2.append("\n  Invalid definition because there are no mandatory steps in the procedure");
            definitionStep.setDisabled(true);
        }
        stringBuilder = this.writeCodeForSequence(rppExtractStep);
        if (!this.sbError.isEmpty()) {
            stringBuilder2.append("\n------------- error  --------------").append((CharSequence)this.sbError);
        }
        stringBuilder2.append((CharSequence)this.codeForPriority());
        stringBuilder2.append((CharSequence)stringBuilder);
        definitionStep.g_(stringBuilder2.toString());
        return definitionStep;
    }

    private RppExtractStep extractSteps(Suite suite, BasicSequence basicSequence, boolean bl2, @Nullable String[][] stringArray, List list, Map map, List list2) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "extractSteps(Suite,BasicSequence,boolean,String[][],List<String>,Map<String, String>,List<String>)", 678).addDetail("sequenceSuite", (Object)suite)).addDetail("sequence", (Object)basicSequence)).addDetail("optionalStep", bl2)).addDetail("parameters", (Object)stringArray)).addDetail("parentProcedureCalls", (Object)list)).addDetail("doctags", (Object)map)).addDetail("knownProceduresUsed", (Object)list2)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("doctags is marked non-null but is null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("knownProceduresUsed is marked non-null but is null");
        }
        RppExtractStep rppExtractStep = new RppExtractStep(null, 0, false);
        List list3 = this.removeIgnoreSteps(basicSequence);
        if (list3 == null) {
            return rppExtractStep;
        }
        for (AbstractStep abstractStep : list3) {
            boolean bl3;
            this.setOptionalStepsStartProcedure(bl2, list, abstractStep);
            String string = RppExtractProcCallDef.addDoctags(map, abstractStep);
            boolean bl4 = this.determineLocalOptionalStep(bl2, abstractStep);
            boolean bl5 = bl3 = bl2 || this.isOptionalScope() || bl4;
            if (abstractStep instanceof BasicSequence) {
                BasicSequence basicSequence2 = (BasicSequence)abstractStep;
                if (abstractStep instanceof IfSequence || abstractStep instanceof TryStep) {
                    var17_17 = this.extractSteps(suite, basicSequence2, false, stringArray, list, map, list2);
                    ((RppExtractStep)var17_17).setOptional(bl3);
                    if (abstractStep instanceof IfSequence) {
                        ((RppExtractStep)var17_17).setGroupType("if");
                    } else {
                        ((RppExtractStep)var17_17).setGroupType("try");
                    }
                    rppExtractStep.addEntryToGroup((RppExtractStep)var17_17);
                } else if (abstractStep instanceof ElseifSequence || abstractStep instanceof ElseSequence || abstractStep instanceof FinallySequence || abstractStep instanceof CatchSequence) {
                    var17_17 = this.extractSteps(suite, basicSequence2, false, stringArray, list, map, list2);
                    ((RppExtractStep)var17_17).setOptional(bl3);
                    if (abstractStep instanceof ElseSequence) {
                        ((RppExtractStep)var17_17).setGroupType("else");
                    } else if (abstractStep instanceof ElseifSequence) {
                        ((RppExtractStep)var17_17).setGroupType("elseif");
                    } else if (abstractStep instanceof CatchSequence) {
                        ((RppExtractStep)var17_17).setGroupType("catch");
                    } else {
                        ((RppExtractStep)var17_17).setGroupType("finally");
                    }
                    rppExtractStep.addEntryToGroup((RppExtractStep)var17_17);
                } else {
                    var17_17 = this.extractSteps(suite, basicSequence2, bl2 || bl4, stringArray, list, map, list2);
                    ((RppExtractStep)var17_17).setOptional(bl3);
                    rppExtractStep.addEntriesToGroup((RppExtractStep)var17_17);
                }
            } else if (abstractStep instanceof ProcedureCall) {
                ProcedureCall procedureCall = (ProcedureCall)abstractStep;
                var17_17 = procedureCall.getName();
                if (!"qfs.swing.cleanup.closeAllMenus".equals(var17_17) && !this.isRecursiveCall(list, (String)var17_17)) {
                    Object object;
                    Suite suite2;
                    AbstractStep abstractStep2;
                    if (knownProceduresList.containsKey(var17_17)) {
                        abstractStep2 = (AbstractStep)knownProceduresList.get(var17_17);
                        suite2 = this.suite;
                        if (!list2.contains(var17_17)) {
                            list2.add(var17_17);
                        }
                    } else {
                        object = new Suite[1];
                        abstractStep2 = suite.locateCallable((String)var17_17, (Suite[])object, "procedure");
                        Suite suite3 = suite2 = object[0] == null ? suite : object[0];
                    }
                    if (abstractStep2 instanceof Procedure) {
                        object = (Procedure)abstractStep2;
                        list.add(var17_17);
                        RppExtractStep rppExtractStep2 = this.extractSteps(suite2, (BasicSequence)object, bl2 || bl4, RppExtractProcCallDef.passRelevantVariables(procedureCall, stringArray), list, map, list2);
                        rppExtractStep2.setOptional(bl3);
                        rppExtractStep.addEntriesToGroup(rppExtractStep2);
                        this.maybeClearOptionalStepsStartProcedure(list);
                        list.remove(list.size() - 1);
                    }
                }
            } else if (abstractStep instanceof ComponentDependant) {
                var17_17 = new RppExtractStep(this.suite, stringArray, abstractStep, map);
                rppExtractStep.getSbError().append((CharSequence)((RppExtractStep)var17_17).getSbError());
                if (!((RppExtractStep)var17_17).isOptional()) {
                    ((RppExtractStep)var17_17).setOptional(bl3);
                }
                rppExtractStep.addEntryToGroup((RppExtractStep)var17_17);
            }
            if (!bl2 && this.isOptionalScope() && this.endOfLocalOptionalScope(abstractStep)) {
                this.optionalStepsStartProcedure = null;
            }
            map.put(RPP_SCOPE, string);
        }
        return rppExtractStep;
    }

    static String addDoctags(Map map, AbstractStep abstractStep) {
        String string;
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addDoctags(Map<String, String>,AbstractStep)", 802).addDetail("doctags", (Object)map)).addDetail("step", (Object)abstractStep)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("doctags is marked non-null but is null");
        }
        String string2 = null;
        if (map.containsKey(RPP_SCOPE)) {
            string2 = (String)map.get(RPP_SCOPE);
        }
        if (abstractStep != null && abstractStep.getComment() != null && (string = abstractStep.getDoctag(RPP_SCOPE)) != null) {
            map.put(RPP_SCOPE, string);
        }
        return string2;
    }

    private boolean determineLocalOptionalStep(boolean bl2, AbstractStep abstractStep) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "determineLocalOptionalStep(boolean,AbstractStep)", 826).addDetail("optionalStep", bl2)).addDetail("abstractStep", (Object)abstractStep)).log();
        }
        return !bl2 && !this.isOptionalScope() && abstractStep.getDoctag(RPP_OPTIONAL) != null;
    }

    private List cloneStepList(List list) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "cloneStepList(List<Map<String, String>>)", 834).addDetail("originalList", (Object)list)).log();
        }
        ArrayList arrayList = new ArrayList();
        for (Map map : list) {
            HashMap hashMap = new HashMap(map);
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private boolean isOptionalScope() {
        if (RppExtractProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "isOptionalScope()", 844).log();
        }
        return this.optionalStepsStartProcedure != null;
    }

    private void setOptionalStepsStartProcedure(boolean bl2, List list, AbstractStep abstractStep) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setOptionalStepsStartProcedure(boolean,List<String>,AbstractStep)", 851).addDetail("isOptionalStep", bl2)).addDetail("parentProcedureCalls", (Object)list)).addDetail("abstractStep", (Object)abstractStep)).log();
        }
        if (!bl2 && abstractStep.getDoctag(RPP_OPTIONAL_START) != null && !this.isOptionalScope()) {
            this.optionalStepsStartProcedure = Misc.emptyOrNull((Collection)list) ? "" : (String)list.get(list.size() - 1);
        }
    }

    private void maybeClearOptionalStepsStartProcedure(List list) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "maybeClearOptionalStepsStartProcedure(List<String>)", 872).addDetail("parentProcedureCalls", (Object)list)).log();
        }
        if (this.optionalStepsStartProcedure != null && this.optionalStepsStartProcedure.equals(list.get(list.size() - 1))) {
            this.optionalStepsStartProcedure = null;
            this.reduceIndent();
        }
    }

    private void reduceIndent() {
        if (RppExtractProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "reduceIndent()", 884).log();
        }
        if (this.indent.length() >= 5) {
            this.indent = this.indent.substring(0, this.indent.length() - 4);
        } else if (RppExtractProcCallDef.logger.level >= 3) {
            ((LevelAwareLogBuilder)logger.lvlBuild(3, "reduceIndent()", 890).add("Indentation cannot be reduced!")).log();
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private String[][] addProcedureParametersToHierarchy(Procedure var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:68)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIter.rewriteExpressions(StructuredIter.java:119)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean equalSteps(Map map, Map map2) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "equalSteps(Map<String, String>,Map<String, String>)", 926).addDetail("node1", (Object)map)).addDetail("node2", (Object)map2)).log();
        }
        if (map.isEmpty() || map.size() != map2.size()) {
            return false;
        }
        for (String string : map.keySet()) {
            if (!map2.containsKey(string)) {
                return false;
            }
            if (((String)map.get(string)).equals(map2.get(string))) continue;
            return false;
        }
        return true;
    }

    private boolean isRecursiveCall(List list, String string) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "isRecursiveCall(List<String>,String)", 952).addDetail("parentProcedures", (Object)list)).addDetail("procedureName", string)).log();
        }
        if (Misc.emptyOrNull((Collection)list)) {
            return false;
        }
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private List removeIgnoreSteps(BasicSequence basicSequence) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeIgnoreSteps(BasicSequence)", 975).addDetail("sequence", (Object)basicSequence)).log();
        }
        if (Misc.emptyOrNull((Collection)basicSequence.getSteps()) || this.ignoreStepByKindAndDoctag(basicSequence)) {
            return null;
        }
        ArrayList<AbstractStep> arrayList = new ArrayList<AbstractStep>();
        for (Object e2 : basicSequence.getSteps()) {
            if (e2 instanceof AbstractStep) {
                AbstractStep abstractStep = (AbstractStep)e2;
                if (this.ignoreStepByKindAndDoctag(abstractStep)) continue;
                arrayList.add(abstractStep);
                continue;
            }
            this.sbError.append("\nThe procedure contains children which are no AbstractStep!");
        }
        return arrayList;
    }

    private boolean ignoreStepByKindAndDoctag(AbstractStep abstractStep) {
        KeyEventStep keyEventStep;
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "ignoreStepByKindAndDoctag(AbstractStep)", 1005).addDetail("step", (Object)abstractStep)).log();
        }
        if (abstractStep.isDisabled() || abstractStep instanceof ScriptStep || abstractStep instanceof SetGlobalStep || abstractStep instanceof LogMessageStep || abstractStep instanceof FetchTextStep || abstractStep instanceof FetchIndexStep || abstractStep instanceof FetchGeometryStep || abstractStep instanceof ThrowStep) {
            return true;
        }
        if (abstractStep instanceof KeyEventStep && (keyEventStep = (KeyEventStep)abstractStep).k().equals("9")) {
            return true;
        }
        if (abstractStep.getDoctag(RPP_IGNORE) != null) {
            return true;
        }
        if (this.ignore) {
            if (abstractStep.getDoctag(RPP_IGNORE_END) != null) {
                this.ignore = false;
            }
            return true;
        }
        if (abstractStep.getDoctag(RPP_IGNORE_START) != null) {
            this.ignore = true;
            return true;
        }
        return false;
    }

    private boolean endOfLocalOptionalScope(AbstractStep abstractStep) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "endOfLocalOptionalScope(AbstractStep)", 1099).addDetail("step", (Object)abstractStep)).log();
        }
        return abstractStep.getDoctag(RPP_OPTIONAL_END) != null;
    }

    private static String[][] passRelevantVariables(ProcedureCall procedureCall, @Nullable String[][] stringArray) {
        String[][] stringArray2;
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "passRelevantVariables(ProcedureCall,String[][])", 1135).addDetail("procedureCall", (Object)procedureCall)).addDetail("parameters", (Object)stringArray)).log();
        }
        if (Misc.emptyOrNull((Object[])(stringArray2 = procedureCall.getVariables()))) {
            return stringArray;
        }
        Map map = RppExtractProcCallDef.removeDuplicates(stringArray2);
        map.replaceAll((string, string2) -> RppPlaceholder.removeDefaultIdGroup((String)map.get(string)));
        if (stringArray != null) {
            for (Object object : stringArray) {
                boolean bl2 = false;
                for (String string3 : map.keySet()) {
                    if (!((String)map.get(string3)).equals("$(" + object[0] + ")")) continue;
                    map.put(string3, object[1]);
                    bl2 = true;
                }
                if (bl2 || map.containsKey(object[0])) continue;
                map.put(object[0], object[1]);
            }
        }
        String[][] stringArray3 = new String[map.size()][2];
        int n2 = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            stringArray3[n2][0] = object = (String)iterator.next();
            stringArray3[n2][1] = (String)map.get(object);
            ++n2;
        }
        return stringArray3;
    }

    private static Map removeDuplicates(String[][] stringArray) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeDuplicates(String[][])", 1185).addDetail("vars", (Object)stringArray)).log();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringArray != null) {
            for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                String string;
                if (stringArray[i2] == null || stringArray[i2].length < 2 || stringArray[i2][0] == null || hashMap.containsKey(string = stringArray[i2][0])) continue;
                String string2 = stringArray[i2][1] == null ? "" : stringArray[i2][1];
                hashMap.put(string, string2);
            }
        }
        return hashMap;
    }

    private static boolean containsAVariable(@Nullable String string) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "containsAVariable(String)", 1209).addDetail("placeholder", string)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return false;
        }
        return string.contains("$(") && string.substring(string.indexOf("$(")).contains(")");
    }

    private DefinitionStep findExistingDefinition() {
        if (RppExtractProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "findExistingDefinition()", 1221).log();
        }
        DefinitionStep definitionStep = new DefinitionStep();
        Object object = this.suite.getRoot();
        if (object instanceof RootStep) {
            Package package_;
            RootStep rootStep = (RootStep)object;
            try {
                package_ = rootStep.getProcedures().findPackage(DEFINITIONS_MODIFIED);
                definitionStep = RppExtractProcCallDef.findDefinitionInPackage(package_, this.procedure.getQualifiedName(false));
            }
            catch (ProcedureNotFoundException procedureNotFoundException) {
                // empty catch block
            }
            if (definitionStep != null && definitionStep.q() != null) {
                return definitionStep;
            }
            try {
                package_ = rootStep.getProcedures().findPackage(DEFINITIONS_DONE);
                definitionStep = RppExtractProcCallDef.findDefinitionInPackage(package_, this.procedure.getQualifiedName(false));
            }
            catch (ProcedureNotFoundException procedureNotFoundException) {
                // empty catch block
            }
            if (definitionStep != null) {
                return definitionStep;
            }
        }
        return new DefinitionStep();
    }

    private static DefinitionStep findDefinitionInPackage(Package package_, String string) {
        List list;
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "findDefinitionInPackage(Package,String)", 1249).addDetail("packageDone", (Object)package_)).addDetail("definitionName", string)).log();
        }
        if ((list = package_.getSteps()) == null) {
            return null;
        }
        for (Object e2 : list) {
            DefinitionStep definitionStep;
            if (e2 instanceof Package) {
                DefinitionStep definitionStep2;
                if (((Package)e2).isDisabled() || (definitionStep2 = RppExtractProcCallDef.findDefinitionInPackage((Package)e2, string)) == null) continue;
                return definitionStep2;
            }
            if (!(e2 instanceof DefinitionStep) || (definitionStep = (DefinitionStep)e2).isDisabled() || !string.equals(definitionStep.q())) continue;
            return definitionStep.l();
        }
        return null;
    }

    protected static Package extractAll(Suite suite, Package package_, boolean bl2, Map map) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "extractAll(Suite,Package,boolean,Map<String, String>)", 1282).addDetail("suite", (Object)suite)).addDetail("pck", (Object)package_)).addDetail("setKnownProcedures", bl2)).addDetail("doctags", (Object)map)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("doctags is marked non-null but is null");
        }
        Package package_2 = new Package(package_.getName());
        if (package_.getDoctag(RPP_IGNORE) != null || package_.getDoctag(RPP_DUPLICATE) != null || package_.isDisabled() || package_.getSteps() == null || DEFINITIONS_MODIFIED.equals(package_.getName()) || DEFINITIONS_DONE.equals(package_.getName())) {
            return package_2;
        }
        for (Object e2 : package_.getSteps()) {
            Package package_3;
            Object object;
            if (!(e2 instanceof AbstractStep)) continue;
            AbstractStep abstractStep = (AbstractStep)e2;
            String string = RppExtractProcCallDef.addDoctags(map, abstractStep);
            if (abstractStep.getDoctag(RPP_IGNORE) != null || abstractStep.getDoctag(RPP_DUPLICATE) != null || abstractStep.isDisabled() || DEFINITIONS_MODIFIED.equals(abstractStep.getName()) || DEFINITIONS_DONE.equals(abstractStep.getName())) continue;
            if (abstractStep instanceof Procedure) {
                Procedure procedure = (Procedure)abstractStep;
                object = new RppExtractProcCallDef(suite, procedure);
                DefinitionStep definitionStep = ((RppExtractProcCallDef)object).extract(bl2, map);
                if (definitionStep != null) {
                    package_2.add(definitionStep);
                }
            } else if (abstractStep instanceof Package && ((BasicSequence)(object = RppExtractProcCallDef.extractAll(suite, package_3 = (Package)abstractStep, bl2, map))).getChildCount() > 0) {
                package_2.add((AbstractStep)object);
            }
            map.put(RPP_SCOPE, string);
        }
        return package_2;
    }

    protected static void addKnownProcedures(Package package_) {
        if (RppExtractProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addKnownProcedures(Package)", 1324).addDetail("pck", (Object)package_)).log();
        }
        if (Misc.emptyOrNull((Object)package_) || Misc.emptyOrNull((Collection)package_.getSteps())) {
            return;
        }
        for (Object e2 : package_.getSteps()) {
            String[] stringArray;
            BasicSequence basicSequence;
            if (e2 instanceof Package) {
                basicSequence = (Package)e2;
                RppExtractProcCallDef.addKnownProcedures((Package)basicSequence);
            }
            if (!(e2 instanceof Procedure) || (stringArray = ((Procedure)(basicSequence = (Procedure)e2)).getQualifiedName(false).split("known procedures.")).length <= 1) continue;
            knownProceduresList.put(stringArray[1], basicSequence);
        }
    }

    private static /* synthetic */ String[][] lambda$addProcedureParametersToHierarchy$1(int n2) {
        return new String[n2][];
    }
}

