/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.record.procbuilder.RppCompIdData;
import de.qfs.apps.qftest.record.procbuilder.RppMetadataConfig;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholder;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholdersForStep;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.e;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.step.AbstractStep;
import de.qfs.apps.qftest.step.CheckStep;
import de.qfs.apps.qftest.step.CommentStep;
import de.qfs.apps.qftest.step.ComponentDependant;
import de.qfs.apps.qftest.step.ComponentWaiter;
import de.qfs.apps.qftest.step.MouseEventStep;
import de.qfs.apps.qftest.step.RethrowStep;
import de.qfs.apps.qftest.step.ReturnStep;
import de.qfs.apps.qftest.step.TextInputStep;
import de.qfs.apps.qftest.suite.Suite;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RppExtractStep {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.RppExtractStep");
    protected static final String RPP_PARAMETER = "rpp_parameter";
    private static final String RPP_ADD_STEP = "rpp_add_step";
    private static final String RPP_COMPONENT_ID = "rpp_component_id";
    private static final String RPP_ANY = "any";
    private static final String RPP_COMPONENT_CLASS = "rpp_component_class";
    private static final String RPP_COMPONENT_NAME = "rpp_component_name";
    protected static final String IF_BLOCK = "if";
    protected static final String ELSE_BLOCK = "else";
    protected static final String ELSEIF_BLOCK = "elseif";
    protected static final String TRY_BLOCK = "try";
    protected static final String CATCH_BLOCK = "catch";
    protected static final String FINALLY_BLOCK = "finally";
    protected static final String STEP_ADD = "add";
    protected static final String STEP_IGNORE = "ignore";
    protected static final String STEP_OPTIONAL = "optional";
    static final String LINE_BREAK = "\n";
    static final String indent2 = "  ";
    static final String indent4 = "    ";
    static final String indent6 = "      ";
    static final String indent8 = "        ";
    private static final String indent10 = "          ";
    private static final String indent12 = "            ";
    protected static final Map classMappings = new HashMap();
    private final StringBuilder sbStep = new StringBuilder();
    private final StringBuilder sbStepNodeType = new StringBuilder();
    private final StringBuilder sbStepAttributes = new StringBuilder();
    private final StringBuilder sbStepComponent = new StringBuilder();
    private final StringBuilder sbStepComponentScope = new StringBuilder();
    private final StringBuilder sbStepSubIndexes = new StringBuilder();
    private final StringBuilder sbStepExtraFeatures = new StringBuilder();
    private final StringBuilder sbCondition = new StringBuilder();
    private final StringBuilder sbParameters = new StringBuilder();
    private final StringBuilder sbError = new StringBuilder();
    private final Map currentStep = new HashMap();
    private List group = new ArrayList();
    private String groupType;
    private boolean optional;
    private int levelOfIndentation = 0;

    protected RppExtractStep(String string, int n2, boolean bl2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RppExtractStep(String,int,boolean)", 218).addDetail("groupType", string)).addDetail("levelOfIndentation", n2)).addDetail(STEP_OPTIONAL, bl2)).log();
        }
        this.groupType = string;
        this.levelOfIndentation = n2;
        this.optional = bl2;
    }

    protected RppExtractStep(Suite suite, String[][] stringArray, AbstractStep abstractStep, Map map) {
        String string;
        boolean bl2;
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RppExtractStep(Suite,String[][],AbstractStep,Map<String, String>)", 227).addDetail("suite", (Object)suite)).addDetail("parameters", (Object)stringArray)).addDetail("abstractStep", (Object)abstractStep)).addDetail("docTags", (Object)map)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("docTags is marked non-null but is null");
        }
        this.addNodeClassAndTypeToCode(abstractStep, stringArray);
        RppPlaceholdersForStep rppPlaceholdersForStep = new RppPlaceholdersForStep(abstractStep, suite, stringArray);
        if (abstractStep instanceof ComponentDependant) {
            this.addComponentInfoToCode(rppPlaceholdersForStep, stringArray, map);
        }
        if (!(bl2 = STEP_ADD.equals(string = RppExtractStep.ignoreStepByInstanceAndClass(abstractStep, this.getMappedClass(rppPlaceholdersForStep)))) && STEP_OPTIONAL.equals(string)) {
            bl2 = true;
            this.optional = true;
        }
        if (bl2 && (abstractStep instanceof TextInputStep || abstractStep instanceof CheckStep)) {
            bl2 = abstractStep.getDoctag(RPP_ADD_STEP) != null;
            bl2 |= !Misc.emptyOrNull((Collection)Util.getDoctags((String)abstractStep.getComment(), (String)RPP_PARAMETER));
            bl2 |= this.variablesInRecordableAttributes(rppPlaceholdersForStep);
        }
        if (bl2) {
            this.addDoctagVariablesToParameterCode(abstractStep);
            this.addAttributesToStepCode(rppPlaceholdersForStep, abstractStep);
            this.completeSbStep();
        } else {
            this.sbStep.setLength(0);
            this.group.clear();
        }
    }

    private RppExtractStep(StringBuilder stringBuilder, String string, boolean bl2, int n2, StringBuilder stringBuilder2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RppExtractStep(StringBuilder,String,boolean,int,StringBuilder)", 278).addDetail("sbStep", (Object)stringBuilder)).addDetail("groupType", string)).addDetail(STEP_OPTIONAL, bl2)).addDetail("levelOfIndentation", n2)).addDetail("sbError", (Object)stringBuilder2)).log();
        }
        this.sbStep.append((CharSequence)stringBuilder);
        this.groupType = string;
        this.optional = bl2;
        this.levelOfIndentation = n2;
        this.sbError.append((CharSequence)stringBuilder2);
    }

    private String getMappedClass(RppPlaceholdersForStep rppPlaceholdersForStep) {
        String string;
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getMappedClass(RppPlaceholdersForStep)", 295).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).log();
        }
        if (classMappings.containsKey(string = rppPlaceholdersForStep.getPlaceholderValue("class"))) {
            string = (String)classMappings.get(string);
            rppPlaceholdersForStep.update("class", string);
        }
        return string;
    }

    private void initializeStepCode() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "initializeStepCode()", 307).log();
        }
        this.currentStep.clear();
        this.sbStep.setLength(0);
        this.sbStepNodeType.setLength(0);
        this.sbStepAttributes.setLength(0);
        this.sbStepSubIndexes.setLength(0);
        this.sbStepComponent.setLength(0);
        this.sbStepComponentScope.setLength(0);
        this.sbStepExtraFeatures.setLength(0);
        this.sbCondition.setLength(0);
        this.sbParameters.setLength(0);
        this.optional = false;
    }

    StringBuilder getIndentedSbStep(int n2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getIndentedSbStep(int)", 331).addDetail("levelOfIndentation", n2)).log();
        }
        if (this.optional) {
            this.levelOfIndentation = n2;
            return this.getCodeForOptionalStep();
        }
        StringBuilder stringBuilder = new StringBuilder(this.sbStep);
        if (n2 == 0) {
            return stringBuilder;
        }
        this.levelOfIndentation = n2;
        this.indentCode(stringBuilder);
        return stringBuilder;
    }

    private void indentCode(StringBuilder stringBuilder) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "indentCode(StringBuilder)", 350).addDetail("sb", (Object)stringBuilder)).log();
        }
        String string = this.getIndentation();
        int n2 = stringBuilder.indexOf(LINE_BREAK);
        while (n2 != -1) {
            stringBuilder.insert(n2 + 2, string);
            n2 = stringBuilder.indexOf(LINE_BREAK, n2 + 2);
        }
    }

    StringBuilder getCodeForOptionalStep() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "getCodeForOptionalStep()", 367).log();
        }
        StringBuilder stringBuilder = new StringBuilder(this.sbStep);
        if (!this.group.isEmpty()) {
            for (RppExtractStep rppExtractStep : this.group) {
                rppExtractStep.levelOfIndentation = this.levelOfIndentation;
                stringBuilder.append((CharSequence)rppExtractStep.getCodeForOptionalStep());
            }
            return stringBuilder;
        }
        if (this.levelOfIndentation != 0) {
            this.indentCode(stringBuilder);
        }
        String string = "\n        " + this.getIndentation();
        stringBuilder.append(string).append("repeat").append(":");
        stringBuilder.append(string).append(indent2).append("min").append(": 0");
        stringBuilder.append(string).append(indent2).append("max").append(": 1");
        return stringBuilder;
    }

    protected String getIndentation() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "getIndentation()", 391).log();
        }
        if (this.levelOfIndentation > 25) {
            if (RppExtractStep.logger.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getIndentation()", 394).add("level of indentation (")).add(this.levelOfIndentation)).add(") too high")).log();
            }
            this.levelOfIndentation = 25;
        }
        String string = "                                                                                                                                                                                                            ";
        return string.substring(0, this.levelOfIndentation * 4);
    }

    private static String ignoreStepByInstanceAndClass(AbstractStep abstractStep, @Nullable String string) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ignoreStepByInstanceAndClass(AbstractStep,String)", 417).addDetail("abstractStep", (Object)abstractStep)).addDetail("componentClass", string)).log();
        }
        if (abstractStep instanceof MouseEventStep) {
            if (Options.cached_OPT_RPP_CREATE_DEFINITIONS_RECORD_CLICKS_TO_TEXTS) {
                return STEP_ADD;
            }
            if ("TextArea".equals(string) || "TextField".equals(string)) {
                return STEP_IGNORE;
            }
            return STEP_ADD;
        }
        if (abstractStep instanceof ComponentWaiter) {
            ComponentWaiter componentWaiter = (ComponentWaiter)abstractStep;
            String string2 = string;
            if (classMappings.containsKey(string2)) {
                string2 = (String)classMappings.get(string2);
            }
            if ("Window".equals(string2) || "Dialog".equals(string2)) {
                if ("true".equals(componentWaiter.getAttributeValue(ComponentWaiter.s))) {
                    return STEP_IGNORE;
                }
                return STEP_OPTIONAL;
            }
            return STEP_IGNORE;
        }
        if (abstractStep instanceof CommentStep || abstractStep instanceof RethrowStep || abstractStep instanceof ReturnStep) {
            return STEP_IGNORE;
        }
        return STEP_ADD;
    }

    protected void addNodeClassAndTypeToCode(AbstractStep abstractStep, @Nullable String[][] stringArray) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addNodeClassAndTypeToCode(AbstractStep,String[][])", 456).addDetail("abstractStep", (Object)abstractStep)).addDetail("parameters", (Object)stringArray)).log();
        }
        if (abstractStep == null) {
            throw new IllegalArgumentException("abstractStep is marked non-null but is null");
        }
        String string = RppPlaceholder.getKindOfNode(abstractStep);
        String string2 = RppPlaceholder.getNodeType(abstractStep);
        this.addNodeTypeCode(string);
        if (string2 != null) {
            string2 = RppPlaceholder.replaceCallerVariables(string2, stringArray);
            this.addAttributeCode("check type", string2);
        }
    }

    void addComponentInfoToCode(RppPlaceholdersForStep rppPlaceholdersForStep, String[][] stringArray, Map map) {
        String string;
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addComponentInfoToCode(RppPlaceholdersForStep,String[][],Map<String, String>)", 488).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).addDetail("hierarchyParameters", (Object)stringArray)).addDetail("docTags", (Object)map)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("docTags is marked non-null but is null");
        }
        RppCompIdData rppCompIdData = rppPlaceholdersForStep.getCompIdData();
        if (rppCompIdData == null) {
            return;
        }
        boolean bl2 = rppCompIdData.addComponentAttributeAndIdToCode(rppPlaceholdersForStep, stringArray);
        this.sbError.append((CharSequence)rppCompIdData.getSbError());
        if (bl2) {
            this.addCompIdToCode(rppCompIdData.getComponentAttribute(), rppCompIdData.getCompIdWithoutSubIndex(), rppCompIdData.getComponentSuite());
        }
        this.addScopeCode(rppCompIdData);
        this.addSubindexesCode(rppPlaceholdersForStep, rppCompIdData);
        this.addCompIdVariablesToParameters(rppCompIdData);
        String string2 = rppCompIdData.getCompIdWithoutSubIndex();
        if (bl2 && !e.a((String)string2)) {
            return;
        }
        if (e.a((String)string2)) {
            this.addSmartIdInfoToCode(new e(string2));
            this.addSmartIdAncestorInfoToCode(rppPlaceholdersForStep);
        }
        if ((string = rppPlaceholdersForStep.getStep() != null && rppPlaceholdersForStep.getStep().getDoctag(RPP_COMPONENT_CLASS) != null ? rppPlaceholdersForStep.getStep().getDoctag(RPP_COMPONENT_CLASS) : rppPlaceholdersForStep.getPlaceholderValue("class")) != null) {
            String string3;
            if (!RPP_ANY.equals(string)) {
                if (classMappings.containsKey(string)) {
                    this.addComponentValueCode("classes", (String)classMappings.get(string));
                    rppPlaceholdersForStep.update("class", (String)classMappings.get(string));
                } else if (string.contains(".")) {
                    this.addExtraFeatureCode("qfs:class", string);
                } else {
                    this.addComponentValueCode("classes", string);
                }
            }
            if ((string3 = rppPlaceholdersForStep.getStep() != null && rppPlaceholdersForStep.getStep().getDoctag(RPP_COMPONENT_NAME) != null ? rppPlaceholdersForStep.getStep().getDoctag(RPP_COMPONENT_NAME) : rppPlaceholdersForStep.getPlaceholderValue("name")) != null) {
                this.addComponentNameToCode(string3, rppPlaceholdersForStep);
            } else {
                String string4 = rppPlaceholdersForStep.getPlaceholderValue("feature");
                if (string4 != null) {
                    this.addComponentValueCode("feature", string4);
                } else {
                    String string5 = rppPlaceholdersForStep.getPlaceholderValue("compef-qfs:labelLeft");
                    if (string5 != null) {
                        this.addExtraFeatureCode("qfs:labelLeft", string5);
                    } else {
                        string5 = rppPlaceholdersForStep.getPlaceholderValue("compef-qfs:labelText");
                        if (string5 != null) {
                            this.addExtraFeatureCode("qfs:labelText", string5);
                        } else {
                            string5 = rppPlaceholdersForStep.getPlaceholderValue("compef-qfs:labelBest");
                            if (string5 != null) {
                                this.addExtraFeatureCode("qfs:labelBest", string5);
                            }
                        }
                    }
                }
            }
        }
        this.addScopeCode(map);
    }

    private void addCompIdToCode(String string, String string2, String string3) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addCompIdToCode(String,String,String)", 587).addDetail("componentAttribute", string)).addDetail("compIdWithoutIndex", string2)).addDetail("testsuite", string3)).log();
        }
        this.addComponentValueCode("id", string2);
        this.addComponentValueCode("testsuite", string3);
        if (!string.equals(string2)) {
            this.addAttributeCode("component id", string);
        }
    }

    private void addSmartIdInfoToCode(e e2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addSmartIdInfoToCode(SmartID)", 628).addDetail("smartID", (Object)e2)).log();
        }
        if (e2.d()) {
            return;
        }
        String string = e2.g();
        if (string != null) {
            if ("Dialog|Window:Dialog".equals(string)) {
                this.addComponentValueCode("classes", "Dialog");
            } else {
                this.addComponentValueCode("classes", e2.g());
            }
        }
        if (e2.c() != null) {
            this.addComponentValueCode("engine", e2.c());
        }
        if (e2.h() == null && string != null && !"List".equals(string) && !"Table".equals(string)) {
            this.sbError.append("\nThe SmartId '").append(e2.a()).append("' has no match identifier!");
            return;
        }
        if (e2.m() && e2.b() != null) {
            this.addExtraFeatureCode(e2.h(), e2.b());
            return;
        }
        if (e2.k() && e2.b() != null) {
            this.addComponentValueCode("name", e2.b());
            return;
        }
        if (e2.b() != null) {
            this.addComponentValueCode("feature", e2.b());
        }
    }

    protected void addComponentNameToCode(String string, RppPlaceholdersForStep rppPlaceholdersForStep) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addComponentNameToCode(String,RppPlaceholdersForStep)", 675).addDetail("name", string)).addDetail("componentPlaceholders", (Object)rppPlaceholdersForStep)).log();
        }
        this.addComponentValueCode("name", string);
        String string2 = rppPlaceholdersForStep.getPlaceholderValue("compef-qfs:matchindex");
        if (string2 != null) {
            this.addComponentValueCode("name", string);
            this.addExtraFeatureCode("qfs:matchindex", string2);
        } else {
            string2 = rppPlaceholdersForStep.getPlaceholderValue("SMARTID_INDEX");
            if (string2 != null && !"0".equals(string2)) {
                this.addTermToCondition("\"<SMARTID_INDEX>\" == \"" + string2 + "\"");
            }
        }
    }

    protected void addSubindexesCode(RppPlaceholdersForStep rppPlaceholdersForStep, RppCompIdData rppCompIdData) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addSubindexesCode(RppPlaceholdersForStep,RppCompIdData)", 704).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).addDetail("compIdData", (Object)rppCompIdData)).log();
        }
        String string = rppPlaceholdersForStep.getPlaceholderValue("class");
        List list = rppCompIdData.getSubindexes();
        if (string != null && string.contains("Table") && list.size() > 1) {
            this.addTextOrNumericIndexToCode(rppCompIdData, 0, "subindexcol", "subindexcolseparator", "subindexcoltext", "subindexcolnumeric", "subindexcolrecexp");
            this.addTextOrNumericIndexToCode(rppCompIdData, 1, "subindexrow", "subindexrowseparator", "subindexrowtext", "subindexrownumeric", "subindexrowregexp");
        } else {
            this.addTextOrNumericIndexToCode(rppCompIdData, 0, "subindex", "subindexseparator", "subindextext", "subindexnumeric", "subindexrexexp");
            this.addTextOrNumericIndexToCode(rppCompIdData, 1, "subindex1", "subindexseparator1", "subindextext1", "subindexnumeric1", "subindexrexexp1");
        }
        for (int i2 = 2; i2 < list.size(); ++i2) {
            this.addTextOrNumericIndexToCode(rppCompIdData, i2, "subindex" + i2, "subindexseparator" + i2, "subindextext" + i2, "subindexnumeric" + i2, "subindexrexexp" + i2);
        }
    }

    private void addTextOrNumericIndexToCode(RppCompIdData rppCompIdData, int n2, String string, String string2, String string3, String string4, String string5) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addTextOrNumericIndexToCode(RppCompIdData,int,String,String,String,String,String)", 749).addDetail("compIdData", (Object)rppCompIdData)).addDetail("idx", n2)).addDetail("indexPlaceholder", string)).addDetail("separatorPlaceholder", string2)).addDetail("textIndexPlaceholder", string3)).addDetail("numericIndexPlaceholder", string4)).addDetail("regexpIndexPlaceholder", string5)).log();
        }
        if (rppCompIdData == null) {
            throw new IllegalArgumentException("compIdData is marked non-null but is null");
        }
        if (Misc.emptyOrNull((Collection)rppCompIdData.getSubindexes()) || rppCompIdData.getSubindexes().size() <= n2) {
            return;
        }
        String string6 = rppCompIdData.getSubindexValue(n2);
        String string7 = rppCompIdData.getSubindexSeparator(n2);
        if ("@".equals(string7)) {
            String string8 = this.addVariablesToParameters(string6, string3);
            if (string8 != null) {
                if (string8.equals(string6)) {
                    this.addComponentValueCode(string3, string6);
                } else {
                    this.addComponentValueCode(string5, string8);
                }
            }
        } else if ("&".equals(string7)) {
            this.addComponentValueCode(string4, string6);
        } else if ("%".equals(string7)) {
            String string9 = this.addVariablesToParameters(string6, string3);
            if (string9 != null) {
                this.addComponentValueCode(string5, string9);
            }
        } else if (RppExtractStep.isAVariable(string7)) {
            this.addVariableToParameters(RppPlaceholder.stripVarReference(string6), string, true);
            this.addVariableToParameters(RppPlaceholder.stripVarReference(string7), string2, true);
        } else {
            this.sbError.append("\nOnly '@', '&', '%' and variables are ").append("' allowed as separator. Got: '").append(string7).append("'");
        }
    }

    private void addTextOrNumericIndexToCodeOld(RppPlaceholdersForStep rppPlaceholdersForStep, String string, String string2, String string3, String string4, String string5) {
        String string6;
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addTextOrNumericIndexToCodeOld(RppPlaceholdersForStep,String,String,String,String,String)", 789).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).addDetail("indexPlaceholder", string)).addDetail("separatorPlaceholder", string2)).addDetail("textIndexPlaceholder", string3)).addDetail("numericIndexPlaceholder", string4)).addDetail("regexpIndexPlaceholder", string5)).log();
        }
        if ((string6 = rppPlaceholdersForStep.getPlaceholderValue(string)) == null) {
            return;
        }
        String string7 = rppPlaceholdersForStep.getPlaceholderValue(string2);
        if ("@".equals(string7)) {
            String string8 = this.addVariablesToParameters(string6, string3);
            if (string8 != null) {
                if (string8.equals(string6)) {
                    this.addComponentValueCode(string3, string6);
                } else {
                    this.addComponentValueCode(string5, string8);
                }
            }
        } else if ("&".equals(string7)) {
            this.addComponentValueCode(string4, string6);
        } else if ("%".equals(string7)) {
            String string9 = this.addVariablesToParameters(string6, string3);
            if (string9 != null) {
                this.addComponentValueCode(string5, string9);
            }
        } else if ("#".equals(string7)) {
            this.addComponentValueCode(string, string6);
        } else {
            this.sbError.append("\nOnly '@', '&', '%' and '").append("#").append("' allowed. Separator got: '").append(string7).append("'");
        }
    }

    protected void addSmartIdAncestorInfoToCode(RppPlaceholdersForStep rppPlaceholdersForStep) {
        String string;
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addSmartIdAncestorInfoToCode(RppPlaceholdersForStep)", 838).addDetail("componentPlaceholders", (Object)rppPlaceholdersForStep)).log();
        }
        for (int i2 = 1; i2 < 100 && (string = rppPlaceholdersForStep.getPlaceholderValue("SMARTID" + i2 + "_id")) != null; ++i2) {
            this.addTermToCondition("\"<SMARTID" + i2 + "_id>\" == \"" + string + "\"");
        }
    }

    protected void addNodeTypeCode(String string) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addNodeTypeCode(String)", 852).addDetail("name", string)).log();
        }
        if ((string = this.addVariablesToParameters(string, "node type")) != null) {
            this.sbStepNodeType.append(LINE_BREAK).append(indent8).append("node type").append(": ").append(this.escape(string));
            this.currentStep.put("node type", string);
        }
    }

    @Nullable
    private String addVariablesToParameters(String string, String string2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addVariablesToParameters(String,String)", 876).addDetail("stringWithVariables", string)).addDetail("placeholderName", string2)).log();
        }
        if (RppExtractStep.isAVariable(string)) {
            this.addVariableToParameters(string.substring(2, string.length() - 1), string2, true);
            return null;
        }
        String string3 = string;
        boolean bl2 = false;
        while (string3.contains("$(")) {
            int n2 = string3.indexOf("$(");
            int n3 = string3.indexOf(")", n2 + 2);
            if (n3 == -1) continue;
            bl2 = true;
            String string4 = string3.substring(n2 + 2, n3);
            String string5 = string3.substring(n2, n3 + 1);
            string3 = string3.replace(string5, ".+");
            if (string2 != null) {
                this.addParameterCode(string4, "\"<" + string2 + "> !!! please correct the value - the variable is used in the index '" + string + "' !!! \"");
                continue;
            }
            this.addParameterCode(string4, "\"please set value !\"");
        }
        if (bl2) {
            return string3;
        }
        return string;
    }

    protected void addAttributeCode(String string, String string2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addAttributeCode(String,String)", 908).addDetail("name", string)).addDetail("value", string2)).log();
        }
        if (string == null || string2 == null || string.equals("component id") || "client".equals(string)) {
            return;
        }
        if (RppExtractStep.isAVariable(string2)) {
            this.addVariableToParameters(string2.substring(2, string2.length() - 1), string, true);
            return;
        }
        if (string2.equals(RppMetadataConfig.attributeDefault.get(string))) {
            return;
        }
        if (!this.currentStep.containsKey("attributes" + string)) {
            this.sbStepAttributes.append(LINE_BREAK).append(indent10).append(string).append(": ").append(this.escape(string2));
            this.currentStep.put("attributes" + string, string2);
        }
    }

    protected void addComponentValueCode(@Nullable String string, @Nullable String string2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addComponentValueCode(String,String)", 930).addDetail("name", string)).addDetail("value", string2)).log();
        }
        if (Misc.emptyOrNull((String)string) || string2 == null) {
            return;
        }
        if (RppExtractStep.isAVariable(string2)) {
            this.addVariableToParameters(string2.substring(2, string2.length() - 1), string, true);
            return;
        }
        if (!this.currentStep.containsKey("component" + string)) {
            this.sbStepComponent.append(LINE_BREAK).append(indent10).append(string).append(": ").append(this.escape(string2));
            this.currentStep.put("component" + string, string2);
        }
    }

    private void addScopeCode(RppCompIdData rppCompIdData) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addScopeCode(RppCompIdData)", 951).addDetail("compIdData", (Object)rppCompIdData)).log();
        }
        if (rppCompIdData == null) {
            throw new IllegalArgumentException("compIdData is marked non-null but is null");
        }
        if (Misc.emptyOrNull((Collection)rppCompIdData.getScopeIds())) {
            return;
        }
        List list = rppCompIdData.getScopeIds();
        StringBuilder stringBuilder = new StringBuilder((String)list.get(0));
        for (int i2 = 1; i2 < list.size(); ++i2) {
            stringBuilder.append("@").append((String)list.get(i2));
        }
        this.addScopeCode(stringBuilder.toString());
    }

    private void addScopeCode(Map map) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addScopeCode(Map<String, String>)", 967).addDetail("docTags", (Object)map)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("docTags is marked non-null but is null");
        }
        if (Misc.emptyOrNull((Map)map) || map.get("rpp_scope") == null) {
            return;
        }
        String string = (String)map.get("rpp_scope");
        this.addScopeCode(string);
    }

    private void addScopeCode(String string) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addScopeCode(String)", 979).addDetail("scope", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        if (!this.currentStep.containsKey("component-scope")) {
            this.sbStepComponentScope.append(LINE_BREAK).append(indent12).append("id").append(": ").append(this.escape(string));
            this.currentStep.put("component-scope", string);
        }
    }

    protected void addExtraFeatureCode(String string, String string2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addExtraFeatureCode(String,String)", 988).addDetail("name", string)).addDetail("value", string2)).log();
        }
        if (RppExtractStep.isAVariable(string2)) {
            this.addVariableToParameters(string2.substring(2, string2.length() - 1), "compef-" + string, true);
            return;
        }
        if (!this.currentStep.containsKey("compef-" + string)) {
            this.sbStepExtraFeatures.append(LINE_BREAK).append(indent12).append(string).append(": ").append(this.escape(string2));
            this.currentStep.put("compef-" + string, string2);
        }
    }

    protected void addParameterCode(String string, String string2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addParameterCode(String,String)", 1001).addDetail("name", string)).addDetail("value", string2)).log();
        }
        if (RppExtractStep.isAVariable(string2)) {
            this.addVariableToParameters(string2.substring(2, string2.length() - 1), string, false);
            return;
        }
        if (!this.currentStep.containsKey("your-parameter" + string)) {
            this.sbParameters.append(LINE_BREAK).append(indent10).append(string).append(": ").append(this.escape(string2));
            this.currentStep.put("your-parameter" + string, string2);
        }
    }

    protected void addCompIdVariablesToParameters(RppCompIdData rppCompIdData) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addCompIdVariablesToParameters(RppCompIdData)", 1014).addDetail("compIdData", (Object)rppCompIdData)).log();
        }
        if (rppCompIdData == null) {
            throw new IllegalArgumentException("compIdData is marked non-null but is null");
        }
        List list = rppCompIdData.getVariables();
        if (!Misc.emptyOrNull((Collection)list)) {
            for (Map map : list) {
                this.addVariableToParameters((String)map.get("name"), (String)map.get("value"), "true".equals(map.get("valueIsPlaceholderName")));
            }
        }
    }

    private String escape(String string) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "escape(String)", 1035).addDetail("value", string)).log();
        }
        if (string == null) {
            return null;
        }
        if (string.contains(":") || string.startsWith("#")) {
            return "'" + string + "'";
        }
        return string;
    }

    protected void addTermToCondition(String string) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addTermToCondition(String)", 1049).addDetail("term", string)).log();
        }
        if (this.sbCondition.isEmpty()) {
            this.sbCondition.append(string);
        } else {
            this.sbCondition.append(" and ").append(string);
        }
    }

    protected void completeSbStep() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "completeSbStep()", 1061).log();
        }
        this.sbStep.append(LINE_BREAK).append(indent4).append("- ").append("node").append(":").append((CharSequence)this.sbStepNodeType);
        this.sbStepNodeType.setLength(0);
        this.addAttributesToCode();
        this.addComponentValuesToCode();
        this.addSubIndexesToCode();
        this.addParametersToCode();
        this.addConditionToCode();
    }

    private void addAttributesToCode() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "addAttributesToCode()", 1074).log();
        }
        if (!this.sbStepAttributes.isEmpty()) {
            this.sbStep.append(LINE_BREAK).append(indent8).append("attributes").append(":").append((CharSequence)this.sbStepAttributes);
            this.sbStepAttributes.setLength(0);
        }
    }

    private void addScopeToCode() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "addScopeToCode()", 1084).log();
        }
        if (!this.sbStepComponentScope.isEmpty()) {
            this.sbStep.append(LINE_BREAK).append(indent10).append("scope").append(":").append((CharSequence)this.sbStepComponentScope);
            this.sbStepComponentScope.setLength(0);
        }
    }

    private void addSubIndexesToCode() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "addSubIndexesToCode()", 1094).log();
        }
        if (!this.sbStepSubIndexes.isEmpty()) {
            this.sbStep.append(LINE_BREAK).append((CharSequence)this.sbStepSubIndexes);
            this.sbStepSubIndexes.setLength(0);
        }
    }

    private void addComponentValuesToCode() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "addComponentValuesToCode()", 1104).log();
        }
        if (!(this.sbStepComponent.isEmpty() && this.sbStepExtraFeatures.isEmpty() && this.sbStepComponentScope.isEmpty())) {
            this.sbStep.append(LINE_BREAK).append(indent8).append("component").append(":").append((CharSequence)this.sbStepComponent);
            this.addScopeToCode();
            if (!this.sbStepExtraFeatures.isEmpty()) {
                this.sbStep.append(LINE_BREAK).append(indent10).append("Extra features").append(":").append((CharSequence)this.sbStepExtraFeatures);
                this.sbStepExtraFeatures.setLength(0);
            }
            this.sbStepComponent.setLength(0);
        }
    }

    private void addExtraFeaturesToCode() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "addExtraFeaturesToCode()", 1123).log();
        }
    }

    private void addParametersToCode() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "addParametersToCode()", 1128).log();
        }
        if (!this.sbParameters.isEmpty()) {
            this.sbStep.append(LINE_BREAK).append(indent8).append("procedure call parameters").append(":").append((CharSequence)this.sbParameters);
            this.sbParameters.setLength(0);
        }
    }

    private void addConditionToCode() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "addConditionToCode()", 1138).log();
        }
        if (!this.sbCondition.isEmpty()) {
            this.sbStep.append(LINE_BREAK).append(indent8).append("condition").append(": '").append((CharSequence)this.sbCondition).append("'");
            this.sbCondition.setLength(0);
        }
    }

    protected static boolean isAVariable(@Nullable String string) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isAVariable(String)", 1148).addDetail("placeholder", string)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return false;
        }
        return string.startsWith("$(") && string.indexOf(")") == string.length() - 1;
    }

    private void addDoctagVariablesToParameterCode(AbstractStep abstractStep) {
        String string;
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addDoctagVariablesToParameterCode(AbstractStep)", 1164).addDetail("abstractStep", (Object)abstractStep)).log();
        }
        if ((string = abstractStep.getComment()) == null) {
            return;
        }
        List list = Util.getDoctags((String)string, (String)RPP_PARAMETER);
        if (!Misc.emptyOrNull((Collection)list)) {
            for (String string2 : list) {
                String[] stringArray = string2.split("=");
                String string3 = stringArray[0].strip();
                if (stringArray.length < 2) {
                    if (RppExtractStep.logger.level < 1) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "addDoctagVariablesToParameterCode(AbstractStep)", 1176).add("Invalid syntax for the doctag '@rpp_variable. Expected @rpp_variable varname=value. Got: @rpp_variable ", string2)).add("' in step ")).add("abstractStep", (Object)abstractStep)).log();
                    continue;
                }
                String string4 = stringArray[1].strip();
                if (Misc.emptyOrNull((String)string3)) continue;
                this.addVariableToParameters(string3, string4, false);
            }
        }
    }

    private boolean variablesInRecordableAttributes(RppPlaceholdersForStep rppPlaceholdersForStep) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "variablesInRecordableAttributes(RppPlaceholdersForStep)", 1198).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).log();
        }
        if (rppPlaceholdersForStep != null && rppPlaceholdersForStep.getRecordableStepPlaceholders() != null) {
            for (String string : rppPlaceholdersForStep.getRecordableStepPlaceholders()) {
                String string2 = rppPlaceholdersForStep.getPlaceholderValue(string);
                if (string2 == null || !string2.contains("$(") || "client".equals(string) && ((String)RppMetadataConfig.attributeDefault.get(string)).equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private void addAttributesToStepCode(RppPlaceholdersForStep rppPlaceholdersForStep, AbstractStep abstractStep) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addAttributesToStepCode(RppPlaceholdersForStep,AbstractStep)", 1228).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).addDetail("abstractStep", (Object)abstractStep)).log();
        }
        for (int i2 = 0; i2 < abstractStep.getExtraNodeCount(); ++i2) {
            String string = abstractStep.getExtraNodeName(i2);
            this.addAttributeToStepCode(rppPlaceholdersForStep, abstractStep, string);
        }
        for (String string : rppPlaceholdersForStep.getRecordableStepPlaceholders()) {
            String string2 = rppPlaceholdersForStep.getPlaceholderValue(string);
            this.addAttributeCode(string, string2);
        }
    }

    private void addAttributeToStepCode(RppPlaceholdersForStep rppPlaceholdersForStep, AbstractStep abstractStep, String string) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addAttributeToStepCode(RppPlaceholdersForStep,AbstractStep,String)", 1244).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).addDetail("abstractStep", (Object)abstractStep)).addDetail("placeholder", string)).log();
        }
        if (rppPlaceholdersForStep.getRecordableStepPlaceholders().contains(string)) {
            String string2 = rppPlaceholdersForStep.getPlaceholderValue(string);
            this.addAttributeCode(string, string2);
        }
    }

    protected void addParameterForValue(String[][] stringArray, String[][] stringArray2, String string, String string2) {
        String string3;
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addParameterForValue(String[][],String[][],String,String)", 1270).addDetail("parameters", (Object)stringArray)).addDetail("callParameters", (Object)stringArray2)).addDetail("variableName", string)).addDetail("defaultValue", string2)).log();
        }
        if ((string3 = RppExtractStep.getParameter(stringArray2, string)) != null && RppExtractStep.isAVariable(string3)) {
            string = string3.substring(2, string3.length() - 1);
            this.addValueVariableToParameters(stringArray, string);
            return;
        }
        string3 = RppExtractStep.getParameter(stringArray, string);
        if (string3 != null && RppExtractStep.isAVariable(string3)) {
            string = string3.substring(2, string3.length() - 1);
            this.addValueVariableToParameters(stringArray, string);
            return;
        }
        if (string2 != null) {
            this.addVariableToParameters(string, string2, true);
        }
    }

    private void addValueVariableToParameters(String[][] stringArray, String string) {
        String string2;
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addValueVariableToParameters(String[][],String)", 1313).addDetail("parameters", (Object)stringArray)).addDetail("parameterName", string)).log();
        }
        if ((string2 = RppExtractStep.getParameter(stringArray, string)) != null) {
            if (RppExtractStep.isAVariable(string2)) {
                string = string2.substring(2, string2.length() - 1);
                this.addVariableToParameters(string, "VALUE", true);
            }
        } else {
            this.addVariableToParameters(string, "VALUE", true);
        }
    }

    protected void addVariableToParameters(String string, String string2, boolean bl2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addVariableToParameters(String,String,boolean)", 1337).addDetail("parameterName", string)).addDetail("parameterValue", string2)).addDetail("valueIsPlaceholderName", bl2)).log();
        }
        if (bl2) {
            this.addParameterCode(string, "<" + string2 + ">");
        } else {
            this.addParameterCode(string, string2);
        }
    }

    @Nullable
    private String[] extractAndRemoveVariable(String string) {
        int n2;
        int n3;
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "extractAndRemoveVariable(String)", 1358).addDetail("placeholder", string)).log();
        }
        String[] stringArray = new String[2];
        if (Misc.emptyOrNull((String)string)) {
            return null;
        }
        int n4 = string.indexOf(")");
        if (n4 < 2) {
            return null;
        }
        for (n2 = string.substring(0, n4).indexOf("$("); n2 > -1 && (n3 = string.substring(n2 + 2, n4).indexOf("$(")) != -1; n2 += n3 + 2) {
        }
        stringArray[0] = string.substring(n2 + 2, n4);
        stringArray[1] = string.substring(0, n2) + string.substring(n4 + 1);
        return stringArray;
    }

    @Nullable
    static String replaceVariable(String string, String string2, String string3) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "replaceVariable(String,String,String)", 1393).addDetail("inputString", string)).addDetail("toBeReplaced", string2)).addDetail("replacement", string3)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return string;
        }
        return string.replace(string2, string3);
    }

    @Nullable
    protected static String getParameter(String[][] stringArray, String string) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getParameter(String[][],String)", 1411).addDetail("parameters", (Object)stringArray)).addDetail("parameterName", string)).log();
        }
        if (!Misc.emptyOrNull((Object[])stringArray)) {
            for (String[] stringArray2 : stringArray) {
                if (stringArray2 == null || !string.equals(stringArray2[0])) continue;
                return stringArray2[1] == null ? "" : stringArray2[1];
            }
        }
        return null;
    }

    private Map cloneOfCurrentStep() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "cloneOfCurrentStep()", 1426).log();
        }
        if (this.currentStep == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.currentStep.keySet()) {
            hashMap.put(string, (String)this.currentStep.get(string));
        }
        return hashMap;
    }

    protected void addEntryToGroup(RppExtractStep rppExtractStep) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addEntryToGroup(RppExtractStep)", 1477).addDetail("extractedStep", (Object)rppExtractStep)).log();
        }
        if (RppExtractStep.isAddStep(rppExtractStep)) {
            this.group.add(rppExtractStep);
            this.sbError.append((CharSequence)rppExtractStep.getSbError());
        }
    }

    RppExtractStep copy() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "copy()", 1492).log();
        }
        RppExtractStep rppExtractStep = new RppExtractStep(this.sbStep, this.groupType, this.optional, this.levelOfIndentation, this.sbError);
        if (!this.group.isEmpty()) {
            for (RppExtractStep rppExtractStep2 : this.group) {
                rppExtractStep.group.add(rppExtractStep2.copy());
            }
        }
        return rppExtractStep;
    }

    void copyKnownProcedureToGroup(RppExtractStep rppExtractStep) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "copyKnownProcedureToGroup(RppExtractStep)", 1511).addDetail("knownProcedure", (Object)rppExtractStep)).log();
        }
        RppExtractStep rppExtractStep2 = rppExtractStep.copy();
        this.group.add(rppExtractStep2);
    }

    protected void addEntryToGroupAsFlatAsPossible(RppExtractStep rppExtractStep) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addEntryToGroupAsFlatAsPossible(RppExtractStep)", 1530).addDetail("extractedStep", (Object)rppExtractStep)).log();
        }
        if (RppExtractStep.isAddStep(rppExtractStep)) {
            if (rppExtractStep.group.isEmpty() || "choice group".equals(rppExtractStep.groupType)) {
                this.group.add(rppExtractStep);
            } else {
                for (RppExtractStep rppExtractStep2 : rppExtractStep.group) {
                    rppExtractStep2.optional |= rppExtractStep.isOptional();
                    this.group.add(rppExtractStep2);
                }
            }
        }
    }

    private static boolean isAddStep(RppExtractStep rppExtractStep) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isAddStep(RppExtractStep)", 1554).addDetail("extractedStep", (Object)rppExtractStep)).log();
        }
        return !rppExtractStep.sbStep.isEmpty() || !rppExtractStep.group.isEmpty();
    }

    protected void addEntriesToGroup(RppExtractStep rppExtractStep) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addEntriesToGroup(RppExtractStep)", 1568).addDetail("extractedStep", (Object)rppExtractStep)).log();
        }
        if (Misc.emptyOrNull((Collection)rppExtractStep.group)) {
            return;
        }
        for (RppExtractStep rppExtractStep2 : rppExtractStep.group) {
            if (!RppExtractStep.isAddStep(rppExtractStep2)) continue;
            this.group.add(rppExtractStep2);
        }
    }

    protected void addEntriesAsOptional(RppExtractStep rppExtractStep) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addEntriesAsOptional(RppExtractStep)", 1589).addDetail("extractedStep", (Object)rppExtractStep)).log();
        }
        if (Misc.emptyOrNull((Collection)rppExtractStep.group)) {
            return;
        }
        for (RppExtractStep rppExtractStep2 : rppExtractStep.group) {
            if (Misc.emptyOrNull((Collection)rppExtractStep2.group)) {
                rppExtractStep2.setOptional(true);
                this.group.add(rppExtractStep2);
                continue;
            }
            this.addEntriesAsOptional(rppExtractStep2);
        }
    }

    protected boolean optionalEntryExist() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "optionalEntryExist()", 1608).log();
        }
        for (RppExtractStep rppExtractStep : this.group) {
            if (rppExtractStep.isOptional()) {
                return true;
            }
            boolean bl2 = true;
            for (RppExtractStep rppExtractStep2 : rppExtractStep.getGroup()) {
                if (rppExtractStep2.isOptional()) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    protected boolean hasFinallyGroup() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "hasFinallyGroup()", 1633).log();
        }
        for (RppExtractStep rppExtractStep : this.group) {
            if (!FINALLY_BLOCK.equals(rppExtractStep.getGroup())) continue;
            return true;
        }
        return false;
    }

    boolean allGroupEntriesHaveEqualText(RppExtractStep rppExtractStep) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "allGroupEntriesHaveEqualText(RppExtractStep)", 1644).addDetail("entry", (Object)rppExtractStep)).log();
        }
        if (rppExtractStep == null) {
            throw new IllegalArgumentException("entry is marked non-null but is null");
        }
        if (Misc.emptyOrNull((Collection)this.group) && Misc.emptyOrNull((Collection)rppExtractStep.group)) {
            return true;
        }
        if (Misc.emptyOrNull((Collection)this.group) || Misc.emptyOrNull((Collection)rppExtractStep.group)) {
            return false;
        }
        if (this.group.size() != rppExtractStep.group.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.group.size(); ++i2) {
            if (((RppExtractStep)this.group.get((int)i2)).sbStep.toString().contentEquals(((RppExtractStep)rppExtractStep.group.get((int)i2)).sbStep)) continue;
            return false;
        }
        return true;
    }

    public StringBuilder getSbStep() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "getSbStep()", 158).log();
        }
        return this.sbStep;
    }

    public StringBuilder getSbError() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "getSbError()", 179).log();
        }
        return this.sbError;
    }

    public List getGroup() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "getGroup()", 190).log();
        }
        return this.group;
    }

    public RppExtractStep setGroup(List list) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setGroup(List<RppExtractStep>)", 191).addDetail("group", (Object)list)).log();
        }
        this.group = list;
        return this;
    }

    public String getGroupType() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "getGroupType()", 197).log();
        }
        return this.groupType;
    }

    public RppExtractStep setGroupType(String string) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setGroupType(String)", 198).addDetail("groupType", string)).log();
        }
        this.groupType = string;
        return this;
    }

    public boolean isOptional() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "isOptional()", 204).log();
        }
        return this.optional;
    }

    public RppExtractStep setOptional(boolean bl2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setOptional(boolean)", 205).addDetail(STEP_OPTIONAL, bl2)).log();
        }
        this.optional = bl2;
        return this;
    }

    public int getLevelOfIndentation() {
        if (RppExtractStep.logger.level >= 7) {
            logger.lvlBuild(7, "getLevelOfIndentation()", 211).log();
        }
        return this.levelOfIndentation;
    }

    public RppExtractStep setLevelOfIndentation(int n2) {
        if (RppExtractStep.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setLevelOfIndentation(int)", 212).addDetail("levelOfIndentation", n2)).log();
        }
        this.levelOfIndentation = n2;
        return this;
    }

    static {
        classMappings.put("javax.swing.JButton", "Button");
        classMappings.put("com.jgoodies.looks.plastic.PlasticComboBoxButton", "Button");
        classMappings.put("javax.swing.JCheckBox", "CheckBox");
        classMappings.put("javax.swing.JComboBox", "ComboBox");
        classMappings.put("javax.swing.JDialog", "Dialog");
        classMappings.put("de.qfs.apps.qftest.edit.Editor", "Dialog");
        classMappings.put("de.qfs.lib.gui.ModalDialog", "Dialog");
        classMappings.put("javax.swing.JMenuBar", "MenuBar");
        classMappings.put("javax.swing.JMenu", "MenuItem");
        classMappings.put("javax.swing.JMenuItem", "MenuItem");
        classMappings.put("javax.swing.JCheckBoxMenuItem", "MenuItem");
        classMappings.put("de.qfs.apps.qftest.suite.TerminalMenuItem", "MenuItem");
        classMappings.put("javax.swing.JLabel", "Label");
        classMappings.put("javax.swing.JList", "List");
        classMappings.put("de.qfs.apps.qftest.run.StatusCounterPanel$StatusCounter", "Panel");
        classMappings.put("javax.swing.JScrollPane", "Panel");
        classMappings.put("de.qfs.lib.gui.MultiPane", "Panel");
        classMappings.put("de.qfs.apps.qftest.base.TitlePanel", "Panel");
        classMappings.put("de.qfs.lib.gui.AbstractTextView", "Panel");
        classMappings.put("javax.swing.JPopupMenu", "Popup");
        classMappings.put("javax.swing.JRadioButton", "RadioButton");
        classMappings.put("javax.swing.JSplitPane", "SplitPanel");
        classMappings.put("com.jidesoft.swing.JideTabbedPane", "TabPanel");
        classMappings.put("javax.swing.table.JTableHeader", "TableHeader");
        classMappings.put("javax.swing.JTable", "Table");
        classMappings.put("de.qfs.apps.qftest.edit.IncludeFilesOptionEdit$MyTable", "Table");
        classMappings.put("javax.swing.text.JTextComponent", "TextArea, TextField");
        classMappings.put("javax.swing.JTextField", "TextField");
        classMappings.put("javax.swing.JTextArea", "TextArea");
        classMappings.put("de.qfs.apps.qftest.jedit.JEditTextArea", "TextArea");
        classMappings.put("javax.swing.JToggleButton", "ToggleButton");
        classMappings.put("javax.swing.JToolBar", "ToolBar");
        classMappings.put("de.qfs.apps.qftest.suite.SuiteTree", "Tree");
        classMappings.put("de.qfs.apps.qftest.suite.SuiteFrame", "Window");
        classMappings.put("de.qfs.apps.qftest.log.StepLogFrame", "Window");
    }
}

