/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.record.procbuilder.RppComponentDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppConditionDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppEventDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppGroupAnywhere;
import de.qfs.apps.qftest.record.procbuilder.RppGroupChoice;
import de.qfs.apps.qftest.record.procbuilder.RppGroupDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppGroupSequential;
import de.qfs.apps.qftest.record.procbuilder.RppGroupUnsorted;
import de.qfs.apps.qftest.record.procbuilder.RppParameterDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppProcCallDef;
import de.qfs.apps.qftest.record.procbuilder.RppRepeatDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppReturnValueDefinition;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.script.DataFormatException;
import de.qfs.apps.qftest.step.datastep.metadata.a;
import de.qfs.apps.qftest.step.datastep.metadata.b;
import de.qfs.apps.qftest.step.datastep.metadata.j;
import de.qfs.apps.qftest.step.datastep.metadata.l;
import de.qfs.apps.qftest.step.datastep.metadata.n;
import de.qfs.apps.qftest.step.datastep.metadata.q;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class RppProcCallDefFactory {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.RppProcCallDefFactory");
    protected static final String CLASSES_ALL = "all";
    protected static final String REGEXP = "regexp";
    protected static final String ERROR = "error";

    public static ArrayList createProcCallDefs(@Nullable l l2) throws DataFormatException {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createProcCallDefs(MetadataMap)", 121).addDetail("metadata", (Object)l2)).log();
        }
        ArrayList<RppProcCallDef> arrayList = new ArrayList<RppProcCallDef>();
        if (Misc.emptyOrNull((Object)l2) || l2.u()) {
            return arrayList;
        }
        for (String string : l2.t()) {
            l l3;
            try {
                l3 = l2.f(string);
            }
            catch (ClassCastException classCastException) {
                throw new DataFormatException(classCastException.getMessage());
            }
            RppProcCallDef rppProcCallDef = RppProcCallDefFactory.createProcCallDef(l3);
            arrayList.add(rppProcCallDef);
        }
        return arrayList;
    }

    static RppProcCallDef createProcCallDef(@Nullable l l2) throws DataFormatException {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createProcCallDef(MetadataMap)", 153).addDetail("metadataProcCallDef", (Object)l2)).log();
        }
        RppProcCallDef rppProcCallDef = new RppProcCallDef();
        if (Misc.emptyOrNull((Object)l2) || l2.u()) {
            return rppProcCallDef;
        }
        rppProcCallDef.setCodeEntryName(l2.n());
        try {
            rppProcCallDef.setPrio(l2.a("priority", 10));
            rppProcCallDef.setCheckForOccurrencesBeforeGroup(l2.a("allow anywhere events before group", false));
            rppProcCallDef.setCheckForOccurrencesAfterGroup(l2.a("allow anywhere events after group", false));
        }
        catch (ClassCastException classCastException) {
            throw new DataFormatException(classCastException.getMessage());
        }
        rppProcCallDef.setExpectedOccurrences(RppProcCallDefFactory.createAnywhereGroup(l2));
        String string = RppProcCallDefFactory.determineGroupType(l2);
        rppProcCallDef.setExpectedSteps(RppProcCallDefFactory.createGroup(l2.f(string), string));
        return rppProcCallDef;
    }

    static RppGroupDefinition createGroup(l l2, String string) throws DataFormatException {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createGroup(MetadataMap,String)", 189).addDetail("metadataGroup", (Object)l2)).addDetail("groupType", string)).log();
        }
        if (!RppProcCallDefFactory.isValidGroupType(string)) {
            if (RppProcCallDefFactory.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "createGroup(MetadataMap,String)", 193).add("Error in setMetadataGroup: Wrong group type! Continuing with sequential group")).log();
            }
            string = "sequential group";
        }
        RppGroupDefinition rppGroupDefinition = "sequential group".equals(string) ? new RppGroupSequential() : ("choice group".equals(string) ? new RppGroupChoice() : new RppGroupUnsorted());
        if (l2 == null) {
            return rppGroupDefinition;
        }
        rppGroupDefinition.setCheckForOccurrencesInGroup(l2.a("allow anywhere events in group", true));
        List list = RppProcCallDefFactory.createEvents(l2.h("expected nodes"));
        rppGroupDefinition.setEvents(list);
        return rppGroupDefinition;
    }

    static RppGroupAnywhere createAnywhereGroup(l l2) throws DataFormatException {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createAnywhereGroup(MetadataMap)", 226).addDetail("metadata", (Object)l2)).log();
        }
        if (l2 == null) {
            throw new IllegalArgumentException("metadata is marked non-null but is null");
        }
        RppGroupAnywhere rppGroupAnywhere = new RppGroupAnywhere();
        l l3 = l2.f("anywhere group");
        if (Misc.emptyOrNull((Object)l3)) {
            return rppGroupAnywhere;
        }
        List list = RppProcCallDefFactory.createEvents(l3.h("expected nodes"));
        rppGroupAnywhere.setEvents(list);
        return rppGroupAnywhere;
    }

    private static String determineGroupType(@Nullable l l2) {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "determineGroupType(MetadataMap)", 250).addDetail("parent", (Object)l2)).log();
        }
        if (Misc.emptyOrNull((Object)l2)) {
            return null;
        }
        if (l2.e("sequential group") && l2.f("sequential group") != null) {
            return "sequential group";
        }
        if (l2.e("choice group") && l2.f("choice group") != null) {
            return "choice group";
        }
        if (l2.e("unsorted group") && l2.f("unsorted group") != null) {
            return "unsorted group";
        }
        return null;
    }

    static List createEvents(@Nullable n n2) throws DataFormatException {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createEvents(MetadataNestedList)", 279).addDetail("metadataEvents", (Object)n2)).log();
        }
        ArrayList<RppEventDefinition> arrayList = new ArrayList<RppEventDefinition>();
        if (n2 == null || n2.s()) {
            return arrayList;
        }
        try {
            block2: for (b b2 : n2) {
                l l2 = (l)b2;
                if (l2 == null || l2.u()) {
                    if (RppProcCallDefFactory.logger.level < 3) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "createEvents(MetadataNestedList)", 289).add("Empty event -> skip the event")).log();
                    continue;
                }
                for (String string : l2.t()) {
                    l l3 = l2.f(string);
                    if (l3 == null) continue;
                    RppEventDefinition rppEventDefinition = new RppEventDefinition();
                    if ("node".equals(string)) {
                        rppEventDefinition = RppProcCallDefFactory.createEvent(l3);
                    } else {
                        rppEventDefinition.subGroup = RppProcCallDefFactory.createGroup(l3, string);
                        if (l3.e("repeat")) {
                            rppEventDefinition.setRepeat(RppProcCallDefFactory.createRepeat(l3.f("repeat"), "repeat"));
                        }
                    }
                    arrayList.add(rppEventDefinition);
                    continue block2;
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new DataFormatException(classCastException.getMessage());
        }
        return arrayList;
    }

    static RppEventDefinition createEvent(l l2) throws DataFormatException {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createEvent(MetadataMap)", 330).addDetail("metadataEvent", (Object)l2)).log();
        }
        if (l2 == null) {
            throw new IllegalArgumentException("metadataEvent is marked non-null but is null");
        }
        RppEventDefinition rppEventDefinition = new RppEventDefinition();
        rppEventDefinition.setNode(l2.l("node type"));
        rppEventDefinition.setComponent(RppProcCallDefFactory.createComponent(l2));
        RppProcCallDefFactory.createAttributes(l2, rppEventDefinition);
        RppConditionDefinition rppConditionDefinition = new RppConditionDefinition();
        rppEventDefinition.setCondition(rppConditionDefinition.setExpression(l2.l("condition")));
        rppEventDefinition.setParams(RppProcCallDefFactory.createParameters(l2));
        rppEventDefinition.setReturnVar(RppProcCallDefFactory.createReturnVar(l2));
        rppEventDefinition.setDoctags(RppProcCallDefFactory.createDoctags(l2));
        if (l2.f("repeat") != null) {
            rppEventDefinition.setRepeat(RppProcCallDefFactory.createRepeat(l2.f("repeat"), "repeat"));
        }
        if (l2.f("occurrences") != null) {
            rppEventDefinition.setOccurrences(RppProcCallDefFactory.createRepeat(l2.f("occurrences"), "occurrences"));
        }
        return rppEventDefinition;
    }

    private static boolean isValidGroupType(@Nullable String string) {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isValidGroupType(String)", 364).addDetail("groupType", string)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return false;
        }
        return "sequential group".equals(string) || "unsorted group".equals(string) || "choice group".equals(string);
    }

    static RppComponentDefinition createComponent(l l2) throws DataFormatException {
        l l3;
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createComponent(MetadataMap)", 375).addDetail("metadataEvent", (Object)l2)).log();
        }
        RppComponentDefinition rppComponentDefinition = new RppComponentDefinition();
        if (l2.e("component")) {
            l3 = l2.f("component");
        } else if (l2.e("scope")) {
            l3 = l2.f("scope");
        } else {
            return rppComponentDefinition;
        }
        if (Misc.emptyOrNull((Object)l3)) {
            return rppComponentDefinition;
        }
        String string = "";
        Iterator iterator = l3.t().iterator();
        block62: while (iterator.hasNext()) {
            String string2;
            switch (string2 = (String)iterator.next()) {
                case "id": {
                    rppComponentDefinition.setId(l3.l("id"));
                    break;
                }
                case "name": {
                    rppComponentDefinition.setName(l3.l("name"));
                    break;
                }
                case "classes": {
                    j j2 = l3.g("classes");
                    if (Misc.emptyOrNull((Object)j2)) {
                        return rppComponentDefinition;
                    }
                    for (Object object : j2) {
                        try {
                            rppComponentDefinition.getClasses().add(((q)object).t());
                        }
                        catch (Exception exception) {
                            throw new DataFormatException(ErrorMessage.rppclassesmustbearrayorstring.toString());
                        }
                    }
                    continue block62;
                }
                case "Extra features": {
                    Object object;
                    if (!l3.e("Extra features")) continue block62;
                    Object object2 = l3.f("Extra features");
                    if (object2 == null) break;
                    object = ((l)object2).t().iterator();
                    while (object.hasNext()) {
                        String string3 = (String)object.next();
                        String string4 = ((l)object2).a(string3, (String)null);
                        if (string4 == null) continue;
                        if ("qfs:matchindex".equals(string3)) {
                            rppComponentDefinition.setMatchIndex(string4);
                            continue;
                        }
                        string = RppProcCallDefFactory.addToConditionString("compef-" + string3, string4, string);
                    }
                    continue block62;
                }
                case "subindex": 
                case "subindex0": 
                case "subindex1": 
                case "subindex2": 
                case "subindex3": 
                case "subindex4": 
                case "subindex5": 
                case "subindex6": 
                case "subindex7": {
                    RppProcCallDefFactory.addSubIndex(string2, l3, rppComponentDefinition, null);
                    break;
                }
                case "subindextext": 
                case "subindexcoltext": 
                case "subindexrowtext": 
                case "subindextext0": 
                case "subindextext1": 
                case "subindextext2": 
                case "subindextext3": 
                case "subindextext4": 
                case "subindextext5": 
                case "subindextext6": 
                case "subindextext7": {
                    RppProcCallDefFactory.addSubIndex(string2, l3, rppComponentDefinition, "@");
                    break;
                }
                case "subindexnumeric": 
                case "subindexcolnumeric": 
                case "subindexrownumeric": 
                case "subindexnumeric0": 
                case "subindexnumeric1": 
                case "subindexnumeric2": 
                case "subindexnumeric3": 
                case "subindexnumeric4": 
                case "subindexnumeric5": 
                case "subindexnumeric6": 
                case "subindexnumeric7": {
                    RppProcCallDefFactory.addSubIndex(string2, l3, rppComponentDefinition, "&");
                    break;
                }
                case "subindexrexexp": 
                case "subindexcolrecexp": 
                case "subindexrowregexp": 
                case "subindexrexexp0": 
                case "subindexrexexp1": 
                case "subindexrexexp2": 
                case "subindexrexexp3": 
                case "subindexrexexp4": 
                case "subindexrexexp5": 
                case "subindexrexexp6": 
                case "subindexrexexp7": {
                    RppProcCallDefFactory.addSubIndex(string2, l3, rppComponentDefinition, "%");
                    break;
                }
                case "scope": {
                    Object object2 = l3.f("scope");
                    if (object2 == null) continue block62;
                    rppComponentDefinition.setAncestor(RppProcCallDefFactory.createComponent(l3));
                    break;
                }
                default: {
                    if (string2.startsWith("subindexseparator")) continue block62;
                    string = RppProcCallDefFactory.addToConditionString(string2, l3.l(string2), string);
                }
            }
        }
        rppComponentDefinition.getCondition().setExpression(string);
        return rppComponentDefinition;
    }

    private static void addSubIndex(String string, l l2, RppComponentDefinition rppComponentDefinition, String string2) throws DataFormatException {
        int n2;
        String string3;
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addSubIndex(String,MetadataMap,RppComponentDefinition,String)", 478).addDetail("key", string)).addDetail("metadataComponent", (Object)l2)).addDetail("component", (Object)rppComponentDefinition)).addDetail("separator", string2)).log();
        }
        if ((string3 = l2.l(string)) == null) {
            return;
        }
        Object object = null;
        if ("subindex".equals(string)) {
            n2 = 0;
            object = "subindexseparator";
        } else if (string.startsWith("subindexcol")) {
            n2 = 0;
            object = "subindexcolseparator";
        } else if (string.startsWith("subindexrow")) {
            n2 = 1;
            object = "subindexrowseparator";
        } else {
            try {
                n2 = Integer.parseInt(string.substring(string.length() - 1));
                object = "subindexseparator" + n2;
            }
            catch (Exception exception) {
                n2 = -1;
            }
        }
        if (n2 != -1) {
            if (string2 == null) {
                string2 = l2.l((String)object);
            }
            if (string2 == null) {
                throw new DataFormatException(string + " " + String.valueOf((Object)a.a.b) + " subindexseparator" + n2);
            }
            rppComponentDefinition.setSubItemIndex(n2, string3, string2);
        }
    }

    private static void createAttributes(l l2, RppEventDefinition rppEventDefinition) throws DataFormatException {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createAttributes(MetadataMap,RppEventDefinition)", 524).addDetail("metadataEvent", (Object)l2)).addDetail("event", (Object)rppEventDefinition)).log();
        }
        if (l2 == null) {
            throw new IllegalArgumentException("metadataEvent is marked non-null but is null");
        }
        l l3 = l2.f("attributes");
        String string = "";
        if (l3 != null) {
            for (String string2 : l3.t()) {
                if ("component id".equals(string2)) {
                    rppEventDefinition.getComponent().setComponentAttribute(l3.l(string2));
                    continue;
                }
                if ("check type".equals(string2)) {
                    String string3 = l3.l("check type");
                    if ("your-type".equals(string3)) continue;
                    rppEventDefinition.setCheckType(string3);
                    continue;
                }
                string = RppProcCallDefFactory.addToConditionString(string2, l3.l(string2), string);
            }
        }
        rppEventDefinition.setAttributesCondition(new RppConditionDefinition().setExpression(string));
    }

    private static String addToConditionString(String string, @Nullable String string2, String string3) {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addToConditionString(String,String,String)", 555).addDetail("attribute", string)).addDetail("value", string2)).addDetail("condition", string3)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("attribute is marked non-null but is null");
        }
        if (string2 == null) {
            return string3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if ("true".equalsIgnoreCase(string2)) {
            stringBuilder.append("<").append(string).append(">");
        } else if ("false".equalsIgnoreCase(string2)) {
            stringBuilder.append("not ").append("<").append(string).append(">");
        } else {
            stringBuilder.append("\"<").append(string).append(">").append("\"==\"").append(string2).append("\"");
        }
        if (string3.isEmpty()) {
            return stringBuilder.toString();
        }
        return string3 + " and " + String.valueOf(stringBuilder);
    }

    static List createParameters(l l2) throws DataFormatException {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createParameters(MetadataMap)", 590).addDetail("metadataEvent", (Object)l2)).log();
        }
        ArrayList<RppParameterDefinition> arrayList = new ArrayList<RppParameterDefinition>();
        l l3 = l2.f("procedure call parameters");
        if (Misc.emptyOrNull((Object)l3)) {
            return arrayList;
        }
        for (b b2 : l3.s()) {
            RppParameterDefinition rppParameterDefinition;
            try {
                rppParameterDefinition = RppProcCallDefFactory.createParameter((l)b2);
            }
            catch (Exception exception) {
                throw new DataFormatException("your-parameter " + String.valueOf((Object)ErrorMessage.yamlmustbemaporstring));
            }
            arrayList.add(rppParameterDefinition);
        }
        return arrayList;
    }

    static RppParameterDefinition createParameter(l l2) {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createParameter(MetadataMap)", 613).addDetail("metadataParam", (Object)l2)).log();
        }
        RppParameterDefinition rppParameterDefinition = new RppParameterDefinition();
        if (Misc.emptyOrNull((Object)l2)) {
            return rppParameterDefinition;
        }
        rppParameterDefinition.setParameterName(l2.n());
        rppParameterDefinition.setParameterValue(l2.a("value", (String)null));
        rppParameterDefinition.setOverwriteOption(l2.a("overwrite option", "setifempty"));
        rppParameterDefinition.setSeparator(l2.a("separator", "|||"));
        return rppParameterDefinition;
    }

    static RppConditionDefinition createCondition(l l2) {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createCondition(MetadataMap)", 631).addDetail("metadataEvent", (Object)l2)).log();
        }
        RppConditionDefinition rppConditionDefinition = new RppConditionDefinition();
        if (!l2.e("condition")) {
            return rppConditionDefinition;
        }
        l l3 = l2.f("condition");
        if (Misc.emptyOrNull((Object)l3)) {
            return rppConditionDefinition;
        }
        return rppConditionDefinition;
    }

    static RppReturnValueDefinition createReturnVar(l l2) {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createReturnVar(MetadataMap)", 658).addDetail("metadataEvent", (Object)l2)).log();
        }
        RppReturnValueDefinition rppReturnValueDefinition = new RppReturnValueDefinition();
        if (!l2.e("variable for return value")) {
            return rppReturnValueDefinition;
        }
        l l3 = l2.f("variable for return value");
        if (Misc.emptyOrNull((Object)l3)) {
            return rppReturnValueDefinition;
        }
        rppReturnValueDefinition.setName(l3.l("variable name"));
        rppReturnValueDefinition.setLocal(l3.a("local variable", Options.cached_OPT_PREFER_LOCAL_VARIABLES));
        return rppReturnValueDefinition;
    }

    static List createDoctags(l l2) throws DataFormatException {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createDoctags(MetadataMap)", 686).addDetail("metadataEvent", (Object)l2)).log();
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        l l3 = l2.f("doctags");
        if (Misc.emptyOrNull((Object)l3)) {
            return arrayList;
        }
        for (String string : l3.t()) {
            try {
                String string2 = l3.l(string);
                String[] stringArray = new String[]{string, string2};
                arrayList.add(stringArray);
            }
            catch (Exception exception) {
                throw new DataFormatException("your-doctag-name '" + string + "' " + String.valueOf((Object)ErrorMessage.yamlmustbemaporstring));
            }
        }
        return arrayList;
    }

    static RppRepeatDefinition createRepeat(l l2, String string) {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createRepeat(MetadataMap,String)", 711).addDetail("metadataRepeat", (Object)l2)).addDetail("repeatType", string)).log();
        }
        RppRepeatDefinition rppRepeatDefinition = new RppRepeatDefinition();
        rppRepeatDefinition.setDefaults(string);
        if (Misc.emptyOrNull((Object)l2)) {
            return rppRepeatDefinition;
        }
        rppRepeatDefinition.setMin(l2.j("min").t());
        rppRepeatDefinition.setMax(l2.j("max").t());
        if ("repeat".equals(l2.n())) {
            rppRepeatDefinition.setCheckForOccurrencesBetweenRepeats(l2.a("allow anywhere events between repeats", false));
        }
        return rppRepeatDefinition;
    }

    static boolean rightPath(List list, String string) {
        if (RppProcCallDefFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "rightPath(List<Object>,String)", 821).addDetail("keyPath", (Object)list)).addDetail("firstKeyPathEntry", string)).log();
        }
        if (list == null) {
            throw new IllegalArgumentException("keyPath is marked non-null but is null");
        }
        return !list.isEmpty() && string.equals(list.get(0));
    }

    public static enum ErrorMessage {
        yamlmustbestring,
        yamlmustbemaporstring,
        rppclassesmustbearrayorstring;

    }

    public static enum properties {
        nodetype,
        classes,
        overwrite,
        anywhereeventsingroup,
        minrepeat,
        maxrepeat,
        allowanywhereeventsbetweenrepeats,
        returnvariable,
        returnvariablelocal,
        returnvariablename;

    }
}

