/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.record.procbuilder.RppDebug;
import de.qfs.apps.qftest.record.procbuilder.RppDebugEvent;
import de.qfs.lib.log.QFLogger;

public class RppRepeatDefinition {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.RppRepeatDefinition");
    protected static final int MAX_VALUE = 1000;
    private String type;
    private int min = 1;
    private int max = 1;
    private boolean checkForOccurrencesBetweenRepeats;
    private int currRepeat;

    protected RppRepeatDefinition() {
    }

    protected void setDefaults(String string) {
        this.type = string;
        if ("occurrences".equals(string)) {
            this.min = 0;
            this.max = 1000;
        } else {
            this.min = 1;
            this.max = 1;
        }
    }

    protected boolean maximumNotReached(RppDebug rppDebug, RppDebugEvent rppDebugEvent) {
        boolean bl2;
        boolean bl3 = bl2 = this.currRepeat < this.max;
        if (this.max != 1 && !bl2 && rppDebugEvent != null) {
            rppDebugEvent.setRepeatInfo(this.type + " maximum (" + this.max + ") reached");
            rppDebug.addCommentStep(this.type + " maximum (" + this.max + ") reached");
        }
        return bl2;
    }

    protected boolean minimumNotReached(RppDebug rppDebug, RppDebugEvent rppDebugEvent) {
        boolean bl2;
        boolean bl3 = bl2 = this.currRepeat < this.min;
        if ("repeat".equals(this.type) && this.min != 1 && bl2 && rppDebugEvent != null) {
            rppDebugEvent.setRepeatInfo("repeat minimum (" + this.min + ") not reached: only " + this.currRepeat + " repetition" + (this.currRepeat > 1 ? "s" : ""));
            rppDebug.addCommentStep("Not enough iterations of the step");
        }
        return bl2;
    }

    protected void increaseCounter() {
        ++this.currRepeat;
    }

    protected void initializeCounter() {
        this.currRepeat = 0;
    }

    protected String getCounterAsString() {
        return Integer.toString(this.currRepeat);
    }

    public String toString() {
        return this.getMin() + "-" + this.getMax();
    }

    public String getType() {
        return this.type;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isCheckForOccurrencesBetweenRepeats() {
        return this.checkForOccurrencesBetweenRepeats;
    }

    public int getCurrRepeat() {
        return this.currRepeat;
    }

    public RppRepeatDefinition setType(String string) {
        this.type = string;
        return this;
    }

    public RppRepeatDefinition setMin(int n2) {
        this.min = n2;
        return this;
    }

    public RppRepeatDefinition setMax(int n2) {
        this.max = n2;
        return this;
    }

    public RppRepeatDefinition setCheckForOccurrencesBetweenRepeats(boolean bl2) {
        this.checkForOccurrencesBetweenRepeats = bl2;
        return this;
    }

    public RppRepeatDefinition setCurrRepeat(int n2) {
        this.currRepeat = n2;
        return this;
    }
}

