/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.script.languages;

import de.qfs.apps.qftest.run.AbstractRunContext;
import de.qfs.apps.qftest.script.languages.ScriptLanguageFactoryServer;
import de.qfs.apps.qftest.shared.exceptions.JythonException;
import de.qfs.apps.qftest.shared.exceptions.ScriptException;
import de.qfs.apps.qftest.shared.exceptions.TestControlException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.CommonRunContext;
import de.qfs.apps.qftest.shared.io.b;
import de.qfs.apps.qftest.shared.script.g;
import de.qfs.apps.qftest.shared.script.p;
import de.qfs.apps.qftest.shared.variables.VariableData;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.MessageCollector;
import de.qfs.lib.util.Misc;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.python.Version;
import org.python.core.PyBoolean;

public class JythonScriptLanguage
extends ScriptLanguageFactoryServer {
    private static final QFLogger f = new QFLogger("de.qfs.apps.qftest.script.languages.JythonScriptLanguage");

    public JythonScriptLanguage() {
        if (JythonScriptLanguage.f.level >= 7) {
            f.lvlBuild(7, "JythonScriptLanguage()", 55).log();
        }
        this.c = new de.qfs.apps.qftest.shared.script.languages.JythonScriptLanguage();
        String string = Version.getVersion();
        if (JythonScriptLanguage.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "JythonScriptLanguage()", 61).add("pythonVersion", string)).log();
        }
    }

    public String getLanguageName() {
        if (JythonScriptLanguage.f.level >= 7) {
            f.lvlBuild(7, "getLanguageName()", 68).log();
        }
        return "Jython";
    }

    public String getInterpreterName() {
        if (JythonScriptLanguage.f.level >= 7) {
            f.lvlBuild(7, "getInterpreterName()", 77).log();
        }
        return "jython";
    }

    @Override
    public void startServer(b b2) {
        if (JythonScriptLanguage.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "startServer(FunnelledPipedWriter)", 86).addDetail("po", (Object)b2)).log();
        }
        new g(null, (Writer)b2);
    }

    @Override
    protected Pattern b() {
        if (JythonScriptLanguage.f.level >= 7) {
            f.lvlBuild(7, "getTerminalPattern()", 95).log();
        }
        return Pattern.compile("(>>>|\\.\\.\\.) ?");
    }

    @Override
    public Class getServerClass() {
        if (JythonScriptLanguage.f.level >= 7) {
            f.lvlBuild(7, "getServerClass()", 104).log();
        }
        return g.class;
    }

    @Override
    public void runScript(CommonRunContext commonRunContext, String string, String string2, String string3) throws TestException {
        if (JythonScriptLanguage.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "runScript(CommonRunContext,String,String,String)", 113).addDetail("rmiRunContext", (Object)commonRunContext)).addDetail("name", string)).addDetail("code", string2)).addDetail("file", string3)).log();
        }
        try {
            p.a().a(string2, (Object)commonRunContext, this.getInterpreterName(), string, string3);
        }
        catch (BSFException bSFException) {
            if (bSFException.getTargetException() instanceof TestControlException) {
                throw (TestControlException)bSFException.getTargetException();
            }
            if (bSFException.getReason() == BSFException.REASON_EXECUTION_ERROR && bSFException.getTargetException() != null) {
                throw new JythonException(bSFException.getTargetException());
            }
            throw new ScriptException(bSFException.getMessage(), bSFException.getTargetException() == null ? bSFException : bSFException.getTargetException());
        }
    }

    @Override
    public void setServerVariable(Object object) throws TestException {
        if (JythonScriptLanguage.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "setServerVariable(Object)", 134).addDetail("data", object)).log();
        }
        if (object == null) {
            throw new IllegalArgumentException("data is marked non-null but is null");
        }
        BSFManager bSFManager = p.a().c();
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(new String((byte[])object, Misc.UTF8_CHARSET));
            p.a().a(bSFManager, "jython", "import qfcommon\nqfcommon.unpickleAndStore", arrayList, "qfcommon.py");
        }
        catch (BSFException bSFException) {
            if (bSFException.getTargetException() instanceof TestControlException) {
                throw (TestControlException)bSFException.getTargetException();
            }
            if (bSFException.getReason() == BSFException.REASON_EXECUTION_ERROR && bSFException.getTargetException() != null) {
                if (JythonScriptLanguage.f.level >= 5) {
                    ((LevelAwareLogBuilder)f.lvlBuild(5, "setServerVariable(Object)", 153).add("ex.getTargetException()", (Object)bSFException.getTargetException())).log();
                }
                throw new JythonException(bSFException.getTargetException());
            }
            if (JythonScriptLanguage.f.level >= 5) {
                ((LevelAwareLogBuilder)f.lvlBuild(5, "setServerVariable(Object)", 156).add("ex", (Object)bSFException)).log();
            }
            throw new ScriptException(bSFException.getMessage(), bSFException.getTargetException() == null ? bSFException : bSFException.getTargetException());
        }
    }

    @Override
    public Object getServerVariable(String string) throws TestException {
        if (JythonScriptLanguage.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getServerVariable(String)", 166).addDetail("name", string)).log();
        }
        BSFManager bSFManager = p.a().c();
        String[] stringArray = new String[1];
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(string);
            arrayList.add(stringArray);
            p.a().a(bSFManager, "jython", "import qfcommon\nqfcommon.getvar", arrayList, "qfcommon.py");
            return stringArray[0].getBytes(Misc.UTF8_CHARSET);
        }
        catch (BSFException bSFException) {
            if (bSFException.getTargetException() instanceof TestControlException) {
                throw (TestControlException)bSFException.getTargetException();
            }
            if (bSFException.getReason() == BSFException.REASON_EXECUTION_ERROR && bSFException.getTargetException() != null) {
                if (JythonScriptLanguage.f.level >= 5) {
                    ((LevelAwareLogBuilder)f.lvlBuild(5, "getServerVariable(String)", 187).add("ex.getTargetException()", (Object)bSFException.getTargetException())).log();
                }
                throw new JythonException(bSFException.getTargetException());
            }
            if (JythonScriptLanguage.f.level >= 5) {
                ((LevelAwareLogBuilder)f.lvlBuild(5, "getServerVariable(String)", 190).add("ex", (Object)bSFException)).log();
            }
            throw new ScriptException(bSFException.getMessage(), bSFException.getTargetException() == null ? bSFException : bSFException.getTargetException());
        }
    }

    public Object runCode(String string, boolean bl2) throws TestException {
        if (JythonScriptLanguage.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "runCode(String,boolean)", 200).addDetail("code", string)).addDetail("async", bl2)).log();
        }
        BSFManager bSFManager = p.a().c();
        try {
            return bSFManager.eval("jython", "code", 0, 0, (Object)string);
        }
        catch (BSFException bSFException) {
            if (JythonScriptLanguage.f.level >= 3) {
                ((LevelAwareLogBuilder)f.lvlBuild(3, "runCode(String,boolean)", 206).add("e", (Object)bSFException)).log();
            }
            return null;
        }
    }

    @Override
    public boolean verifyCondition(String string, String string2, File file) {
        String string3;
        int n2;
        if (JythonScriptLanguage.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "verifyCondition(String,String,File)", 215).addDetail("nodeName", string)).addDetail("languageComment", string2)).addDetail("file", (Object)file)).log();
        }
        if ((n2 = (string3 = string2).toLowerCase().indexOf(this.getInterpreterName())) != -1) {
            BSFManager bSFManager;
            try {
                bSFManager = p.a().c();
            }
            catch (TestException testException) {
                if (JythonScriptLanguage.f.level >= 1) {
                    ((LevelAwareLogBuilder)f.lvlBuild(1, "verifyCondition(String,String,File)", 224).add("No BSF Manager")).log();
                }
                MessageCollector.instance().logFatalError("Jython not available.");
                return false;
            }
            string3 = string3.substring(n2 + this.getInterpreterName().length());
            try {
                Object object = bSFManager.eval("jython", "expression", 1, 0, (Object)string3);
                if (object != null) {
                    try {
                        int n3 = ((PyBoolean)object).getValue();
                        return n3 == 1;
                    }
                    catch (ClassCastException classCastException) {
                        if (JythonScriptLanguage.f.level >= 3) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "verifyCondition(String,String,File)", 240).add("e", (Object)classCastException)).add("Exception in Jython condition.")).log();
                        }
                        MessageCollector.instance().logFatalError("Jython error in condition for '" + string + "':\n " + classCastException.getMessage());
                        return false;
                    }
                }
            }
            catch (BSFException bSFException) {
                if (bSFException.getReason() == BSFException.REASON_EXECUTION_ERROR && bSFException.getTargetException() != null) {
                    if (JythonScriptLanguage.f.level >= 3) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "verifyCondition(String,String,File)", 248).add("ex.getTargetException()", (Object)bSFException.getTargetException())).add("Exception in Jython condition.")).log();
                    }
                    MessageCollector.instance().logFatalError("Jython error in condition for '" + string + "':\n " + bSFException.getMessage());
                    return false;
                }
                if (JythonScriptLanguage.f.level >= 3) {
                    if (JythonScriptLanguage.f.level >= 3) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "verifyCondition(String,String,File)", 254).add("ex.getTargetException() == null ? ex : ex.getTargetException()", (Object)(bSFException.getTargetException() == null ? bSFException : bSFException.getTargetException()))).add("Exception in Jython condition.")).log();
                    }
                    MessageCollector.instance().logFatalError("Jython error in condition for '" + string + "':\n " + bSFException.getMessage());
                }
                return false;
            }
        }
        if (JythonScriptLanguage.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "verifyCondition(String,String,File)", 263).add("Jython condition ok")).log();
        }
        return true;
    }

    @Override
    @Nullable
    public VariableData evalCode(String string, AbstractRunContext abstractRunContext) throws TestException {
        if (JythonScriptLanguage.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "evalCode(String,AbstractRunContext)", 279).addDetail("code", string)).addDetail("context", (Object)abstractRunContext)).log();
        }
        BSFManager bSFManager = p.a().c();
        TestException[] testExceptionArray = new TestException[1];
        Object[] objectArray = new Object[2];
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(objectArray);
            arrayList.add((Object)abstractRunContext);
            arrayList.add(string);
            arrayList.add(testExceptionArray);
            p.a().a(bSFManager, "jython", "qftest.evalscript", arrayList, "Expression");
        }
        catch (BSFException bSFException) {
            if (bSFException.getReason() == BSFException.REASON_EXECUTION_ERROR && bSFException.getTargetException() != null) {
                if (JythonScriptLanguage.f.level >= 5) {
                    ((LevelAwareLogBuilder)f.lvlBuild(5, "evalCode(String,AbstractRunContext)", 302).add("ex.getTargetException()", (Object)bSFException.getTargetException())).log();
                }
                throw new JythonException(bSFException.getTargetException());
            }
            if (JythonScriptLanguage.f.level >= 5) {
                ((LevelAwareLogBuilder)f.lvlBuild(5, "evalCode(String,AbstractRunContext)", 305).add("ex", (Object)bSFException)).log();
            }
            throw new ScriptException(bSFException.getMessage(), bSFException.getTargetException() == null ? bSFException : bSFException.getTargetException());
        }
        if (testExceptionArray[0] != null) {
            throw testExceptionArray[0];
        }
        return VariableData.fromInlineScriptResult((Object)objectArray[1], (String)Misc.toStringOrNull((Object)objectArray[0]));
    }

    public boolean isRelatedClassName(String string) {
        if (JythonScriptLanguage.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "isRelatedClassName(String)", 322).addDetail("callerClassName", string)).log();
        }
        return string.startsWith("org.python");
    }
}

