/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.suite.command;

import de.qfs.apps.qftest.base.TreeView;
import de.qfs.apps.qftest.base.command.ao;
import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.android.adb.AdbDevice;
import de.qfs.apps.qftest.shared.android.adb.AdbExecutionException;
import de.qfs.apps.qftest.shared.android.adb.AdbLocator;
import de.qfs.apps.qftest.shared.android.sdk.b;
import de.qfs.apps.qftest.shared.exceptions.AndroidAdbNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.InvalidAndroidAdbPathException;
import de.qfs.apps.qftest.suite.command.cx;
import de.qfs.apps.qftest.suite.command.cy;
import de.qfs.apps.qftest.t;
import de.qfs.lib.command.CommandException;
import de.qfs.lib.command.Invokable;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.ModalDialog;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Window;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

public class CommandViewRunningAndroidDevices
extends ao
implements Invokable {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.suite.command.CommandViewRunningAndroidDevices");
    private Frame d;

    public CommandViewRunningAndroidDevices(TreeView treeView) {
        super(treeView);
        if (CommandViewRunningAndroidDevices.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "CommandViewRunningAndroidDevices(TreeView)", 101).addDetail("view", (Object)treeView)).log();
        }
        this.d = treeView.s();
    }

    public Object invoke() throws CommandException {
        if (CommandViewRunningAndroidDevices.a.level >= 7) {
            a.lvlBuild(7, "invoke()", 116).log();
        }
        Dialog dialog = new Dialog(this.d);
        dialog.setVisible(true);
        return null;
    }

    private class Dialog
    extends ModalDialog {
        private JTable c;
        private DefaultTableModel d;
        private MapResourceBundle e;

        public Dialog(Frame frame) {
            super("", (Window)frame);
            if (CommandViewRunningAndroidDevices.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "Dialog.Dialog(Frame)", 161).addDetail("parent", (Object)frame)).log();
            }
            assert (SwingUtilities.isEventDispatchThread());
            this.e = Globals.getResources();
            String string = this.e.getString("runningAndroidDevices.dialog.title", "Running Android Devices");
            this.setTitle(string);
            Grid grid = new Grid();
            grid.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add((Component)grid);
            JLabel jLabel = new JLabel(this.e.getString("runningAndroidDevices.table.title", "Known Android Devices"));
            jLabel.setName("runningAndroidDevices.title");
            grid.add((Component)jLabel, 0.0);
            String string2 = this.e.getString("runningAndroidDevices.table.column1.text", "Name");
            String string3 = this.e.getString("runningAndroidDevices.table.column2.text", "State");
            this.d = new DefaultTableModel();
            this.d.addColumn(string2);
            this.d.addColumn(string3);
            this.c = new JTable(this.d);
            this.c.setName("runningAndroidDevices.table");
            Font font = this.c.getFont();
            FontMetrics fontMetrics = this.c.getFontMetrics(font);
            int n2 = Math.max(Misc.OS_IS_LINUX ? 18 : 16, fontMetrics.getHeight() + (Misc.OS_IS_MAC_OS_X ? 3 : 2));
            this.c.setRowHeight(n2);
            JScrollPane jScrollPane = new JScrollPane(this.c);
            jScrollPane.setName("runningAndroidDevices.scroll");
            jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
            grid.add((Component)jScrollPane, 1.0);
            JButton jButton = new JButton(this.e.getString("runningAndroidDevices.button.refresh.text", "Refresh"));
            jButton.setName("refreshBtn");
            jButton.setMnemonic('R');
            jButton.addActionListener(new cx(this, CommandViewRunningAndroidDevices.this));
            JButton jButton2 = new JButton(this.e.getString("runningAndroidDevices.button.close.text", "Close"));
            jButton2.setName("closeBtn");
            jButton2.setMnemonic('C');
            jButton2.addActionListener(new cy(this, CommandViewRunningAndroidDevices.this));
            grid.addLine(new Component[]{jButton, jButton2});
            this.b();
            this.setSize(800, 500);
            SwingUtil.centerWindow((Window)((Object)this));
        }

        public List a() {
            String string;
            Object object;
            if (CommandViewRunningAndroidDevices.a.level >= 7) {
                a.lvlBuild(7, "Dialog.getRunningDevicesAndState()", 231).log();
            }
            b b2 = de.qfs.apps.qftest.shared.android.sdk.b.f();
            LinkedList linkedList = b2.c();
            List list = new LinkedList();
            boolean bl2 = false;
            try {
                object = AdbLocator.instance().locateAdb();
                list = object.listDevices();
            }
            catch (AndroidAdbNotFoundException | InvalidAndroidAdbPathException throwable) {
                if (CommandViewRunningAndroidDevices.a.level >= 3) {
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "Dialog.getRunningDevicesAndState()", 242).add("Couldn't find adb path", (Object)throwable)).log();
                }
                if (Misc.OS_IS_MAC_OS_X && t.instance().isUsingSystemMenu()) {
                    Message.showMessage((Component)((Object)this), (String)"SUTSetup.android.sdkNotFoundMac");
                } else {
                    Message.showMessage((Component)((Object)this), (String)"SUTSetup.android.sdkNotFound");
                }
                bl2 = true;
            }
            catch (AdbExecutionException adbExecutionException) {
                if (CommandViewRunningAndroidDevices.a.level >= 3) {
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "Dialog.getRunningDevicesAndState()", 250).add("Error reading out running devices", (Object)adbExecutionException)).log();
                }
                bl2 = true;
            }
            object = new HashSet();
            LinkedList<Object[]> linkedList2 = new LinkedList<Object[]>();
            for (AdbDevice adbDevice : list) {
                String string2;
                String string3;
                string = adbDevice.getDeviceName();
                if (string == null) {
                    linkedList2.add(new Object[]{"?", "Error reading device name"});
                    continue;
                }
                if (string.startsWith("emulator-")) {
                    try {
                        string3 = adbDevice.getTelnetDevice().a();
                        string2 = adbDevice.getDeviceState();
                        linkedList2.add(new Object[]{string3, "Running emulator: " + string2});
                        ((HashSet)object).add(string3);
                    }
                    catch (Throwable throwable) {
                        linkedList2.add(new Object[]{"??? " + string + " ???", "Error reading the avd name of this emulator"});
                    }
                    continue;
                }
                try {
                    string3 = adbDevice.getDeviceSerialNumber();
                    string2 = adbDevice.getDeviceState();
                    linkedList2.add(new Object[]{string3, "Real device: " + string2});
                }
                catch (Throwable throwable) {
                    linkedList2.add(new Object[]{"??? " + string + " ???", "Error reading real device information"});
                }
            }
            for (AdbDevice adbDevice : linkedList) {
                string = adbDevice.a();
                if (string == null || ((HashSet)object).contains(string)) continue;
                linkedList2.add(new Object[]{string, bl2 ? "Emulator in unknown state (adb not found or error)" : "Stopped emulator"});
            }
            return linkedList2;
        }

        public void b() {
            if (CommandViewRunningAndroidDevices.a.level >= 7) {
                a.lvlBuild(7, "Dialog.refreshTable()", 293).log();
            }
            while (this.d.getRowCount() > 0) {
                this.d.removeRow(0);
            }
            for (Object[] objectArray : this.a()) {
                this.d.addRow(objectArray);
            }
        }
    }
}

