/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.base;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.UIManager;

public class SystemUtils {
    protected static final String OS_NAME = SystemUtils.getSystemProperty("os.name");
    protected static final String OS_VERSION = SystemUtils.getSystemProperty("os.version");
    protected static final String JAVA_VERSION = SystemUtils.getSystemProperty("java.version");
    public static final boolean IS_OS_LINUX = SystemUtils.startsWith(OS_NAME, "Linux") || SystemUtils.startsWith(OS_NAME, "LINUX");
    public static final boolean IS_OS_MAC = SystemUtils.startsWith(OS_NAME, "Mac OS");
    public static final boolean IS_OS_SOLARIS = SystemUtils.startsWith(OS_NAME, "Solaris");
    public static final boolean IS_OS_WINDOWS = SystemUtils.startsWith(OS_NAME, "Windows");
    public static final boolean IS_OS_WINDOWS_XP = SystemUtils.startsWith(OS_NAME, "Windows") && SystemUtils.startsWith(OS_VERSION, "5.1");
    public static final boolean IS_OS_WINDOWS_XP_64_BIT_OR_SERVER_2003 = SystemUtils.startsWith(OS_NAME, "Windows") && SystemUtils.startsWith(OS_VERSION, "5.2");
    public static final boolean IS_OS_WINDOWS_VISTA = SystemUtils.startsWith(OS_NAME, "Windows") && SystemUtils.startsWith(OS_VERSION, "6.0");
    public static final boolean IS_OS_WINDOWS_7 = SystemUtils.startsWith(OS_NAME, "Windows") && SystemUtils.startsWith(OS_VERSION, "6.1");
    public static final boolean IS_OS_WINDOWS_8 = SystemUtils.startsWith(OS_NAME, "Windows") && SystemUtils.startsWith(OS_VERSION, "6.2");
    public static final boolean IS_OS_WINDOWS_8_1 = SystemUtils.startsWith(OS_NAME, "Windows") && SystemUtils.startsWith(OS_VERSION, "6.3");
    public static final boolean IS_OS_WINDOWS_10 = SystemUtils.startsWith(OS_NAME, "Windows") && SystemUtils.startsWith(OS_VERSION, "6.4");
    public static final boolean IS_OS_WINDOWS_6_OR_LATER = SystemUtils.startsWith(OS_NAME, "Windows") && (SystemUtils.startsWith(OS_VERSION, "6.") || SystemUtils.startsWith(OS_VERSION, "10."));
    public static final boolean IS_OS_WINDOWS_LUNA = IS_OS_WINDOWS_XP || IS_OS_WINDOWS_XP_64_BIT_OR_SERVER_2003;
    public static final boolean IS_OS_WINDOWS_AERO = IS_OS_WINDOWS_VISTA || IS_OS_WINDOWS_7;
    public static final boolean IS_OS_WINDOWS_METRO = IS_OS_WINDOWS_8 || IS_OS_WINDOWS_8_1 || IS_OS_WINDOWS_10;
    public static final boolean IS_JAVA_7 = SystemUtils.startsWith(JAVA_VERSION, "1.7");
    public static final boolean IS_JAVA_8 = SystemUtils.startsWith(JAVA_VERSION, "1.8");
    public static final boolean IS_JAVA_8_OR_LATER = !IS_JAVA_7;
    public static final boolean IS_JAVA_9 = SystemUtils.startsWith(JAVA_VERSION, "1.9");
    public static final boolean IS_LAF_WINDOWS_XP_ENABLED = SystemUtils.isWindowsXPLafEnabled();
    public static final boolean IS_LOW_RESOLUTION = SystemUtils.isLowResolution();

    public static boolean isLafAqua() {
        return UIManager.getLookAndFeel().getID().equals("Aqua");
    }

    protected SystemUtils() {
    }

    protected static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            Logger.getLogger(SystemUtils.class.getName()).warning("Can't access the System property " + key + ".");
            return "";
        }
    }

    protected static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    private static boolean isWindowsXPLafEnabled() {
        return IS_OS_WINDOWS && Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) && SystemUtils.getSystemProperty("swing.noxp") == null;
    }

    private static boolean isLowResolution() {
        try {
            return Toolkit.getDefaultToolkit().getScreenResolution() < 120;
        }
        catch (HeadlessException e) {
            return true;
        }
    }
}

