/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.Fonts;
import com.jgoodies.looks.LookUtils;
import java.awt.Font;
import java.lang.reflect.Method;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;

public final class FontPolicies {
    private FontPolicies() {
    }

    public static FontPolicy createFixedPolicy(FontSet fontSet) {
        return new FixedPolicy(fontSet);
    }

    public static FontPolicy customSettingsPolicy(FontPolicy fontPolicy) {
        return new CustomSettingsPolicy(fontPolicy);
    }

    public static FontPolicy getDefaultPlasticOnWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    public static FontPolicy getDefaultPlasticPolicy() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return FontPolicies.getDefaultPlasticOnWindowsPolicy();
        }
        return FontPolicies.getLogicalFontsPolicy();
    }

    public static FontPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    public static FontPolicy getLogicalFontsPolicy() {
        return FontPolicies.createFixedPolicy(FontSets.getLogicalFontSet());
    }

    private static FontSet getCustomFontSet(String string) {
        String string2 = string + ".controlFont";
        String string3 = string + ".menuFont";
        String string4 = LookUtils.getSystemProperty(string2);
        if (string4 == null) {
            return null;
        }
        Font font = Font.decode(string4);
        String string5 = LookUtils.getSystemProperty(string3);
        Font font2 = string5 != null ? Font.decode(string5) : null;
        Font font3 = "Plastic".equals(string) ? font.deriveFont(1) : font;
        return FontSets.createDefaultFontSet(font, font2, font3);
    }

    private static FontPolicy getCustomPolicy(String string) {
        return null;
    }

    private static final class FixedPolicy
    implements FontPolicy {
        private final FontSet fontSet;

        FixedPolicy(FontSet fontSet) {
            this.fontSet = fontSet;
        }

        @Override
        public FontSet getFontSet(String string, UIDefaults uIDefaults) {
            return this.fontSet;
        }
    }

    private static class DefaultWindowsPolicy
    implements FontPolicy {
        private static final String FONT_UTILITIES_CLASS_NAME = "sun.font.FontUtilities";

        private DefaultWindowsPolicy() {
        }

        @Override
        public FontSet getFontSet(String string, UIDefaults uIDefaults) {
            Font font = Fonts.getWindowsControlFont();
            Font font2 = DefaultWindowsPolicy.lookUpControlFont(font, uIDefaults);
            Font font3 = uIDefaults == null ? font2 : uIDefaults.getFont("Menu.font");
            Font font4 = font2;
            Font font5 = uIDefaults == null ? font2 : uIDefaults.getFont("OptionPane.font");
            Font font6 = uIDefaults == null ? font2.deriveFont(font2.getSize2D() - 2.0f) : uIDefaults.getFont("ToolTip.font");
            Font font7 = uIDefaults == null ? font2 : uIDefaults.getFont("InternalFrame.titleFont");
            return FontSets.createDefaultFontSet(font2, font3, font4, font5, font6, font7);
        }

        private static Font lookUpControlFont(Font font, UIDefaults uIDefaults) {
            Preconditions.checkNotNull(font, "The %s must not be null.", "Windows control font");
            Font font2 = DefaultWindowsPolicy.adjustSizeIfNecessary(font, uIDefaults);
            if (DefaultWindowsPolicy.fontSupportsDefaultEncoding(font2)) {
                return font2;
            }
            FontUIResource fontUIResource = DefaultWindowsPolicy.getCompositeFontUIResource(font2);
            return fontUIResource != null ? fontUIResource : font2;
        }

        private static Font adjustSizeIfNecessary(Font font, UIDefaults uIDefaults) {
            if (uIDefaults == null) {
                return font;
            }
            Font font2 = uIDefaults.getFont("Button.font");
            if (font2 != null && font2.getName().equals(font.getName())) {
                if (font2.getSize() == font.getSize() || font2.getStyle() == font.getStyle()) {
                    return font2;
                }
                return font2.deriveFont(font.getStyle(), font.getSize2D());
            }
            return font;
        }

        private static boolean fontSupportsDefaultEncoding(Font font) {
            try {
                Method method = Class.forName(FONT_UTILITIES_CLASS_NAME).getMethod("fontSupportsDefaultEncoding", Font.class);
                if (method != null) {
                    return (Boolean)method.invoke(null, font);
                }
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }

        private static FontUIResource getCompositeFontUIResource(Font font) {
            try {
                Method method = Class.forName(FONT_UTILITIES_CLASS_NAME).getMethod("getCompositeFontUIResource", Font.class);
                if (method != null) {
                    return (FontUIResource)method.invoke(null, font);
                }
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static final class CustomSettingsPolicy
    implements FontPolicy {
        private final FontPolicy wrappedPolicy;

        CustomSettingsPolicy(FontPolicy fontPolicy) {
            this.wrappedPolicy = fontPolicy;
        }

        @Override
        public FontSet getFontSet(String string, UIDefaults uIDefaults) {
            FontPolicy fontPolicy = FontPolicies.getCustomPolicy(string);
            if (fontPolicy != null) {
                return fontPolicy.getFontSet(null, uIDefaults);
            }
            FontSet fontSet = FontPolicies.getCustomFontSet(string);
            if (fontSet != null) {
                return fontSet;
            }
            return this.wrappedPolicy.getFontSet(string, uIDefaults);
        }
    }
}

