/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class LookUtils
extends SystemUtils {
    private static boolean loggingEnabled = true;

    private LookUtils() {
    }

    public static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            LookUtils.log("Can't read the System property " + string + ".");
            return null;
        }
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            LookUtils.log("Can't read the System property " + string + ".");
            return string2;
        }
    }

    public static Boolean getBooleanSystemProperty(String string, String string2) {
        Boolean bl;
        String string3;
        switch (string3 = LookUtils.getSystemProperty(string, "").toLowerCase()) {
            case "false": {
                bl = Boolean.FALSE;
                break;
            }
            case "true": {
                bl = Boolean.TRUE;
                break;
            }
            default: {
                bl = null;
            }
        }
        if (bl != null) {
            LookUtils.log(string2 + " have been " + (bl != false ? "en" : "dis") + "abled in the system properties.");
        }
        return bl;
    }

    public static boolean isTrueColor(Component component) {
        return component.getToolkit().getColorModel().getPixelSize() >= 24;
    }

    public static boolean getToolkitUsesNativeDropShadows() {
        return IS_OS_MAC;
    }

    public static Color getSlightlyBrighter(Color color) {
        return LookUtils.getSlightlyBrighter(color, 1.1f);
    }

    public static Color getSlightlyBrighter(Color color, float f) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = Math.min(f4 * f, 1.0f);
        return Color.getHSBColor(f2, f3, f5);
    }

    public static void setLookAndTheme(LookAndFeel lookAndFeel, Object object) throws UnsupportedLookAndFeelException {
        if (lookAndFeel instanceof PlasticLookAndFeel && object != null && object instanceof PlasticTheme) {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)object);
        }
        UIManager.setLookAndFeel(lookAndFeel);
    }

    public static PlasticTheme getDefaultTheme(LookAndFeel lookAndFeel) {
        return lookAndFeel instanceof PlasticLookAndFeel ? PlasticLookAndFeel.createMyDefaultTheme() : null;
    }

    public static List<PlasticTheme> getInstalledThemes(LookAndFeel lookAndFeel) {
        return lookAndFeel instanceof PlasticLookAndFeel ? PlasticLookAndFeel.getInstalledThemes() : Collections.EMPTY_LIST;
    }

    public static void setLoggingEnabled(boolean bl) {
        loggingEnabled = bl;
    }

    public static void log() {
        if (loggingEnabled) {
            System.out.println();
        }
    }

    public static void log(String string) {
        if (loggingEnabled) {
            System.out.println("JGoodies Looks: " + string);
        }
    }
}

