/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;

public final class ExtBasicPopupMenuSeparatorUI
extends BasicPopupMenuSeparatorUI {
    private static final int SEPARATOR_HEIGHT = 2;
    private Insets insets;
    private static ComponentUI popupMenuSeparatorUI;

    public static ComponentUI createUI(JComponent jComponent) {
        if (popupMenuSeparatorUI == null) {
            popupMenuSeparatorUI = new ExtBasicPopupMenuSeparatorUI();
        }
        return popupMenuSeparatorUI;
    }

    @Override
    protected void installDefaults(JSeparator jSeparator) {
        super.installDefaults(jSeparator);
        this.insets = UIManager.getInsets("PopupMenuSeparator.margin");
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        int n = this.insets.top;
        int n2 = this.insets.left;
        int n3 = this.insets.right;
        graphics.setColor(UIManager.getColor("MenuItem.background"));
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.translate(0, n);
        graphics.setColor(jComponent.getForeground());
        graphics.drawLine(n2, 0, dimension.width - n3, 0);
        graphics.setColor(jComponent.getBackground());
        graphics.drawLine(n2, 1, dimension.width - n3, 1);
        graphics.translate(0, -n);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(0, this.insets.top + 2 + this.insets.bottom);
    }
}

