/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.decoration.internal;

import com.jgoodies.common.base.Strings;
import com.jgoodies.looks.decoration.internal.MyFontUtilities;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.text.AttributedString;
import javax.swing.JComponent;

public final class MySwingUtilities2 {
    private static final int CHAR_BUFFER_SIZE = 100;
    private static final Object charsBufferLock = new Object();
    private static char[] charsBuffer = new char[100];
    private static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);

    private MySwingUtilities2() {
    }

    public static int stringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) {
        if (Strings.isBlank(string)) {
            return 0;
        }
        return fontMetrics.stringWidth(string);
    }

    public static String clipStringIfNecessary(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = MySwingUtilities2.stringWidth(jComponent, fontMetrics, string);
        if (n2 > n) {
            return MySwingUtilities2.clipString(jComponent, fontMetrics, string, n);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String clipString(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        String string2 = "...";
        int n2 = string.length();
        if ((n -= MySwingUtilities2.stringWidth(jComponent, fontMetrics, string2)) <= 0) {
            return string2;
        }
        boolean bl = false;
        Object object = charsBufferLock;
        synchronized (object) {
            if (charsBuffer == null || charsBuffer.length < n2) {
                charsBuffer = string.toCharArray();
            } else {
                string.getChars(0, n2, charsBuffer, 0);
            }
            bl = MySwingUtilities2.isComplexLayout(charsBuffer, 0, n2);
            if (!bl) {
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    if ((n3 += fontMetrics.charWidth(charsBuffer[i])) <= n) continue;
                    string = string.substring(0, i);
                    break;
                }
            }
        }
        if (bl) {
            object = MySwingUtilities2.getFontRenderContext(jComponent, fontMetrics);
            AttributedString attributedString = new AttributedString(string);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), (FontRenderContext)object);
            int n4 = lineBreakMeasurer.nextOffset(n);
            string = string.substring(0, n4);
        }
        return string + string2;
    }

    private static final boolean isComplexLayout(char[] cArray, int n, int n2) {
        return MyFontUtilities.isComplexText(cArray, n, n2);
    }

    private static FontRenderContext getFontRenderContext(Component component, FontMetrics fontMetrics) {
        assert (fontMetrics != null || component != null);
        return fontMetrics != null ? fontMetrics.getFontRenderContext() : MySwingUtilities2.getFontRenderContext(component);
    }

    private static FontRenderContext getFontRenderContext(Component component) {
        assert (component != null);
        if (component == null) {
            return DEFAULT_FRC;
        }
        return component.getFontMetrics(component.getFont()).getFontRenderContext();
    }
}

