/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.ActiveBasicButtonListener;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalButtonUI;

public class PlasticButtonUI
extends MetalButtonUI {
    private static final PlasticButtonUI INSTANCE = new PlasticButtonUI();
    private boolean borderPaintsFocus;
    private Insets focusInsets;

    public static ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    @Override
    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        this.borderPaintsFocus = Boolean.TRUE.equals(UIManager.get(this.getPropertyPrefix() + "borderPaintsFocus"));
        this.focusInsets = UIManager.getInsets(this.getPropertyPrefix() + "focusInsets");
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new ActiveBasicButtonListener(abstractButton);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            if (this.isToolBarButton(abstractButton)) {
                jComponent.setOpaque(false);
            } else if (abstractButton.isContentAreaFilled()) {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                if (this.is3D(abstractButton)) {
                    Rectangle rectangle = new Rectangle(1, 1, jComponent.getWidth() - 2, jComponent.getHeight() - 1);
                    PlasticUtils.add3DEffekt(graphics, rectangle);
                }
            }
        }
        this.paint(graphics, jComponent);
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (this.borderPaintsFocus) {
            return;
        }
        int n = this.focusInsets.left;
        int n2 = this.focusInsets.top;
        int n3 = abstractButton.getWidth() - n - this.focusInsets.right;
        int n4 = abstractButton.getHeight() - n2 - this.focusInsets.bottom;
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, n, n2, n3, n4);
    }

    protected boolean isToolBarButton(AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    protected boolean is3D(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        return PlasticUtils.is3D("Button.") && abstractButton.isBorderPainted() && buttonModel.isEnabled() && (!buttonModel.isPressed() || !buttonModel.isArmed());
    }
}

