/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.PopupMenuLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public final class PlasticPopupMenuUI
extends BasicPopupMenuUI {
    private PropertyChangeListener borderListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticPopupMenuUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.installBorder();
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new PopupMenuLayout(this.popupMenu, 1));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.borderListener = new BorderStyleChangeHandler();
        this.popupMenu.addPropertyChangeListener("JPopupMenu.noMargin", this.borderListener);
    }

    @Override
    protected void uninstallListeners() {
        this.popupMenu.removePropertyChangeListener("JPopupMenu.noMargin", this.borderListener);
        super.uninstallListeners();
    }

    private void installBorder() {
        boolean bl = Boolean.TRUE.equals(this.popupMenu.getClientProperty("JPopupMenu.noMargin"));
        String string = bl ? "noMarginBorder" : "border";
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu." + string);
    }

    private final class BorderStyleChangeHandler
    implements PropertyChangeListener {
        private BorderStyleChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PlasticPopupMenuUI.this.installBorder();
        }
    }
}

