/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticArrowButton;
import com.jgoodies.looks.plastic.PlasticBumps;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public final class PlasticScrollBarUI
extends MetalScrollBarUI {
    private static final String PROPERTY_PREFIX = "ScrollBar.";
    public static final String MAX_BUMPS_WIDTH_KEY = "ScrollBar.maxBumpsWidth";
    private Color shadowColor;
    private Color highlightColor;
    private Color darkShadowColor;
    private Color thumbColor;
    private Color thumbShadow;
    private Color thumbHighlightColor;
    private PlasticBumps bumps;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.bumps = new PlasticBumps(10, 10, this.thumbHighlightColor, this.thumbShadow, this.thumbColor);
    }

    @Override
    protected JButton createDecreaseButton(int n) {
        this.decreaseButton = new PlasticArrowButton(n, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int n) {
        this.increaseButton = new PlasticArrowButton(n, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        this.shadowColor = UIManager.getColor("ScrollBar.shadow");
        this.highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.translate(rectangle.x, rectangle.y);
        boolean bl = PlasticUtils.isLeftToRight(jComponent);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!bl) {
                    ++rectangle.width;
                    graphics.translate(-1, 0);
                } else {
                    rectangle.width += 2;
                }
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(this.darkShadowColor);
                graphics.drawLine(0, 0, 0, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 2, 0, rectangle.width - 2, rectangle.height - 1);
                graphics.drawLine(1, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                graphics.drawLine(1, 0, rectangle.width - 2, 0);
                graphics.setColor(this.shadowColor);
                graphics.drawLine(1, 1, 1, rectangle.height - 2);
                graphics.drawLine(1, 1, rectangle.width - 3, 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int n = this.thumbRect.y + this.thumbRect.height - rectangle.y;
                    graphics.drawLine(1, n, rectangle.width - 1, n);
                }
                graphics.setColor(this.highlightColor);
                graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            } else {
                PlasticUtils.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.isFreeStanding) {
                if (!bl) {
                    --rectangle.width;
                    graphics.translate(1, 0);
                } else {
                    rectangle.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(this.darkShadowColor);
                graphics.drawLine(0, 0, rectangle.width - 1, 0);
                graphics.drawLine(0, 1, 0, rectangle.height - 2);
                graphics.drawLine(0, rectangle.height - 2, rectangle.width - 1, rectangle.height - 2);
                graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 1);
                graphics.setColor(this.shadowColor);
                graphics.drawLine(1, 1, rectangle.width - 2, 1);
                graphics.drawLine(1, 1, 1, rectangle.height - 3);
                graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int n = this.thumbRect.x + this.thumbRect.width - rectangle.x;
                    graphics.drawLine(n, 1, n, rectangle.height - 1);
                }
            } else {
                PlasticUtils.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!jComponent.isEnabled()) {
            return;
        }
        boolean bl = PlasticUtils.isLeftToRight(jComponent);
        graphics.translate(rectangle.x, rectangle.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!bl) {
                    ++rectangle.width;
                    graphics.translate(-1, 0);
                } else {
                    rectangle.width += 2;
                }
            }
            graphics.setColor(this.thumbColor);
            graphics.fillRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(this.thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(this.thumbHighlightColor);
            graphics.drawLine(1, 1, rectangle.width - 3, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 2);
            this.paintBumps(graphics, jComponent, 3, 4, rectangle.width - 6, rectangle.height - 7);
            if (!this.isFreeStanding) {
                if (!bl) {
                    --rectangle.width;
                    graphics.translate(1, 0);
                } else {
                    rectangle.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            graphics.setColor(this.thumbColor);
            graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(this.thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(this.thumbHighlightColor);
            graphics.drawLine(1, 1, rectangle.width - 2, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 3);
            this.paintBumps(graphics, jComponent, 4, 3, rectangle.width - 7, rectangle.height - 6);
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
        if (PlasticUtils.is3D(PROPERTY_PREFIX)) {
            this.paintThumb3D(graphics, rectangle);
        }
    }

    private void paintBumps(Graphics graphics, JComponent jComponent, int n, int n2, int n3, int n4) {
        if (!PlasticScrollBarUI.useNarrowBumps()) {
            this.bumps.setBumpArea(n3, n4);
            this.bumps.paintIcon(jComponent, graphics, n, n2);
        } else {
            int n5 = UIManager.getInt(MAX_BUMPS_WIDTH_KEY);
            int n6 = Math.min(n5, n3);
            int n7 = Math.min(n5, n4);
            int n8 = n + (n3 - n6) / 2;
            int n9 = n2 + (n4 - n7) / 2;
            this.bumps.setBumpArea(n6, n7);
            this.bumps.paintIcon(jComponent, graphics, n8, n9);
        }
    }

    private void paintThumb3D(Graphics graphics, Rectangle rectangle) {
        boolean bl = this.scrollbar.getOrientation() == 0;
        int n = rectangle.width - (bl ? 3 : 1);
        int n2 = rectangle.height - (bl ? 1 : 3);
        Rectangle rectangle2 = new Rectangle(rectangle.x + 2, rectangle.y + 2, n, n2);
        PlasticUtils.addLight3DEffekt(graphics, rectangle2, bl);
    }

    private static boolean useNarrowBumps() {
        return UIManager.get(MAX_BUMPS_WIDTH_KEY) instanceof Integer;
    }
}

