/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, FontDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public boolean getEffectsVisible() {
        return false;
    }

    @Deprecated
    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        Object[] objectArray;
        boolean bl;
        Object object;
        long l;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l2 = GTK.gtk_font_chooser_dialog_new((byte[])byArray, (long)0L);
        if (this.parent != null) {
            l = this.parent.topHandle();
            GTK.gtk_window_set_transient_for((long)l2, (long)l);
        }
        l = GTK.gtk_window_get_group((long)0L);
        GTK.gtk_window_group_add_window((long)l, (long)l2);
        GTK.gtk_window_set_modal((long)l2, (boolean)true);
        if (this.fontData != null) {
            object = new Font((Device)display, this.fontData);
            long l3 = OS.pango_font_description_to_string(object.handle);
            int n = C.strlen((long)l3);
            byte[] byArray2 = new byte[n + 1];
            C.memmove((byte[])byArray2, (long)l3, (long)n);
            object.dispose();
            OS.g_free(l3);
            GTK.gtk_font_chooser_set_font((long)l2, (byte[])byArray2);
        }
        display.runDialogShownHooks(this, l2);
        display.addIdleProc();
        object = null;
        if (GTK.gtk_window_get_modal((long)l2)) {
            object = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        long l4 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l4 = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l2, 0L);
        }
        display.sendPreExternalEventDispatchEvent();
        int n2 = GTK.gtk_dialog_run((long)l2);
        GDK.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l4);
        }
        if (GTK.gtk_window_get_modal((long)l2)) {
            display.setModalDialog((Dialog)object);
        }
        boolean bl2 = bl = n2 == -5;
        if (bl) {
            long l5 = GTK.gtk_font_chooser_get_font((long)l2);
            int n3 = C.strlen((long)l5);
            byte[] byArray3 = new byte[n3 + 1];
            C.memmove((byte[])byArray3, (long)l5, (long)n3);
            OS.g_free(l5);
            long l6 = OS.pango_font_description_from_string(byArray3);
            Font font = Font.gtk_new((Device)display, (long)l6);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(l6);
        }
        if (bl) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = this.fontData;
            objectArray = objectArray2;
            objectArray2[1] = null;
        } else {
            objectArray = null;
        }
        Object[] objectArray3 = (Object[])display.runDialogClosedHooks(this, objectArray);
        if (objectArray3 != null) {
            this.fontData = (FontData)objectArray3[0];
            this.rgb = (RGB)objectArray3[1];
            bl = true;
        }
        display.removeIdleProc();
        GTK.gtk_widget_destroy((long)l2);
        if (!bl) {
            return null;
        }
        return this.fontData;
    }

    public void setEffectsVisible(boolean bl) {
    }

    @Deprecated
    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

