/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import com.jidesoft.swing.CheckBoxListWithSelectable;
import com.jidesoft.swing.DefaultSelectable;
import com.jidesoft.swing.NullCheckBox;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.swing.Resource;
import com.jidesoft.swing.Selectable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class CheckBoxListCellRenderer
extends JPanel
implements ListCellRenderer,
Serializable {
    private static final long serialVersionUID = 2003073492549917883L;
    protected AbstractButton _checkBox = new NullCheckBox();
    protected JLabel _label = new NullLabel();
    protected ListCellRenderer _actualListRenderer;

    public CheckBoxListCellRenderer(ListCellRenderer renderer) {
        this._checkBox.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this._checkBox.setOpaque(false);
        this.setOpaque(true);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._checkBox, "Before");
        this._actualListRenderer = renderer;
    }

    public CheckBoxListCellRenderer() {
        this((ListCellRenderer)null);
    }

    public ListCellRenderer getActualListRenderer() {
        return this._actualListRenderer;
    }

    public void setActualListRenderer(ListCellRenderer actualListRenderer) {
        this._actualListRenderer = actualListRenderer;
    }

    public String getToolTipText(MouseEvent event) {
        if (this._actualListRenderer instanceof JComponent) {
            Point p = event.getPoint();
            p.translate(-this._checkBox.getWidth(), 0);
            MouseEvent newEvent = new MouseEvent((JComponent)((Object)this._actualListRenderer), event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
            String tip = ((JComponent)((Object)this._actualListRenderer)).getToolTipText(newEvent);
            if (tip != null) {
                return tip;
            }
        }
        return super.getToolTipText(event);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Object actualValue;
        this.applyComponentOrientation(list.getComponentOrientation());
        this.setLocale(list.getLocale());
        if (list instanceof CheckBoxList) {
            CheckBoxListSelectionModel selectionModel = ((CheckBoxList)list).getCheckBoxListSelectionModel();
            if (selectionModel != null) {
                boolean enabled;
                boolean bl = enabled = list.isEnabled() && ((CheckBoxList)list).isCheckBoxEnabled() && ((CheckBoxList)list).isCheckBoxEnabled(index);
                if (!enabled && !isSelected && this.getBackground() != null) {
                    this.setForeground(this.getBackground().darker());
                }
                this._checkBox.setEnabled(enabled);
                this._checkBox.setSelected(selectionModel.isSelectedIndex(index));
            }
            actualValue = value;
        } else if (list instanceof CheckBoxListWithSelectable) {
            boolean enabled;
            if (value instanceof Selectable) {
                this._checkBox.setSelected(((Selectable)value).isSelected());
                boolean bl = enabled = list.isEnabled() && ((Selectable)value).isEnabled() && ((CheckBoxListWithSelectable)list).isCheckBoxEnabled();
                if (!enabled && !isSelected) {
                    this.setForeground(this.getBackground().darker());
                }
                this._checkBox.setEnabled(enabled);
            } else {
                enabled = list.isEnabled();
                if (!enabled && !isSelected) {
                    this.setForeground(this.getBackground().darker());
                }
                this._checkBox.setEnabled(enabled);
            }
            actualValue = value instanceof DefaultSelectable ? ((DefaultSelectable)value).getObject() : value;
        } else {
            throw new IllegalArgumentException("CheckBoxListCellRenderer should only be used for CheckBoxList.");
        }
        if (this._actualListRenderer != null) {
            JComponent listCellRendererComponent = (JComponent)this._actualListRenderer.getListCellRendererComponent(list, actualValue, index, isSelected, cellHasFocus);
            if (listCellRendererComponent instanceof JLabel) {
                String v = this.convertElementToString(this.getLocale(), ((JLabel)listCellRendererComponent).getText());
                ((JLabel)listCellRendererComponent).setText(v);
            }
            if (list instanceof CheckBoxListWithSelectable && !((CheckBoxListWithSelectable)list).isCheckBoxVisible(index)) {
                return listCellRendererComponent;
            }
            if (list instanceof CheckBoxList && !((CheckBoxList)list).isCheckBoxVisible(index)) {
                return listCellRendererComponent;
            }
            Border border = listCellRendererComponent.getBorder();
            this.setBorder(border);
            listCellRendererComponent.setBorder(BorderFactory.createEmptyBorder());
            if (this.getComponentCount() == 2) {
                this.remove(1);
            }
            this.add(listCellRendererComponent);
            this.setBackground(listCellRendererComponent.getBackground());
            listCellRendererComponent.setBackground(null);
            this.setForeground(listCellRendererComponent.getForeground());
            listCellRendererComponent.setForeground(null);
            listCellRendererComponent.setEnabled(this._checkBox.isEnabled());
        } else {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (this.getComponentCount() == 2) {
                this.remove(1);
            }
            this.add(this._label);
            this.customizeDefaultCellRenderer(actualValue);
            this.setFont(list.getFont());
        }
        return this;
    }

    private String convertElementToString(Locale locale, Object value) {
        if (CheckBoxList.ALL_ENTRY.equals(value) || "(All)".equals(value)) {
            return Resource.getResourceBundle(locale).getString("CheckBoxList.all");
        }
        return value == null ? "" : value.toString();
    }

    protected void customizeDefaultCellRenderer(Object value) {
        if (value instanceof Icon) {
            this._label.setIcon((Icon)value);
            this._label.setText("");
        } else {
            this._label.setIcon(null);
            this._label.setText(this.convertElementToString(this.getLocale(), value));
        }
    }

    public static class UIResource
    extends CheckBoxListCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

