/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.LegacyCheckBoxTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyCheckBoxTreeSelectionModel
extends DefaultTreeSelectionModel
implements TreeModelListener {
    private TreeModel _model;
    private boolean _digIn = true;
    private LegacyCheckBoxTree _tree;
    protected Set<TreePath> _pathHasAdded;
    private boolean _singleEventMode = false;
    private static final long serialVersionUID = 1368502059666946634L;
    private boolean _fireEvent = true;
    private boolean _batchMode = false;
    private Set<TreePath> _toBeAdded = new HashSet<TreePath>();
    private Set<TreePath> _toBeRemoved = new HashSet<TreePath>();

    public LegacyCheckBoxTreeSelectionModel(TreeModel model) {
        this.setModel(model);
        this.setSelectionMode(4);
    }

    void setTree(LegacyCheckBoxTree tree) {
        this._tree = tree;
    }

    public LegacyCheckBoxTreeSelectionModel(TreeModel model, boolean digIn) {
        this.setModel(model);
        this._digIn = digIn;
    }

    public TreeModel getModel() {
        return this._model;
    }

    public void setModel(TreeModel model) {
        if (this._model != model) {
            if (this._model != null) {
                this._model.removeTreeModelListener(this);
            }
            this._model = model;
            if (this._model != null) {
                this._model.addTreeModelListener(this);
            }
        }
    }

    public boolean isDigIn() {
        return this._digIn;
    }

    public void setDigIn(boolean digIn) {
        this._digIn = digIn;
    }

    public boolean isPartiallySelected(TreePath path) {
        if (!this.isDigIn()) {
            return this.isPathSelected(path, false);
        }
        if (this.isPathSelected(path, true)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths == null) {
            return false;
        }
        for (TreePath selectionPath : selectionPaths) {
            if (!this.isDescendant(selectionPath, path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRowSelected(int row) {
        return this.isPathSelected(this._tree.getPathForRow(row), this._tree.isDigIn());
    }

    protected boolean isParentActuallySelected(TreePath path, TreePath parent) {
        return true;
    }

    public boolean isPathSelected(TreePath path, boolean digIn) {
        TreePath parent;
        if (path == null) {
            return false;
        }
        if (!digIn) {
            return super.isPathSelected(path);
        }
        for (parent = path; parent != null && !super.isPathSelected(parent); parent = parent.getParentPath()) {
        }
        if (parent != null) {
            return this.isParentActuallySelected(path, parent);
        }
        if (this._model == null) {
            return true;
        }
        Object node = path.getLastPathComponent();
        if (this.getChildrenCount(node) == 0) {
            return false;
        }
        boolean allChildrenSelected = true;
        for (int i = 0; i < this.getChildrenCount(node); ++i) {
            Object childNode = this.getChild(node, i);
            if (this.isPathSelected(path.pathByAddingChild(childNode), true)) continue;
            allChildrenSelected = false;
            break;
        }
        if (this._tree.isCheckBoxVisible(path) && allChildrenSelected) {
            this.addSelectionPaths(new TreePath[]{path}, false);
        }
        return allChildrenSelected;
    }

    boolean isDescendant(TreePath path1, TreePath path2) {
        Object[] obj2;
        Object[] obj1 = path1.getPath();
        if (obj1.length < (obj2 = path2.getPath()).length) {
            return false;
        }
        for (int i = 0; i < obj2.length; ++i) {
            if (obj1[i] == obj2[i]) continue;
            return false;
        }
        return true;
    }

    protected void notifyPathChange(Vector changedPaths, TreePath oldLeadSelection) {
        if (this._fireEvent) {
            super.notifyPathChange(changedPaths, oldLeadSelection);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] pPaths) {
        if (!this.isDigIn() || this.selectionMode == 1) {
            super.setSelectionPaths(pPaths);
        } else {
            this.clearSelection();
            this.addSelectionPaths(pPaths);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        this.addSelectionPaths(paths, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSelectionPaths(TreePath[] paths, boolean needCheckPathSelection) {
        if (!this.isDigIn()) {
            super.addSelectionPaths(paths);
            return;
        }
        this.setBatchMode(true);
        boolean fireEventAtTheEnd = false;
        if (this.isSingleEventMode() && this._fireEvent) {
            this._fireEvent = false;
            fireEventAtTheEnd = true;
        }
        try {
            if (needCheckPathSelection) {
                this._pathHasAdded = new HashSet<TreePath>();
                for (TreePath path : paths) {
                    if (this.isPathSelected(path, this.isDigIn())) continue;
                    if (this._toBeAdded.contains(path)) {
                        this.addToExistingSet(this._pathHasAdded, path);
                        continue;
                    }
                    boolean findAncestor = false;
                    for (TreePath addPath : this._pathHasAdded) {
                        if (!addPath.isDescendant(path)) continue;
                        findAncestor = true;
                        break;
                    }
                    if (findAncestor) continue;
                    TreePath temp = null;
                    while (this.areSiblingsSelected(path)) {
                        temp = path;
                        if (path.getParentPath() == null) break;
                        path = path.getParentPath();
                    }
                    if (temp != null) {
                        if (temp.getParentPath() != null) {
                            this.delegateAddSelectionPaths(new TreePath[]{temp.getParentPath()});
                        } else {
                            this.delegateAddSelectionPaths(new TreePath[]{temp});
                        }
                    } else {
                        this.delegateAddSelectionPaths(new TreePath[]{path});
                    }
                    this.addToExistingSet(this._pathHasAdded, path);
                }
                ArrayList<TreePath> toBeRemoved = new ArrayList<TreePath>();
                for (TreePath path : this._toBeAdded) {
                    TreePath[] selectionPaths = this.getSelectionPaths();
                    if (selectionPaths == null) break;
                    for (TreePath selectionPath : selectionPaths) {
                        if (!this.isDescendant(selectionPath, path)) continue;
                        toBeRemoved.add(selectionPath);
                    }
                }
                if (toBeRemoved.size() > 0) {
                    this.delegateRemoveSelectionPaths(toBeRemoved.toArray(new TreePath[toBeRemoved.size()]));
                }
            } else {
                ArrayList<TreePath> toBeRemoved = new ArrayList<TreePath>();
                for (TreePath path : paths) {
                    TreePath[] selectionPaths = this.getSelectionPaths();
                    if (selectionPaths == null) break;
                    for (TreePath selectionPath : selectionPaths) {
                        if (!this.isDescendant(selectionPath, path)) continue;
                        toBeRemoved.add(selectionPath);
                    }
                }
                if (toBeRemoved.size() > 0) {
                    this.delegateRemoveSelectionPaths(toBeRemoved.toArray(new TreePath[toBeRemoved.size()]));
                }
                for (TreePath path : paths) {
                    TreePath temp = null;
                    while (this.areSiblingsSelected(path)) {
                        temp = path;
                        if (path.getParentPath() == null) break;
                        path = path.getParentPath();
                    }
                    if (temp != null) {
                        if (temp.getParentPath() != null) {
                            this.addSelectionPath(temp.getParentPath());
                            continue;
                        }
                        if (!this.isSelectionEmpty()) {
                            this.removeSelectionPaths(this.getSelectionPaths(), !fireEventAtTheEnd);
                        }
                        this.delegateAddSelectionPaths(new TreePath[]{temp});
                        continue;
                    }
                    this.delegateAddSelectionPaths(new TreePath[]{path});
                }
            }
        }
        finally {
            this._fireEvent = true;
            this.setBatchMode(false);
            if (this.isSingleEventMode() && fireEventAtTheEnd) {
                this.notifyPathChange(paths, true, paths[0]);
            }
        }
    }

    protected boolean areSiblingsSelected(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent == null) {
            return true;
        }
        Object node = path.getLastPathComponent();
        Object parentNode = parent.getLastPathComponent();
        int childCount = this.getChildrenCount(parentNode);
        for (int i = 0; i < childCount; ++i) {
            Object childNode = this.getChild(parentNode, i);
            if (childNode == node) continue;
            TreePath childPath = parent.pathByAddingChild(childNode);
            if (!(this._tree == null || this._tree.isCheckBoxVisible(childPath) || this.isPathSelected(childPath, true) || this._pathHasAdded != null && this._pathHasAdded.contains(childPath))) {
                return false;
            }
            if (this.isPathSelected(childPath) || this._pathHasAdded != null && this._pathHasAdded.contains(childPath)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        this.removeSelectionPaths(paths, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeSelectionPaths(TreePath[] paths, boolean doFireEvent) {
        if (!this.isDigIn()) {
            super.removeSelectionPaths(paths);
            return;
        }
        boolean fireEventAtTheEnd = false;
        if (doFireEvent && this.isSingleEventMode() && this._fireEvent) {
            this._fireEvent = false;
            fireEventAtTheEnd = true;
        }
        this.setBatchMode(true);
        try {
            HashSet<TreePath> pathHasRemoved = new HashSet<TreePath>();
            for (TreePath path : paths) {
                void var12_17;
                if (!this.isPathSelected(path, this.isDigIn())) continue;
                TreePath upperMostSelectedAncestor = null;
                if (this._toBeAdded.contains(path)) {
                    this._toBeAdded.remove(path);
                    this.addToExistingSet(pathHasRemoved, path);
                    continue;
                }
                boolean findAncestor = false;
                for (TreePath treePath : pathHasRemoved) {
                    if (!treePath.isDescendant(path)) continue;
                    findAncestor = true;
                    break;
                }
                if (findAncestor) continue;
                HashSet<TreePath> pathToRemoved = new HashSet<TreePath>();
                for (TreePath pathToAdded : this._toBeAdded) {
                    if (!path.isDescendant(pathToAdded)) continue;
                    pathToRemoved.add(pathToAdded);
                }
                this._toBeAdded.removeAll(pathToRemoved);
                for (TreePath pathToAdded : this._toBeAdded) {
                    if (!pathToAdded.isDescendant(path)) continue;
                    upperMostSelectedAncestor = pathToAdded;
                    break;
                }
                TreePath treePath = path.getParentPath();
                Stack<void> stack = new Stack<void>();
                while (var12_17 != null && (upperMostSelectedAncestor == null ? !this.isPathSelected((TreePath)var12_17) : var12_17 != upperMostSelectedAncestor)) {
                    stack.push(var12_17);
                    TreePath treePath2 = var12_17.getParentPath();
                }
                if (var12_17 == null) {
                    this.delegateRemoveSelectionPaths(new TreePath[]{path});
                    this.addToExistingSet(pathHasRemoved, path);
                    continue;
                }
                stack.push(var12_17);
                ArrayList<TreePath> toBeAdded = new ArrayList<TreePath>();
                while (!stack.isEmpty()) {
                    TreePath temp = (TreePath)stack.pop();
                    TreePath peekPath = stack.isEmpty() ? path : (TreePath)stack.peek();
                    Object node = temp.getLastPathComponent();
                    Object peekNode = peekPath.getLastPathComponent();
                    int childCount = this.getChildrenCount(node);
                    for (int i = 0; i < childCount; ++i) {
                        Object childNode = this.getChild(node, i);
                        if (childNode == peekNode) continue;
                        TreePath treePath3 = temp.pathByAddingChild(childNode);
                        toBeAdded.add(treePath3);
                    }
                }
                if (toBeAdded.size() > 0) {
                    this.delegateAddSelectionPaths(toBeAdded.toArray(new TreePath[toBeAdded.size()]));
                }
                this.delegateRemoveSelectionPaths(new TreePath[]{var12_17});
                this.addToExistingSet(pathHasRemoved, path);
            }
        }
        finally {
            this._fireEvent = true;
            this.setBatchMode(false);
            if (this.isSingleEventMode() && fireEventAtTheEnd) {
                this.notifyPathChange(paths, false, paths[0]);
            }
        }
    }

    protected Object getChild(Object node, int i) {
        return this._model.getChild(node, i);
    }

    protected int getChildrenCount(Object node) {
        return this._model.getChildCount(node);
    }

    private void addToExistingSet(Set<TreePath> pathHasOperated, TreePath pathToOperate) {
        if (pathHasOperated.contains(pathToOperate)) {
            return;
        }
        for (TreePath path : pathHasOperated) {
            if (!path.isDescendant(pathToOperate)) continue;
            return;
        }
        HashSet<TreePath> duplicatePathToErase = new HashSet<TreePath>();
        for (TreePath path : pathHasOperated) {
            if (!pathToOperate.isDescendant(path)) continue;
            duplicatePathToErase.add(path);
        }
        pathHasOperated.removeAll(duplicatePathToErase);
        pathHasOperated.add(pathToOperate);
    }

    public boolean isSingleEventMode() {
        return this._singleEventMode;
    }

    public void setSingleEventMode(boolean singleEventMode) {
        this._singleEventMode = singleEventMode;
    }

    protected void notifyPathChange(TreePath[] changedPaths, boolean isNew, TreePath oldLeadSelection) {
        if (this._fireEvent) {
            int cPathCount = changedPaths.length;
            boolean[] newness = new boolean[cPathCount];
            for (int counter = 0; counter < cPathCount; ++counter) {
                newness[counter] = isNew;
            }
            TreeSelectionEvent event = new TreeSelectionEvent((Object)this, changedPaths, newness, oldLeadSelection, this.leadPath);
            this.fireValueChanged(event);
        }
    }

    boolean isBatchMode() {
        return this._batchMode;
    }

    public void setBatchMode(boolean batchMode) {
        this._batchMode = batchMode;
        if (!this._batchMode) {
            TreePath[] treePaths = this._toBeAdded.toArray(new TreePath[this._toBeAdded.size()]);
            this._toBeAdded.clear();
            super.addSelectionPaths(treePaths);
            treePaths = this._toBeRemoved.toArray(new TreePath[this._toBeRemoved.size()]);
            this._toBeRemoved.clear();
            super.removeSelectionPaths(treePaths);
        }
    }

    private void delegateRemoveSelectionPaths(TreePath[] paths) {
        if (!this.isBatchMode()) {
            super.removeSelectionPaths(paths);
        } else {
            for (TreePath path : paths) {
                this._toBeRemoved.add(path);
                this._toBeAdded.remove(path);
            }
        }
    }

    private void delegateAddSelectionPaths(TreePath[] paths) {
        if (!this.isBatchMode()) {
            super.addSelectionPaths(paths);
        } else {
            for (TreePath path : paths) {
                this.addToExistingSet(this._toBeAdded, path);
                this._toBeRemoved.remove(path);
            }
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.revalidateSelectedTreePaths();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.revalidateSelectedTreePaths();
    }

    private boolean isTreePathValid(TreePath path) {
        Object parent = this._model.getRoot();
        for (int i = 0; i < path.getPathCount(); ++i) {
            Object pathComponent = path.getPathComponent(i);
            if (i == 0) {
                if (pathComponent == parent) continue;
                return false;
            }
            boolean found = false;
            for (int j = 0; j < this.getChildrenCount(parent); ++j) {
                Object child = this.getChild(parent, j);
                if (child != pathComponent) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            parent = pathComponent;
        }
        return true;
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.revalidateSelectedTreePaths();
    }

    private void revalidateSelectedTreePaths() {
        TreePath[] treePaths = this.getSelectionPaths();
        if (treePaths != null) {
            for (TreePath treePath : treePaths) {
                if (treePath == null || this.isTreePathValid(treePath)) continue;
                super.removeSelectionPath(treePath);
            }
        }
    }
}

