/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.CellRendererPane;

public class JideFocusTracker {
    protected Component compHighest;
    protected FocusListener listenerFocus = null;
    protected ContainerListener listenerContainer = null;
    protected transient FocusListener listenerMultiCast;
    protected boolean repeat;
    protected transient Component lastFocus = null;

    public JideFocusTracker() {
        this.setRepeating(true);
        this.listenerFocus = new MainFocusListener();
        this.listenerContainer = new MainContainerListener();
    }

    public JideFocusTracker(Component compHighest) {
        this();
        this.setHighestComponent(compHighest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighestComponent(Component compHighest) {
        Object object;
        Component OldValue = this.compHighest;
        if (OldValue != null) {
            object = OldValue.getTreeLock();
            synchronized (object) {
                this.removeInternalListeners(OldValue);
            }
        }
        if (compHighest != null) {
            object = compHighest.getTreeLock();
            synchronized (object) {
                this.addInternalListeners(compHighest);
            }
        }
        this.compHighest = compHighest;
    }

    public Component getHighestComponent() {
        return this.compHighest;
    }

    public boolean isRepeating() {
        return this.repeat;
    }

    public void setRepeating(boolean repeat) {
        this.repeat = repeat;
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.listenerMultiCast = AWTEventMulticaster.add(this.listenerMultiCast, l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.listenerMultiCast = AWTEventMulticaster.remove(this.listenerMultiCast, l);
    }

    protected void addInternalListeners(Component component) {
        if (!this.isExcludedComponent(component)) {
            component.addFocusListener(this.listenerFocus);
            if (component instanceof Container) {
                Container container = (Container)component;
                container.addContainerListener(this.listenerContainer);
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    this.addInternalListeners(container.getComponent(i));
                }
            }
        }
    }

    protected boolean isExcludedComponent(Component component) {
        return component instanceof CellRendererPane;
    }

    protected void removeInternalListeners(Component component) {
        if (!this.isExcludedComponent(component)) {
            component.removeFocusListener(this.listenerFocus);
            if (component instanceof Container) {
                Container container = (Container)component;
                container.removeContainerListener(this.listenerContainer);
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    this.removeInternalListeners(container.getComponent(i));
                }
            }
        }
    }

    class MainFocusListener
    implements FocusListener {
        MainFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (JideFocusTracker.this.listenerMultiCast != null && (e.getSource() != JideFocusTracker.this.lastFocus || JideFocusTracker.this.isRepeating())) {
                JideFocusTracker.this.listenerMultiCast.focusGained(e);
            }
        }

        public void focusLost(FocusEvent e) {
            if (JideFocusTracker.this.listenerMultiCast != null && (e.getSource() != JideFocusTracker.this.lastFocus || JideFocusTracker.this.isRepeating())) {
                JideFocusTracker.this.listenerMultiCast.focusLost(e);
            }
        }
    }

    class MainContainerListener
    implements ContainerListener {
        MainContainerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentAdded(ContainerEvent e) {
            Object object = e.getChild().getTreeLock();
            synchronized (object) {
                JideFocusTracker.this.addInternalListeners(e.getChild());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentRemoved(ContainerEvent e) {
            Object object = e.getChild().getTreeLock();
            synchronized (object) {
                JideFocusTracker.this.removeInternalListeners(e.getChild());
            }
        }
    }
}

