/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared;

import de.qfs.apps.qftest.shared.Geometry;
import de.qfs.apps.qftest.shared.h;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.QFLogger;

public class DoubleGeometry
extends Geometry {
    private static final QFLogger c = new QFLogger("de.qfs.apps.qftest.shared.DoubleGeometry");
    public boolean hasLocation;
    public double x;
    public double y;
    public boolean hasSize;
    public double width;
    public double height;

    public DoubleGeometry() {
    }

    public DoubleGeometry(double d2, double d3, double d4, double d5) {
        this.setGeometry(d2, d3, d4, d5);
    }

    public static DoubleGeometry location(double d2, double d3) {
        return new DoubleGeometry().setLocation(d2, d3);
    }

    public static DoubleGeometry location(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("location is marked non-null but is null");
        }
        assert (dArray.length >= 0);
        return DoubleGeometry.location(dArray[0], dArray[1]);
    }

    public static DoubleGeometry size(double d2, double d3) {
        return new DoubleGeometry().setSize(d2, d3);
    }

    public static DoubleGeometry size(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("size is marked non-null but is null");
        }
        assert (dArray.length >= 2);
        return DoubleGeometry.size(dArray[0], dArray[1]);
    }

    public static DoubleGeometry sizeFromGeometryArray(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("geometryArray is marked non-null but is null");
        }
        assert (dArray.length >= 4);
        return DoubleGeometry.size(dArray[2], dArray[3]);
    }

    public static DoubleGeometry geometry(double d2, double d3, double d4, double d5) {
        return new DoubleGeometry().setGeometry(d2, d3, d4, d5);
    }

    public static DoubleGeometry geometry(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("geometryArray is marked non-null but is null");
        }
        assert (dArray.length >= 4);
        return DoubleGeometry.geometry(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    @Override
    public Number getObjectX() {
        return this.x;
    }

    @Override
    public Number getObjectY() {
        return this.y;
    }

    @Override
    public Number getObjectWidth() {
        return this.width;
    }

    @Override
    public Number getObjectHeight() {
        return this.height;
    }

    public DoubleGeometry setLocation(double d2, double d3) {
        super.setLocation((int)Math.round(d2), (int)Math.round(d3));
        this.x = d2;
        this.y = d3;
        this.hasLocation = true;
        return this;
    }

    @Override
    public Geometry setLocation(int n2, int n3) {
        this.setLocation((double)n2, (double)n3);
        return super.setLocation(n2, n3);
    }

    public DoubleGeometry setSize(double d2, double d3) {
        super.setSize((int)Math.round(d2), (int)Math.round(d3));
        this.width = d2;
        this.height = d3;
        this.hasSize = true;
        return this;
    }

    @Override
    public Geometry setSize(int n2, int n3) {
        this.setSize((double)n2, (double)n3);
        return super.setSize(n2, n3);
    }

    public DoubleGeometry setGeometry(double d2, double d3, double d4, double d5) {
        return this.setLocation(d2, d3).setSize(d4, d5);
    }

    @Override
    public Geometry setGeometry(int n2, int n3, int n4, int n5) {
        this.setGeometry((double)n2, (double)n3, (double)n4, (double)n5);
        return super.setGeometry(n2, n3, n4, n5);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DoubleGeometry@");
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("[");
        if (this.hasSize) {
            stringBuffer.append(this.width);
            stringBuffer.append("x");
            stringBuffer.append(this.height);
        }
        if (this.hasLocation) {
            if (this.x >= 0.0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(this.x);
            if (this.y >= 0.0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(this.y);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean contains(double d2, double d3) {
        return this.hasLocation && this.hasSize && d2 >= this.x && d2 < this.x + this.width && d3 >= this.y && d3 < this.y + this.height;
    }

    @Override
    public boolean contains(int n2, int n3) {
        return this.contains((double)n2, (double)n3);
    }

    public double getMaxDoubleX() {
        return this.x + this.width;
    }

    @Override
    public int getMaxX() {
        return (int)Math.round(this.x + this.width);
    }

    public double getMaxDoubleY() {
        return this.y + this.height;
    }

    @Override
    public int getMaxY() {
        return (int)Math.round(this.y + this.height);
    }

    @Override
    public String getSize() {
        return this.hasSize ? this.width + "x" + this.height : "-";
    }

    @Override
    public String getLocationAsString() {
        return this.hasLocation ? this.x + ":" + this.y : "-";
    }

    @Override
    public DoubleGeometry uniteWith(Geometry geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException("other is marked non-null but is null");
        }
        if (!(this.hasLocation && this.hasSize && geometry.hasLocation && geometry.hasSize)) {
            return this;
        }
        double d2 = Math.min(this.x, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).x : (double)geometry.x);
        double d3 = Math.min(this.y, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).y : (double)geometry.y);
        double d4 = Math.max(this.x + this.width, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).x + ((DoubleGeometry)geometry).height : (double)(geometry.x + geometry.width)) - d2;
        double d5 = Math.max(this.y + this.height, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).x + ((DoubleGeometry)geometry).height : (double)(geometry.y + geometry.height)) - d3;
        this.setGeometry(d2, d3, d4, d5);
        return this;
    }

    @Override
    public DoubleGeometry intersect(Geometry geometry) {
        if (!(this.hasLocation && this.hasSize && geometry.hasLocation && geometry.hasSize)) {
            return this;
        }
        double d2 = Math.max(this.x, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).x : (double)geometry.x);
        double d3 = Math.max(this.y, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).y : (double)geometry.y);
        double d4 = Math.min(this.x + this.width, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).x + ((DoubleGeometry)geometry).height : (double)(geometry.x + geometry.width)) - d2;
        double d5 = Math.min(this.y + this.height, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).x + ((DoubleGeometry)geometry).height : (double)(geometry.y + geometry.height)) - d3;
        if (d4 < 0.0 || d5 < 0.0) {
            this.setGeometry(0, 0, 0, 0);
            this.hasLocation = false;
            this.hasSize = false;
        } else {
            this.setGeometry(d2, d3, d4, d5);
        }
        return this;
    }

    @Override
    public DoubleGeometry relateTo(Geometry geometry) {
        if (!this.hasLocation || !geometry.hasLocation) {
            return this;
        }
        this.setLocation(this.x - (geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).x : (double)geometry.x), this.y - (geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).y : (double)geometry.y));
        return this;
    }

    @Override
    public DoubleGeometry clone() {
        return (DoubleGeometry)super.clone();
    }

    @Override
    public JsonValue asJsonValue() {
        JsonObject jsonObject = new JsonObject();
        if (this.hasLocation) {
            jsonObject.add("x", this.x);
            jsonObject.add("y", this.y);
        }
        if (this.hasSize) {
            jsonObject.add("width", this.width);
            jsonObject.add("height", this.height);
        }
        return jsonObject;
    }

    public static DoubleGeometry fromJson(JsonValue jsonValue) {
        DoubleGeometry doubleGeometry = new DoubleGeometry();
        if (jsonValue instanceof JsonObject) {
            if (((JsonObject)jsonValue).contains("x") || ((JsonObject)jsonValue).contains("y")) {
                doubleGeometry.setLocation(h.a(jsonValue, "x", 0.0), h.a(jsonValue, "y", 0.0));
            }
            if (((JsonObject)jsonValue).contains("width") || ((JsonObject)jsonValue).contains("height")) {
                doubleGeometry.setSize(h.a(jsonValue, "width", 0.0), h.a(jsonValue, "height", 0.0));
            }
        }
        return doubleGeometry;
    }

    @Override
    public boolean equalLocation(Geometry geometry) {
        return this.a(this.x, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).x : (double)geometry.x) && this.a(this.y, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).y : (double)geometry.y);
    }

    @Override
    public boolean equalSize(Geometry geometry) {
        return this.a(this.height, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).height : (double)geometry.height) && this.a(this.width, geometry instanceof DoubleGeometry ? ((DoubleGeometry)geometry).width : (double)geometry.width);
    }

    protected boolean a(double d2, double d3) {
        return Math.abs(d2 - d3) < 1.0E-15;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DoubleGeometry)) {
            return false;
        }
        DoubleGeometry doubleGeometry = (DoubleGeometry)object;
        if (!doubleGeometry.a(this)) {
            return false;
        }
        if (Double.compare(this.x, doubleGeometry.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, doubleGeometry.y) != 0) {
            return false;
        }
        if (Double.compare(this.width, doubleGeometry.width) != 0) {
            return false;
        }
        return Double.compare(this.height, doubleGeometry.height) == 0;
    }

    @Override
    protected boolean a(Object object) {
        return object instanceof DoubleGeometry;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        long l2 = Double.doubleToLongBits(this.x);
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = Double.doubleToLongBits(this.y);
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = Double.doubleToLongBits(this.width);
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = Double.doubleToLongBits(this.height);
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        return n2;
    }
}

