/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared;

import de.qfs.apps.qftest.shared.h;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonSerializable;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.QFLogger;
import java.io.Serializable;

public class Geometry
implements JsonSerializable,
Serializable,
Cloneable {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.Geometry");
    public boolean hasLocation;
    public int x;
    public int y;
    public boolean hasSize;
    public int width;
    public int height;

    public Geometry() {
    }

    public Geometry(int n2, int n3, int n4, int n5) {
        this.setGeometry(n2, n3, n4, n5);
    }

    public Geometry(double d2, double d3, double d4, double d5) {
        this((int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4), (int)Math.round(d5));
    }

    public static Geometry location(int n2, int n3) {
        return new Geometry().setLocation(n2, n3);
    }

    public static Geometry location(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("location is marked non-null but is null");
        }
        assert (nArray.length >= 0);
        return Geometry.location(nArray[0], nArray[1]);
    }

    public static Geometry size(int n2, int n3) {
        return new Geometry().setSize(n2, n3);
    }

    public static Geometry size(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("size is marked non-null but is null");
        }
        assert (nArray.length >= 2);
        return Geometry.size(nArray[0], nArray[1]);
    }

    public static Geometry sizeFromGeometryArray(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("geometryArray is marked non-null but is null");
        }
        assert (nArray.length >= 4);
        return Geometry.size(nArray[2], nArray[3]);
    }

    public static Geometry geometry(int n2, int n3, int n4, int n5) {
        return new Geometry().setGeometry(n2, n3, n4, n5);
    }

    public static Geometry geometry(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("geometryArray is marked non-null but is null");
        }
        assert (nArray.length >= 4);
        return Geometry.geometry(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static Geometry location(double d2, double d3) {
        return new Geometry().setLocation((int)Math.round(d2), (int)Math.round(d3));
    }

    public static Geometry location(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("location is marked non-null but is null");
        }
        assert (dArray.length >= 0);
        return Geometry.location(dArray[0], dArray[1]);
    }

    public static Geometry size(double d2, double d3) {
        return new Geometry().setSize((int)Math.round(d2), (int)Math.round(d3));
    }

    public static Geometry size(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("size is marked non-null but is null");
        }
        assert (dArray.length >= 2);
        return Geometry.size(dArray[0], dArray[1]);
    }

    public static Geometry sizeFromGeometryArray(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("geometryArray is marked non-null but is null");
        }
        assert (dArray.length >= 4);
        return Geometry.size(dArray[2], dArray[3]);
    }

    public static Geometry geometry(double d2, double d3, double d4, double d5) {
        return new Geometry().setGeometry((int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4), (int)Math.round(d5));
    }

    public static Geometry geometry(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("geometryArray is marked non-null but is null");
        }
        assert (dArray.length >= 4);
        return Geometry.geometry(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public Number getObjectX() {
        return this.x;
    }

    public Number getObjectY() {
        return this.y;
    }

    public Number getObjectWidth() {
        return this.width;
    }

    public Number getObjectHeight() {
        return this.height;
    }

    public Geometry setLocation(int n2, int n3) {
        this.x = n2;
        this.y = n3;
        this.hasLocation = true;
        return this;
    }

    public Geometry setSize(int n2, int n3) {
        this.width = n2;
        this.height = n3;
        this.hasSize = true;
        return this;
    }

    public Geometry setGeometry(int n2, int n3, int n4, int n5) {
        return this.setLocation(n2, n3).setSize(n4, n5);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Geometry@");
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("[");
        if (this.hasSize) {
            stringBuffer.append(this.width);
            stringBuffer.append("x");
            stringBuffer.append(this.height);
        }
        if (this.hasLocation) {
            if (this.x >= 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(this.x);
            if (this.y >= 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(this.y);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean contains(int n2, int n3) {
        return this.hasLocation && this.hasSize && n2 >= this.x && n2 < this.x + this.width && n3 >= this.y && n3 < this.y + this.height;
    }

    public int getMaxX() {
        return this.x + this.width;
    }

    public int getMaxY() {
        return this.y + this.height;
    }

    public String getSize() {
        return this.hasSize ? this.width + "x" + this.height : "-";
    }

    public String getLocationAsString() {
        return this.hasLocation ? this.x + ":" + this.y : "-";
    }

    public Geometry uniteWith(Geometry geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException("other is marked non-null but is null");
        }
        if (!(this.hasLocation && this.hasSize && geometry.hasLocation && geometry.hasSize)) {
            return this;
        }
        int n2 = Math.min(this.x, geometry.x);
        int n3 = Math.min(this.y, geometry.y);
        int n4 = Math.max(this.x + this.width, geometry.x + geometry.width) - n2;
        int n5 = Math.max(this.y + this.height, geometry.y + geometry.height) - n3;
        this.setGeometry(n2, n3, n4, n5);
        return this;
    }

    public Geometry intersect(Geometry geometry) {
        if (!(this.hasLocation && this.hasSize && geometry.hasLocation && geometry.hasSize)) {
            return this;
        }
        int n2 = Math.max(this.x, geometry.x);
        int n3 = Math.max(this.y, geometry.y);
        int n4 = Math.min(this.x + this.width, geometry.x + geometry.width) - n2;
        int n5 = Math.min(this.y + this.height, geometry.y + geometry.height) - n3;
        if (n4 < 0 || n5 < 0) {
            this.setGeometry(0, 0, 0, 0);
            this.hasLocation = false;
            this.hasSize = false;
        } else {
            this.setGeometry(n2, n3, n4, n5);
        }
        return this;
    }

    public Geometry relateTo(Geometry geometry) {
        if (!this.hasLocation || !geometry.hasLocation) {
            return this;
        }
        this.setLocation(this.x - geometry.x, this.y - geometry.y);
        return this;
    }

    public Geometry clone() {
        try {
            return (Geometry)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false) : "does not happen";
            return null;
        }
    }

    public JsonValue asJsonValue() {
        JsonObject jsonObject = new JsonObject();
        if (this.hasLocation) {
            jsonObject.add("x", this.x);
            jsonObject.add("y", this.y);
        }
        if (this.hasSize) {
            jsonObject.add("width", this.width);
            jsonObject.add("height", this.height);
        }
        return jsonObject;
    }

    public static Geometry fromJson(JsonValue jsonValue) {
        Geometry geometry = new Geometry();
        if (jsonValue instanceof JsonObject) {
            if (((JsonObject)jsonValue).contains("x") || ((JsonObject)jsonValue).contains("y")) {
                geometry.setLocation((int)Math.round(h.a(jsonValue, "x", 0.0)), (int)Math.round(h.a(jsonValue, "y", 0.0)));
            }
            if (((JsonObject)jsonValue).contains("width") || ((JsonObject)jsonValue).contains("height")) {
                geometry.setSize((int)Math.round(h.a(jsonValue, "width", 0.0)), (int)Math.round(h.a(jsonValue, "height", 0.0)));
            }
        }
        return geometry;
    }

    public boolean equalLocation(Geometry geometry) {
        return this.x == geometry.getX() && this.y == geometry.getY();
    }

    public boolean equalSize(Geometry geometry) {
        return this.width == geometry.getWidth() && this.height == geometry.getHeight();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Geometry)) {
            return false;
        }
        Geometry geometry = (Geometry)object;
        if (!geometry.a(this)) {
            return false;
        }
        if (this.getX() != geometry.getX()) {
            return false;
        }
        if (this.getY() != geometry.getY()) {
            return false;
        }
        if (this.getWidth() != geometry.getWidth()) {
            return false;
        }
        return this.getHeight() == geometry.getHeight();
    }

    protected boolean a(Object object) {
        return object instanceof Geometry;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = n2 * 59 + this.getX();
        n2 = n2 * 59 + this.getY();
        n2 = n2 * 59 + this.getWidth();
        n2 = n2 * 59 + this.getHeight();
        return n2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

