/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared;

import de.qfs.apps.qftest.shared.features.FeatureManager;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Scanner;

public class Globals {
    private static final QFLogger c = new QFLogger("de.qfs.apps.qftest.shared.Globals");
    public static final String COMPANY_TOKEN = "qfs";
    public static final String APP_NAME = "QF-Test";
    public static final String APP_TOKEN = "qftest";
    public static final String PRE42_USER_CFG_DIR = Misc.getBestPath((File)new File(System.getProperty("user.home"), ".qftest"));
    private static final Globals d = new Globals();
    private static byte[] e;
    protected MapResourceBundle a = new MapResourceBundle();
    protected OptionSet b = new OptionSet("globals");

    private Globals() {
        if (Globals.c.level >= 7) {
            c.lvlBuild(7, "Globals()", 99).log();
        }
    }

    public static final MapResourceBundle getResources() {
        return d.a();
    }

    public static void addResources(MapResourceBundle mapResourceBundle) {
        if (Globals.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "addResources(MapResourceBundle)", 129).addDetail("rb", (Object)mapResourceBundle)).log();
        }
        d.a(mapResourceBundle);
    }

    public static final void addGlobal(Option option) {
        if (Globals.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "addGlobal(Option)", 141).addDetail("option", (Object)option)).log();
        }
        if (Globals.c.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(9, "addGlobal(Option)", 143).add("instance", (Object)d)).add("loader", (Object)d.getClass().getClassLoader())).log();
        }
        d.b().add(option);
    }

    public static final void removeGlobal(String string) {
        if (Globals.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "removeGlobal(String)", 153).addDetail("optionName", string)).log();
        }
        if (Globals.c.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(9, "removeGlobal(String)", 155).add("instance", (Object)d)).add("loader", (Object)d.getClass().getClassLoader())).log();
        }
        d.b().remove(string);
    }

    public static final boolean getGlobalBoolean(String string, boolean bl) {
        return d.b().getBoolean(string, bl);
    }

    public static final int getGlobalInt(String string, int n2) {
        return d.b().getInt(string, n2);
    }

    public static final String getGlobalString(String string, String string2) {
        return d.b().getString(string, string2);
    }

    public static final Object getGlobalValue(String string, Object object) {
        return d.b().getValue(string, object);
    }

    public static final Option getGlobalOption(String string) {
        return d.b().getOption(string);
    }

    public static void reserveMemory(int n2) {
        block3: {
            if (Globals.c.level >= 7) {
                ((LevelAwareLogBuilder)c.lvlBuild(7, "reserveMemory(int)", 252).addDetail("amount", n2)).log();
            }
            try {
                e = new byte[n2 <= 0 ? 0x500000 : n2];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (Globals.c.level < 1) break block3;
                ((LevelAwareLogBuilder)c.lvlBuild(1, "reserveMemory(int)", 257).add("ex", (Object)outOfMemoryError)).log();
            }
        }
    }

    public static void releaseMemory() {
        if (Globals.c.level >= 7) {
            c.lvlBuild(7, "releaseMemory()", 267).log();
        }
        e = null;
    }

    private MapResourceBundle a() {
        return this.a;
    }

    private final OptionSet b() {
        return this.b;
    }

    private void a(MapResourceBundle mapResourceBundle) {
        if (Globals.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "_addResources(MapResourceBundle)", 313).addDetail("rb", (Object)mapResourceBundle)).log();
        }
        this.a.addResources((ResourceBundle)mapResourceBundle);
        Option.addResources((ResourceBundle)mapResourceBundle);
        Message.addResources((ResourceBundle)mapResourceBundle);
        PopupManager.addResources((ResourceBundle)mapResourceBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalizedDocument(String string) {
        block10: {
            if (Globals.c.level >= 7) {
                ((LevelAwareLogBuilder)c.lvlBuild(7, "getLocalizedDocument(String)", 332).addDetail("resourceName", string)).log();
            }
            if (string == null) {
                throw new IllegalArgumentException("resourceName is marked non-null but is null");
            }
            if (!string.startsWith("/")) {
                string = "documents/" + string;
            }
            InputStream inputStream = Globals.getLocalizedResourceAsStream(string);
            if (inputStream == null) break block10;
            Scanner scanner = null;
            try {
                scanner = new Scanner(inputStream, "UTF-8");
                scanner.useDelimiter("\\A");
                String string2 = scanner.hasNext() ? scanner.next() : "";
                String string3 = FeatureManager.instance().filterText(string2);
                if (scanner != null) {
                    scanner.close();
                }
                return string3;
            }
            catch (Throwable throwable) {
                try {
                    if (scanner != null) {
                        scanner.close();
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    if (Globals.c.level < 1) break block10;
                    ((LevelAwareLogBuilder)c.lvlBuild(1, "getLocalizedDocument(String)", 354).add("ex", (Object)exception)).log();
                }
            }
        }
        return "Not found: " + string;
    }

    public static String expandHandbookXml(String string) {
        if (Globals.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "expandHandbookXml(String)", 368).addDetail("xml", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("xml is marked non-null but is null");
        }
        string = string.replaceAll("&qt;", "QF&#8209;Test");
        string = string.replaceAll("&QFS;", "QFS");
        string = string.replaceAll("&SUT;", "SUT");
        string = string.replaceAll("<man:title scope=\"chapter\">([^<]+)</man:title>", "<h1>$1</h1>");
        string = string.replaceAll("<man:title>([^<]+)</man:title>", "<h2>$1</h2>");
        string = string.replaceAll("<man:ref [^>/]+/>", Globals.getResources().getString("manual.title", "manual"));
        string = string.replaceAll("&ref_argRunlogdir;", "<code>-runlogdir &lt;dir&gt;</code>");
        string = string.replaceAll("&ref_argLogdir;", "<code>-logdir &lt;dir&gt;</code>");
        string = string.replaceAll("<man:menuitem label=\"([^\"]+)\"/?>", "<i>$1</i> ");
        string = string.replaceAll("</man:menuitem>", "");
        return string;
    }

    public static InputStream getLocalizedResourceAsStream(String string) {
        InputStream inputStream;
        if (Globals.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "getLocalizedResourceAsStream(String)", 395).addDetail("resourceName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("resourceName is marked non-null but is null");
        }
        if (!string.startsWith("/")) {
            string = "/de/qfs/apps/qftest/resources/" + string;
        }
        Locale locale = Locale.getDefault();
        String string2 = string;
        String string3 = "";
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
            string3 = string.substring(n2);
        }
        if ((inputStream = Globals.class.getResourceAsStream(String.format("%s_%s_%s%s", string2, locale.getLanguage(), locale.getCountry(), string3))) != null) {
            return inputStream;
        }
        inputStream = Globals.class.getResourceAsStream(String.format("%s_%s%s", string2, locale.getLanguage(), string3));
        if (inputStream != null) {
            return inputStream;
        }
        return Globals.class.getResourceAsStream(string);
    }
}

