/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ai.prompt;

import de.qfs.apps.qftest.shared.ai.AIExecutionException;
import de.qfs.apps.qftest.shared.ai.AIModel;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PromptTemplate {
    private static final QFLogger f = new QFLogger("de.qfs.apps.qftest.shared.ai.prompt.PromptTemplate");
    final String a;
    final String b;
    final String c;
    final String d;
    final Predicate e;

    public static PromptTemplate getTemplate(String string) {
        if (PromptTemplate.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getTemplate(String)", 40).addDetail("name", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        Optional<PromptTemplate> optional = PromptTemplate.getConfiguredTemplates().stream().filter(promptTemplate -> string.equals(promptTemplate.a)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new IllegalArgumentException("Prompt template not found in options: " + string);
    }

    public static List getConfiguredTemplates() {
        if (PromptTemplate.f.level >= 7) {
            f.lvlBuild(7, "getConfiguredTemplates()", 51).log();
        }
        Object[][] objectArray2 = (Object[][])Misc.valueOrDefault((Object)Options.cached_OPT_LLM_PROMPT_TEMPLATES, (Object)new Object[0][]);
        return Arrays.stream(objectArray2).map(objectArray -> new PromptTemplate((String)objectArray[0], (String)objectArray[1], (String)objectArray[2], (String)objectArray[3], PromptTemplate.getEvaluator((String)objectArray[0], (String)objectArray[2], (String)objectArray[3]))).collect(Collectors.toList());
    }

    public static Predicate getEvaluator(String string, String string2, String string3) {
        if (PromptTemplate.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getEvaluator(String,String,String)", 58).addDetail("templateName", string)).addDetail("positiveResponse", string2)).addDetail("negativeResponse", string3)).log();
        }
        return aIExecutionResult -> {
            block4: {
                try {
                    String string4 = String.valueOf(aIExecutionResult.getContent()).replaceAll("[^a-zA-Z]", "");
                    if (string2.equalsIgnoreCase(string4)) {
                        return true;
                    }
                    if (string3.equalsIgnoreCase(string4)) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    if (PromptTemplate.f.level < 3) break block4;
                    ((LevelAwareLogBuilder)f.lvlBuild(3, "getEvaluator(String,String,String)", 65).add("Error evaluating LLM result: ", (Object)exception)).log();
                }
            }
            throw new AIExecutionException("Could not evaluate LLM answer via prompt template \"" + string + "\".\nExpected answers: \"" + string2 + "\" or \"" + string3 + "\".\nActual answer: \"" + aIExecutionResult.getContent() + "\"");
        };
    }

    public String getPrompt(Map map) {
        if (PromptTemplate.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getPrompt(Map<String, String>)", 81).addDetail("substitutions", (Object)map)).log();
        }
        String string = this.b;
        for (Map.Entry entry : map.entrySet()) {
            string = string.replace("{{" + (String)entry.getKey() + "}}", (CharSequence)Misc.valueOrDefault(entry.getValue(), (Object)""));
        }
        return string;
    }

    public boolean evalResult(AIModel.AIExecutionResult aIExecutionResult) throws AIExecutionException {
        if (PromptTemplate.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "evalResult(AIExecutionResult)", 90).addDetail("aiResult", (Object)aIExecutionResult)).log();
        }
        return this.e.test(aIExecutionResult);
    }

    public PromptTemplate(String string, String string2, String string3, String string4, Predicate predicate) {
        if (PromptTemplate.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "PromptTemplate(String,String,String,String,AIExecutionResult>)", 36).addDetail("name", string)).addDetail("prompt", string2)).addDetail("positiveResponse", string3)).addDetail("negativeResponse", string4)).addDetail("evaluator", (Object)predicate)).log();
        }
        this.a = string;
        this.b = string2;
        this.c = string3;
        this.d = string4;
        this.e = predicate;
    }

    public String getName() {
        if (PromptTemplate.f.level >= 7) {
            f.lvlBuild(7, "getName()", 75).log();
        }
        return this.a;
    }

    public String getPrompt() {
        if (PromptTemplate.f.level >= 7) {
            f.lvlBuild(7, "getPrompt()", 76).log();
        }
        return this.b;
    }

    public String getPositiveResponse() {
        if (PromptTemplate.f.level >= 7) {
            f.lvlBuild(7, "getPositiveResponse()", 77).log();
        }
        return this.c;
    }

    public String getNegativeResponse() {
        if (PromptTemplate.f.level >= 7) {
            f.lvlBuild(7, "getNegativeResponse()", 78).log();
        }
        return this.d;
    }
}

