/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.android.apk;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidApkAnalyzer {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.android.apk.AndroidApkAnalyzer");
    private final File b;
    private WeakReference c;

    public AndroidApkAnalyzer(File file) {
        if (AndroidApkAnalyzer.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "AndroidApkAnalyzer(File)", 78).addDetail("apkFile", (Object)file)).log();
        }
        if (file == null) {
            throw new RuntimeException("apkFile must not be null!");
        }
        this.b = file;
    }

    public int a(byte[] byArray, int n2) {
        if (AndroidApkAnalyzer.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "readLittleEndianWord(byte[],int)", 92).addDetail("arr", (Object)byArray)).addDetail("ptr", n2)).log();
        }
        return byArray[n2 + 3] << 24 & 0xFF000000 | byArray[n2 + 2] << 16 & 0xFF0000 | byArray[n2 + 1] << 8 & 0xFF00 | byArray[n2] & 0xFF;
    }

    public String a(byte[] byArray, int n2, int n3, int n4) {
        if (AndroidApkAnalyzer.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getStr(byte[],int,int,int)", 100).addDetail("arr", (Object)byArray)).addDetail("sitOff", n2)).addDetail("stOff", n3)).addDetail("strInd", n4)).log();
        }
        if (n4 < 0) {
            return null;
        }
        int n5 = n3 + this.a(byArray, n2 + n4 * 4);
        int n6 = byArray[n5 + 1] << 8 & 0xFF00 | byArray[n5] & 0xFF;
        byte[] byArray2 = new byte[n6 << 1];
        System.arraycopy(byArray, n5 + 2, byArray2, 0, byArray2.length);
        String string = new String(byArray2, StandardCharsets.UTF_16LE);
        string = string.replace("&", "&amp;").replace("'", "&apos;").replace("\"", "&quot;").replace(">", "&gt;").replace("<", "&lt;");
        return string;
    }

    public InputStream a(ZipInputStream zipInputStream) throws IOException {
        if (AndroidApkAnalyzer.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "decodeManifest(ZipInputStream)", 114).addDetail("zis", (Object)zipInputStream)).log();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4098];
        int n2 = zipInputStream.read(byArray);
        while (n2 > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n2 = zipInputStream.read(byArray);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        StringBuilder stringBuilder = new StringBuilder(8176);
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        int n3 = this.a(byArray2, 16);
        int n4 = 36 + n3 * 4;
        int n5 = this.a(byArray2, 12);
        while (this.a(byArray2, n5) != 0x100102) {
            n5 += 4;
        }
        while (n5 < byArray2.length) {
            String string;
            int n6 = this.a(byArray2, n5 + 0);
            int n7 = this.a(byArray2, n5 + 4);
            int n8 = this.a(byArray2, n5 + 8);
            int n9 = this.a(byArray2, n5 + 12);
            int n10 = this.a(byArray2, n5 + 16);
            int n11 = this.a(byArray2, n5 + 20);
            n5 += 24;
            if (n6 == 0x100102) {
                string = this.a(byArray2, 36, n4, n11);
                stringBuilder.append("<").append(string);
                int n12 = this.a(byArray2, n5 + 0);
                int n13 = this.a(byArray2, n5 + 4);
                int n14 = this.a(byArray2, n5 + 8);
                n5 += 12;
                for (int i2 = 0; i2 < n13; ++i2) {
                    int n15 = this.a(byArray2, n5 + 0);
                    int n16 = this.a(byArray2, n5 + 4);
                    int n17 = this.a(byArray2, n5 + 8);
                    int n18 = this.a(byArray2, n5 + 12);
                    int n19 = this.a(byArray2, n5 + 16);
                    n5 += 20;
                    String string2 = this.a(byArray2, 36, n4, n16);
                    String string3 = n17 != -1 ? this.a(byArray2, 36, n4, n17) : "(resourceId " + n19 + ")";
                    stringBuilder.append(" ").append(string2).append("=\"").append(string3).append("\"");
                }
                stringBuilder.append(">");
                continue;
            }
            if (n6 == 0x100103) {
                string = this.a(byArray2, 36, n4, n11);
                stringBuilder.append("</").append(string).append(">");
                continue;
            }
            if (n6 == 0x100101) break;
            throw new APKAnalyzerException("Unknown tag " + n6);
        }
        String string = stringBuilder.toString();
        if (AndroidApkAnalyzer.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "decodeManifest(ZipInputStream)", 181).add("result", string)).log();
        }
        byte[] byArray3 = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        return byteArrayInputStream;
    }

    public InputStream a() throws IOException {
        if (AndroidApkAnalyzer.a.level >= 7) {
            a.lvlBuild(7, "getManfiestAsStream()", 190).log();
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.b));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                if ("AndroidManifest.xml".equals(string)) {
                    InputStream inputStream = this.a(zipInputStream);
                    return inputStream;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        throw new APKAnalyzerException("APK file does not contain an AndroidManifest");
    }

    public Document b() {
        if (AndroidApkAnalyzer.a.level >= 7) {
            a.lvlBuild(7, "getManfiest()", 212).log();
        }
        Document document = null;
        if (this.c != null && (document = (Document)this.c.get()) != null) {
            return document;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(this.a());
        }
        catch (Throwable throwable) {
            if (AndroidApkAnalyzer.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getManfiest()", 225).add("t", (Object)throwable)).log();
            }
            throw new APKAnalyzerException("Not an apk file or error while analyzing APK file", throwable);
        }
        this.c = new WeakReference<Document>(document);
        return document;
    }

    public String getPackage() {
        if (AndroidApkAnalyzer.a.level >= 7) {
            a.lvlBuild(7, "getPackage()", 235).log();
        }
        Document document = this.b();
        Element element = document.getDocumentElement();
        return element.getAttribute("package");
    }

    public List c() {
        Object object;
        if (AndroidApkAnalyzer.a.level >= 7) {
            a.lvlBuild(7, "getActivityNodes()", 244).log();
        }
        Document document = this.b();
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        Object object2 = null;
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = nodeList.item(i2);
            String string = object.getNodeName();
            if (!"application".equals(string)) continue;
            object2 = object;
            break;
        }
        LinkedList<Node> linkedList = new LinkedList<Node>();
        if (object2 != null) {
            object = object2.getChildNodes();
            int n3 = object.getLength();
            for (int i3 = 0; i3 < n3; ++i3) {
                Node node = object.item(i3);
                String string = node.getNodeName();
                if (!"activity".equals(string) && !"activity-alias".equals(string)) continue;
                linkedList.add(node);
            }
        } else {
            throw new APKAnalyzerException("No <application> tag");
        }
        return linkedList;
    }

    public boolean a(Node node) {
        if (AndroidApkAnalyzer.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isMainActivity(Node)", 279).addDetail("n", (Object)node)).log();
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = nodeList.item(i2);
            String string = node2.getNodeName();
            if (!"intent-filter".equals(string)) continue;
            NodeList nodeList2 = node2.getChildNodes();
            int n3 = nodeList2.getLength();
            for (int i3 = 0; i3 < n3; ++i3) {
                String string2;
                Node node3 = nodeList2.item(i3);
                String string3 = node3.getNodeName();
                if (!"action".equals(string3) && !"category".equals(string3) || !"android.intent.action.MAIN".equals(string2 = ((Element)node3).getAttribute("name")) && !"android.intent.category.LAUNCHER".equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public String b(Node node) {
        if (AndroidApkAnalyzer.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getActivityName(Node)", 309).addDetail("n", (Object)node)).log();
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            String string = element.getAttribute("name");
            if (string == null) {
                throw new APKAnalyzerException("Activity name == null? " + String.valueOf(element));
            }
            return string;
        }
        throw new APKAnalyzerException("Activity node not instanceof Element? " + String.valueOf(node) + " (" + node.getClass().getName() + ")");
    }

    public String d() {
        if (AndroidApkAnalyzer.a.level >= 7) {
            a.lvlBuild(7, "getMainActivity()", 324).log();
        }
        List list = this.c();
        for (Node node : list) {
            if (!this.a(node)) continue;
            return this.b(node);
        }
        return null;
    }

    public List e() {
        if (AndroidApkAnalyzer.a.level >= 7) {
            a.lvlBuild(7, "getActivities()", 337).log();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        List list = this.c();
        for (Node node : list) {
            String string = this.b(node);
            linkedList.add(string);
        }
        return linkedList;
    }

    class APKAnalyzerException
    extends RuntimeException {
        public APKAnalyzerException() {
            if (AndroidApkAnalyzer.a.level >= 7) {
                a.lvlBuild(7, "APKAnalyzerException.APKAnalyzerException()", 352).log();
            }
        }

        public APKAnalyzerException(String string) {
            super(string);
            if (AndroidApkAnalyzer.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "APKAnalyzerException.APKAnalyzerException(String)", 355).addDetail("msg", string)).log();
            }
        }

        public APKAnalyzerException(String string, Throwable throwable) {
            super(string, throwable);
            if (AndroidApkAnalyzer.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "APKAnalyzerException.APKAnalyzerException(String,Throwable)", 358).addDetail("msg", string)).addDetail("cause", (Object)throwable)).log();
            }
        }
    }
}

