/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.data;

import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.ExtraFeature;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonSerializable;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ExtraFeatureSet
implements JsonSerializable,
Serializable,
Cloneable {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.data.ExtraFeatureSet");
    public static final long serialVersionUID = -6649568588579526849L;
    public static final String QFS_LABEL_BEST = "qfs:labelBest";
    private TreeMap b = new TreeMap();
    private boolean c;

    public ExtraFeatureSet() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "ExtraFeatureSet.ExtraFeatureSet()", 48).log();
        }
    }

    public ExtraFeatureSet add(ExtraFeature extraFeature) {
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "add(ExtraFeature)", 77).addDetail("extraFeature", (Object)extraFeature)).log();
        }
        if (this.c) {
            this.a(extraFeature);
        }
        this.b.put(extraFeature.getName(), extraFeature);
        return this;
    }

    public ExtraFeatureSet add(String string, String string2) {
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "add(String,String)", 95).addDetail("name", string)).addDetail("value", string2)).log();
        }
        return this.add(new ExtraFeature(string, string2));
    }

    public ExtraFeatureSet add(int n2, String string, String string2) {
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "add(int,String,String)", 110).addDetail("state", n2)).addDetail("name", string)).addDetail("value", string2)).log();
        }
        return this.add(new ExtraFeature(n2, string, string2));
    }

    public ExtraFeature get(String string) {
        return (ExtraFeature)this.b.get(string);
    }

    public String getValue(String string) {
        ExtraFeature extraFeature = this.get(string);
        return extraFeature == null ? null : extraFeature.getValue();
    }

    public ExtraFeature getShouldMatchLabel() {
        for (ExtraFeature extraFeature : this.b.values()) {
            if (!extraFeature.isLabelVariant() || extraFeature.getState() != 1) continue;
            return extraFeature;
        }
        return null;
    }

    public ExtraFeature remove(String string) {
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "remove(String)", 178).addDetail("name", string)).log();
        }
        if (this.c) {
            this.a(string);
        }
        return (ExtraFeature)this.b.remove(string);
    }

    public ExtraFeature remove(ExtraFeature extraFeature) {
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "remove(ExtraFeature)", 195).addDetail("extraFeature", (Object)extraFeature)).log();
        }
        return this.remove(extraFeature.getName());
    }

    public ExtraFeature[] toArray() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "toArray()", 208).log();
        }
        return this.b.values().toArray(new ExtraFeature[0]);
    }

    public int size() {
        return this.b.size();
    }

    public int countRelevant() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "countRelevant()", 239).log();
        }
        int n2 = 0;
        Iterator iterator = this.b.values().iterator();
        while (iterator.hasNext()) {
            if (((ExtraFeature)iterator.next()).getState() == 0) continue;
            ++n2;
        }
        return n2;
    }

    public int countMustMatch() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "countMustMatch()", 258).log();
        }
        int n2 = 0;
        Iterator iterator = this.b.values().iterator();
        while (iterator.hasNext()) {
            if (((ExtraFeature)iterator.next()).getState() != 2) continue;
            ++n2;
        }
        return n2;
    }

    public Set getRelevantNames() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "getRelevantNames()", 272).log();
        }
        Set set = this.b.values().stream().filter(extraFeature -> extraFeature.getState() != 0).map(ExtraFeature::getName).collect(Collectors.toSet());
        if (ExtraFeatureSet.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getRelevantNames()", 278).add("ret", set)).log();
        }
        return set;
    }

    public String toString() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "toString()", 295).log();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append('[');
        ExtraFeature[] extraFeatureArray = this.toArray();
        for (int i2 = 0; i2 < extraFeatureArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(extraFeatureArray[i2]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Object clone() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "clone()", 320).log();
        }
        try {
            ExtraFeatureSet extraFeatureSet = (ExtraFeatureSet)super.clone();
            extraFeatureSet.b = new TreeMap();
            for (String string : this.b.keySet()) {
                extraFeatureSet.b.put(string, (ExtraFeature)((ExtraFeature)this.b.get(string)).clone());
            }
            return extraFeatureSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void fixupNbsp() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "fixupNbsp()", 342).log();
        }
        for (ExtraFeature extraFeature : this.b.values()) {
            String string = extraFeature.getValue();
            if (string == null) continue;
            extraFeature.setValue(Util.getCleanElementText(string));
        }
    }

    public void trim() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "trim()", 358).log();
        }
        for (ExtraFeature extraFeature : this.b.values()) {
            String string = extraFeature.getValue();
            extraFeature.setValue(Misc.safeTrimToNull((String)string));
        }
    }

    public JsonValue asJsonValue() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "asJsonValue()", 370).log();
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("map", Json.value((Object)this.b));
        return jsonObject;
    }

    public static ExtraFeatureSet fromJsonValue(JsonValue jsonValue) {
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "fromJsonValue(JsonValue)", 384).addDetail("resAsJson", (Object)jsonValue)).log();
        }
        if (jsonValue == null) {
            throw new IllegalArgumentException("resAsJson is marked non-null but is null");
        }
        if (ExtraFeatureSet.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "fromJsonValue(JsonValue)", 386).addDetail("resAsJson", (Object)jsonValue)).log();
        }
        ExtraFeatureSet extraFeatureSet = new ExtraFeatureSet();
        JsonValue jsonValue2 = jsonValue.asObject().get("map");
        if (jsonValue2.isObject()) {
            for (JsonObject.Member member : jsonValue2.asObject()) {
                try {
                    ExtraFeature extraFeature = ExtraFeature.fromJsonValue(member.getValue());
                    if (ExtraFeatureSet.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "fromJsonValue(JsonValue)", 395).add("extraFeature", (Object)extraFeature)).log();
                    }
                    extraFeatureSet.add(extraFeature);
                }
                catch (Exception exception) {
                    if (ExtraFeatureSet.a.level < 5) continue;
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "fromJsonValue(JsonValue)", 398).add("ex", (Object)exception)).log();
                }
            }
        } else {
            throw new IllegalArgumentException("extraFeatureSet has no map");
        }
        return extraFeatureSet;
    }

    public boolean areLabelConstraintsValid() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "areLabelConstraintsValid()", 409).log();
        }
        int n2 = 0;
        String string = null;
        if (this.b.get(QFS_LABEL_BEST) == null) {
            return false;
        }
        Object object = this.b.values().iterator();
        while (object.hasNext()) {
            ExtraFeature extraFeature = (ExtraFeature)object.next();
            if (!extraFeature.isLabelVariant()) continue;
            if (extraFeature.getState() == 2) {
                return false;
            }
            if (extraFeature.isRegexp()) {
                return false;
            }
            if (extraFeature.getState() != 1) continue;
            ++n2;
            if (QFS_LABEL_BEST.equals(extraFeature.getName())) continue;
            string = extraFeature.getValue();
        }
        if (n2 > 1) {
            return false;
        }
        if (string != null && (object = (ExtraFeature)this.b.get(QFS_LABEL_BEST)) != null) {
            return string.equals(((ExtraFeature)object).getValue());
        }
        return true;
    }

    public void enrichLabelFeaturesWithSet() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "enrichLabelFeaturesWithSet()", 445).log();
        }
        for (ExtraFeature extraFeature : this.b.values()) {
            if (!extraFeature.isLabelVariant()) continue;
            extraFeature.setExtraFeatureSet(this);
        }
    }

    public void revokeSetForLabelFeatures() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "revokeSetForLabelFeatures()", 455).log();
        }
        for (ExtraFeature extraFeature : this.b.values()) {
            if (!extraFeature.isLabelVariant()) continue;
            extraFeature.setExtraFeatureSet(null);
        }
    }

    public void setAllShouldMatchLabelFeaturesStateToIgnore() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "setAllShouldMatchLabelFeaturesStateToIgnore()", 465).log();
        }
        for (ExtraFeature extraFeature : this.b.values()) {
            if (!extraFeature.isLabelVariant() || extraFeature.getState() != 1) continue;
            extraFeature.setState(0);
        }
    }

    public void setCorrespondentSpecificLabelValue(String string) {
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setCorrespondentSpecificLabelValue(String)", 475).addDetail("value", string)).log();
        }
        for (ExtraFeature extraFeature : this.b.values()) {
            if (!extraFeature.isLabelVariant() || extraFeature.getState() != 1 || extraFeature.getValue() == null || !extraFeature.getValue().equals(((ExtraFeature)this.b.get(QFS_LABEL_BEST)).getValue()) || extraFeature.getValue().equals(string)) continue;
            extraFeature.setValueWithoutCheck(string);
        }
    }

    public void setBestLabelValue(String string) {
        ExtraFeature extraFeature;
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setBestLabelValue(String)", 490).addDetail("value", string)).log();
        }
        if ((extraFeature = (ExtraFeature)this.b.get(QFS_LABEL_BEST)) != null && !Misc.equalOrNull((Object)extraFeature.getValue(), (Object)string)) {
            extraFeature.setValueWithoutCheck(string);
        }
    }

    private void a() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "removeBestLabel()", 500).log();
        }
        this.b.remove(QFS_LABEL_BEST);
    }

    private void a(ExtraFeature extraFeature) {
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "ensureLabelConstraintsForAdd(ExtraFeature)", 506).addDetail("addedExtraFeature", (Object)extraFeature)).log();
        }
        if (extraFeature.isLabelVariant() && extraFeature.getState() == 1) {
            this.setAllShouldMatchLabelFeaturesStateToIgnore();
            this.setBestLabelValue(extraFeature.getValue());
        }
        if (extraFeature.getName().equals(QFS_LABEL_BEST) && extraFeature.getState() == 0) {
            this.setCorrespondentSpecificLabelValue(extraFeature.getValue());
        }
    }

    private void a(String string) {
        ExtraFeature extraFeature;
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "ensureLabelConstraintsForRemove(String)", 523).addDetail("removedExtraFeatureName", string)).log();
        }
        if ((extraFeature = this.get(string)) == null) {
            return;
        }
        if (QFS_LABEL_BEST.equals(string)) {
            this.setAllShouldMatchLabelFeaturesStateToIgnore();
        } else if (extraFeature.isLabelVariant() && extraFeature.getState() == 1) {
            this.a();
        }
    }

    public TreeMap getMap() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "getMap()", 63).log();
        }
        return this.b;
    }

    public boolean isHoldLabelConstraints() {
        if (ExtraFeatureSet.a.level >= 7) {
            a.lvlBuild(7, "isHoldLabelConstraints()", 65).log();
        }
        return this.c;
    }

    public ExtraFeatureSet setHoldLabelConstraints(boolean bl) {
        if (ExtraFeatureSet.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setHoldLabelConstraints(boolean)", 65).addDetail("holdLabelConstraints", bl)).log();
        }
        this.c = bl;
        return this;
    }
}

