/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.exceptions;

import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExceptionData
implements Serializable {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.exceptions.ExceptionData");
    static final long serialVersionUID = 8035368023027588958L;
    public String className;
    public String message;
    public String rawmessage;
    public String stacktrace;

    public ExceptionData() {
    }

    public ExceptionData(Throwable throwable) {
        this.className = throwable.getClass().getName();
        this.message = throwable.getLocalizedMessage();
        this.rawmessage = throwable.getMessage();
        this.stacktrace = Log.getStackTrace((Throwable)throwable);
    }

    public String toString() {
        return super.toString() + "[" + this.className + " \"" + this.message + "\"]";
    }

    public Exception recreateException() {
        StackTraceElement[] stackTraceElementArray;
        Exception exception;
        block7: {
            block6: {
                exception = null;
                try {
                    stackTraceElementArray = Class.forName(this.className);
                    exception = (Exception)Reflector.safeCreateInstance(stackTraceElementArray, String.class, (Object)this.rawmessage);
                }
                catch (Throwable throwable) {
                    if (ExceptionData.a.level < 9) break block6;
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "recreateException()", 120).add("Could not create exception with message", (Object)throwable)).log();
                }
            }
            if (exception == null) {
                try {
                    stackTraceElementArray = Class.forName(this.className);
                    exception = (Exception)Reflector.safeCreateInstance(stackTraceElementArray);
                }
                catch (Throwable throwable) {
                    if (ExceptionData.a.level < 9) break block7;
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "recreateException()", 127).add("Could not create exception", (Object)throwable)).log();
                }
            }
        }
        if (exception == null) {
            exception = new TestException(this.className + ": " + this.rawmessage);
        }
        stackTraceElementArray = this.a(this.stacktrace);
        exception.setStackTrace(stackTraceElementArray);
        return exception;
    }

    private StackTraceElement[] a(String string) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = string.split("\n\tat ");
        Pattern pattern = Pattern.compile("(.*)\\.([^\\.]+)\\(([^\\)]+)\\)");
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            Object object;
            Matcher matcher = pattern.matcher(stringArray[i2]);
            if (!matcher.find()) continue;
            String string2 = null;
            int n2 = 0;
            String string3 = matcher.group(3);
            if ("Native Method".equals(string3)) {
                n2 = -2;
            } else {
                object = Misc.fastSplit((String)string3, (char)':', (int)2);
                string2 = object[0];
                try {
                    n2 = Integer.parseInt(object[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = new StackTraceElement(matcher.group(1), matcher.group(2), string2, n2);
            arrayList.add((String[])object);
        }
        return arrayList.toArray(new StackTraceElement[arrayList.size()]);
    }
}

