/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.extensions.image;

import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.ImageHandler;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.extensions.image.NativeImageHandler;
import de.qfs.apps.qftest.shared.image.BaseImageHelper;
import de.qfs.apps.qftest.shared.script.modules.QF;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.system.NativeRobot;
import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Observer;
import de.qfs.lib.util.Reflector;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Set;

public abstract class BaseImageHandler
implements ImageHandler {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.extensions.image.BaseImageHandler");
    public static final int DEFAULT_COMPRESSION = 6;
    static volatile BaseImageHandler c = null;
    static volatile BaseImageHandler d = null;
    static volatile BaseImageHandler e = null;
    static volatile BaseImageHandler f = null;
    static boolean g = true;
    static boolean h = true;
    private static Observer b = (observable, object) -> {
        f = null;
    };

    public BaseImageHandler() {
        if (BaseImageHandler.a.level >= 7) {
            a.lvlBuild(7, "BaseImageHandler.BaseImageHandler()", 53).log();
        }
    }

    public static BaseImageHandler instance() {
        if (f != null) {
            return f;
        }
        try {
            Options.getOption(Options.OPT_DEFAULT_SCREENSHOT_TECHNOLOGY).addObserver(b);
            String string = Options.cached_OPT_DEFAULT_SCREENSHOT_TECHNOLOGY;
            if (BaseImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "instance()", 95).add("defaultTechnology", string)).add("nativeImageHandler", (Object)e)).add("standaloneFxImageHandler", (Object)c)).add("awtImageHandler", (Object)d)).log();
            }
            for (String string2 : string.split(",")) {
                Object unsupportedClassVersionError;
                if (h && "native".equals(string2)) {
                    if (e != null) {
                        f = e;
                        return f;
                    }
                    unsupportedClassVersionError = Native.instance().getNativeRobot();
                    if (unsupportedClassVersionError == null) {
                        h = false;
                        continue;
                    }
                    f = e = new NativeImageHandler((NativeRobot)unsupportedClassVersionError);
                    return f;
                }
                if (!g || !"fx".equals(string2)) break;
                try {
                    if (c != null) {
                        f = c;
                        return f;
                    }
                    unsupportedClassVersionError = BaseImageHandler.class.getClassLoader().loadClass("de.qfs.apps.qftest.shared.extensions.image.StandaloneFxImageHandler");
                    f = c = (BaseImageHandler)Reflector.call((Class)unsupportedClassVersionError, (String)"instance");
                    return f;
                }
                catch (UnsupportedClassVersionError classNotFoundException) {
                    if (BaseImageHandler.a.level >= 5) {
                        ((LevelAwareLogBuilder)a.lvlBuild(5, "instance()", 127).add("ex", (Object)classNotFoundException)).log();
                    }
                    g = false;
                    break;
                }
                catch (ClassNotFoundException throwable) {
                    if (BaseImageHandler.a.level >= 5) {
                        ((LevelAwareLogBuilder)a.lvlBuild(5, "instance()", 131).add("ex", (Object)throwable)).log();
                    }
                    g = false;
                }
                catch (Throwable throwable) {
                    if (BaseImageHandler.a.level < 3) break;
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "instance()", 136).add("ex", (Object)throwable)).log();
                    break;
                }
            }
            if (d != null) {
                f = d;
                return f;
            }
            Class<?> clazz = BaseImageHandler.class.getClassLoader().loadClass("de.qfs.apps.qftest.shared.extensions.image.AWTImageHandler");
            f = d = (BaseImageHandler)Reflector.call(clazz, (String)"instance");
            return f;
        }
        catch (Exception exception) {
            if (BaseImageHandler.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "instance()", 153).add("e", (Object)exception)).log();
            }
            BaseImageHandler.maybeLogWarningInRunLog("failureLoadingImageHandler.message", exception);
            return null;
        }
    }

    public static BaseImageHandler instance(Object object) {
        try {
            if (object != null) {
                boolean bl = (Boolean)Reflector.call((Object)object, (String)"isSWT");
                boolean bl2 = (Boolean)Reflector.call((Object)object, (String)"isWeb");
                boolean bl3 = (Boolean)Reflector.call((Object)object, (String)"isFx");
                boolean bl4 = (Boolean)Reflector.call((Object)object, (String)"isAndroid");
                boolean bl5 = (Boolean)Reflector.call((Object)object, (String)"isIOS");
                boolean bl6 = (Boolean)Reflector.call((Object)object, (String)"isWin");
                ClassLoader classLoader = BaseImageHandler.class.getClassLoader();
                if (bl) {
                    Class<?> clazz = classLoader.loadClass("de.qfs.apps.qftest.client.swt.SWTImageHandler");
                    return (BaseImageHandler)Reflector.call(clazz, (String)"instance", object.getClass(), (Object)object);
                }
                if (bl2) {
                    Class<?> clazz = classLoader.loadClass("de.qfs.apps.qftest.client.web.WebImageHandler");
                    Class<?> clazz2 = classLoader.loadClass("de.qfs.apps.qftest.client.web.WebEngine");
                    return (BaseImageHandler)Reflector.call(clazz, (String)"instance", clazz2, (Object)object);
                }
                if (bl3) {
                    Class<?> clazz = classLoader.loadClass("de.qfs.apps.qftest.client.fx.image.FxImageHandler");
                    return (BaseImageHandler)Reflector.call(clazz, (String)"instance");
                }
                if (bl4 || bl5) {
                    Class<?> clazz = classLoader.loadClass("de.qfs.apps.qftest.client.mobile.image.MobileImageHandler");
                    Class<?> clazz3 = classLoader.loadClass("de.qfs.apps.qftest.client.mobile.MobileEngine");
                    return (BaseImageHandler)Reflector.call(clazz, (String)"instance", clazz3, (Object)object);
                }
                if (bl6) {
                    Class<?> clazz = classLoader.loadClass("de.qfs.apps.qftest.client.win.WinImageHandler");
                    Object object2 = Reflector.call((Object)object, (String)"getHelper");
                    return (BaseImageHandler)Reflector.call(clazz, (String)"instance", object.getClass(), (Object)object);
                }
                Class<?> clazz = classLoader.loadClass("de.qfs.apps.qftest.shared.extensions.image.AWTImageHandler");
                return (BaseImageHandler)Reflector.call(clazz, (String)"instance");
            }
            return BaseImageHandler.instance();
        }
        catch (Exception exception) {
            if (BaseImageHandler.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "instance(Object)", 226).add("e", (Object)exception)).log();
            }
            BaseImageHandler.maybeLogWarningInRunLog("failureLoadingImageHandler2.message", object, exception);
            return null;
        }
    }

    @Override
    public ImageRep grabScreenshot(int n2) {
        if (BaseImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "grabScreenshot(int)", 241).addDetail("monitor", n2)).log();
        }
        int[] nArray = this.getBoundsOfScreen(n2);
        return this.grabScreenshot(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    @Override
    public ImageRep[] grabScreenshots() {
        if (BaseImageHandler.a.level >= 7) {
            a.lvlBuild(7, "grabScreenshots()", 251).log();
        }
        return this.grabSpecifiedScreenshots(null, false);
    }

    @Override
    public ImageRep grabScreenshotOfAllScreens() {
        if (BaseImageHandler.a.level >= 7) {
            a.lvlBuild(7, "grabScreenshotOfAllScreens()", 262).log();
        }
        return this.grabSpecifiedScreenshots(null, true)[0];
    }

    public int getScreenForRegion(int n2, int n3, int n4, int n5) {
        if (BaseImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getScreenForRegion(int,int,int,int)", 283).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).dumpStack();
        }
        int n6 = 0;
        int n7 = -1;
        for (int i2 = 0; i2 < this.getMonitorCount(); ++i2) {
            int n8;
            int[] nArray = this.getBoundsOfScreen(i2);
            if (BaseImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForRegion(int,int,int,int)", 289).add("bounds", (Object)nArray)).log();
            }
            int n9 = Math.max(n2, nArray[0]);
            int n10 = Math.min(n2 + n4, nArray[0] + nArray[2]);
            int n11 = Math.max(n3, nArray[1]);
            int n12 = Math.min(n3 + n5, nArray[1] + nArray[3]);
            if (BaseImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForRegion(int,int,int,int)", 295).add("left", n9)).add("right", n10)).add("top", n11)).add("bottom", n12)).log();
            }
            int n13 = n10 - n9;
            int n14 = n12 - n11;
            if (BaseImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForRegion(int,int,int,int)", 299).add("w", n13)).add("h", n14)).log();
            }
            if (n13 <= 0 || n14 <= 0 || (n8 = n13 * n14) <= n6) continue;
            n6 = n8;
            n7 = i2;
            if (BaseImageHandler.a.level < 9) continue;
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForRegion(int,int,int,int)", 305).add("max", n6)).add("best", n7)).log();
        }
        return n7;
    }

    @Override
    public boolean isComponentShownOnVisibleMonitors(Object object) {
        if (BaseImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isComponentShownOnVisibleMonitors(Object)", 318).addDetail("com", object)).log();
        }
        return this.getScreenForComponent(object) >= 0;
    }

    public ImageRep[] grabSpecifiedScreenshots(Set set, boolean bl) {
        if (BaseImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabSpecifiedScreenshots(Set<Integer>,boolean)", 338).addDetail("specifiedMonitors", (Object)set)).addDetail("asSingleImage", bl)).dumpStack();
        }
        try {
            ArrayList<ImageRep> arrayList = new ArrayList<ImageRep>();
            int n2 = this.getMonitorCount();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            ImageRep imageRep = null;
            if (bl) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (set != null && !set.contains(i2)) {
                        if (BaseImageHandler.a.level < 9) continue;
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "grabSpecifiedScreenshots(Set<Integer>,boolean)", 350).add("Skipping monitor ")).add(i2)).log();
                        continue;
                    }
                    int[] nArray = this.getBoundsOfScreen(i2);
                    n3 = Math.min(n3, nArray[0]);
                    n4 = Math.max(n4, nArray[0] + nArray[2]);
                    n5 = Math.min(n5, nArray[1]);
                    n6 = Math.max(n6, nArray[1] + nArray[3]);
                }
                int[] nArray = new int[(n4 - n3) * (n6 - n5)];
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    nArray[i3] = -16777216;
                }
                imageRep = new ImageRep("total screen area", nArray, ImageRep.CompressionMode.BINARY, n4 - n3, n6 - n5);
                arrayList.add(imageRep);
            }
            for (int i4 = 0; i4 < n2; ++i4) {
                if (set != null && !set.contains(i4)) {
                    if (BaseImageHandler.a.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "grabSpecifiedScreenshots(Set<Integer>,boolean)", 370).add("Skipping monitor ")).add(i4)).log();
                    }
                    arrayList.add(null);
                    continue;
                }
                ImageRep imageRep2 = this.grabScreenshot(i4);
                if (bl) {
                    int[] nArray = this.getBoundsOfScreen(i4);
                    BaseImageHelper.mergeImage(imageRep, imageRep2, nArray[0], nArray[1]);
                    continue;
                }
                arrayList.add(imageRep2);
            }
            if (!arrayList.isEmpty()) {
                return arrayList.toArray(new ImageRep[0]);
            }
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Throwable throwable) {
            if (BaseImageHandler.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "grabSpecifiedScreenshots(Set<Integer>,boolean)", 390).add("ex", (Object)throwable)).log();
            }
            BaseImageHandler.maybeLogWarningInRunLogWithStackTrace(this.getClass(), "screenshotCreationFailure.message", throwable);
            return null;
        }
    }

    public abstract int getScreenForComponent(Object var1);

    @Override
    public void savePng(String string, ImageRep imageRep) {
        if (BaseImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "savePng(String,ImageRep)", 425).addDetail("filename", string)).addDetail("imageRep", (Object)imageRep)).log();
        }
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));){
            bufferedOutputStream.write(BaseImageHelper.pngEncode(imageRep));
        }
        catch (Exception exception) {
            if (BaseImageHandler.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "savePng(String,ImageRep)", 430).add("e", (Object)exception)).log();
            }
            String string2 = Misc.emptyOrNull((String)imageRep.getName()) ? "Img(" + imageRep.getWidth() + "x" + imageRep.getHeight() + ")" : imageRep.getName();
            BaseImageHandler.maybeLogWarningInRunLog("imageNotSaveable.message", string2, string, exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImageRep loadPng(String string) {
        if (BaseImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "loadPng(String)", 448).addDetail("filename", string)).log();
        }
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            ImageRep imageRep = this.getHelper().pngDecode(fileInputStream);
            return imageRep;
        }
        catch (Exception exception) {
            if (BaseImageHandler.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "loadPng(String)", 453).add("e", (Object)exception)).log();
            }
            BaseImageHandler.maybeLogWarningInRunLog("imageNotLoadable.message", string, exception);
            return null;
        }
    }

    public abstract BaseImageHelper getHelper();

    public static void maybeLogWarningInRunLog(String string, Object ... objectArray) {
        if (BaseImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "maybeLogWarningInRunLog(String,Object[])", 488).addDetail("message", string)).addDetail("objects", (Object)objectArray)).log();
        }
        if (Options.cached_OPT_IMG_HANDLER_LOG_WARNING) {
            if (objectArray == null || objectArray.length == 0) {
                QF.logWarning(string, false, false);
            } else {
                QF.logWarning(Message.format((String)string, (Object[])objectArray), false, false);
            }
        }
    }

    public static void maybeLogWarningInRunLogWithStackTrace(Class clazz, String string, Object object) {
        if (BaseImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "maybeLogWarningInRunLogWithStackTrace(Class<? extends Object>,String,Object)", 502).addDetail("callingClass", (Object)clazz)).addDetail("message", string)).addDetail("ex", object)).log();
        }
        String string2 = clazz == null ? "unknown" : clazz.getSimpleName();
        String string3 = object instanceof Throwable ? Log.getStackTrace((Throwable)((Throwable)object)) : String.valueOf(object);
        BaseImageHandler.maybeLogWarningInRunLog(string, string2, string3);
    }

    public static void setCanUseFx(boolean bl) {
        if (BaseImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setCanUseFx(boolean)", 67).addDetail("canUseFx", bl)).log();
        }
        g = bl;
    }

    public static void setCanUseNative(boolean bl) {
        if (BaseImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setCanUseNative(boolean)", 68).addDetail("canUseNative", bl)).log();
        }
        h = bl;
    }
}

