/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.extensions.image;

import com.sixlegs.png.PngImage;
import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.image.BaseImageHandler;
import de.qfs.apps.qftest.shared.extensions.image.ImageComparator;
import de.qfs.apps.qftest.shared.extensions.image.ImageRepDrawer;
import de.qfs.apps.qftest.shared.image.AWTImageHelper;
import de.qfs.apps.qftest.shared.image.BaseImageHelper;
import de.qfs.apps.qftest.shared.image.DefaultImageComparator;
import de.qfs.apps.qftest.shared.variables.VariableDataHelperRegistry;
import de.qfs.apps.qftest.shared.variables.VariableDataView;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class ImageRep
implements Serializable,
Cloneable {
    private static final QFLogger b = new QFLogger("de.qfs.apps.qftest.shared.extensions.image.ImageRep");
    private static final Color c = new Color(70, 140, 195);
    private static final AtomicReference d = new AtomicReference();
    static final long serialVersionUID = 7893919702409074615L;
    protected String name;
    protected int width;
    protected int height;
    protected int screen = -1;
    protected transient String client;
    protected byte[] deflated;
    protected CompressionMode compressionMode = CompressionMode.BINARY;
    private transient WeakReference e;
    private transient WeakReference f;
    protected transient ImageComparator comparator = new DefaultImageComparator();

    public ImageRep() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "ImageRep()", 177).log();
        }
    }

    public ImageRep(String string, byte[] byArray, CompressionMode compressionMode, int n2, int n3) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "ImageRep(String,byte[],CompressionMode,int,int)", 194).addDetail("name", string)).addDetail("deflated", (Object)byArray)).addDetail("compressionMode", (Object)compressionMode)).addDetail("width", n2)).addDetail("height", n3)).log();
        }
        if (n2 < 1 || n3 < 1 || byArray.length < 1) {
            throw new RuntimeException("The image data does not match width or height.");
        }
        this.name = string;
        this.deflated = byArray;
        this.compressionMode = compressionMode;
        this.width = n2;
        this.height = n3;
    }

    public ImageRep(String string, int[] nArray, CompressionMode compressionMode, int n2, int n3) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "ImageRep(String,int[],CompressionMode,int,int)", 219).addDetail("name", string)).addDetail("argb", (Object)nArray)).addDetail("compressionMode", (Object)compressionMode)).addDetail("width", n2)).addDetail("height", n3)).log();
        }
        if (n2 * n3 != nArray.length) {
            throw new RuntimeException("The image data does not match width or height.");
        }
        this.name = string;
        this.compressionMode = compressionMode;
        this.width = n2;
        this.height = n3;
        this.a(nArray);
        this.e = null;
    }

    public ImageRep(String string, byte[] byArray, boolean bl, int n2, int n3) {
        this(string, byArray, bl ? CompressionMode.PNG : CompressionMode.BINARY, n2, n3);
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "ImageRep(String,byte[],boolean,int,int)", 252).addDetail("name", string)).addDetail("deflated", (Object)byArray)).addDetail("png", bl)).addDetail("width", n2)).addDetail("height", n3)).log();
        }
    }

    public ImageRep(String string, int[] nArray, boolean bl, int n2, int n3) {
        this(string, nArray, bl ? CompressionMode.PNG : CompressionMode.BINARY, n2, n3);
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "ImageRep(String,int[],boolean,int,int)", 271).addDetail("name", string)).addDetail("argb", (Object)nArray)).addDetail("png", bl)).addDetail("width", n2)).addDetail("height", n3)).log();
        }
    }

    public ImageRep(String string, BufferedImage bufferedImage) {
        this(string, new int[bufferedImage.getWidth() * bufferedImage.getHeight()], CompressionMode.BINARY, bufferedImage.getWidth(), bufferedImage.getHeight());
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "ImageRep(String,BufferedImage)", 286).addDetail("name", string)).addDetail("image", (Object)bufferedImage)).log();
        }
        if (bufferedImage == null) {
            throw new IllegalArgumentException("image is marked non-null but is null");
        }
        this.setBufferedImage(bufferedImage);
    }

    public final String getName() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getName()", 304).log();
        }
        return this.name;
    }

    public final void setName(String string) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setName(String)", 317).addDetail("name", string)).log();
        }
        this.name = string;
    }

    public final int getWidth() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getWidth()", 330).log();
        }
        return this.width;
    }

    public final void setWidth(int n2) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setWidth(int)", 343).addDetail("width", n2)).log();
        }
        this.width = n2;
    }

    public final int getHeight() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getHeight()", 356).log();
        }
        return this.height;
    }

    public final void setHeight(int n2) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setHeight(int)", 369).addDetail("height", n2)).log();
        }
        this.height = n2;
    }

    public final int getScreen() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getScreen()", 382).log();
        }
        return this.screen;
    }

    public final void setScreen(int n2) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setScreen(int)", 395).addDetail("screen", n2)).log();
        }
        this.screen = n2;
    }

    public final String getClient() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getClient()", 408).log();
        }
        return this.client;
    }

    public final void setClient(String string) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setClient(String)", 421).addDetail("client", string)).log();
        }
        this.client = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPng() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getPng()", 434).log();
        }
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getPng()", 436).add("this", (Object)this)).log();
        }
        ImageRep imageRep = this;
        synchronized (imageRep) {
            if (this.compressionMode == CompressionMode.PNG) {
                if (this.deflated == null && ImageRep.b.level >= 1) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(1, "getPng()", 441).add("Internal error - this: ")).add((Object)this)).log();
                }
                return this.deflated;
            }
            return BaseImageHelper.pngEncode(this.getARGB(), this.width, this.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPng(byte[] byArray) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setPng(byte[])", 459).addDetail("deflated", (Object)byArray)).log();
        }
        ImageRep imageRep = this;
        synchronized (imageRep) {
            this.deflated = byArray;
            this.compressionMode = CompressionMode.PNG;
            this.e = null;
            this.f = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getWebP() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getWebP()", 478).log();
        }
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getWebP()", 480).add("this", (Object)this)).log();
        }
        ImageRep imageRep = this;
        synchronized (imageRep) {
            if (this.compressionMode == CompressionMode.WEBP) {
                if (this.deflated == null && ImageRep.b.level >= 1) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(1, "getWebP()", 485).add("Internal error - this: ")).add((Object)this)).log();
                }
                return this.deflated;
            }
            int[] nArray = this.getARGB();
            return BaseImageHelper.webpEncode(nArray, this.width, this.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebP(byte[] byArray) throws IOException {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setWebP(byte[])", 501).addDetail("deflated", (Object)byArray)).log();
        }
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setWebP(byte[])", 503).add("this", (Object)this)).log();
        }
        ImageRep imageRep = this;
        synchronized (imageRep) {
            this.compressionMode = CompressionMode.WEBP;
            int[] nArray = BaseImageHelper.webpDecode(byArray, this.width, this.height);
            this.setARGB(nArray, this.width, this.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getARGB() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getARGB()", 520).log();
        }
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getARGB()", 522).add("this", (Object)this)).log();
        }
        int[] nArray = null;
        ImageRep imageRep = this;
        synchronized (imageRep) {
            int[] nArray2 = nArray = this.e == null ? null : (int[])this.e.get();
            if (nArray == null && this.deflated != null) {
                switch (this.compressionMode) {
                    case PNG: {
                        ImageRep imageRep2 = BaseImageHandler.instance().getHelper().createImageRep(new ByteArrayInputStream(this.deflated));
                        if (imageRep2 != null) {
                            nArray = imageRep2.getARGB();
                            this.e = new WeakReference<int[]>(nArray);
                            break;
                        }
                        if (ImageRep.b.level < 3) break;
                        ((LevelAwareLogBuilder)b.lvlBuild(3, "getARGB()", 536).add("Broken PNG image")).log();
                        break;
                    }
                    case WEBP: {
                        try {
                            nArray = BaseImageHelper.webpDecode(this.deflated, this.width, this.height);
                            this.e = new WeakReference<int[]>(nArray);
                        }
                        catch (Exception exception) {
                            if (ImageRep.b.level < 3) break;
                            ((LevelAwareLogBuilder)b.lvlBuild(3, "getARGB()", 545).add("e", (Object)exception)).log();
                        }
                        break;
                    }
                    default: {
                        nArray = BaseImageHelper.inflateRGB(this.deflated, this.width * this.height);
                        this.e = new WeakReference<int[]>(nArray);
                    }
                }
            }
        }
        if (nArray == null) {
            if (ImageRep.b.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(3, "getARGB()", 558).add("Broken image - ")).add("width", this.width)).add("x")).add("height", this.height)).log();
            }
            nArray = ImageRep.getInvalidImage(this.width, this.height);
            this.e = new WeakReference<int[]>(nArray);
        }
        return nArray;
    }

    public void setARGB(int[] nArray) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setARGB(int[])", 573).addDetail("argb", (Object)nArray)).log();
        }
        this.setARGB(nArray, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setARGB(int[] nArray, int n2, int n3) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "setARGB(int[],int,int)", 588).addDetail("argb", (Object)nArray)).addDetail("width", n2)).addDetail("height", n3)).log();
        }
        if (ImageRep.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "setARGB(int[],int,int)", 590).add("this", (Object)this)).log();
        }
        ImageRep imageRep = this;
        synchronized (imageRep) {
            this.e = new WeakReference<int[]>(nArray);
            this.deflated = null;
            this.f = null;
            this.width = n2;
            this.height = n3;
            this.a(nArray);
        }
    }

    public int getHashCode() {
        int[] nArray;
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getHashCode()", 611).log();
        }
        if (ImageRep.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getHashCode()", 613).add("this", (Object)this)).log();
        }
        if ((nArray = this.getARGB()) == null) {
            throw new IllegalArgumentException("No image");
        }
        int n2 = Arrays.hashCode(nArray);
        return n2;
    }

    public int getPixel(int n2, int n3) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getPixel(int,int)", 635).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        if (n2 < 0 || n2 >= this.width || n3 < 0 || n3 >= this.height) {
            throw new IllegalArgumentException("Bad coordinates: " + n2 + "," + n3);
        }
        int[] nArray = this.getARGB();
        if (nArray == null) {
            throw new IllegalArgumentException("No image");
        }
        return nArray[this.width * n3 + n2];
    }

    public final ImageComparator getComparator() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getComparator()", 657).log();
        }
        return this.comparator;
    }

    public final void setComparator(ImageComparator imageComparator) throws IllegalArgumentException {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setComparator(ImageComparator)", 672).addDetail("comparator", (Object)imageComparator)).log();
        }
        if (imageComparator == null) {
            throw new IllegalArgumentException("Comparator must not be null");
        }
        this.comparator = imageComparator;
    }

    public void crop(int n2, int n3, int n4, int n5) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "crop(int,int,int,int)", 693).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
        }
        int n6 = this.width;
        int n7 = this.height;
        int[] nArray = this.getARGB();
        int[] nArray2 = BaseImageHelper.getRGBRegion(nArray, n6, n7, n2, n3, n4, n5);
        this.setARGB(nArray2, n4, n5);
    }

    public boolean equals(ImageRep imageRep) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "equals(ImageRep)", 712).addDetail("compare", (Object)imageRep)).log();
        }
        return (this.comparator == null ? new DefaultImageComparator() : this.comparator).equals(imageRep, this);
    }

    public void rotate(int n2) {
        int n3;
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "rotate(int)", 725).addDetail("degree", n2)).log();
        }
        if ((n2 = (n2 > 0 ? n2 : 360 - n2) % 360) % 90 != 0) {
            throw new UnsupportedOperationException("Until now the degree value needs to be dividable by 90!");
        }
        if (n2 == 0) {
            return;
        }
        int[] nArray = this.getARGB();
        int[] nArray2 = new int[nArray.length];
        if (n2 != 180) {
            int n4 = 0;
            for (n3 = 0; n3 < this.width; ++n3) {
                for (int i2 = 0; i2 < this.height; ++i2) {
                    nArray2[n4++] = nArray[this.width - 1 - n3 + i2 * this.width];
                }
            }
            n3 = this.width;
            this.width = this.height;
            this.height = n3;
            if (n2 == 270) {
                System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
            }
        }
        if (n2 >= 180) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray2[nArray.length - 1 - n3] = nArray[n3];
            }
        }
        this.setARGB(nArray2);
    }

    public ImageRepDrawer draw() throws TestException {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "draw()", 778).log();
        }
        return new ImageRepDrawer(this);
    }

    public ImageRepDrawer draw(Object object) throws TestException {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "draw(Object)", 794).addDetail("obj", object)).log();
        }
        return new ImageRepDrawer(this).draw(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] getDeflated() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getDeflated()", 813).log();
        }
        if (this.deflated == null) {
            ImageRep imageRep = this;
            synchronized (imageRep) {
                if (this.deflated == null) {
                    int[] nArray = this.e == null ? null : (int[])this.e.get();
                    this.a(nArray);
                }
            }
        }
        return this.deflated;
    }

    private synchronized void a(@Nullable int[] nArray) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setDeflatedByEncodingWithRetry(int[])", 830).addDetail("inflated", (Object)nArray)).log();
        }
        this.b(nArray);
        if (this.deflated == null) {
            this.b(nArray);
        }
        if (this.deflated == null && ImageRep.b.level >= 3) {
            ((LevelAwareLogBuilder)b.lvlBuild(3, "setDeflatedByEncodingWithRetry(int[])", 836).add("Broken image, cannot deflate")).dumpStack();
        }
    }

    private synchronized void b(@Nullable int[] nArray) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setDeflatedByEncoding(int[])", 843).addDetail("inflated", (Object)nArray)).log();
        }
        if (nArray == null) {
            if (ImageRep.b.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(3, "setDeflatedByEncoding(int[])", 846).add("Broken image", this.width)).add("height", this.height)).log();
            }
            if (this.width == 0 || this.height == 0) {
                return;
            }
            nArray = ImageRep.getInvalidImage(this.width, this.height);
        }
        assert (nArray != null);
        switch (this.compressionMode) {
            case PNG: {
                this.deflated = BaseImageHelper.pngEncode(nArray, this.width, this.height);
                break;
            }
            case WEBP: {
                this.c(nArray);
                this.deflated = BaseImageHelper.webpEncode(nArray, this.width, this.height);
                break;
            }
            default: {
                this.deflated = BaseImageHelper.deflateRGB(nArray);
            }
        }
    }

    private void c(int[] nArray) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "maybeGC(int[])", 878).addDetail("inflated", (Object)nArray)).log();
        }
        if (nArray == null) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.freeMemory();
        long l3 = nArray.length;
        if (ImageRep.b.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "maybeGC(int[])", 885).add("freeMemory", l2)).add("inflatedSize", l3)).log();
        }
        if (l2 < l3 * 4L) {
            runtime.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeflated(byte[] byArray, CompressionMode compressionMode) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "setDeflated(byte[],CompressionMode)", 903).addDetail("deflated", (Object)byArray)).addDetail("compressionMode", (Object)compressionMode)).log();
        }
        ImageRep imageRep = this;
        synchronized (imageRep) {
            this.deflated = byArray;
            this.compressionMode = compressionMode;
            this.e = null;
            this.f = null;
        }
    }

    public final boolean isPng() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "isPng()", 924).log();
        }
        return this.compressionMode == CompressionMode.PNG;
    }

    public void setPng(boolean bl) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setPng(boolean)", 939).addDetail("png", bl)).log();
        }
        this.setCompressionMode(bl ? CompressionMode.PNG : CompressionMode.BINARY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompressionMode(CompressionMode compressionMode) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setCompressionMode(CompressionMode)", 952).addDetail("compressionMode", (Object)compressionMode)).log();
        }
        ImageRep imageRep = this;
        synchronized (imageRep) {
            CompressionMode compressionMode2 = this.compressionMode;
            try {
                if (this.compressionMode != compressionMode) {
                    int[] nArray = this.getARGB();
                    this.compressionMode = compressionMode;
                    this.deflated = null;
                    this.e = new WeakReference<int[]>(nArray);
                    this.a(nArray);
                }
            }
            catch (Exception exception) {
                if (ImageRep.b.level >= 3) {
                    ((LevelAwareLogBuilder)b.lvlBuild(3, "setCompressionMode(CompressionMode)", 969).add("ex", (Object)exception)).log();
                }
                this.compressionMode = compressionMode2;
                this.getDeflated();
            }
        }
    }

    public final Object getUserData() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getUserData()", 986).log();
        }
        return this.f == null ? null : this.f.get();
    }

    public final void setUserData(Object object) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setUserData(Object)", 999).addDetail("userData", object)).log();
        }
        this.f = new WeakReference<Object>(object);
    }

    public boolean hasZeroSize() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "hasZeroSize()", 1011).log();
        }
        return this.width <= 0 || this.height <= 0;
    }

    public synchronized void cleanup() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "cleanup()", 1021).log();
        }
        this.getDeflated();
        this.e = null;
        this.f = null;
    }

    public Object clone() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "clone()", 1036).log();
        }
        try {
            ImageRep imageRep = (ImageRep)super.clone();
            imageRep.e = null;
            return imageRep;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        int[] nArray;
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "toString()", 1058).log();
        }
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("[name=");
        stringBuilder.append(this.name);
        stringBuilder.append(",width=");
        stringBuilder.append(this.width);
        stringBuilder.append(",height=");
        stringBuilder.append(this.height);
        if (this.screen >= 0) {
            stringBuilder.append(",screen=");
            stringBuilder.append(this.screen);
        }
        if (this.client != null) {
            stringBuilder.append(",client=");
            stringBuilder.append(this.client);
        }
        stringBuilder.append(",compressionMode=");
        stringBuilder.append((Object)this.compressionMode);
        stringBuilder.append(",deflated=");
        if (this.deflated == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(this.deflated);
            stringBuilder.append('[');
            stringBuilder.append(this.deflated.length);
            stringBuilder.append(']');
        }
        stringBuilder.append(",inflated=");
        int[] nArray2 = nArray = this.e == null ? null : (int[])this.e.get();
        if (nArray == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(nArray);
            stringBuilder.append('[');
            stringBuilder.append(nArray.length);
            stringBuilder.append(']');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void writeToFile(File file) throws IOException {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "writeToFile(File)", 1103).addDetail("file", (Object)file)).log();
        }
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file);
            if (file != null && file.getName().toLowerCase().endsWith(".webp")) {
                fileOutputStream.write(this.getWebP());
            } else {
                fileOutputStream.write(this.getPng());
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "writeObject(ObjectOutputStream)", 1134).addDetail("out", (Object)objectOutputStream)).log();
        }
        this.getDeflated();
        objectOutputStream.defaultWriteObject();
    }

    protected static int[] getInvalidImage(int n2, int n3) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getInvalidImage(int,int)", 1146).addDetail("width", n2)).addDetail("height", n3)).log();
        }
        n2 = Math.max(n2, 1);
        n3 = Math.max(n3, 1);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(c);
        graphics.fillRect(0, 0, n2, n3);
        for (Image image : ImageRep.getINVALID_IMAGE_PLACEHOLDERS()) {
            int n4 = image.getWidth(null);
            int n5 = image.getHeight(null);
            if (n4 > n2 || n5 > n3) continue;
            graphics.drawImage(image, (n2 - n4) / 2, (n3 - n5) / 2, null);
            break;
        }
        return AWTImageHelper.instance().getARGB(bufferedImage, false);
    }

    private static List b() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "loadInvalidImagePlaceholders()", 1170).log();
        }
        LinkedList<BufferedImage> linkedList = new LinkedList<BufferedImage>();
        for (String string : new String[]{"", "-medium", "-small", "-tiny"}) {
            try {
                InputStream inputStream;
                String string2 = "img/InvalidImage" + string + ".png";
                if (ImageRep.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "loadInvalidImagePlaceholders()", 1177).add("imgName", string2)).log();
                }
                if ((inputStream = Globals.getLocalizedResourceAsStream(string2)) == null) {
                    if (ImageRep.b.level < 9) continue;
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "loadInvalidImagePlaceholders()", 1180).add("Image not found")).log();
                    continue;
                }
                PngImage pngImage = new PngImage();
                BufferedImage bufferedImage = pngImage.read(inputStream, true);
                linkedList.add(bufferedImage);
            }
            catch (Exception exception) {
                if (ImageRep.b.level < 3) continue;
                ((LevelAwareLogBuilder)b.lvlBuild(3, "loadInvalidImagePlaceholders()", 1187).add("e", (Object)exception)).log();
            }
        }
        return linkedList;
    }

    public BufferedImage asBufferedImage() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "asBufferedImage()", 1203).log();
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        bufferedImage.setRGB(0, 0, n2, n3, this.getARGB(), 0, n2);
        return bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        if (ImageRep.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setBufferedImage(BufferedImage)", 1218).addDetail("bufferedImage", (Object)bufferedImage)).log();
        }
        if (bufferedImage == null) {
            throw new IllegalArgumentException("bufferedImage is marked non-null but is null");
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int[] nArray = bufferedImage.getRGB(0, 0, n2, n3, null, 0, n2);
        this.setARGB(nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getINVALID_IMAGE_PLACEHOLDERS() {
        Object object;
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getINVALID_IMAGE_PLACEHOLDERS()", 77).log();
        }
        if ((object = d.get()) == null) {
            AtomicReference atomicReference = d;
            synchronized (atomicReference) {
                object = d.get();
                if (object == null) {
                    List list = ImageRep.b();
                    object = list == null ? d : list;
                    d.set(object);
                }
            }
        }
        return object == d ? null : object;
    }

    public CompressionMode getCompressionMode() {
        if (ImageRep.b.level >= 7) {
            b.lvlBuild(7, "getCompressionMode()", 149).log();
        }
        return this.compressionMode;
    }

    static {
        VariableDataHelperRegistry.instance().registerView(ImageRep.class, new VariableDataView(){

            @Override
            @Nullable
            public String getToString(@Nullable Object object) {
                if (b.level >= 7) {
                    ((LevelAwareLogBuilder)b.lvlBuild(7, "VariableDataView.getToString(Object)", 92).addDetail("object", object)).log();
                }
                ImageRep imageRep = (ImageRep)object;
                assert (imageRep != null);
                return String.format("ImageRep(%s)[%dx%d]", imageRep.getName(), imageRep.getWidth(), imageRep.getHeight());
            }

            @Override
            @Nullable
            public String getDescription(@Nullable Object object) {
                if (b.level >= 7) {
                    ((LevelAwareLogBuilder)b.lvlBuild(7, "VariableDataView.getDescription(Object)", 101).addDetail("object", object)).log();
                }
                ImageRep imageRep = (ImageRep)object;
                assert (imageRep != null);
                return String.format("(ImageRep) %s[%dx%d]", imageRep.getName(), imageRep.getWidth(), imageRep.getHeight());
            }
        });
    }

    public static enum CompressionMode {
        BINARY,
        PNG,
        WEBP;


        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private CompressionMode() {
            if (b.level >= 7) {
                b.lvlBuild(7, "CompressionMode.CompressionMode()", 67).log();
            }
        }
    }
}

