/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.extensions.image;

import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.script.ScriptObjectHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ImageRepDrawer {
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f, 2, 1);
    public static final String DEFAULT_FONT_NAME = "Monospaced";
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final int DEFAULT_FONT_STYLE = 0;
    public static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    public static final int DEFAULT_STROKE_SIZE = 1;
    public static final Color DEFAULT_STROKE_COLOR = Color.BLACK;
    public static final Color DEFAULT_FILL_COLOR = null;
    public static final Color DEFAULT_ERASE_COLOR = Color.BLACK;
    public static final int CAPS_SQUARED = 0;
    public static final int CAPS_ROUND = 1;
    private ImageRep a;
    private BufferedImage b;
    private int c = 1;
    private Color d;
    private int e;
    private Color f;
    private Font g;

    public ImageRepDrawer(ImageRep imageRep) throws TestException {
        if (imageRep == null) {
            throw new NullPointerException("The image to edit must not be null!");
        }
        try {
            this.a = imageRep;
            this.b = imageRep.asBufferedImage();
            this.d = Color.BLACK;
            this.c = 1;
            this.e = 0;
            this.f = null;
            this.g = null;
        }
        catch (Throwable throwable) {
            throw new TestException("Could not convert to buffered image", throwable);
        }
    }

    public ImageRepDrawer draw(Object object) throws TestException {
        if (object == null) {
            throw new IllegalArgumentException("Object to draw must not be null!");
        }
        try {
            Graphics2D graphics2D = this.b.createGraphics();
            if (object instanceof DrawInterface) {
                ((DrawInterface)object).call(graphics2D);
            } else {
                ScriptObjectHelper.a(object).a(graphics2D);
            }
            graphics2D.dispose();
        }
        catch (Throwable throwable) {
            throw new TestException("Could not draw on image", throwable);
        }
        try {
            this.a.setBufferedImage(this.b);
        }
        catch (Throwable throwable) {
            throw new TestException("Could not convert to image rep", throwable);
        }
        return this;
    }

    public ImageRepDrawer drawFigure(Object object, Color color) throws TestException {
        Graphics2D graphics2D;
        if (object == null) {
            throw new IllegalArgumentException("Object to draw must not be null!");
        }
        if (color == null) {
            throw new IllegalArgumentException("Drawing color must not be null!");
        }
        int n2 = this.b.getWidth();
        int n3 = this.b.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        try {
            graphics2D = bufferedImage.createGraphics();
            if (object instanceof DrawInterface) {
                ((DrawInterface)object).call(graphics2D);
            } else {
                ScriptObjectHelper.a(object).a(graphics2D);
            }
            graphics2D.dispose();
        }
        catch (Throwable throwable) {
            throw new TestException("Could not draw on image", throwable);
        }
        try {
            graphics2D = this.b.createGraphics();
            graphics2D.setStroke(DEFAULT_STROKE);
            graphics2D.setColor(color);
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < n3; ++i3) {
                    if ((nArray = writableRaster.getPixel(i2, i3, nArray))[0] != 0 || nArray[1] != 0 || nArray[2] != 0 || nArray[3] != 255) continue;
                    graphics2D.drawLine(i2, i3, i2, i3);
                }
            }
            graphics2D.dispose();
        }
        catch (Throwable throwable) {
            throw new TestException("Could not draw on image", throwable);
        }
        try {
            this.a.setBufferedImage(this.b);
        }
        catch (Throwable throwable) {
            throw new TestException("Could not convert to image rep", throwable);
        }
        return this;
    }

    public final ImageRepDrawer setStrokeCap(int n2) throws TestException {
        if (n2 != 0 && n2 != 1) {
            throw new TestException("stroke Caps should either be 0 or 1, not " + n2);
        }
        this.e = n2;
        return this;
    }

    public final ImageRepDrawer setStrokeSize(int n2) throws TestException {
        if (this.c < 0) {
            throw new TestException("Size must not be negative!");
        }
        this.c = n2;
        return this;
    }

    public final ImageRepDrawer setStrokeColor(Color color) throws TestException {
        this.d = color;
        return this;
    }

    public final ImageRepDrawer setStrokeColor(int n2, int n3, int n4, int n5) throws TestException {
        this.d = new Color(n2, n3, n4, n5);
        return this;
    }

    public final ImageRepDrawer setStrokeColor(int n2, int n3, int n4) throws TestException {
        this.d = new Color(n2, n3, n4);
        return this;
    }

    public final ImageRepDrawer setFillColor(Color color) throws TestException {
        this.f = color;
        return this;
    }

    public final ImageRepDrawer setFillColor(int n2, int n3, int n4, int n5) throws TestException {
        this.f = new Color(n2, n3, n4, n5);
        return this;
    }

    public final ImageRepDrawer setFillColor(int n2, int n3, int n4) throws TestException {
        this.f = new Color(n2, n3, n4);
        return this;
    }

    public final ImageRepDrawer setFont(Font font) throws TestException {
        this.g = font;
        return this;
    }

    public final ImageRepDrawer setFont(String string) throws TestException {
        this.g = new Font(string, 0, 12);
        return this;
    }

    public final ImageRepDrawer setFont(String string, int n2) throws TestException {
        this.g = new Font(string, 0, n2);
        return this;
    }

    public final ImageRepDrawer setFont(String string, int n2, int n3) throws TestException {
        this.g = new Font(string, n3, n2);
        return this;
    }

    public final ImageRepDrawer pixel(int n2, int n3, int n4, int n5, int n6, int n7) throws TestException {
        Color color = new Color(n4, n5, n6, n7);
        return this.pixel(n2, n3, color);
    }

    public final ImageRepDrawer pixel(int n2, int n3, int n4, int n5, int n6) throws TestException {
        return this.pixel(n2, n3, n4, n5, n6);
    }

    public final ImageRepDrawer pixel(int n2, int n3, Color color) throws TestException {
        return this.draw(graphics2D -> {
            if (this.a(graphics2D, color)) {
                graphics2D.setStroke(DEFAULT_STROKE);
                graphics2D.drawLine(n2, n3, n2, n3);
            }
        });
    }

    public final ImageRepDrawer pixel(int n2, int n3) throws TestException {
        return this.pixel(n2, n3, this.d);
    }

    public ImageRepDrawer text(int n2, int n3, String string, Color color, Font font) throws TestException {
        return this.draw(graphics2D -> {
            graphics2D.setStroke(DEFAULT_STROKE);
            if (font != null) {
                graphics2D.setFont(font);
            } else if (this.g != null) {
                graphics2D.setFont(this.g);
            } else {
                graphics2D.setFont(DEFAULT_FONT);
            }
            if (color != null) {
                graphics2D.setColor(color);
            } else if (this.d != null) {
                graphics2D.setColor(this.d);
            } else {
                graphics2D.setColor(DEFAULT_STROKE_COLOR);
            }
            graphics2D.drawString(string, n2, n3);
        });
    }

    public ImageRepDrawer text(int n2, int n3, String string, Color color) throws TestException {
        return this.text(n2, n3, string, color, null);
    }

    public ImageRepDrawer text(int n2, int n3, String string, int n4, int n5, int n6, int n7) throws TestException {
        Color color = new Color(n4, n5, n6, n7);
        return this.text(n2, n3, string, color, null);
    }

    public ImageRepDrawer text(int n2, int n3, String string, int n4, int n5, int n6) throws TestException {
        Color color = new Color(n4, n5, n6);
        return this.text(n2, n3, string, color, null);
    }

    public ImageRepDrawer text(int n2, int n3, String string, String string2, int n4, int n5) throws TestException {
        Font font = new Font(string2, n5, n4);
        return this.text(n2, n3, string, null, font);
    }

    public ImageRepDrawer text(int n2, int n3, String string, String string2, int n4) throws TestException {
        Font font = new Font(string2, 0, n4);
        return this.text(n2, n3, string, null, font);
    }

    public ImageRepDrawer text(int n2, int n3, String string, String string2) throws TestException {
        Font font = new Font(string2, 0, 12);
        return this.text(n2, n3, string, null, font);
    }

    public ImageRepDrawer text(int n2, int n3, String string) throws TestException {
        return this.text(n2, n3, string, null, null);
    }

    public ImageRepDrawer rectangle(int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2) throws TestException {
        return this.draw(graphics2D -> {
            graphics2D.setStroke(DEFAULT_STROKE);
            if (this.a(graphics2D, color)) {
                if (n7 == 0) {
                    for (int i2 = 0; i2 < n6; ++i2) {
                        graphics2D.drawRect(n2 - i2 - 1, n3 - i2 - 1, n4 + 2 * i2 + 2, n5 + 2 * i2 + 2);
                    }
                } else if (n7 == 1) {
                    int n8 = n6 * n6;
                    for (int i3 = 1; i3 <= n6; ++i3) {
                        int n9 = i3 * i3;
                        int n10 = (int)Math.round(Math.sqrt(n8 - n9));
                        graphics2D.drawRect(n2 - i3, n3 - n10, n4 + 2 * i3, n5 + 2 * n10);
                        graphics2D.drawRect(n2 - n10, n3 - i3, n4 + 2 * n10, n5 + 2 * i3);
                    }
                }
                if (this.b(graphics2D, color2)) {
                    graphics2D.fillRect(n2, n3, n4 + 1, n5 + 1);
                }
            }
        });
    }

    public ImageRepDrawer rectangle(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) throws TestException {
        Color color = new Color(n8, n9, n10, n11);
        Color color2 = new Color(n12, n13, n14, n15);
        return this.rectangle(n2, n3, n4, n5, n6, n7, color, color2);
    }

    public ImageRepDrawer rectangle(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) throws TestException {
        Color color = new Color(n8, n9, n10);
        Color color2 = new Color(n11, n12, n13);
        return this.rectangle(n2, n3, n4, n5, n6, n7, color, color2);
    }

    public ImageRepDrawer rectangle(int n2, int n3, int n4, int n5, int n6, Color color, Color color2) throws TestException {
        return this.rectangle(n2, n3, n4, n5, n6, this.e, color, color2);
    }

    public ImageRepDrawer rectangle(int n2, int n3, int n4, int n5, int n6, int n7, Color color) throws TestException {
        return this.rectangle(n2, n3, n4, n5, n6, n7, color, null);
    }

    public ImageRepDrawer rectangle(int n2, int n3, int n4, int n5, int n6, Color color) throws TestException {
        return this.rectangle(n2, n3, n4, n5, n6, this.e, color, null);
    }

    public ImageRepDrawer rectangle(int n2, int n3, int n4, int n5, int n6) throws TestException {
        return this.rectangle(n2, n3, n4, n5, n6, this.e, null, null);
    }

    public ImageRepDrawer rectangle(int n2, int n3, int n4, int n5) throws TestException {
        return this.rectangle(n2, n3, n4, n5, this.c, this.e, null, null);
    }

    public ImageRepDrawer line(int n2, int n3, int n4, int n5, int n6, Color color) throws TestException {
        return this.draw(graphics2D -> {
            if (this.a(graphics2D, color)) {
                BasicStroke basicStroke = new BasicStroke(n6, this.e == 0 ? 2 : 1, 1);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawLine(n2, n3, n4, n5);
            }
        });
    }

    public ImageRepDrawer line(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws TestException {
        Color color = new Color(n7, n8, n9, n10);
        return this.line(n2, n3, n4, n5, n6, color);
    }

    public ImageRepDrawer line(int n2, int n3, int n4, int n5, Color color) throws TestException {
        return this.line(n2, n3, n4, n5, this.c, color);
    }

    public ImageRepDrawer line(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws TestException {
        Color color = new Color(n6, n7, n8, n9);
        return this.line(n2, n3, n4, n5, this.c, color);
    }

    public ImageRepDrawer line(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws TestException {
        Color color = new Color(n6, n7, n8);
        return this.line(n2, n3, n4, n5, this.c, color);
    }

    public ImageRepDrawer line(int n2, int n3, int n4, int n5, int n6) throws TestException {
        return this.line(n2, n3, n4, n5, n6, this.d);
    }

    public ImageRepDrawer line(int n2, int n3, int n4, int n5) throws TestException {
        return this.line(n2, n3, n4, n5, this.c, this.d);
    }

    public ImageRepDrawer fillRectangle(int n2, int n3, int n4, int n5, Color color) throws TestException {
        return this.draw(graphics2D -> {
            if (this.b(graphics2D, color)) {
                graphics2D.fillRect(n2, n3, n4, n5);
            }
        });
    }

    public ImageRepDrawer fillRectangle(int n2, int n3, int n4, int n5) throws TestException {
        return this.fillRectangle(n2, n3, n4, n5, null);
    }

    public final ImageRepDrawer cross(int n2, int n3, int n4) throws TestException {
        if (this.d == null || this.d.getAlpha() != 255) {
            return this.drawFigure(graphics2D -> {
                if (this.a(graphics2D, Color.BLACK)) {
                    BasicStroke basicStroke = new BasicStroke(this.c, this.e == 0 ? 2 : 1, 1);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.drawLine(n2 - n4, n3 - n4, n2 + n4, n3 + n4);
                    graphics2D.drawLine(n2 - n4, n3 + n4, n2 + n4, n3 - n4);
                }
            }, this.d);
        }
        this.line(n2 - n4, n3 - n4, n2 + n4, n3 + n4);
        this.line(n2 - n4, n3 + n4, n2 + n4, n3 - n4);
        return this;
    }

    public final ImageRepDrawer cross(int n2, int n3) throws TestException {
        return this.cross(n2, n3, 5);
    }

    public final ImageRepDrawer circle(int n2, int n3, int n4, int n5, Color color, Color color2) throws TestException {
        return this.draw(graphics2D -> {
            if (this.a(graphics2D, color)) {
                BasicStroke basicStroke = new BasicStroke(n5, this.e == 0 ? 2 : 1, 1);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawArc(n2 - n4, n3 - n4, 2 * n4, 2 * n4, 0, 360);
                if (this.b(graphics2D, color2)) {
                    BasicStroke basicStroke2 = new BasicStroke(1.0f, 1, 1);
                    graphics2D.setStroke(basicStroke2);
                    int n6 = n4 - n5 / 2;
                    graphics2D.fillArc(n2 - n6, n3 - n6, 2 * n6, 2 * n6, 0, 360);
                }
            }
        });
    }

    public final ImageRepDrawer circle(int n2, int n3, int n4, int n5, Color color) throws TestException {
        return this.circle(n2, n3, n4, n5, color, null);
    }

    public final ImageRepDrawer circle(int n2, int n3, int n4, Color color) throws TestException {
        return this.circle(n2, n3, n4, this.c, color);
    }

    public final ImageRepDrawer circle(int n2, int n3, int n4, int n5) throws TestException {
        return this.circle(n2, n3, n4, n5, null);
    }

    public final ImageRepDrawer circle(int n2, int n3, int n4) throws TestException {
        return this.circle(n2, n3, n4, null);
    }

    public final ImageRepDrawer erase(int n2, int n3, int n4, int n5) throws TestException {
        return this.draw(graphics2D -> {
            graphics2D.setColor(DEFAULT_ERASE_COLOR);
            graphics2D.fillRect(n2, n3, n4, n5);
        });
    }

    public final ImageRepDrawer image(ImageRep imageRep, int n2, int n3) throws TestException {
        try {
            BufferedImage bufferedImage = imageRep.asBufferedImage();
            return this.draw(graphics2D -> graphics2D.drawImage((Image)bufferedImage, n2, n3, null));
        }
        catch (Throwable throwable) {
            throw new TestException("Could not convert to buffered image", throwable);
        }
    }

    public final ImageRepDrawer image(Image image, int n2, int n3) throws TestException {
        return this.draw(graphics2D -> graphics2D.drawImage(image, n2, n3, null));
    }

    public final ImageRepDrawer arrow(int n2, int n3, int n4, int n5, int n6, int n7, Color color, int n8) throws TestException {
        if (color != null && color.getAlpha() == 255) {
            return this.draw(graphics2D -> {
                if (this.a(graphics2D, color)) {
                    BasicStroke basicStroke = new BasicStroke(n7, this.e == 0 ? 2 : 1, 1);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.drawLine(n2, n3, n4, n5);
                    if (n2 != n4 || n3 != n5) {
                        int n9 = n4 - n2;
                        int n10 = n5 - n3;
                        double d2 = Math.sin(1.0 * (double)n8 / 360.0 * (Math.PI * 2));
                        double d3 = Math.cos(1.0 * (double)n8 / 360.0 * (Math.PI * 2));
                        int n11 = (int)(d3 * (double)n9 - d2 * (double)n10);
                        int n12 = (int)(d2 * (double)n9 + d3 * (double)n10);
                        int n13 = (int)(d3 * (double)n9 + d2 * (double)n10);
                        int n14 = (int)(-d2 * (double)n9 + d3 * (double)n10);
                        double d4 = Math.sqrt(n11 * n11 + n12 * n12);
                        double d5 = Math.sqrt(n13 * n13 + n14 * n14);
                        n11 = (int)((double)n11 / d4 * (double)n6);
                        n12 = (int)((double)n12 / d4 * (double)n6);
                        n13 = (int)((double)n13 / d5 * (double)n6);
                        n14 = (int)((double)n14 / d5 * (double)n6);
                        double d6 = Math.sqrt(n9 * n9 + n10 * n10);
                        int n15 = (int)((double)n9 / d6 * (double)n7);
                        int n16 = (int)((double)n10 / d6 * (double)n7);
                        graphics2D.drawLine(n4 + n15, n5 + n16, n4 - n11 + n15, n5 - n12 + n16);
                        graphics2D.drawLine(n4 + n15, n5 + n16, n4 - n13 + n15, n5 - n14 + n16);
                    }
                }
            });
        }
        return this.drawFigure(graphics2D -> {
            if (this.a(graphics2D, Color.BLACK)) {
                BasicStroke basicStroke = new BasicStroke(n7, this.e == 0 ? 2 : 1, 1);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawLine(n2, n3, n4, n5);
                if (n2 != n4 || n3 != n5) {
                    int n9 = n4 - n2;
                    int n10 = n5 - n3;
                    double d2 = Math.sin(1.0 * (double)n8 / 360.0 * (Math.PI * 2));
                    double d3 = Math.cos(1.0 * (double)n8 / 360.0 * (Math.PI * 2));
                    int n11 = (int)(d3 * (double)n9 - d2 * (double)n10);
                    int n12 = (int)(d2 * (double)n9 + d3 * (double)n10);
                    int n13 = (int)(d3 * (double)n9 + d2 * (double)n10);
                    int n14 = (int)(-d2 * (double)n9 + d3 * (double)n10);
                    double d4 = Math.sqrt(n11 * n11 + n12 * n12);
                    double d5 = Math.sqrt(n13 * n13 + n14 * n14);
                    n11 = (int)((double)n11 / d4 * (double)n6);
                    n12 = (int)((double)n12 / d4 * (double)n6);
                    n13 = (int)((double)n13 / d5 * (double)n6);
                    n14 = (int)((double)n14 / d5 * (double)n6);
                    double d6 = Math.sqrt(n9 * n9 + n10 * n10);
                    int n15 = (int)((double)n9 / d6 * (double)n7);
                    int n16 = (int)((double)n10 / d6 * (double)n7);
                    graphics2D.drawLine(n4 + n15, n5 + n16, n4 - n11 + n15, n5 - n12 + n16);
                    graphics2D.drawLine(n4 + n15, n5 + n16, n4 - n13 + n15, n5 - n14 + n16);
                }
            }
        }, color);
    }

    public final ImageRepDrawer arrow(int n2, int n3, int n4, int n5, int n6, int n7, Color color) throws TestException {
        return this.arrow(n2, n3, n4, n5, n6, n7, color, 45);
    }

    public final ImageRepDrawer arrow(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) throws TestException {
        return this.arrow(n2, n3, n4, n5, n6, n7, new Color(n8, n9, n10, n11));
    }

    public final ImageRepDrawer arrow(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws TestException {
        return this.arrow(n2, n3, n4, n5, n6, n7, new Color(n8, n9, n10));
    }

    public final ImageRepDrawer arrow(int n2, int n3, int n4, int n5, int n6, int n7) throws TestException {
        return this.arrow(n2, n3, n4, n5, n6, n7, this.d);
    }

    public final ImageRepDrawer arrow(int n2, int n3, int n4, int n5, int n6) throws TestException {
        return this.arrow(n2, n3, n4, n5, n6, this.c, this.d);
    }

    public final ImageRepDrawer arrow(int n2, int n3, int n4, int n5) throws TestException {
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        double d2 = Math.sqrt(n6 * n6 + n7 * n7);
        int n8 = (int)(0.382 * d2);
        return this.arrow(n2, n3, n4, n5, n8, this.c, this.d);
    }

    public final BufferedImage asBufferedImage() throws TestException {
        BufferedImage bufferedImage = new BufferedImage(this.b.getWidth(), this.b.getHeight(), this.b.getType());
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(this.b, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    private boolean a(Graphics2D graphics2D, Color color) {
        if (color != null) {
            graphics2D.setColor(color);
        } else if (this.d != null) {
            graphics2D.setColor(this.d);
        } else {
            graphics2D.setColor(DEFAULT_STROKE_COLOR);
        }
        return true;
    }

    private boolean b(Graphics2D graphics2D, Color color) {
        if (color != null) {
            graphics2D.setColor(color);
        } else if (this.f != null) {
            graphics2D.setColor(this.f);
        } else {
            return false;
        }
        return true;
    }

    public static interface DrawInterface {
        public void call(Graphics2D var1);
    }
}

