/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.image;

import com.keypoint.PngEncoder;
import com.keypoint.PngEncoderB;
import com.sixlegs.png.PngImage;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.image.BaseImageHelper;
import de.qfs.apps.qftest.shared.image.h;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.ThreadPool;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;

public class AWTImageHelper
extends BaseImageHelper {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.shared.image.AWTImageHelper");
    private static AWTImageHelper instance = new AWTImageHelper();
    private static boolean brokenGrabImage;
    private ThreadPool threadPool;

    protected AWTImageHelper() {
        if (AWTImageHelper.logger.level >= 7) {
            logger.lvlBuild(7, "AWTImageHelper()", 92).log();
        }
    }

    public static synchronized AWTImageHelper instance() {
        if (instance == null) {
            instance = new AWTImageHelper();
        }
        return instance;
    }

    public final boolean isBrokenGrabImage() {
        return brokenGrabImage;
    }

    public final void setBrokenGrabImage(boolean bl) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setBrokenGrabImage(boolean)", 143).addDetail("_brokenGrabImage", bl)).log();
        }
        brokenGrabImage = bl;
    }

    public final ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public final void setThreadPool(ThreadPool threadPool) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setThreadPool(ThreadPool)", 174).addDetail("threadPool", (Object)threadPool)).log();
        }
        this.threadPool = threadPool;
    }

    public byte[] pngEncode(Image image) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "pngEncode(Image)", 194).addDetail("image", (Object)image)).log();
        }
        return this.pngEncode(image, 6);
    }

    public byte[] pngEncode(Image image, int n2) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "pngEncode(Image,int)", 210).addDetail("image", (Object)image)).addDetail("compression", n2)).log();
        }
        if (image instanceof BufferedImage) {
            PngEncoderB pngEncoderB = new PngEncoderB((BufferedImage)image);
            pngEncoderB.setCompressionLevel(n2);
            return pngEncoderB.pngEncode();
        }
        PngEncoder pngEncoder = new PngEncoder(image);
        pngEncoder.setCompressionLevel(n2);
        return pngEncoder.pngEncode();
    }

    public Image pngDecodeForImage(InputStream inputStream) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "pngDecodeForImage(InputStream)", 236).addDetail("stream", (Object)inputStream)).log();
        }
        PngImage pngImage = new PngImage();
        try {
            return pngImage.read(inputStream, true);
        }
        catch (IOException iOException) {
            if (AWTImageHelper.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "pngDecodeForImage(InputStream)", 242).add("ex", (Object)iOException)).log();
            }
            return null;
        }
    }

    public Image pngDecode(byte[] byArray) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "pngDecode(byte[])", 257).addDetail("data", (Object)byArray)).log();
        }
        return this.pngDecodeForImage(new ByteArrayInputStream(byArray));
    }

    public Image getSubImage(Image image, Rectangle rectangle, Component component) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getSubImage(Image,Rectangle,Component)", 278).addDetail("image", (Object)image)).addDetail("region", (Object)rectangle)).addDetail("producer", (Object)component)).log();
        }
        if (component == null) {
            component = new Canvas();
        }
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        if (AWTImageHelper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSubImage(Image,Rectangle,Component)", 287).add("sub", (Object)bufferedImage)).log();
        }
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.drawImage(image, -rectangle.x, -rectangle.y, component);
        graphics.dispose();
        return bufferedImage;
    }

    public ImageRep getZoomedImage(Image image, int n2, int n3, Component component) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getZoomedImage(Image,int,int,Component)", 308).addDetail("image", (Object)image)).addDetail("width", n2)).addDetail("height", n3)).addDetail("producer", (Object)component)).log();
        }
        if (component == null) {
            component = new Canvas();
        }
        Image image2 = image.getScaledInstance(n2, n3, 16);
        if (AWTImageHelper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getZoomedImage(Image,int,int,Component)", 316).add("zoomed", (Object)image2)).log();
        }
        h h2 = new h(image2);
        return new ImageRep("", AWTImageHelper.instance().getARGB(image2, false), ImageRep.CompressionMode.BINARY, h2.a(), h2.b());
    }

    public ImageRep crop(ImageRep imageRep, int n2, int n3, int n4, int n5, Component component) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "crop(ImageRep,int,int,int,int,Component)", 336).addDetail("baseRep", (Object)imageRep)).addDetail("regX", n2)).addDetail("regY", n3)).addDetail("regWidth", n4)).addDetail("regHeight", n5)).addDetail("producer", (Object)component)).log();
        }
        int n6 = Math.max(0, Math.min(n2, imageRep.getWidth() - 1));
        int n7 = Math.max(0, Math.min(n3, imageRep.getHeight() - 1));
        int n8 = Math.min(imageRep.getWidth() - n6, n4);
        int n9 = Math.min(imageRep.getHeight() - n7, n5);
        Image image = AWTImageHelper.instance().createImage(imageRep.getARGB(), imageRep.getWidth(), imageRep.getHeight(), true);
        ImageRep imageRep2 = new ImageRep();
        if (image != null) {
            image = AWTImageHelper.instance().getSubImage(image, new Rectangle(n6, n7, n8, n9), component);
            imageRep2.setARGB(AWTImageHelper.instance().getARGB(image, false), n8, n9);
        } else {
            imageRep2.setWidth(n8);
            imageRep2.setHeight(n9);
        }
        imageRep2.setName(imageRep.getName());
        imageRep2.setCompressionMode(imageRep.getCompressionMode());
        return imageRep2;
    }

    public BufferedImage resize(BufferedImage bufferedImage, int n2, int n3, boolean bl, boolean bl2) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "resize(BufferedImage,int,int,boolean,boolean)", 372).addDetail("source", (Object)bufferedImage)).addDetail("newW", n2)).addDetail("newH", n3)).addDetail("keepAspectRatio", bl)).addDetail("ARGBType", bl2)).log();
        }
        if (bufferedImage.getWidth() == n2 && bufferedImage.getHeight() == n3) {
            return bufferedImage;
        }
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = bl2 ? new BufferedImage(n2, n3, 2) : new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (bl) {
            double d2 = (double)n4 / (double)n5;
            int n6 = n2;
            int n7 = (int)Math.round((double)n6 * d2);
            int n8 = 0;
            int n9 = n2 - n6;
            if (n7 > n3) {
                n7 = n3;
                n6 = (int)Math.round((double)n7 * d2);
                n8 = n2 - n6;
                n9 = 0;
            }
            graphics2D.drawImage(bufferedImage, n8, n9, n6 + n8, n6 + n9, 0, 0, n4, n5, null);
        } else {
            graphics2D.drawImage(bufferedImage, 0, 0, n2, n3, 0, 0, n4, n5, null);
        }
        graphics2D.dispose();
        bufferedImage = null;
        return bufferedImage2;
    }

    public int[] getARGB(Image image, boolean bl) {
        Object object;
        Object object2;
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getARGB(Image,boolean)", 427).addDetail("image", (Object)image)).addDetail("copy", bl)).log();
        }
        h h2 = new h(image);
        int n2 = h2.a();
        int n3 = h2.b();
        if (n2 < 0 || n3 < 0) {
            return null;
        }
        if (image instanceof BufferedImage && ((Raster)(object2 = ((BufferedImage)image).getRaster())).getSampleModel() instanceof SinglePixelPackedSampleModel) {
            object = (SinglePixelPackedSampleModel)((Raster)object2).getSampleModel();
            if (((SampleModel)object).getDataType() == 3 && ((SinglePixelPackedSampleModel)object).getScanlineStride() == n2 && (((SampleModel)object).getNumBands() == 3 || ((SampleModel)object).getNumBands() == 4) && ((Raster)object2).getDataBuffer() instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)((Raster)object2).getDataBuffer()).getData();
                return bl ? (int[])nArray.clone() : nArray;
            }
            if (AWTImageHelper.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getARGB(Image,boolean)", 448).add("raster", object2)).add("buf")).add("raster.getDataBuffer()", (Object)((Raster)object2).getDataBuffer())).log();
            }
        }
        object2 = new int[n2 * n3];
        object = new PixelGrabber(image, 0, 0, n2, n3, (int[])object2, 0, n2);
        try {
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            if (AWTImageHelper.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "getARGB(Image,boolean)", 460).add("e", (Object)interruptedException)).log();
            }
            return null;
        }
        return object2;
    }

    public Image createImage(int[] nArray, int n2, int n3, boolean bl) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createImage(int[],int,int,boolean)", 481).addDetail("data", (Object)nArray)).addDetail("width", n2)).addDetail("height", n3)).addDetail("paintable", bl)).log();
        }
        if (nArray == null) {
            return null;
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, n2 * n3);
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(3, n2, n3, new int[]{0xFF0000, 65280, 255, -16777216});
        try {
            WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferInt, new Point(0, 0));
            return new BufferedImage(colorModel, writableRaster, false, null);
        }
        catch (RasterFormatException rasterFormatException) {
            return null;
        }
    }

    public Image createXOR(int[] nArray, int[] nArray2, int n2, int n3, boolean bl) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createXOR(int[],int[],int,int,boolean)", 520).addDetail("data1", (Object)nArray)).addDetail("data2", (Object)nArray2)).addDetail("width", n2)).addDetail("height", n3)).addDetail("paintable", bl)).log();
        }
        int[] nArray3 = (int[])nArray.clone();
        for (int i2 = Math.min(nArray2.length, nArray3.length) - 1; i2 >= 0; --i2) {
            int n4 = i2;
            nArray3[n4] = nArray3[n4] ^ nArray2[i2] & 0xFFFFFF;
        }
        return this.createImage(nArray3, n2, n3, bl);
    }

    public Image createDifference(int[] nArray, int[] nArray2, int n2, int n3, boolean bl) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createDifference(int[],int[],int,int,boolean)", 545).addDetail("data1", (Object)nArray)).addDetail("data2", (Object)nArray2)).addDetail("width", n2)).addDetail("height", n3)).addDetail("paintable", bl)).log();
        }
        int[] nArray3 = (int[])nArray.clone();
        for (int i2 = Math.min(nArray2.length, nArray3.length) - 1; i2 >= 0; --i2) {
            nArray3[i2] = (nArray2[i2] & 0xFFFFFF) == (nArray3[i2] & 0xFFFFFF) ? -16777216 : -1;
        }
        return this.createImage(nArray3, n2, n3, bl);
    }

    @Override
    public ImageRep createImageRep(InputStream inputStream) {
        if (AWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createImageRep(InputStream)", 559).addDetail("stream", (Object)inputStream)).log();
        }
        PngImage pngImage = new PngImage();
        try {
            BufferedImage bufferedImage = pngImage.read(inputStream, true);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            return new ImageRep("", this.getARGB(bufferedImage, false), ImageRep.CompressionMode.BINARY, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        }
        catch (IOException iOException) {
            if (AWTImageHelper.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "createImageRep(InputStream)", 567).add("ex", (Object)iOException)).log();
            }
            return null;
        }
    }
}

