/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.image;

import de.qfs.apps.qftest.shared.c;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.image.BarcodeHelper;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;

public class Barcodes
extends c {
    private static final String a = "BarcodeHelperImpl";
    private static final String b = "zxing.jar";
    private static Barcodes c;

    public static synchronized Barcodes instance() {
        if (c == null) {
            c = new Barcodes();
        }
        return c;
    }

    private Barcodes() {
        super(a, b);
    }

    public String readCode(BufferedImage bufferedImage) throws TestException {
        try {
            return ((BarcodeHelper)this.helper).readCodeFromImage(bufferedImage);
        }
        catch (Exception exception) {
            if (exception instanceof TestException) {
                throw (TestException)exception;
            }
            if ("com.google.zxing.NotFoundException".equals(exception.getMessage())) {
                throw new TestException("No code found in image", "noCodeFoundInImage");
            }
            throw new TestException(exception);
        }
    }

    public String readCode(File file) throws TestException {
        try {
            return this.readCode(ImageIO.read(file));
        }
        catch (Exception exception) {
            if (exception instanceof TestException) {
                throw (TestException)exception;
            }
            throw new TestException(exception);
        }
    }

    public String readCode(URL uRL) throws TestException {
        try {
            return this.readCode(ImageIO.read(uRL));
        }
        catch (Exception exception) {
            if (exception instanceof TestException) {
                throw (TestException)exception;
            }
            throw new TestException(exception);
        }
    }

    public String readCode(ImageRep imageRep) throws TestException {
        try {
            return this.readCode(imageRep.asBufferedImage());
        }
        catch (Exception exception) {
            if (exception instanceof TestException) {
                throw (TestException)exception;
            }
            throw new TestException(exception);
        }
    }

    public ImageRep createCode(String string, int n2, int n3, String string2) throws TestException {
        try {
            BufferedImage bufferedImage = ((BarcodeHelper)this.helper).writeCodeToImage(string, n2, n3, string2);
            return new ImageRep("Code('" + string + "')", bufferedImage);
        }
        catch (Exception exception) {
            if (exception instanceof TestException) {
                throw (TestException)exception;
            }
            throw new TestException(exception);
        }
    }
}

