/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.image;

import de.qfs.apps.qftest.shared.c;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.image.b;
import de.qfs.apps.qftest.shared.image.g;
import de.qfs.apps.qftest.shared.image.i;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public abstract class BaseImageHelper {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.shared.image.BaseImageHelper");
    public static final int DEFAULT_COMPRESSION = 6;

    public BaseImageHelper() {
        if (BaseImageHelper.logger.level >= 7) {
            logger.lvlBuild(7, "BaseImageHelper.BaseImageHelper()", 54).log();
        }
    }

    public static final byte[] deflateRGB(int[] nArray) {
        if (BaseImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "deflateRGB(int[])", 77).addDetail("data", (Object)nArray)).log();
        }
        return BaseImageHelper.deflateRGB(nArray, 6);
    }

    public static final byte[] deflateRGB(int[] nArray, int n2) {
        if (BaseImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "deflateRGB(int[],int)", 93).addDetail("data", (Object)nArray)).addDetail("level", n2)).log();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(n2));
        byte[] byArray = new byte[30720];
        int n3 = (nArray.length + 10239) / 10240;
        try {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = i2 * 10240;
                int n5 = Math.min((i2 + 1) * 10240, nArray.length);
                int n6 = 0;
                for (int i3 = n4; i3 < n5; ++i3) {
                    int n7 = nArray[i3];
                    byArray[n6++] = (byte)(n7 >> 16 & 0xFF);
                    byArray[n6++] = (byte)(n7 >> 8 & 0xFF);
                    byArray[n6++] = (byte)(n7 & 0xFF);
                }
                deflaterOutputStream.write(byArray, 0, n6);
            }
            deflaterOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            if (BaseImageHelper.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "deflateRGB(int[],int)", 118).add("ex", (Object)iOException)).log();
            }
            return null;
        }
    }

    public static final int[] inflateRGB(byte[] byArray, int n2) {
        if (BaseImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "inflateRGB(byte[],int)", 134).addDetail("data", (Object)byArray)).addDetail("size", n2)).log();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        int n3 = n2;
        if (n3 <= 0) {
            n3 = 10240;
        }
        byte[] byArray2 = new byte[30720];
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = Math.max(10240, n3);
        int n6 = 0;
        while (true) {
            long l2;
            try {
                l2 = n6 + inflaterInputStream.read(byArray2, n6, 30720 - n6);
            }
            catch (IOException iOException) {
                if (BaseImageHelper.logger.level < 1) break;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "inflateRGB(byte[],int)", 155).add("ex", (Object)iOException)).log();
                break;
            }
            if (l2 < 0L) break;
            if ((long)n4 + l2 / 3L > (long)n3) {
                int[] nArray2 = new int[n3 += (n5 *= 2)];
                System.arraycopy(nArray, 0, nArray2, 0, n4);
                nArray = nArray2;
            }
            n6 = (int)(l2 % 3L);
            long l3 = l2 - (long)n6;
            int n7 = 0;
            while ((long)n7 < l3) {
                nArray[n4++] = 0xFF000000 | byArray2[n7] << 16 & 0xFF0000 | byArray2[n7 + 1] << 8 & 0xFF00 | byArray2[n7 + 2] & 0xFF;
                n7 += 3;
            }
            if (n6 >= 1) {
                byArray2[0] = byArray2[n7];
            }
            if (n6 != 2) continue;
            byArray2[1] = byArray2[n7 + 1];
        }
        if (n4 == n3 || n4 < n2) {
            return nArray;
        }
        int[] nArray3 = new int[n4];
        System.arraycopy(nArray, 0, nArray3, 0, n4);
        return nArray3;
    }

    public static final int[] getRGBRegion(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int[] nArray2;
        int n9;
        int n10;
        if (BaseImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getRGBRegion(int[],int,int,int,int,int,int)", 210).addDetail("data", (Object)nArray)).addDetail("width", n2)).addDetail("height", n3)).addDetail("subX", n4)).addDetail("subY", n5)).addDetail("subWidth", n6)).addDetail("subHeight", n7)).log();
        }
        if (n4 < 0 || n5 < 0) {
            n4 = Math.abs(n4);
            n5 = Math.abs(n5);
            n10 = n5 * (n2 + n4) + n4;
            n9 = 0;
            nArray2 = new int[(n2 + n4) * (n3 + n5)];
            for (int i2 = 0; i2 < n3; ++i2) {
                System.arraycopy(nArray, n9, nArray2, n10, n2);
                n10 += n2 + n4;
                n9 += n2;
            }
            int[] nArray3 = new int[n4 + n2];
            for (n8 = 0; n8 < n4 + n2; ++n8) {
                nArray3[n8] = -16777216;
            }
            n10 = 0;
            for (n8 = 0; n8 < n5; ++n8) {
                System.arraycopy(nArray3, 0, nArray2, n10, n4 + n2);
                n10 += n4 + n2;
            }
            n10 = n5 * (n2 + n4);
            for (n8 = n5; n8 < n5 + n3; ++n8) {
                System.arraycopy(nArray3, 0, nArray2, n10, n4);
                n10 += n2 + n4;
            }
            nArray = nArray2;
            n2 += n4;
            n3 += n5;
            n4 = 0;
            n5 = 0;
        }
        nArray2 = new int[n6 * n7];
        n10 = Math.max(0, Math.min(n6, n2 - n4));
        if (BaseImageHelper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRGBRegion(int[],int,int,int,int,int,int)", 252).add("dx", n10)).log();
        }
        n9 = Math.max(0, Math.min(n7, n3 - n5));
        if (BaseImageHelper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRGBRegion(int[],int,int,int,int,int,int)", 254).add("dy", n9)).log();
        }
        if (n10 > 0) {
            int n11;
            int n12 = n5 * n2 + n4;
            n8 = 0;
            int[] nArray4 = null;
            if (n6 > n10 || n7 > n9) {
                nArray4 = new int[n6];
                for (n11 = 0; n11 < n6; ++n11) {
                    nArray4[n11] = -16777216;
                }
            }
            for (n11 = 0; n11 < n9; ++n11) {
                if (BaseImageHelper.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRGBRegion(int[],int,int,int,int,int,int)", 267).add("source", n12)).log();
                }
                if (BaseImageHelper.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRGBRegion(int[],int,int,int,int,int,int)", 268).add("dest", n8)).log();
                }
                System.arraycopy(nArray, n12, nArray2, n8, n10);
                if (n6 > n10) {
                    System.arraycopy(nArray4, n10, nArray2, n8 + n10, n6 - n10);
                }
                n12 += n2;
                n8 += n6;
            }
            for (n11 = n9; n11 < n7; ++n11) {
                System.arraycopy(nArray4, 0, nArray2, n8, n6);
                n8 += n6;
            }
        }
        return nArray2;
    }

    public static final byte[] pngEncode(ImageRep imageRep) {
        return BaseImageHelper.pngEncode(imageRep.getARGB(), imageRep.getWidth(), imageRep.getHeight());
    }

    public static final byte[] pngEncode(int[] nArray, int n2, int n3) {
        if (BaseImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "pngEncode(int[],int,int)", 312).addDetail("argb", (Object)nArray)).addDetail("width", n2)).addDetail("height", n3)).log();
        }
        g g2 = new g();
        g2.a(nArray);
        g2.a(n2);
        g2.b(n3);
        g2.setCompressionLevel(6);
        return g2.pngEncode();
    }

    public static byte[] webpEncode(int[] nArray, int n2, int n3) {
        if (BaseImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "webpEncode(int[],int,int)", 326).addDetail("argbData", (Object)nArray)).addDetail("width", n2)).addDetail("height", n3)).log();
        }
        return a.a().a(nArray, n2, n3);
    }

    public static int[] webpDecode(byte[] byArray, int n2, int n3) throws IOException {
        if (BaseImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "webpDecode(byte[],int,int)", 334).addDetail("deflated", (Object)byArray)).addDetail("width", n2)).addDetail("height", n3)).log();
        }
        return a.a().a(byArray, n2, n3);
    }

    public static ImageRep mergeImage(ImageRep imageRep, ImageRep imageRep2, int n2, int n3) {
        int[] nArray = (int[])imageRep.getARGB().clone();
        int[] nArray2 = imageRep2.getARGB();
        int n4 = imageRep.getWidth();
        int n5 = imageRep.getHeight();
        int n6 = imageRep2.getWidth();
        int n7 = imageRep2.getHeight();
        int n8 = Math.max(0, Math.min(n6, n4 - n2));
        int n9 = Math.max(0, Math.min(n7, n5 - n3));
        int n10 = n3 * n4 + n2;
        int n11 = 0;
        try {
            for (int i2 = 0; i2 < n9; ++i2) {
                System.arraycopy(nArray2, n11, nArray, n10, n8);
                n10 += n4;
                n11 += n6;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new ImageRep("mergedImage", nArray, ImageRep.CompressionMode.BINARY, n4, n5);
    }

    public ImageRep pngDecode(InputStream inputStream) {
        if (BaseImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "pngDecode(InputStream)", 398).addDetail("stream", (Object)inputStream)).log();
        }
        return this.createImageRep(inputStream);
    }

    public abstract ImageRep createImageRep(InputStream var1);

    public static boolean shouldCompressImages() {
        if (BaseImageHelper.logger.level >= 7) {
            logger.lvlBuild(7, "shouldCompressImages()", 424).log();
        }
        return Options.getBoolean(Options.OPT_LOG_CONTENT_COMPRESS_SCREENSHOTS, true);
    }

    public static void checkImageCompressionAvailable() {
        if (BaseImageHelper.logger.level >= 7) {
            logger.lvlBuild(7, "checkImageCompressionAvailable()", 434).log();
        }
        if (BaseImageHelper.shouldCompressImages()) {
            if (a.b == Boolean.FALSE) {
                a.b = null;
            }
            a.a();
        }
    }

    public static int[] getRGBFromARGB(int n2) {
        if (BaseImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRGBFromARGB(int)", 446).addDetail("argb", n2)).log();
        }
        return new int[]{n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF};
    }

    public static String getHexFromRGB(int[] nArray) {
        if (BaseImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getHexFromRGB(int[])", 453).addDetail("rgb", (Object)nArray)).log();
        }
        if (nArray.length == 3) {
            return String.format("#%02x%02x%02x", nArray[0], nArray[1], nArray[2]);
        }
        return null;
    }

    public static class a
    extends c {
        public static a a;
        static volatile Boolean b;

        public static synchronized a a() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "WebPWrapper.instance()", 481).log();
            }
            if (b == Boolean.FALSE) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "WebPWrapper.instance()", 483).add("Cannot load WebP lib")).log();
                }
                return null;
            }
            if (a == null) {
                assert (b != Boolean.TRUE);
                b = false;
                Boolean bl = (Boolean)AccessController.doPrivileged(new b());
                if (!bl.booleanValue()) {
                    return null;
                }
                assert (a != null);
                b = true;
            }
            return a;
        }

        private a() {
            block3: {
                super("WebPHelperImpl", "webp.jar");
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "WebPWrapper.WebPWrapper()", 536).log();
                }
                try {
                    ((i)this.helper).a();
                }
                catch (Throwable throwable) {
                    if (logger.level < 5) break block3;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "WebPWrapper.WebPWrapper()", 541).add("Could not bridge loggers: ", (Object)throwable)).log();
                }
            }
            ((i)this.helper).b();
        }

        public byte[] a(int[] nArray, int n2, int n3) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "WebPWrapper.webpEncode(int[],int,int)", 552).addDetail("argbData", (Object)nArray)).addDetail("width", n2)).addDetail("height", n3)).log();
            }
            return ((i)this.helper).a(nArray, n2, n3);
        }

        public int[] a(byte[] byArray, int n2, int n3) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "WebPWrapper.webpDecode(byte[],int,int)", 563).addDetail("deflated", (Object)byArray)).addDetail("width", n2)).addDetail("height", n3)).log();
            }
            try {
                return ((i)this.helper).a(byArray, n2, n3);
            }
            catch (IOException iOException) {
                if (logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "WebPWrapper.webpDecode(byte[],int,int)", 568).add("e", (Object)iOException)).log();
                }
                return null;
            }
        }

        /* synthetic */ a(de.qfs.apps.qftest.shared.image.a a2) {
            this();
        }

        static {
            b = null;
        }
    }
}

