/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ios;

import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.ios.IOSConnection;
import de.qfs.apps.qftest.shared.ios.IOSTarget;
import de.qfs.apps.qftest.shared.ios.idb.IdbProcessClient;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessListener;
import de.qfs.lib.util.ProcessManager;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public class IOSUtil {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.ios.IOSUtil");
    private static final List b = Misc.listOf((Object[])new Function[]{iOSTarget -> iOSTarget.getName(), iOSTarget -> IOSUtil.getTargetNameWithVersion(iOSTarget)});

    private static List a() {
        if (IOSUtil.a.level >= 7) {
            a.lvlBuild(7, "getAvailableConnections()", 45).log();
        }
        return Misc.listOf((Object[])new IOSConnection[]{new IdbProcessClient()});
    }

    public static List getAvailableTargets() {
        if (IOSUtil.a.level >= 7) {
            a.lvlBuild(7, "getAvailableTargets()", 49).log();
        }
        return IOSUtil.getAvailableIOSTargets();
    }

    public static List getAvailableIOSTargets() {
        if (IOSUtil.a.level >= 7) {
            a.lvlBuild(7, "getAvailableIOSTargets()", 53).log();
        }
        LinkedList linkedList = new LinkedList();
        IOSUtil.a().forEach(iOSConnection -> linkedList.addAll(iOSConnection.listIOSTargets()));
        linkedList.forEach(iOSTarget -> iOSTarget.setDisplayName(IOSUtil.getUniqueName(iOSTarget, linkedList)));
        return linkedList;
    }

    private static boolean a(IOSTarget iOSTarget, List list, Function function) {
        if (IOSUtil.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "hasTargetUniqueName(IOSTarget,List<? extends IOSTarget>,Function<IOSTarget, String>)", 60).addDetail("target", (Object)iOSTarget)).addDetail("allTargets", (Object)list)).addDetail("generator", (Object)function)).log();
        }
        if (iOSTarget == null || list == null) {
            return true;
        }
        String string = (String)function.apply(iOSTarget);
        if (Misc.emptyOrNull((String)string)) {
            return false;
        }
        for (IOSTarget iOSTarget2 : list) {
            if (iOSTarget2.equals(iOSTarget) || !string.equals(function.apply(iOSTarget2))) continue;
            return false;
        }
        return true;
    }

    public static String getUniqueName(IOSTarget iOSTarget, List list) {
        if (IOSUtil.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getUniqueName(IOSTarget,List<? extends IOSTarget>)", 75).addDetail("target", (Object)iOSTarget)).addDetail("allTargets", (Object)list)).log();
        }
        if (iOSTarget == null) {
            throw new IllegalArgumentException("target is marked non-null but is null");
        }
        if (iOSTarget.getName() == null) {
            return iOSTarget.getUdid();
        }
        for (Function function : b) {
            if (!IOSUtil.a(iOSTarget, list, function)) continue;
            return (String)function.apply(iOSTarget);
        }
        return IOSUtil.getTargetNameWithUdid(iOSTarget);
    }

    public static String getTargetNameWithUdid(IOSTarget iOSTarget) {
        if (IOSUtil.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getTargetNameWithUdid(IOSTarget)", 89).addDetail("target", (Object)iOSTarget)).log();
        }
        if (iOSTarget == null) {
            throw new IllegalArgumentException("target is marked non-null but is null");
        }
        return iOSTarget.getName() + " (" + iOSTarget.getUdid() + ")";
    }

    @Nullable
    public static String getTargetNameWithVersion(IOSTarget iOSTarget) {
        if (IOSUtil.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getTargetNameWithVersion(IOSTarget)", 95).addDetail("target", (Object)iOSTarget)).log();
        }
        if (iOSTarget == null) {
            throw new IllegalArgumentException("target is marked non-null but is null");
        }
        VersionNumber versionNumber = iOSTarget.getOsVersion();
        if (versionNumber == null) {
            return null;
        }
        String string = versionNumber.getOriginalVersionString();
        if (Misc.emptyOrNull((String)string)) {
            return iOSTarget.getName() + " (" + versionNumber.toString() + ")";
        }
        return iOSTarget.getName() + " - " + string;
    }

    public static void adhocSignApp(File file) throws IOException {
        if (IOSUtil.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "adhocSignApp(File)", 107).addDetail("appPath", (Object)file)).log();
        }
        IOSUtil.adhocSignApp(file, null);
    }

    public static void adhocSignApp(File file, ProcessListener processListener) throws IOException {
        if (IOSUtil.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "adhocSignApp(File,ProcessListener)", 112).addDetail("appPath", (Object)file)).addDetail("processListener", (Object)processListener)).log();
        }
        IOSUtil.signApp(file, "-", processListener);
    }

    public static String getActiveDeveloperDirectory() {
        if (IOSUtil.a.level >= 7) {
            a.lvlBuild(7, "getActiveDeveloperDirectory()", 117).log();
        }
        String string = IOSUtil.a("xcode-select", null);
        try {
            String string2 = ProcessManager.runProcess((String[])new String[]{string, "-p"}, (int)5000);
            if (IOSUtil.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getActiveDeveloperDirectory()", 121).add("output", string2)).log();
            }
            return string2.trim();
        }
        catch (ProcessManager.RunProcessException runProcessException) {
            if (IOSUtil.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getActiveDeveloperDirectory()", 124).add("e", (Object)runProcessException)).log();
            }
            return null;
        }
    }

    private static String a(String string, String string2) {
        String string3;
        if (IOSUtil.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getToolPath(String,String)", 129).addDetail("binaryName", string)).addDetail("optionName", string2)).log();
        }
        String string4 = string3 = string2 == null ? null : Options.getString(string2);
        if (!Misc.emptyOrNull((String)string3)) {
            return string3;
        }
        File file = Util.findOnPath(string);
        return file != null ? file.getAbsolutePath() : string;
    }

    public static String getCodesignPath() {
        if (IOSUtil.a.level >= 7) {
            a.lvlBuild(7, "getCodesignPath()", 138).log();
        }
        return IOSUtil.a("codesign", Options.OPT_IOS_TOOL_PATH_CODESIGN);
    }

    public static String getXcodebuildPath() {
        if (IOSUtil.a.level >= 7) {
            a.lvlBuild(7, "getXcodebuildPath()", 142).log();
        }
        return IOSUtil.a("xcodebuild", Options.OPT_IOS_TOOL_PATH_XCODEBUILD);
    }

    public static String getXcrunPath() {
        if (IOSUtil.a.level >= 7) {
            a.lvlBuild(7, "getXcrunPath()", 146).log();
        }
        return IOSUtil.a("xcrun", Options.OPT_IOS_TOOL_PATH_XCRUN);
    }

    public static void signApp(File file, String string, ProcessListener processListener) throws IOException {
        if (IOSUtil.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "signApp(File,String,ProcessListener)", 150).addDetail("appPath", (Object)file)).addDetail("identity", string)).addDetail("processListener", (Object)processListener)).log();
        }
        try {
            String string2 = ProcessManager.runProcess((String[])new String[]{IOSUtil.getCodesignPath(), "-f", "--verify", "-s", string, file.getAbsolutePath()}, (int)5000, (ProcessListener)processListener);
            if (IOSUtil.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "signApp(File,String,ProcessListener)", 154).add("output", string2)).log();
            }
        }
        catch (ProcessManager.RunProcessException runProcessException) {
            throw new IOException("Could not adhoc sign the app file", runProcessException);
        }
    }
}

